package ONVIF::PTZ::Types::User;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Username_of :ATTR(:get<Username>);
my %Password_of :ATTR(:get<Password>);
my %UserLevel_of :ATTR(:get<UserLevel>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        Username
        Password
        UserLevel
        Extension

    ) ],
    {
        'Username' => \%Username_of,
        'Password' => \%Password_of,
        'UserLevel' => \%UserLevel_of,
        'Extension' => \%Extension_of,
    },
    {
        'Username' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'Password' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'UserLevel' => 'ONVIF::PTZ::Types::UserLevel',
        'Extension' => 'ONVIF::PTZ::Types::UserExtension',
    },
    {

        'Username' => 'Username',
        'Password' => 'Password',
        'UserLevel' => 'UserLevel',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::PTZ::Types::User

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
User from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * Username


=item * Password


=item * UserLevel


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::PTZ::Types::User
   Username =>  $some_value, # string
   Password =>  $some_value, # string
   UserLevel => $some_value, # UserLevel
   Extension =>  { # ONVIF::PTZ::Types::UserExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

