/* SPDX-License-Identifier: GPL-2.0 */
#ifndef LINUX_DECOMPRESS_LUNZIP_H
#define LINUX_DECOMPRESS_LUNZIP_H

int lunzip(unsigned char *inbuf, long in_len,
	   long (*fill)(void*, unsigned long),
	   long (*flush)(void*, unsigned long),
	   unsigned char *outbuf,
	   long *in_posp,
	   void (*error)(const char *x));

/* This internal function is required because the decompress_fn above
 * (see include/linux/decompress/generic.h) should have an out_size
 * argument to prevent overflowing outbuf in case of corruption of the
 * compressed data.
 */
int __lunzip(unsigned char *inbuf, long in_len,
	     long (*fill)(void*, unsigned long),
	     long (*flush)(void*, unsigned long),
	     unsigned char *outbuf, long out_size,
	     long *in_posp, long *out_posp,
	     void (*error)(const char *x));
#endif
