% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backends.R
\name{read_csv_as_stanfit}
\alias{read_csv_as_stanfit}
\title{Read CmdStan CSV files as a brms-formatted stanfit object}
\usage{
read_csv_as_stanfit(
  files,
  variables = NULL,
  sampler_diagnostics = NULL,
  model = NULL,
  exclude = "",
  algorithm = "sampling"
)
}
\arguments{
\item{files}{Character vector of CSV files names where draws are stored.}

\item{variables}{Character vector of variables to extract from the CSV files.}

\item{sampler_diagnostics}{Character vector of sampler diagnostics to extract.}

\item{model}{A compiled cmdstanr model object (optional). Provide this argument
if you want to allow updating the model without recompilation.}

\item{exclude}{Character vector of variables to exclude from the stanfit. Only
used when \code{variables} is also specified.}

\item{algorithm}{The algorithm with which the model was fitted.
See \code{\link{brm}} for details.}
}
\value{
A stanfit object consistent with the structure of the \code{fit}
 slot of a brmsfit object.
}
\description{
\code{read_csv_as_stanfit} is used internally to read CmdStan CSV files into a
\code{stanfit} object that is consistent with the structure of the fit slot of a
brmsfit object.
}
\examples{
\dontrun{
# fit a model manually via cmdstanr
scode <- stancode(count ~ Trt, data = epilepsy)
sdata <- standata(count ~ Trt, data = epilepsy)
mod <- cmdstanr::cmdstan_model(cmdstanr::write_stan_file(scode))
stanfit <- mod$sample(data = sdata)

# feed the Stan model back into brms
fit <- brm(count ~ Trt, data = epilepsy, empty = TRUE, backend = 'cmdstanr')
fit$fit <- read_csv_as_stanfit(stanfit$output_files(), model = mod)
fit <- rename_pars(fit)
summary(fit)
}

}
