#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment

    def shutdown(self):
        pass

    def get_description(self):
        return _("enables or disables sound")

    def run(self):
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "sound", "enabled"
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("sound disabled"), sound_icon="SoundOff", interrupt=True
            )
        self.env["runtime"]["SettingsManager"].set_setting(
            "sound",
            "enabled",
            str(
                not self.env["runtime"]["SettingsManager"].get_setting_as_bool(
                    "sound", "enabled"
                )
            ),
        )
        if self.env["runtime"]["SettingsManager"].get_setting_as_bool(
            "sound", "enabled"
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("sound enabled"), sound_icon="SoundOn", interrupt=True
            )

    def set_callback(self, callback):
        pass
