#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2015 mortalius
# SPDX-FileCopyrightText: © 2017 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2017 Mopi
set -o errexit

###
# SteamWorld Dig series:
# - SteamWorld Dig
# - SteamWorld Dig 2
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251024.3

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID_DIG1='steamworld-dig-1'
GAME_NAME_DIG1='SteamWorld Dig: A Fistful of Dirt'

GAME_ID_DIG2='steamworld-dig-2'
GAME_NAME_DIG2='SteamWorld Dig 2'

ARCHIVE_BASE_DIG1_GOG_0_NAME='gog_steamworld_dig_2.0.0.7.sh'
ARCHIVE_BASE_DIG1_GOG_0_MD5='2f2ed68e00f151ff3c4d0092d8d6b15b'
ARCHIVE_BASE_DIG1_GOG_0_SIZE='79000'
ARCHIVE_BASE_DIG1_GOG_0_VERSION='1.10-gog2.0.0.7'
ARCHIVE_BASE_DIG1_GOG_0_URL='https://www.gog.com/game/steamworld_dig'

ARCHIVE_BASE_DIG1_HUMBLE_0_NAME='SteamWorldDig_linux_1393468453.tar.gz'
ARCHIVE_BASE_DIG1_HUMBLE_0_MD5='de6ff6273c4e397413d852472d51e788'
ARCHIVE_BASE_DIG1_HUMBLE_0_SIZE='77000'
ARCHIVE_BASE_DIG1_HUMBLE_0_VERSION='1.10-humble140220'
ARCHIVE_BASE_DIG1_HUMBLE_0_URL='https://www.humblebundle.com/store/steamworld-dig'

ARCHIVE_BASE_DIG2_0_NAME='steamworld_dig_2_en_1_1_15062.sh'
ARCHIVE_BASE_DIG2_0_MD5='baafa458aaef7fc9c80e076d48e754f0'
ARCHIVE_BASE_DIG2_0_SIZE='220000'
ARCHIVE_BASE_DIG2_0_VERSION='1.1-gog15062'
ARCHIVE_BASE_DIG2_0_URL='https://www.gog.com/game/steamworld_dig'

CONTENT_PATH_DEFAULT_DIG1_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_DIG1_HUMBLE='SteamWorldDig'
CONTENT_PATH_DEFAULT_DIG2='data/noarch/game'
CONTENT_GAME_BIN_FILES_DIG1='
SteamWorldDig'
CONTENT_GAME_BIN_FILES_DIG2='
Dig2'
CONTENT_GAME_DATA_FILES='
Bundle
BundlePC
icon.bmp
icon.png'
CONTENT_DOC_DATA_FILES='
Licenses
readme.txt'

APP_MAIN_ICON='icon.png'
APP_MAIN_EXE_DIG1='SteamWorldDig'
APP_MAIN_EXE_DIG2='Dig2'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH_DIG1='32'
PKG_BIN_ARCH_DIG2='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libz.so.1'

PKG_DATA_ID_DIG1="${GAME_ID_DIG1}-data"
PKG_DATA_ID_DIG2="${GAME_ID_DIG2}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Force the use of system-provided SDL.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
$(launcher_tweak_sdl_override)"
## Prevent a game crash when using the Wayland video backend of SDL.
APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')"'
# Prevent a game crash when using the Wayland video backend of SDL.
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
