package ONVIF::Media::Types::VideoSourceMode;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/media/wsdl' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::Media::Types::VideoSourceMode::_VideoSourceMode::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %MaxFramerate_of :ATTR(:get<MaxFramerate>);
my %MaxResolution_of :ATTR(:get<MaxResolution>);
my %Encodings_of :ATTR(:get<Encodings>);
my %Reboot_of :ATTR(:get<Reboot>);
my %Description_of :ATTR(:get<Description>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        MaxFramerate
        MaxResolution
        Encodings
        Reboot
        Description
        Extension

    ) ],
    {
        'MaxFramerate' => \%MaxFramerate_of,
        'MaxResolution' => \%MaxResolution_of,
        'Encodings' => \%Encodings_of,
        'Reboot' => \%Reboot_of,
        'Description' => \%Description_of,
        'Extension' => \%Extension_of,
    },
    {
        'MaxFramerate' => 'SOAP::WSDL::XSD::Typelib::Builtin::float',
        'MaxResolution' => 'ONVIF::Media::Types::VideoResolution',
        'Encodings' => 'ONVIF::Media::Types::EncodingTypes',
        'Reboot' => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
        'Description' => 'ONVIF::Media::Types::Description',
        'Extension' => 'ONVIF::Media::Types::VideoSourceModeExtension',
    },
    {

        'MaxFramerate' => 'MaxFramerate',
        'MaxResolution' => 'MaxResolution',
        'Encodings' => 'Encodings',
        'Reboot' => 'Reboot',
        'Description' => 'Description',
        'Extension' => 'Extension',
    }
);

} # end BLOCK




package ONVIF::Media::Types::VideoSourceMode::_VideoSourceMode::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %token_of :ATTR(:get<token>);
my %Enabled_of :ATTR(:get<Enabled>);

__PACKAGE__->_factory(
    [ qw(
        token
        Enabled
    ) ],
    {

        token => \%token_of,

        Enabled => \%Enabled_of,
    },
    {
        token => 'ONVIF::Media::Types::ReferenceToken',
        Enabled => 'SOAP::WSDL::XSD::Typelib::Builtin::boolean',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::Media::Types::VideoSourceMode

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
VideoSourceMode from the namespace http://www.onvif.org/ver10/media/wsdl.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * MaxFramerate


=item * MaxResolution


=item * Encodings


=item * Reboot


=item * Description


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Media::Types::VideoSourceMode
   MaxFramerate =>  $some_value, # float
   MaxResolution =>  { # ONVIF::Media::Types::VideoResolution
     Width =>  $some_value, # int
     Height =>  $some_value, # int
   },
   Encodings => $some_value, # EncodingTypes
   Reboot =>  $some_value, # boolean
   Description => $some_value, # Description
   Extension =>  { # ONVIF::Media::Types::VideoSourceModeExtension
   },
 },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::Media::Types::VideoSourceMode::_VideoSourceMode::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * token

 Indicate token for video source mode.



This attribute is of type L<ONVIF::Media::Types::ReferenceToken|ONVIF::Media::Types::ReferenceToken>.

=item * Enabled

 Indication of whether this mode is active. If active this value is true. In case of non-indication, it means as false. The value of true shall be had by only one video source mode.



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::boolean|SOAP::WSDL::XSD::Typelib::Builtin::boolean>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

