##
# This file is part of WhatWeb and may be subject to
# redistribution and commercial restrictions. Please see the WhatWeb
# web site for more information on licensing and terms of use.
# https://morningstarsecurity.com/research/whatweb
#
Plugin.define do
	name "Plugin-Tutorial-6"
	authors [
		"Your preferred name <email@address>", # v0.1 # 2019-01-01 # Created plugin
	]
	version "0.1"
	description "Describe what the plugin identifies"
	website "http://example.com/"

	# Dorks # 
	dorks [
	'"Generic CMS login"',
	'Generic login register linkname',
	]

	# Matches #
	matches [

		# This searches for a text string. 
		{ :text => "This page was generated by <b>Generic CMS</b>" },

	] 

	# You can write custom Ruby code in plugins for more control
	# There can be a passive function and an aggressive function.
	# The Passive function will always execute
	#
	##
	# The following variables are available 
	#
	#  	@body
	#  	@headers
	#  	@cookies
	#  	@status
	#  	@base_uri
	#		@md5sum
	#		@tagpattern
	#		@ip
	##
	passive do
	  # make a matches array
	  m = []
	  # If the HTTP status is 302 and the redirection location is /admin/genericcms.php then match
	  if @status.to_s =~ /^302$/ and @headers["location"] =~ /^\/admin\/genericcms\.php$/
	    m << { :name => "302 redirection to /admin/genericcms.php" }
	  end
	  # You can add debugging and check the value of variables
	  # pp @status
	  # pp @headers
	  # return the matches array, even if it's empty
	  m
	end
	# Check other plugins with passive functions for examples.


	##
	# The Aggressive function will only sometimes execute
	# At aggressive level 3 if a match is found, then the aggressive function executes
	# At aggressive level 4, the aggressive function always executes
	##

	aggressive do
	  @variables[:my_var] += 1
	  # make a matches array. this returns the equivalent of the matches[] block above
	  m = []
	  # return the matches array, even if it's emtpy
	  m
	end

	## Very few plugins need startup and shutdown functions
	#
	# This executes when the plugin is first loaded
	def startup
		@variables = {my_var: 1}
	end

	# This executes when the plugin is closed on whatweb shutdown
	def shutdown
		# puts("my_var is #{@variables[:my_var]}")
	end

end
