// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: dmworker.proto

package dmpb

import (
	context "context"
	encoding_binary "encoding/binary"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type TaskOp int32

const (
	TaskOp_InvalidOp  TaskOp = 0
	TaskOp_Stop       TaskOp = 1
	TaskOp_Pause      TaskOp = 2
	TaskOp_Resume     TaskOp = 3
	TaskOp_Start      TaskOp = 4
	TaskOp_Update     TaskOp = 5
	TaskOp_AutoResume TaskOp = 6
	TaskOp_Delete     TaskOp = 7
)

var TaskOp_name = map[int32]string{
	0: "InvalidOp",
	1: "Stop",
	2: "Pause",
	3: "Resume",
	4: "Start",
	5: "Update",
	6: "AutoResume",
	7: "Delete",
}

var TaskOp_value = map[string]int32{
	"InvalidOp":  0,
	"Stop":       1,
	"Pause":      2,
	"Resume":     3,
	"Start":      4,
	"Update":     5,
	"AutoResume": 6,
	"Delete":     7,
}

func (x TaskOp) String() string {
	return proto.EnumName(TaskOp_name, int32(x))
}

func (TaskOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{0}
}

// Stage represents current stage for a (sub) task
// a (sub) task should be always in one stage of the following stages
// (sub) task can transfer from on stage to some special other stages
// New: initial stage when a sub task is created
//
//	can not be transferred from other stages
//	transfers to Running when initialize with no error
//
// Running: indicates the sub task is processing
//
//	is transferred from New when created successfully
//	is transferred from Paused when resuming is requested
//	transfers to Paused when error occurred or requested from external
//	transfers to Stopped when requested from external
//	transfers to Finished when sub task processing completed (no Syncer used)
//
// Paused: indicates the processing is paused, and can be resume from external request
//
//	is transferred from Running when error occurred or requested from external
//	transfers to Running when resuming is requested from external
//	transfers to Stopped when requested from external
//
// Stopped: indicates the processing is stopped, and can not be resume (or re-run) again
//
//	is transferred from Running / Paused when requested from external
//	can not transfer to any stages
//
// Finished: indicates the processing is finished, and no need to re-run
//
//	is transferred from Running when processing completed
//	should not transfer to any stages
type Stage int32

const (
	Stage_InvalidStage Stage = 0
	Stage_New          Stage = 1
	Stage_Running      Stage = 2
	Stage_Paused       Stage = 3
	Stage_Stopped      Stage = 4
	Stage_Finished     Stage = 5
	Stage_Pausing      Stage = 6
	Stage_Resuming     Stage = 7
	Stage_Stopping     Stage = 8
)

var Stage_name = map[int32]string{
	0: "InvalidStage",
	1: "New",
	2: "Running",
	3: "Paused",
	4: "Stopped",
	5: "Finished",
	6: "Pausing",
	7: "Resuming",
	8: "Stopping",
}

var Stage_value = map[string]int32{
	"InvalidStage": 0,
	"New":          1,
	"Running":      2,
	"Paused":       3,
	"Stopped":      4,
	"Finished":     5,
	"Pausing":      6,
	"Resuming":     7,
	"Stopping":     8,
}

func (x Stage) String() string {
	return proto.EnumName(Stage_name, int32(x))
}

func (Stage) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{1}
}

// UnitType represents the dm unit's type
type UnitType int32

const (
	UnitType_InvalidUnit UnitType = 0
	UnitType_Check       UnitType = 1
	UnitType_Dump        UnitType = 2
	UnitType_Load        UnitType = 3
	UnitType_Sync        UnitType = 4
	UnitType_Relay       UnitType = 100
)

var UnitType_name = map[int32]string{
	0:   "InvalidUnit",
	1:   "Check",
	2:   "Dump",
	3:   "Load",
	4:   "Sync",
	100: "Relay",
}

var UnitType_value = map[string]int32{
	"InvalidUnit": 0,
	"Check":       1,
	"Dump":        2,
	"Load":        3,
	"Sync":        4,
	"Relay":       100,
}

func (x UnitType) String() string {
	return proto.EnumName(UnitType_name, int32(x))
}

func (UnitType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{2}
}

// RelayOp differs from TaskOp
type RelayOp int32

const (
	RelayOp_InvalidRelayOp RelayOp = 0
	RelayOp_StopRelay      RelayOp = 1
	RelayOp_PauseRelay     RelayOp = 2
	RelayOp_ResumeRelay    RelayOp = 3
)

var RelayOp_name = map[int32]string{
	0: "InvalidRelayOp",
	1: "StopRelay",
	2: "PauseRelay",
	3: "ResumeRelay",
}

var RelayOp_value = map[string]int32{
	"InvalidRelayOp": 0,
	"StopRelay":      1,
	"PauseRelay":     2,
	"ResumeRelay":    3,
}

func (x RelayOp) String() string {
	return proto.EnumName(RelayOp_name, int32(x))
}

func (RelayOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{3}
}

type SchemaOp int32

const (
	SchemaOp_InvalidSchemaOp    SchemaOp = 0
	SchemaOp_GetSchema          SchemaOp = 1
	SchemaOp_SetSchema          SchemaOp = 2
	SchemaOp_RemoveSchema       SchemaOp = 3
	SchemaOp_ListSchema         SchemaOp = 4
	SchemaOp_ListTable          SchemaOp = 5
	SchemaOp_ListMigrateTargets SchemaOp = 6
)

var SchemaOp_name = map[int32]string{
	0: "InvalidSchemaOp",
	1: "GetSchema",
	2: "SetSchema",
	3: "RemoveSchema",
	4: "ListSchema",
	5: "ListTable",
	6: "ListMigrateTargets",
}

var SchemaOp_value = map[string]int32{
	"InvalidSchemaOp":    0,
	"GetSchema":          1,
	"SetSchema":          2,
	"RemoveSchema":       3,
	"ListSchema":         4,
	"ListTable":          5,
	"ListMigrateTargets": 6,
}

func (x SchemaOp) String() string {
	return proto.EnumName(SchemaOp_name, int32(x))
}

func (SchemaOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{4}
}

type V1MetaOp int32

const (
	V1MetaOp_InvalidV1MetaOp V1MetaOp = 0
	V1MetaOp_GetV1Meta       V1MetaOp = 1
	V1MetaOp_RemoveV1Meta    V1MetaOp = 2
)

var V1MetaOp_name = map[int32]string{
	0: "InvalidV1MetaOp",
	1: "GetV1Meta",
	2: "RemoveV1Meta",
}

var V1MetaOp_value = map[string]int32{
	"InvalidV1MetaOp": 0,
	"GetV1Meta":       1,
	"RemoveV1Meta":    2,
}

func (x V1MetaOp) String() string {
	return proto.EnumName(V1MetaOp_name, int32(x))
}

func (V1MetaOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{5}
}

type ErrorOp int32

const (
	ErrorOp_InvalidErrorOp ErrorOp = 0
	ErrorOp_Skip           ErrorOp = 1
	ErrorOp_Replace        ErrorOp = 2
	ErrorOp_Revert         ErrorOp = 3
	ErrorOp_Inject         ErrorOp = 4
	ErrorOp_List           ErrorOp = 5
)

var ErrorOp_name = map[int32]string{
	0: "InvalidErrorOp",
	1: "Skip",
	2: "Replace",
	3: "Revert",
	4: "Inject",
	5: "List",
}

var ErrorOp_value = map[string]int32{
	"InvalidErrorOp": 0,
	"Skip":           1,
	"Replace":        2,
	"Revert":         3,
	"Inject":         4,
	"List":           5,
}

func (x ErrorOp) String() string {
	return proto.EnumName(ErrorOp_name, int32(x))
}

func (ErrorOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{6}
}

type ValidatorOp int32

const (
	ValidatorOp_InvalidValidatorOp ValidatorOp = 0
	ValidatorOp_StartValidator     ValidatorOp = 1
	ValidatorOp_StopValidator      ValidatorOp = 2
)

var ValidatorOp_name = map[int32]string{
	0: "InvalidValidatorOp",
	1: "StartValidator",
	2: "StopValidator",
}

var ValidatorOp_value = map[string]int32{
	"InvalidValidatorOp": 0,
	"StartValidator":     1,
	"StopValidator":      2,
}

func (x ValidatorOp) String() string {
	return proto.EnumName(ValidatorOp_name, int32(x))
}

func (ValidatorOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{7}
}

type ValidateErrorState int32

const (
	ValidateErrorState_InvalidErr  ValidateErrorState = 0
	ValidateErrorState_NewErr      ValidateErrorState = 1
	ValidateErrorState_IgnoredErr  ValidateErrorState = 2
	ValidateErrorState_ResolvedErr ValidateErrorState = 3
)

var ValidateErrorState_name = map[int32]string{
	0: "InvalidErr",
	1: "NewErr",
	2: "IgnoredErr",
	3: "ResolvedErr",
}

var ValidateErrorState_value = map[string]int32{
	"InvalidErr":  0,
	"NewErr":      1,
	"IgnoredErr":  2,
	"ResolvedErr": 3,
}

func (x ValidateErrorState) String() string {
	return proto.EnumName(ValidateErrorState_name, int32(x))
}

func (ValidateErrorState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{8}
}

type ValidationErrOp int32

const (
	ValidationErrOp_InvalidErrOp ValidationErrOp = 0
	ValidationErrOp_IgnoreErrOp  ValidationErrOp = 1
	ValidationErrOp_ResolveErrOp ValidationErrOp = 2
	ValidationErrOp_ClearErrOp   ValidationErrOp = 3
)

var ValidationErrOp_name = map[int32]string{
	0: "InvalidErrOp",
	1: "IgnoreErrOp",
	2: "ResolveErrOp",
	3: "ClearErrOp",
}

var ValidationErrOp_value = map[string]int32{
	"InvalidErrOp": 0,
	"IgnoreErrOp":  1,
	"ResolveErrOp": 2,
	"ClearErrOp":   3,
}

func (x ValidationErrOp) String() string {
	return proto.EnumName(ValidationErrOp_name, int32(x))
}

func (ValidationErrOp) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{9}
}

type QueryStatusRequest struct {
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (m *QueryStatusRequest) Reset()         { *m = QueryStatusRequest{} }
func (m *QueryStatusRequest) String() string { return proto.CompactTextString(m) }
func (*QueryStatusRequest) ProtoMessage()    {}
func (*QueryStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{0}
}
func (m *QueryStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryStatusRequest.Merge(m, src)
}
func (m *QueryStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *QueryStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_QueryStatusRequest proto.InternalMessageInfo

func (m *QueryStatusRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

type CommonWorkerResponse struct {
	Result bool   `protobuf:"varint,1,opt,name=result,proto3" json:"result,omitempty"`
	Msg    string `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	Source string `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	Worker string `protobuf:"bytes,4,opt,name=worker,proto3" json:"worker,omitempty"`
}

func (m *CommonWorkerResponse) Reset()         { *m = CommonWorkerResponse{} }
func (m *CommonWorkerResponse) String() string { return proto.CompactTextString(m) }
func (*CommonWorkerResponse) ProtoMessage()    {}
func (*CommonWorkerResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{1}
}
func (m *CommonWorkerResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CommonWorkerResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CommonWorkerResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CommonWorkerResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonWorkerResponse.Merge(m, src)
}
func (m *CommonWorkerResponse) XXX_Size() int {
	return m.Size()
}
func (m *CommonWorkerResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonWorkerResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CommonWorkerResponse proto.InternalMessageInfo

func (m *CommonWorkerResponse) GetResult() bool {
	if m != nil {
		return m.Result
	}
	return false
}

func (m *CommonWorkerResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *CommonWorkerResponse) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *CommonWorkerResponse) GetWorker() string {
	if m != nil {
		return m.Worker
	}
	return ""
}

// QueryStatusResponse represents status response for query on a dm-worker
// status: dm-worker's current sub tasks' status
type QueryStatusResponse struct {
	Result        bool             `protobuf:"varint,1,opt,name=result,proto3" json:"result,omitempty"`
	Msg           string           `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	SourceStatus  *SourceStatus    `protobuf:"bytes,3,opt,name=sourceStatus,proto3" json:"sourceStatus,omitempty"`
	SubTaskStatus []*SubTaskStatus `protobuf:"bytes,4,rep,name=subTaskStatus,proto3" json:"subTaskStatus,omitempty"`
}

func (m *QueryStatusResponse) Reset()         { *m = QueryStatusResponse{} }
func (m *QueryStatusResponse) String() string { return proto.CompactTextString(m) }
func (*QueryStatusResponse) ProtoMessage()    {}
func (*QueryStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{2}
}
func (m *QueryStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *QueryStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_QueryStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *QueryStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryStatusResponse.Merge(m, src)
}
func (m *QueryStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *QueryStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_QueryStatusResponse proto.InternalMessageInfo

func (m *QueryStatusResponse) GetResult() bool {
	if m != nil {
		return m.Result
	}
	return false
}

func (m *QueryStatusResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *QueryStatusResponse) GetSourceStatus() *SourceStatus {
	if m != nil {
		return m.SourceStatus
	}
	return nil
}

func (m *QueryStatusResponse) GetSubTaskStatus() []*SubTaskStatus {
	if m != nil {
		return m.SubTaskStatus
	}
	return nil
}

// CheckStatus represents status for check unit
// adds fields later
type CheckStatus struct {
	Passed     bool   `protobuf:"varint,1,opt,name=passed,proto3" json:"passed,omitempty"`
	Total      int32  `protobuf:"varint,2,opt,name=total,proto3" json:"total,omitempty"`
	Successful int32  `protobuf:"varint,3,opt,name=successful,proto3" json:"successful,omitempty"`
	Failed     int32  `protobuf:"varint,4,opt,name=failed,proto3" json:"failed,omitempty"`
	Warning    int32  `protobuf:"varint,5,opt,name=warning,proto3" json:"warning,omitempty"`
	Detail     []byte `protobuf:"bytes,6,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (m *CheckStatus) Reset()         { *m = CheckStatus{} }
func (m *CheckStatus) String() string { return proto.CompactTextString(m) }
func (*CheckStatus) ProtoMessage()    {}
func (*CheckStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{3}
}
func (m *CheckStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckStatus.Merge(m, src)
}
func (m *CheckStatus) XXX_Size() int {
	return m.Size()
}
func (m *CheckStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckStatus.DiscardUnknown(m)
}

var xxx_messageInfo_CheckStatus proto.InternalMessageInfo

func (m *CheckStatus) GetPassed() bool {
	if m != nil {
		return m.Passed
	}
	return false
}

func (m *CheckStatus) GetTotal() int32 {
	if m != nil {
		return m.Total
	}
	return 0
}

func (m *CheckStatus) GetSuccessful() int32 {
	if m != nil {
		return m.Successful
	}
	return 0
}

func (m *CheckStatus) GetFailed() int32 {
	if m != nil {
		return m.Failed
	}
	return 0
}

func (m *CheckStatus) GetWarning() int32 {
	if m != nil {
		return m.Warning
	}
	return 0
}

func (m *CheckStatus) GetDetail() []byte {
	if m != nil {
		return m.Detail
	}
	return nil
}

// DumpStatus represents status for dump unit
// add fields later
type DumpStatus struct {
	TotalTables       int64   `protobuf:"varint,1,opt,name=totalTables,proto3" json:"totalTables,omitempty"`
	CompletedTables   float64 `protobuf:"fixed64,2,opt,name=completedTables,proto3" json:"completedTables,omitempty"`
	FinishedBytes     float64 `protobuf:"fixed64,3,opt,name=finishedBytes,proto3" json:"finishedBytes,omitempty"`
	FinishedRows      float64 `protobuf:"fixed64,4,opt,name=finishedRows,proto3" json:"finishedRows,omitempty"`
	EstimateTotalRows float64 `protobuf:"fixed64,5,opt,name=estimateTotalRows,proto3" json:"estimateTotalRows,omitempty"`
	Bps               int64   `protobuf:"varint,6,opt,name=bps,proto3" json:"bps,omitempty"`
	Progress          string  `protobuf:"bytes,7,opt,name=progress,proto3" json:"progress,omitempty"`
}

func (m *DumpStatus) Reset()         { *m = DumpStatus{} }
func (m *DumpStatus) String() string { return proto.CompactTextString(m) }
func (*DumpStatus) ProtoMessage()    {}
func (*DumpStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{4}
}
func (m *DumpStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DumpStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DumpStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DumpStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DumpStatus.Merge(m, src)
}
func (m *DumpStatus) XXX_Size() int {
	return m.Size()
}
func (m *DumpStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_DumpStatus.DiscardUnknown(m)
}

var xxx_messageInfo_DumpStatus proto.InternalMessageInfo

func (m *DumpStatus) GetTotalTables() int64 {
	if m != nil {
		return m.TotalTables
	}
	return 0
}

func (m *DumpStatus) GetCompletedTables() float64 {
	if m != nil {
		return m.CompletedTables
	}
	return 0
}

func (m *DumpStatus) GetFinishedBytes() float64 {
	if m != nil {
		return m.FinishedBytes
	}
	return 0
}

func (m *DumpStatus) GetFinishedRows() float64 {
	if m != nil {
		return m.FinishedRows
	}
	return 0
}

func (m *DumpStatus) GetEstimateTotalRows() float64 {
	if m != nil {
		return m.EstimateTotalRows
	}
	return 0
}

func (m *DumpStatus) GetBps() int64 {
	if m != nil {
		return m.Bps
	}
	return 0
}

func (m *DumpStatus) GetProgress() string {
	if m != nil {
		return m.Progress
	}
	return ""
}

// LoadStatus represents status for load unit
type LoadStatus struct {
	FinishedBytes  int64  `protobuf:"varint,1,opt,name=finishedBytes,proto3" json:"finishedBytes,omitempty"`
	TotalBytes     int64  `protobuf:"varint,2,opt,name=totalBytes,proto3" json:"totalBytes,omitempty"`
	Progress       string `protobuf:"bytes,3,opt,name=progress,proto3" json:"progress,omitempty"`
	MetaBinlog     string `protobuf:"bytes,4,opt,name=metaBinlog,proto3" json:"metaBinlog,omitempty"`
	MetaBinlogGTID string `protobuf:"bytes,5,opt,name=metaBinlogGTID,proto3" json:"metaBinlogGTID,omitempty"`
	Bps            int64  `protobuf:"varint,6,opt,name=bps,proto3" json:"bps,omitempty"`
}

func (m *LoadStatus) Reset()         { *m = LoadStatus{} }
func (m *LoadStatus) String() string { return proto.CompactTextString(m) }
func (*LoadStatus) ProtoMessage()    {}
func (*LoadStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{5}
}
func (m *LoadStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadStatus.Merge(m, src)
}
func (m *LoadStatus) XXX_Size() int {
	return m.Size()
}
func (m *LoadStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadStatus.DiscardUnknown(m)
}

var xxx_messageInfo_LoadStatus proto.InternalMessageInfo

func (m *LoadStatus) GetFinishedBytes() int64 {
	if m != nil {
		return m.FinishedBytes
	}
	return 0
}

func (m *LoadStatus) GetTotalBytes() int64 {
	if m != nil {
		return m.TotalBytes
	}
	return 0
}

func (m *LoadStatus) GetProgress() string {
	if m != nil {
		return m.Progress
	}
	return ""
}

func (m *LoadStatus) GetMetaBinlog() string {
	if m != nil {
		return m.MetaBinlog
	}
	return ""
}

func (m *LoadStatus) GetMetaBinlogGTID() string {
	if m != nil {
		return m.MetaBinlogGTID
	}
	return ""
}

func (m *LoadStatus) GetBps() int64 {
	if m != nil {
		return m.Bps
	}
	return 0
}

// ShardingGroup represents a DDL sharding group, this is used by SyncStatus, and is differ from ShardingGroup in syncer pkg
// target: target table name
// DDL: in syncing DDL
// firstPos: first DDL binlog pos for this group
// synced: synced source tables
// unsynced: unsynced source tables
type ShardingGroup struct {
	Target        string   `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	DDLs          []string `protobuf:"bytes,2,rep,name=DDLs,proto3" json:"DDLs,omitempty"`
	FirstLocation string   `protobuf:"bytes,3,opt,name=firstLocation,proto3" json:"firstLocation,omitempty"`
	Synced        []string `protobuf:"bytes,4,rep,name=synced,proto3" json:"synced,omitempty"`
	Unsynced      []string `protobuf:"bytes,5,rep,name=unsynced,proto3" json:"unsynced,omitempty"`
}

func (m *ShardingGroup) Reset()         { *m = ShardingGroup{} }
func (m *ShardingGroup) String() string { return proto.CompactTextString(m) }
func (*ShardingGroup) ProtoMessage()    {}
func (*ShardingGroup) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{6}
}
func (m *ShardingGroup) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ShardingGroup) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ShardingGroup.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ShardingGroup) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShardingGroup.Merge(m, src)
}
func (m *ShardingGroup) XXX_Size() int {
	return m.Size()
}
func (m *ShardingGroup) XXX_DiscardUnknown() {
	xxx_messageInfo_ShardingGroup.DiscardUnknown(m)
}

var xxx_messageInfo_ShardingGroup proto.InternalMessageInfo

func (m *ShardingGroup) GetTarget() string {
	if m != nil {
		return m.Target
	}
	return ""
}

func (m *ShardingGroup) GetDDLs() []string {
	if m != nil {
		return m.DDLs
	}
	return nil
}

func (m *ShardingGroup) GetFirstLocation() string {
	if m != nil {
		return m.FirstLocation
	}
	return ""
}

func (m *ShardingGroup) GetSynced() []string {
	if m != nil {
		return m.Synced
	}
	return nil
}

func (m *ShardingGroup) GetUnsynced() []string {
	if m != nil {
		return m.Unsynced
	}
	return nil
}

// SyncStatus represents status for sync unit
type SyncStatus struct {
	// totalEvents/totalTps/recentTps has been deprecated now
	TotalEvents         int64            `protobuf:"varint,1,opt,name=totalEvents,proto3" json:"totalEvents,omitempty"`
	TotalTps            int64            `protobuf:"varint,2,opt,name=totalTps,proto3" json:"totalTps,omitempty"`
	RecentTps           int64            `protobuf:"varint,3,opt,name=recentTps,proto3" json:"recentTps,omitempty"`
	MasterBinlog        string           `protobuf:"bytes,4,opt,name=masterBinlog,proto3" json:"masterBinlog,omitempty"`
	MasterBinlogGtid    string           `protobuf:"bytes,5,opt,name=masterBinlogGtid,proto3" json:"masterBinlogGtid,omitempty"`
	SyncerBinlog        string           `protobuf:"bytes,6,opt,name=syncerBinlog,proto3" json:"syncerBinlog,omitempty"`
	SyncerBinlogGtid    string           `protobuf:"bytes,7,opt,name=syncerBinlogGtid,proto3" json:"syncerBinlogGtid,omitempty"`
	BlockingDDLs        []string         `protobuf:"bytes,8,rep,name=blockingDDLs,proto3" json:"blockingDDLs,omitempty"`
	UnresolvedGroups    []*ShardingGroup `protobuf:"bytes,9,rep,name=unresolvedGroups,proto3" json:"unresolvedGroups,omitempty"`
	Synced              bool             `protobuf:"varint,10,opt,name=synced,proto3" json:"synced,omitempty"`
	BinlogType          string           `protobuf:"bytes,11,opt,name=binlogType,proto3" json:"binlogType,omitempty"`
	SecondsBehindMaster int64            `protobuf:"varint,12,opt,name=secondsBehindMaster,proto3" json:"secondsBehindMaster,omitempty"`
	BlockDDLOwner       string           `protobuf:"bytes,13,opt,name=blockDDLOwner,proto3" json:"blockDDLOwner,omitempty"`
	ConflictMsg         string           `protobuf:"bytes,14,opt,name=conflictMsg,proto3" json:"conflictMsg,omitempty"`
	TotalRows           int64            `protobuf:"varint,15,opt,name=totalRows,proto3" json:"totalRows,omitempty"`
	TotalRps            int64            `protobuf:"varint,16,opt,name=totalRps,proto3" json:"totalRps,omitempty"`
	RecentRps           int64            `protobuf:"varint,17,opt,name=recentRps,proto3" json:"recentRps,omitempty"`
	// meter TCP io to downstream of the subtask
	IoTotalBytes uint64 `protobuf:"varint,18,opt,name=ioTotalBytes,proto3" json:"ioTotalBytes,omitempty"`
	// meter TCP io from upstream of the subtask
	DumpIOTotalBytes uint64 `protobuf:"varint,19,opt,name=dumpIOTotalBytes,proto3" json:"dumpIOTotalBytes,omitempty"`
}

func (m *SyncStatus) Reset()         { *m = SyncStatus{} }
func (m *SyncStatus) String() string { return proto.CompactTextString(m) }
func (*SyncStatus) ProtoMessage()    {}
func (*SyncStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{7}
}
func (m *SyncStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncStatus.Merge(m, src)
}
func (m *SyncStatus) XXX_Size() int {
	return m.Size()
}
func (m *SyncStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncStatus.DiscardUnknown(m)
}

var xxx_messageInfo_SyncStatus proto.InternalMessageInfo

func (m *SyncStatus) GetTotalEvents() int64 {
	if m != nil {
		return m.TotalEvents
	}
	return 0
}

func (m *SyncStatus) GetTotalTps() int64 {
	if m != nil {
		return m.TotalTps
	}
	return 0
}

func (m *SyncStatus) GetRecentTps() int64 {
	if m != nil {
		return m.RecentTps
	}
	return 0
}

func (m *SyncStatus) GetMasterBinlog() string {
	if m != nil {
		return m.MasterBinlog
	}
	return ""
}

func (m *SyncStatus) GetMasterBinlogGtid() string {
	if m != nil {
		return m.MasterBinlogGtid
	}
	return ""
}

func (m *SyncStatus) GetSyncerBinlog() string {
	if m != nil {
		return m.SyncerBinlog
	}
	return ""
}

func (m *SyncStatus) GetSyncerBinlogGtid() string {
	if m != nil {
		return m.SyncerBinlogGtid
	}
	return ""
}

func (m *SyncStatus) GetBlockingDDLs() []string {
	if m != nil {
		return m.BlockingDDLs
	}
	return nil
}

func (m *SyncStatus) GetUnresolvedGroups() []*ShardingGroup {
	if m != nil {
		return m.UnresolvedGroups
	}
	return nil
}

func (m *SyncStatus) GetSynced() bool {
	if m != nil {
		return m.Synced
	}
	return false
}

func (m *SyncStatus) GetBinlogType() string {
	if m != nil {
		return m.BinlogType
	}
	return ""
}

func (m *SyncStatus) GetSecondsBehindMaster() int64 {
	if m != nil {
		return m.SecondsBehindMaster
	}
	return 0
}

func (m *SyncStatus) GetBlockDDLOwner() string {
	if m != nil {
		return m.BlockDDLOwner
	}
	return ""
}

func (m *SyncStatus) GetConflictMsg() string {
	if m != nil {
		return m.ConflictMsg
	}
	return ""
}

func (m *SyncStatus) GetTotalRows() int64 {
	if m != nil {
		return m.TotalRows
	}
	return 0
}

func (m *SyncStatus) GetTotalRps() int64 {
	if m != nil {
		return m.TotalRps
	}
	return 0
}

func (m *SyncStatus) GetRecentRps() int64 {
	if m != nil {
		return m.RecentRps
	}
	return 0
}

func (m *SyncStatus) GetIoTotalBytes() uint64 {
	if m != nil {
		return m.IoTotalBytes
	}
	return 0
}

func (m *SyncStatus) GetDumpIOTotalBytes() uint64 {
	if m != nil {
		return m.DumpIOTotalBytes
	}
	return 0
}

// SourceStatus represents status for source runing on dm-worker
type SourceStatus struct {
	Source      string         `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	Worker      string         `protobuf:"bytes,2,opt,name=worker,proto3" json:"worker,omitempty"`
	Result      *ProcessResult `protobuf:"bytes,3,opt,name=result,proto3" json:"result,omitempty"`
	RelayStatus *RelayStatus   `protobuf:"bytes,4,opt,name=relayStatus,proto3" json:"relayStatus,omitempty"`
}

func (m *SourceStatus) Reset()         { *m = SourceStatus{} }
func (m *SourceStatus) String() string { return proto.CompactTextString(m) }
func (*SourceStatus) ProtoMessage()    {}
func (*SourceStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{8}
}
func (m *SourceStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SourceStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SourceStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SourceStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceStatus.Merge(m, src)
}
func (m *SourceStatus) XXX_Size() int {
	return m.Size()
}
func (m *SourceStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceStatus.DiscardUnknown(m)
}

var xxx_messageInfo_SourceStatus proto.InternalMessageInfo

func (m *SourceStatus) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *SourceStatus) GetWorker() string {
	if m != nil {
		return m.Worker
	}
	return ""
}

func (m *SourceStatus) GetResult() *ProcessResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *SourceStatus) GetRelayStatus() *RelayStatus {
	if m != nil {
		return m.RelayStatus
	}
	return nil
}

// RelayStatus represents status for relay unit.
type RelayStatus struct {
	MasterBinlog       string         `protobuf:"bytes,1,opt,name=masterBinlog,proto3" json:"masterBinlog,omitempty"`
	MasterBinlogGtid   string         `protobuf:"bytes,2,opt,name=masterBinlogGtid,proto3" json:"masterBinlogGtid,omitempty"`
	RelaySubDir        string         `protobuf:"bytes,3,opt,name=relaySubDir,proto3" json:"relaySubDir,omitempty"`
	RelayBinlog        string         `protobuf:"bytes,4,opt,name=relayBinlog,proto3" json:"relayBinlog,omitempty"`
	RelayBinlogGtid    string         `protobuf:"bytes,5,opt,name=relayBinlogGtid,proto3" json:"relayBinlogGtid,omitempty"`
	RelayCatchUpMaster bool           `protobuf:"varint,6,opt,name=relayCatchUpMaster,proto3" json:"relayCatchUpMaster,omitempty"`
	Stage              Stage          `protobuf:"varint,7,opt,name=stage,proto3,enum=pb.Stage" json:"stage,omitempty"`
	Result             *ProcessResult `protobuf:"bytes,8,opt,name=result,proto3" json:"result,omitempty"`
}

func (m *RelayStatus) Reset()         { *m = RelayStatus{} }
func (m *RelayStatus) String() string { return proto.CompactTextString(m) }
func (*RelayStatus) ProtoMessage()    {}
func (*RelayStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{9}
}
func (m *RelayStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RelayStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RelayStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RelayStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RelayStatus.Merge(m, src)
}
func (m *RelayStatus) XXX_Size() int {
	return m.Size()
}
func (m *RelayStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_RelayStatus.DiscardUnknown(m)
}

var xxx_messageInfo_RelayStatus proto.InternalMessageInfo

func (m *RelayStatus) GetMasterBinlog() string {
	if m != nil {
		return m.MasterBinlog
	}
	return ""
}

func (m *RelayStatus) GetMasterBinlogGtid() string {
	if m != nil {
		return m.MasterBinlogGtid
	}
	return ""
}

func (m *RelayStatus) GetRelaySubDir() string {
	if m != nil {
		return m.RelaySubDir
	}
	return ""
}

func (m *RelayStatus) GetRelayBinlog() string {
	if m != nil {
		return m.RelayBinlog
	}
	return ""
}

func (m *RelayStatus) GetRelayBinlogGtid() string {
	if m != nil {
		return m.RelayBinlogGtid
	}
	return ""
}

func (m *RelayStatus) GetRelayCatchUpMaster() bool {
	if m != nil {
		return m.RelayCatchUpMaster
	}
	return false
}

func (m *RelayStatus) GetStage() Stage {
	if m != nil {
		return m.Stage
	}
	return Stage_InvalidStage
}

func (m *RelayStatus) GetResult() *ProcessResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// SubTaskStatus represents status for a sub task
// name: sub task'name, when starting a sub task the name should be unique
// stage: sub task's current stage
// unit: sub task's current dm unit's UnitType
// result: current unit's process result, when the stage is Running, no result
// unresolvedDDLLockID: un-resolved sharding DDL lock ID (ref DDLLockInfo)
//
//	if needed, we can put this to SyncStatus
//
// status: current unit's statistics
//
//	for Load, includes total bytes, progress, etc.
//	for Sync, includes TPS, binlog meta, etc.
type SubTaskStatus struct {
	Name                string         `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Stage               Stage          `protobuf:"varint,2,opt,name=stage,proto3,enum=pb.Stage" json:"stage,omitempty"`
	Unit                UnitType       `protobuf:"varint,3,opt,name=unit,proto3,enum=pb.UnitType" json:"unit,omitempty"`
	Result              *ProcessResult `protobuf:"bytes,4,opt,name=result,proto3" json:"result,omitempty"`
	UnresolvedDDLLockID string         `protobuf:"bytes,5,opt,name=unresolvedDDLLockID,proto3" json:"unresolvedDDLLockID,omitempty"`
	// Types that are valid to be assigned to Status:
	//
	//	*SubTaskStatus_Msg
	//	*SubTaskStatus_Check
	//	*SubTaskStatus_Dump
	//	*SubTaskStatus_Load
	//	*SubTaskStatus_Sync
	Status     isSubTaskStatus_Status `protobuf_oneof:"status"`
	Validation *ValidationStatus      `protobuf:"bytes,11,opt,name=validation,proto3" json:"validation,omitempty"`
}

func (m *SubTaskStatus) Reset()         { *m = SubTaskStatus{} }
func (m *SubTaskStatus) String() string { return proto.CompactTextString(m) }
func (*SubTaskStatus) ProtoMessage()    {}
func (*SubTaskStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{10}
}
func (m *SubTaskStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SubTaskStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SubTaskStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SubTaskStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubTaskStatus.Merge(m, src)
}
func (m *SubTaskStatus) XXX_Size() int {
	return m.Size()
}
func (m *SubTaskStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_SubTaskStatus.DiscardUnknown(m)
}

var xxx_messageInfo_SubTaskStatus proto.InternalMessageInfo

type isSubTaskStatus_Status interface {
	isSubTaskStatus_Status()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SubTaskStatus_Msg struct {
	Msg string `protobuf:"bytes,6,opt,name=msg,proto3,oneof" json:"msg,omitempty"`
}
type SubTaskStatus_Check struct {
	Check *CheckStatus `protobuf:"bytes,7,opt,name=check,proto3,oneof" json:"check,omitempty"`
}
type SubTaskStatus_Dump struct {
	Dump *DumpStatus `protobuf:"bytes,8,opt,name=dump,proto3,oneof" json:"dump,omitempty"`
}
type SubTaskStatus_Load struct {
	Load *LoadStatus `protobuf:"bytes,9,opt,name=load,proto3,oneof" json:"load,omitempty"`
}
type SubTaskStatus_Sync struct {
	Sync *SyncStatus `protobuf:"bytes,10,opt,name=sync,proto3,oneof" json:"sync,omitempty"`
}

func (*SubTaskStatus_Msg) isSubTaskStatus_Status()   {}
func (*SubTaskStatus_Check) isSubTaskStatus_Status() {}
func (*SubTaskStatus_Dump) isSubTaskStatus_Status()  {}
func (*SubTaskStatus_Load) isSubTaskStatus_Status()  {}
func (*SubTaskStatus_Sync) isSubTaskStatus_Status()  {}

func (m *SubTaskStatus) GetStatus() isSubTaskStatus_Status {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *SubTaskStatus) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SubTaskStatus) GetStage() Stage {
	if m != nil {
		return m.Stage
	}
	return Stage_InvalidStage
}

func (m *SubTaskStatus) GetUnit() UnitType {
	if m != nil {
		return m.Unit
	}
	return UnitType_InvalidUnit
}

func (m *SubTaskStatus) GetResult() *ProcessResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *SubTaskStatus) GetUnresolvedDDLLockID() string {
	if m != nil {
		return m.UnresolvedDDLLockID
	}
	return ""
}

func (m *SubTaskStatus) GetMsg() string {
	if x, ok := m.GetStatus().(*SubTaskStatus_Msg); ok {
		return x.Msg
	}
	return ""
}

func (m *SubTaskStatus) GetCheck() *CheckStatus {
	if x, ok := m.GetStatus().(*SubTaskStatus_Check); ok {
		return x.Check
	}
	return nil
}

func (m *SubTaskStatus) GetDump() *DumpStatus {
	if x, ok := m.GetStatus().(*SubTaskStatus_Dump); ok {
		return x.Dump
	}
	return nil
}

func (m *SubTaskStatus) GetLoad() *LoadStatus {
	if x, ok := m.GetStatus().(*SubTaskStatus_Load); ok {
		return x.Load
	}
	return nil
}

func (m *SubTaskStatus) GetSync() *SyncStatus {
	if x, ok := m.GetStatus().(*SubTaskStatus_Sync); ok {
		return x.Sync
	}
	return nil
}

func (m *SubTaskStatus) GetValidation() *ValidationStatus {
	if m != nil {
		return m.Validation
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SubTaskStatus) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SubTaskStatus_Msg)(nil),
		(*SubTaskStatus_Check)(nil),
		(*SubTaskStatus_Dump)(nil),
		(*SubTaskStatus_Load)(nil),
		(*SubTaskStatus_Sync)(nil),
	}
}

// SubTaskStatusList used for internal jsonpb marshal
type SubTaskStatusList struct {
	Status []*SubTaskStatus `protobuf:"bytes,1,rep,name=status,proto3" json:"status,omitempty"`
}

func (m *SubTaskStatusList) Reset()         { *m = SubTaskStatusList{} }
func (m *SubTaskStatusList) String() string { return proto.CompactTextString(m) }
func (*SubTaskStatusList) ProtoMessage()    {}
func (*SubTaskStatusList) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{11}
}
func (m *SubTaskStatusList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SubTaskStatusList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SubTaskStatusList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SubTaskStatusList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubTaskStatusList.Merge(m, src)
}
func (m *SubTaskStatusList) XXX_Size() int {
	return m.Size()
}
func (m *SubTaskStatusList) XXX_DiscardUnknown() {
	xxx_messageInfo_SubTaskStatusList.DiscardUnknown(m)
}

var xxx_messageInfo_SubTaskStatusList proto.InternalMessageInfo

func (m *SubTaskStatusList) GetStatus() []*SubTaskStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

// CheckError represents error for check unit
// adds fields later
type CheckError struct {
	Msg string `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
}

func (m *CheckError) Reset()         { *m = CheckError{} }
func (m *CheckError) String() string { return proto.CompactTextString(m) }
func (*CheckError) ProtoMessage()    {}
func (*CheckError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{12}
}
func (m *CheckError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckError.Merge(m, src)
}
func (m *CheckError) XXX_Size() int {
	return m.Size()
}
func (m *CheckError) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckError.DiscardUnknown(m)
}

var xxx_messageInfo_CheckError proto.InternalMessageInfo

func (m *CheckError) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

// DumpError represents error for dump unit
// add fields later
type DumpError struct {
	Msg string `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
}

func (m *DumpError) Reset()         { *m = DumpError{} }
func (m *DumpError) String() string { return proto.CompactTextString(m) }
func (*DumpError) ProtoMessage()    {}
func (*DumpError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{13}
}
func (m *DumpError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *DumpError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_DumpError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *DumpError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DumpError.Merge(m, src)
}
func (m *DumpError) XXX_Size() int {
	return m.Size()
}
func (m *DumpError) XXX_DiscardUnknown() {
	xxx_messageInfo_DumpError.DiscardUnknown(m)
}

var xxx_messageInfo_DumpError proto.InternalMessageInfo

func (m *DumpError) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

// LoadError represents error for load unit
type LoadError struct {
	Msg string `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
}

func (m *LoadError) Reset()         { *m = LoadError{} }
func (m *LoadError) String() string { return proto.CompactTextString(m) }
func (*LoadError) ProtoMessage()    {}
func (*LoadError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{14}
}
func (m *LoadError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *LoadError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_LoadError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *LoadError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadError.Merge(m, src)
}
func (m *LoadError) XXX_Size() int {
	return m.Size()
}
func (m *LoadError) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadError.DiscardUnknown(m)
}

var xxx_messageInfo_LoadError proto.InternalMessageInfo

func (m *LoadError) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

// SyncSQLError represents a sql error in sync unit
type SyncSQLError struct {
	Msg                  string `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
	FailedBinlogPosition string `protobuf:"bytes,2,opt,name=failedBinlogPosition,proto3" json:"failedBinlogPosition,omitempty"`
	ErrorSQL             string `protobuf:"bytes,3,opt,name=errorSQL,proto3" json:"errorSQL,omitempty"`
}

func (m *SyncSQLError) Reset()         { *m = SyncSQLError{} }
func (m *SyncSQLError) String() string { return proto.CompactTextString(m) }
func (*SyncSQLError) ProtoMessage()    {}
func (*SyncSQLError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{15}
}
func (m *SyncSQLError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncSQLError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncSQLError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncSQLError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncSQLError.Merge(m, src)
}
func (m *SyncSQLError) XXX_Size() int {
	return m.Size()
}
func (m *SyncSQLError) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncSQLError.DiscardUnknown(m)
}

var xxx_messageInfo_SyncSQLError proto.InternalMessageInfo

func (m *SyncSQLError) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *SyncSQLError) GetFailedBinlogPosition() string {
	if m != nil {
		return m.FailedBinlogPosition
	}
	return ""
}

func (m *SyncSQLError) GetErrorSQL() string {
	if m != nil {
		return m.ErrorSQL
	}
	return ""
}

// SyncError represents error list for sync unit
type SyncError struct {
	Errors []*SyncSQLError `protobuf:"bytes,1,rep,name=errors,proto3" json:"errors,omitempty"`
}

func (m *SyncError) Reset()         { *m = SyncError{} }
func (m *SyncError) String() string { return proto.CompactTextString(m) }
func (*SyncError) ProtoMessage()    {}
func (*SyncError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{16}
}
func (m *SyncError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SyncError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SyncError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SyncError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SyncError.Merge(m, src)
}
func (m *SyncError) XXX_Size() int {
	return m.Size()
}
func (m *SyncError) XXX_DiscardUnknown() {
	xxx_messageInfo_SyncError.DiscardUnknown(m)
}

var xxx_messageInfo_SyncError proto.InternalMessageInfo

func (m *SyncError) GetErrors() []*SyncSQLError {
	if m != nil {
		return m.Errors
	}
	return nil
}

// SourceError represents error for start/stop source on dm-worker
type SourceError struct {
	Source      string      `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	Worker      string      `protobuf:"bytes,2,opt,name=worker,proto3" json:"worker,omitempty"`
	SourceError string      `protobuf:"bytes,3,opt,name=SourceError,proto3" json:"SourceError,omitempty"`
	RelayError  *RelayError `protobuf:"bytes,4,opt,name=RelayError,proto3" json:"RelayError,omitempty"`
}

func (m *SourceError) Reset()         { *m = SourceError{} }
func (m *SourceError) String() string { return proto.CompactTextString(m) }
func (*SourceError) ProtoMessage()    {}
func (*SourceError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{17}
}
func (m *SourceError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SourceError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SourceError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SourceError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceError.Merge(m, src)
}
func (m *SourceError) XXX_Size() int {
	return m.Size()
}
func (m *SourceError) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceError.DiscardUnknown(m)
}

var xxx_messageInfo_SourceError proto.InternalMessageInfo

func (m *SourceError) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *SourceError) GetWorker() string {
	if m != nil {
		return m.Worker
	}
	return ""
}

func (m *SourceError) GetSourceError() string {
	if m != nil {
		return m.SourceError
	}
	return ""
}

func (m *SourceError) GetRelayError() *RelayError {
	if m != nil {
		return m.RelayError
	}
	return nil
}

// RelayError represents error for relay unit.
type RelayError struct {
	Msg string `protobuf:"bytes,1,opt,name=msg,proto3" json:"msg,omitempty"`
}

func (m *RelayError) Reset()         { *m = RelayError{} }
func (m *RelayError) String() string { return proto.CompactTextString(m) }
func (*RelayError) ProtoMessage()    {}
func (*RelayError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{18}
}
func (m *RelayError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RelayError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RelayError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RelayError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RelayError.Merge(m, src)
}
func (m *RelayError) XXX_Size() int {
	return m.Size()
}
func (m *RelayError) XXX_DiscardUnknown() {
	xxx_messageInfo_RelayError.DiscardUnknown(m)
}

var xxx_messageInfo_RelayError proto.InternalMessageInfo

func (m *RelayError) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

// SubTaskError represents error for a sub task during running
// name: sub task'name, when starting a sub task the name should be unique
// stage: sub task's current stage
// unit: sub task's current dm unit's UnitType
// error: current unit's error information
//
//	for Sync, includes failed sql, failed sql pos in binlog, etc.
type SubTaskError struct {
	Name  string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Stage Stage    `protobuf:"varint,2,opt,name=stage,proto3,enum=pb.Stage" json:"stage,omitempty"`
	Unit  UnitType `protobuf:"varint,3,opt,name=unit,proto3,enum=pb.UnitType" json:"unit,omitempty"`
	// Types that are valid to be assigned to Error:
	//
	//	*SubTaskError_Msg
	//	*SubTaskError_Check
	//	*SubTaskError_Dump
	//	*SubTaskError_Load
	//	*SubTaskError_Sync
	Error isSubTaskError_Error `protobuf_oneof:"error"`
}

func (m *SubTaskError) Reset()         { *m = SubTaskError{} }
func (m *SubTaskError) String() string { return proto.CompactTextString(m) }
func (*SubTaskError) ProtoMessage()    {}
func (*SubTaskError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{19}
}
func (m *SubTaskError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SubTaskError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SubTaskError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SubTaskError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubTaskError.Merge(m, src)
}
func (m *SubTaskError) XXX_Size() int {
	return m.Size()
}
func (m *SubTaskError) XXX_DiscardUnknown() {
	xxx_messageInfo_SubTaskError.DiscardUnknown(m)
}

var xxx_messageInfo_SubTaskError proto.InternalMessageInfo

type isSubTaskError_Error interface {
	isSubTaskError_Error()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SubTaskError_Msg struct {
	Msg string `protobuf:"bytes,4,opt,name=msg,proto3,oneof" json:"msg,omitempty"`
}
type SubTaskError_Check struct {
	Check *CheckError `protobuf:"bytes,5,opt,name=check,proto3,oneof" json:"check,omitempty"`
}
type SubTaskError_Dump struct {
	Dump *DumpError `protobuf:"bytes,6,opt,name=dump,proto3,oneof" json:"dump,omitempty"`
}
type SubTaskError_Load struct {
	Load *LoadError `protobuf:"bytes,7,opt,name=load,proto3,oneof" json:"load,omitempty"`
}
type SubTaskError_Sync struct {
	Sync *SyncError `protobuf:"bytes,8,opt,name=sync,proto3,oneof" json:"sync,omitempty"`
}

func (*SubTaskError_Msg) isSubTaskError_Error()   {}
func (*SubTaskError_Check) isSubTaskError_Error() {}
func (*SubTaskError_Dump) isSubTaskError_Error()  {}
func (*SubTaskError_Load) isSubTaskError_Error()  {}
func (*SubTaskError_Sync) isSubTaskError_Error()  {}

func (m *SubTaskError) GetError() isSubTaskError_Error {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *SubTaskError) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SubTaskError) GetStage() Stage {
	if m != nil {
		return m.Stage
	}
	return Stage_InvalidStage
}

func (m *SubTaskError) GetUnit() UnitType {
	if m != nil {
		return m.Unit
	}
	return UnitType_InvalidUnit
}

func (m *SubTaskError) GetMsg() string {
	if x, ok := m.GetError().(*SubTaskError_Msg); ok {
		return x.Msg
	}
	return ""
}

func (m *SubTaskError) GetCheck() *CheckError {
	if x, ok := m.GetError().(*SubTaskError_Check); ok {
		return x.Check
	}
	return nil
}

func (m *SubTaskError) GetDump() *DumpError {
	if x, ok := m.GetError().(*SubTaskError_Dump); ok {
		return x.Dump
	}
	return nil
}

func (m *SubTaskError) GetLoad() *LoadError {
	if x, ok := m.GetError().(*SubTaskError_Load); ok {
		return x.Load
	}
	return nil
}

func (m *SubTaskError) GetSync() *SyncError {
	if x, ok := m.GetError().(*SubTaskError_Sync); ok {
		return x.Sync
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SubTaskError) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SubTaskError_Msg)(nil),
		(*SubTaskError_Check)(nil),
		(*SubTaskError_Dump)(nil),
		(*SubTaskError_Load)(nil),
		(*SubTaskError_Sync)(nil),
	}
}

// SubTaskErrorList used for internal jsonpb marshal
type SubTaskErrorList struct {
	Error []*SubTaskError `protobuf:"bytes,1,rep,name=error,proto3" json:"error,omitempty"`
}

func (m *SubTaskErrorList) Reset()         { *m = SubTaskErrorList{} }
func (m *SubTaskErrorList) String() string { return proto.CompactTextString(m) }
func (*SubTaskErrorList) ProtoMessage()    {}
func (*SubTaskErrorList) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{20}
}
func (m *SubTaskErrorList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SubTaskErrorList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SubTaskErrorList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SubTaskErrorList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubTaskErrorList.Merge(m, src)
}
func (m *SubTaskErrorList) XXX_Size() int {
	return m.Size()
}
func (m *SubTaskErrorList) XXX_DiscardUnknown() {
	xxx_messageInfo_SubTaskErrorList.DiscardUnknown(m)
}

var xxx_messageInfo_SubTaskErrorList proto.InternalMessageInfo

func (m *SubTaskErrorList) GetError() []*SubTaskError {
	if m != nil {
		return m.Error
	}
	return nil
}

// ProcessResult represents results produced by a dm unit
// isCanceled: indicates whether the process is canceled from external
//
//	when Stop or Pause is requested from external, isCanceled will be true
//
// errors: includes all (potential) errors occured when processing
type ProcessResult struct {
	IsCanceled bool            `protobuf:"varint,1,opt,name=isCanceled,proto3" json:"isCanceled,omitempty"`
	Errors     []*ProcessError `protobuf:"bytes,2,rep,name=errors,proto3" json:"errors,omitempty"`
	Detail     []byte          `protobuf:"bytes,3,opt,name=detail,proto3" json:"detail,omitempty"`
}

func (m *ProcessResult) Reset()         { *m = ProcessResult{} }
func (m *ProcessResult) String() string { return proto.CompactTextString(m) }
func (*ProcessResult) ProtoMessage()    {}
func (*ProcessResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{21}
}
func (m *ProcessResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessResult.Merge(m, src)
}
func (m *ProcessResult) XXX_Size() int {
	return m.Size()
}
func (m *ProcessResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessResult.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessResult proto.InternalMessageInfo

func (m *ProcessResult) GetIsCanceled() bool {
	if m != nil {
		return m.IsCanceled
	}
	return false
}

func (m *ProcessResult) GetErrors() []*ProcessError {
	if m != nil {
		return m.Errors
	}
	return nil
}

func (m *ProcessResult) GetDetail() []byte {
	if m != nil {
		return m.Detail
	}
	return nil
}

// ProcessError is same as terror used in dm
// NOTE: currently stack trace is not supported, `Message` is the `terror.Error.getMsg` result
// and `RawCause` is the `Error` result of error from `terror.Error.Cause()`.
type ProcessError struct {
	ErrCode    int32  `protobuf:"varint,1,opt,name=ErrCode,proto3" json:"ErrCode,omitempty"`
	ErrClass   string `protobuf:"bytes,2,opt,name=ErrClass,proto3" json:"ErrClass,omitempty"`
	ErrScope   string `protobuf:"bytes,3,opt,name=ErrScope,proto3" json:"ErrScope,omitempty"`
	ErrLevel   string `protobuf:"bytes,4,opt,name=ErrLevel,proto3" json:"ErrLevel,omitempty"`
	Message    string `protobuf:"bytes,5,opt,name=Message,proto3" json:"Message,omitempty"`
	RawCause   string `protobuf:"bytes,6,opt,name=RawCause,proto3" json:"RawCause,omitempty"`
	Workaround string `protobuf:"bytes,7,opt,name=Workaround,proto3" json:"Workaround,omitempty"`
}

func (m *ProcessError) Reset()         { *m = ProcessError{} }
func (m *ProcessError) String() string { return proto.CompactTextString(m) }
func (*ProcessError) ProtoMessage()    {}
func (*ProcessError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{22}
}
func (m *ProcessError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProcessError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProcessError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProcessError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProcessError.Merge(m, src)
}
func (m *ProcessError) XXX_Size() int {
	return m.Size()
}
func (m *ProcessError) XXX_DiscardUnknown() {
	xxx_messageInfo_ProcessError.DiscardUnknown(m)
}

var xxx_messageInfo_ProcessError proto.InternalMessageInfo

func (m *ProcessError) GetErrCode() int32 {
	if m != nil {
		return m.ErrCode
	}
	return 0
}

func (m *ProcessError) GetErrClass() string {
	if m != nil {
		return m.ErrClass
	}
	return ""
}

func (m *ProcessError) GetErrScope() string {
	if m != nil {
		return m.ErrScope
	}
	return ""
}

func (m *ProcessError) GetErrLevel() string {
	if m != nil {
		return m.ErrLevel
	}
	return ""
}

func (m *ProcessError) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *ProcessError) GetRawCause() string {
	if m != nil {
		return m.RawCause
	}
	return ""
}

func (m *ProcessError) GetWorkaround() string {
	if m != nil {
		return m.Workaround
	}
	return ""
}

// PurgeRelayRequest represents a request to purge relay log files for this dm-worker
// inactive: whether purge inactive relay log files
// time: whether purge relay log files before this time, the number of seconds elapsed since January 1, 1970 UTC
// filename: whether purge relay log files before this filename
// subDir: specify relay sub directory for @filename
type PurgeRelayRequest struct {
	Inactive bool   `protobuf:"varint,1,opt,name=inactive,proto3" json:"inactive,omitempty"`
	Time     int64  `protobuf:"varint,2,opt,name=time,proto3" json:"time,omitempty"`
	Filename string `protobuf:"bytes,3,opt,name=filename,proto3" json:"filename,omitempty"`
	SubDir   string `protobuf:"bytes,4,opt,name=subDir,proto3" json:"subDir,omitempty"`
}

func (m *PurgeRelayRequest) Reset()         { *m = PurgeRelayRequest{} }
func (m *PurgeRelayRequest) String() string { return proto.CompactTextString(m) }
func (*PurgeRelayRequest) ProtoMessage()    {}
func (*PurgeRelayRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{23}
}
func (m *PurgeRelayRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PurgeRelayRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PurgeRelayRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PurgeRelayRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PurgeRelayRequest.Merge(m, src)
}
func (m *PurgeRelayRequest) XXX_Size() int {
	return m.Size()
}
func (m *PurgeRelayRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PurgeRelayRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PurgeRelayRequest proto.InternalMessageInfo

func (m *PurgeRelayRequest) GetInactive() bool {
	if m != nil {
		return m.Inactive
	}
	return false
}

func (m *PurgeRelayRequest) GetTime() int64 {
	if m != nil {
		return m.Time
	}
	return 0
}

func (m *PurgeRelayRequest) GetFilename() string {
	if m != nil {
		return m.Filename
	}
	return ""
}

func (m *PurgeRelayRequest) GetSubDir() string {
	if m != nil {
		return m.SubDir
	}
	return ""
}

type OperateWorkerSchemaRequest struct {
	Op         SchemaOp `protobuf:"varint,1,opt,name=op,proto3,enum=pb.SchemaOp" json:"op,omitempty"`
	Task       string   `protobuf:"bytes,2,opt,name=task,proto3" json:"task,omitempty"`
	Source     string   `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	Database   string   `protobuf:"bytes,4,opt,name=database,proto3" json:"database,omitempty"`
	Table      string   `protobuf:"bytes,5,opt,name=table,proto3" json:"table,omitempty"`
	Schema     string   `protobuf:"bytes,6,opt,name=schema,proto3" json:"schema,omitempty"`
	Flush      bool     `protobuf:"varint,7,opt,name=flush,proto3" json:"flush,omitempty"`
	Sync       bool     `protobuf:"varint,8,opt,name=sync,proto3" json:"sync,omitempty"`
	FromSource bool     `protobuf:"varint,9,opt,name=fromSource,proto3" json:"fromSource,omitempty"`
	FromTarget bool     `protobuf:"varint,10,opt,name=fromTarget,proto3" json:"fromTarget,omitempty"`
}

func (m *OperateWorkerSchemaRequest) Reset()         { *m = OperateWorkerSchemaRequest{} }
func (m *OperateWorkerSchemaRequest) String() string { return proto.CompactTextString(m) }
func (*OperateWorkerSchemaRequest) ProtoMessage()    {}
func (*OperateWorkerSchemaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{24}
}
func (m *OperateWorkerSchemaRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OperateWorkerSchemaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OperateWorkerSchemaRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OperateWorkerSchemaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperateWorkerSchemaRequest.Merge(m, src)
}
func (m *OperateWorkerSchemaRequest) XXX_Size() int {
	return m.Size()
}
func (m *OperateWorkerSchemaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OperateWorkerSchemaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OperateWorkerSchemaRequest proto.InternalMessageInfo

func (m *OperateWorkerSchemaRequest) GetOp() SchemaOp {
	if m != nil {
		return m.Op
	}
	return SchemaOp_InvalidSchemaOp
}

func (m *OperateWorkerSchemaRequest) GetTask() string {
	if m != nil {
		return m.Task
	}
	return ""
}

func (m *OperateWorkerSchemaRequest) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *OperateWorkerSchemaRequest) GetDatabase() string {
	if m != nil {
		return m.Database
	}
	return ""
}

func (m *OperateWorkerSchemaRequest) GetTable() string {
	if m != nil {
		return m.Table
	}
	return ""
}

func (m *OperateWorkerSchemaRequest) GetSchema() string {
	if m != nil {
		return m.Schema
	}
	return ""
}

func (m *OperateWorkerSchemaRequest) GetFlush() bool {
	if m != nil {
		return m.Flush
	}
	return false
}

func (m *OperateWorkerSchemaRequest) GetSync() bool {
	if m != nil {
		return m.Sync
	}
	return false
}

func (m *OperateWorkerSchemaRequest) GetFromSource() bool {
	if m != nil {
		return m.FromSource
	}
	return false
}

func (m *OperateWorkerSchemaRequest) GetFromTarget() bool {
	if m != nil {
		return m.FromTarget
	}
	return false
}

// copied `TaskMeta` from release-1.0 branch.
type V1SubTaskMeta struct {
	Op    TaskOp `protobuf:"varint,1,opt,name=op,proto3,enum=pb.TaskOp" json:"op,omitempty"`
	Stage Stage  `protobuf:"varint,2,opt,name=stage,proto3,enum=pb.Stage" json:"stage,omitempty"`
	Name  string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	Task  []byte `protobuf:"bytes,4,opt,name=task,proto3" json:"task,omitempty"`
}

func (m *V1SubTaskMeta) Reset()         { *m = V1SubTaskMeta{} }
func (m *V1SubTaskMeta) String() string { return proto.CompactTextString(m) }
func (*V1SubTaskMeta) ProtoMessage()    {}
func (*V1SubTaskMeta) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{25}
}
func (m *V1SubTaskMeta) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *V1SubTaskMeta) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_V1SubTaskMeta.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *V1SubTaskMeta) XXX_Merge(src proto.Message) {
	xxx_messageInfo_V1SubTaskMeta.Merge(m, src)
}
func (m *V1SubTaskMeta) XXX_Size() int {
	return m.Size()
}
func (m *V1SubTaskMeta) XXX_DiscardUnknown() {
	xxx_messageInfo_V1SubTaskMeta.DiscardUnknown(m)
}

var xxx_messageInfo_V1SubTaskMeta proto.InternalMessageInfo

func (m *V1SubTaskMeta) GetOp() TaskOp {
	if m != nil {
		return m.Op
	}
	return TaskOp_InvalidOp
}

func (m *V1SubTaskMeta) GetStage() Stage {
	if m != nil {
		return m.Stage
	}
	return Stage_InvalidStage
}

func (m *V1SubTaskMeta) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *V1SubTaskMeta) GetTask() []byte {
	if m != nil {
		return m.Task
	}
	return nil
}

type OperateV1MetaRequest struct {
	Op V1MetaOp `protobuf:"varint,1,opt,name=op,proto3,enum=pb.V1MetaOp" json:"op,omitempty"`
}

func (m *OperateV1MetaRequest) Reset()         { *m = OperateV1MetaRequest{} }
func (m *OperateV1MetaRequest) String() string { return proto.CompactTextString(m) }
func (*OperateV1MetaRequest) ProtoMessage()    {}
func (*OperateV1MetaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{26}
}
func (m *OperateV1MetaRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OperateV1MetaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OperateV1MetaRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OperateV1MetaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperateV1MetaRequest.Merge(m, src)
}
func (m *OperateV1MetaRequest) XXX_Size() int {
	return m.Size()
}
func (m *OperateV1MetaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OperateV1MetaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OperateV1MetaRequest proto.InternalMessageInfo

func (m *OperateV1MetaRequest) GetOp() V1MetaOp {
	if m != nil {
		return m.Op
	}
	return V1MetaOp_InvalidV1MetaOp
}

type OperateV1MetaResponse struct {
	Result bool                      `protobuf:"varint,1,opt,name=result,proto3" json:"result,omitempty"`
	Msg    string                    `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	Meta   map[string]*V1SubTaskMeta `protobuf:"bytes,3,rep,name=meta,proto3" json:"meta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *OperateV1MetaResponse) Reset()         { *m = OperateV1MetaResponse{} }
func (m *OperateV1MetaResponse) String() string { return proto.CompactTextString(m) }
func (*OperateV1MetaResponse) ProtoMessage()    {}
func (*OperateV1MetaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{27}
}
func (m *OperateV1MetaResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OperateV1MetaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OperateV1MetaResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OperateV1MetaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperateV1MetaResponse.Merge(m, src)
}
func (m *OperateV1MetaResponse) XXX_Size() int {
	return m.Size()
}
func (m *OperateV1MetaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_OperateV1MetaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_OperateV1MetaResponse proto.InternalMessageInfo

func (m *OperateV1MetaResponse) GetResult() bool {
	if m != nil {
		return m.Result
	}
	return false
}

func (m *OperateV1MetaResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *OperateV1MetaResponse) GetMeta() map[string]*V1SubTaskMeta {
	if m != nil {
		return m.Meta
	}
	return nil
}

type HandleWorkerErrorRequest struct {
	Op        ErrorOp  `protobuf:"varint,1,opt,name=op,proto3,enum=pb.ErrorOp" json:"op,omitempty"`
	Task      string   `protobuf:"bytes,2,opt,name=task,proto3" json:"task,omitempty"`
	BinlogPos string   `protobuf:"bytes,3,opt,name=binlogPos,proto3" json:"binlogPos,omitempty"`
	Sqls      []string `protobuf:"bytes,4,rep,name=sqls,proto3" json:"sqls,omitempty"`
}

func (m *HandleWorkerErrorRequest) Reset()         { *m = HandleWorkerErrorRequest{} }
func (m *HandleWorkerErrorRequest) String() string { return proto.CompactTextString(m) }
func (*HandleWorkerErrorRequest) ProtoMessage()    {}
func (*HandleWorkerErrorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{28}
}
func (m *HandleWorkerErrorRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HandleWorkerErrorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HandleWorkerErrorRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HandleWorkerErrorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleWorkerErrorRequest.Merge(m, src)
}
func (m *HandleWorkerErrorRequest) XXX_Size() int {
	return m.Size()
}
func (m *HandleWorkerErrorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleWorkerErrorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleWorkerErrorRequest proto.InternalMessageInfo

func (m *HandleWorkerErrorRequest) GetOp() ErrorOp {
	if m != nil {
		return m.Op
	}
	return ErrorOp_InvalidErrorOp
}

func (m *HandleWorkerErrorRequest) GetTask() string {
	if m != nil {
		return m.Task
	}
	return ""
}

func (m *HandleWorkerErrorRequest) GetBinlogPos() string {
	if m != nil {
		return m.BinlogPos
	}
	return ""
}

func (m *HandleWorkerErrorRequest) GetSqls() []string {
	if m != nil {
		return m.Sqls
	}
	return nil
}

type GetWorkerCfgRequest struct {
}

func (m *GetWorkerCfgRequest) Reset()         { *m = GetWorkerCfgRequest{} }
func (m *GetWorkerCfgRequest) String() string { return proto.CompactTextString(m) }
func (*GetWorkerCfgRequest) ProtoMessage()    {}
func (*GetWorkerCfgRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{29}
}
func (m *GetWorkerCfgRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWorkerCfgRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWorkerCfgRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWorkerCfgRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkerCfgRequest.Merge(m, src)
}
func (m *GetWorkerCfgRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetWorkerCfgRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkerCfgRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkerCfgRequest proto.InternalMessageInfo

type GetWorkerCfgResponse struct {
	Cfg string `protobuf:"bytes,1,opt,name=cfg,proto3" json:"cfg,omitempty"`
}

func (m *GetWorkerCfgResponse) Reset()         { *m = GetWorkerCfgResponse{} }
func (m *GetWorkerCfgResponse) String() string { return proto.CompactTextString(m) }
func (*GetWorkerCfgResponse) ProtoMessage()    {}
func (*GetWorkerCfgResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{30}
}
func (m *GetWorkerCfgResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetWorkerCfgResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetWorkerCfgResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetWorkerCfgResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetWorkerCfgResponse.Merge(m, src)
}
func (m *GetWorkerCfgResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetWorkerCfgResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetWorkerCfgResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetWorkerCfgResponse proto.InternalMessageInfo

func (m *GetWorkerCfgResponse) GetCfg() string {
	if m != nil {
		return m.Cfg
	}
	return ""
}

type CheckSubtasksCanUpdateRequest struct {
	SubtaskCfgTomlString string `protobuf:"bytes,1,opt,name=subtaskCfgTomlString,proto3" json:"subtaskCfgTomlString,omitempty"`
}

func (m *CheckSubtasksCanUpdateRequest) Reset()         { *m = CheckSubtasksCanUpdateRequest{} }
func (m *CheckSubtasksCanUpdateRequest) String() string { return proto.CompactTextString(m) }
func (*CheckSubtasksCanUpdateRequest) ProtoMessage()    {}
func (*CheckSubtasksCanUpdateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{31}
}
func (m *CheckSubtasksCanUpdateRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckSubtasksCanUpdateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckSubtasksCanUpdateRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckSubtasksCanUpdateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckSubtasksCanUpdateRequest.Merge(m, src)
}
func (m *CheckSubtasksCanUpdateRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckSubtasksCanUpdateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckSubtasksCanUpdateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckSubtasksCanUpdateRequest proto.InternalMessageInfo

func (m *CheckSubtasksCanUpdateRequest) GetSubtaskCfgTomlString() string {
	if m != nil {
		return m.SubtaskCfgTomlString
	}
	return ""
}

type CheckSubtasksCanUpdateResponse struct {
	Success bool   `protobuf:"varint,1,opt,name=success,proto3" json:"success,omitempty"`
	Msg     string `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
}

func (m *CheckSubtasksCanUpdateResponse) Reset()         { *m = CheckSubtasksCanUpdateResponse{} }
func (m *CheckSubtasksCanUpdateResponse) String() string { return proto.CompactTextString(m) }
func (*CheckSubtasksCanUpdateResponse) ProtoMessage()    {}
func (*CheckSubtasksCanUpdateResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{32}
}
func (m *CheckSubtasksCanUpdateResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckSubtasksCanUpdateResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckSubtasksCanUpdateResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckSubtasksCanUpdateResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckSubtasksCanUpdateResponse.Merge(m, src)
}
func (m *CheckSubtasksCanUpdateResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckSubtasksCanUpdateResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckSubtasksCanUpdateResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckSubtasksCanUpdateResponse proto.InternalMessageInfo

func (m *CheckSubtasksCanUpdateResponse) GetSuccess() bool {
	if m != nil {
		return m.Success
	}
	return false
}

func (m *CheckSubtasksCanUpdateResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type GetValidationStatusRequest struct {
	TaskName     string `protobuf:"bytes,1,opt,name=taskName,proto3" json:"taskName,omitempty"`
	FilterStatus Stage  `protobuf:"varint,2,opt,name=filterStatus,proto3,enum=pb.Stage" json:"filterStatus,omitempty"`
}

func (m *GetValidationStatusRequest) Reset()         { *m = GetValidationStatusRequest{} }
func (m *GetValidationStatusRequest) String() string { return proto.CompactTextString(m) }
func (*GetValidationStatusRequest) ProtoMessage()    {}
func (*GetValidationStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{33}
}
func (m *GetValidationStatusRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetValidationStatusRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetValidationStatusRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetValidationStatusRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetValidationStatusRequest.Merge(m, src)
}
func (m *GetValidationStatusRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetValidationStatusRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetValidationStatusRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetValidationStatusRequest proto.InternalMessageInfo

func (m *GetValidationStatusRequest) GetTaskName() string {
	if m != nil {
		return m.TaskName
	}
	return ""
}

func (m *GetValidationStatusRequest) GetFilterStatus() Stage {
	if m != nil {
		return m.FilterStatus
	}
	return Stage_InvalidStage
}

type ValidationStatus struct {
	Task                string         `protobuf:"bytes,1,opt,name=task,proto3" json:"task,omitempty"`
	Source              string         `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	Mode                string         `protobuf:"bytes,3,opt,name=mode,proto3" json:"mode,omitempty"`
	Stage               Stage          `protobuf:"varint,4,opt,name=stage,proto3,enum=pb.Stage" json:"stage,omitempty"`
	ValidatorBinlog     string         `protobuf:"bytes,5,opt,name=validatorBinlog,proto3" json:"validatorBinlog,omitempty"`
	ValidatorBinlogGtid string         `protobuf:"bytes,6,opt,name=validatorBinlogGtid,proto3" json:"validatorBinlogGtid,omitempty"`
	Result              *ProcessResult `protobuf:"bytes,7,opt,name=result,proto3" json:"result,omitempty"`
	ProcessedRowsStatus string         `protobuf:"bytes,8,opt,name=processedRowsStatus,proto3" json:"processedRowsStatus,omitempty"`
	PendingRowsStatus   string         `protobuf:"bytes,9,opt,name=pendingRowsStatus,proto3" json:"pendingRowsStatus,omitempty"`
	ErrorRowsStatus     string         `protobuf:"bytes,10,opt,name=errorRowsStatus,proto3" json:"errorRowsStatus,omitempty"`
	CutoverBinlogPos    string         `protobuf:"bytes,11,opt,name=cutoverBinlogPos,proto3" json:"cutoverBinlogPos,omitempty"`
	CutoverBinlogGtid   string         `protobuf:"bytes,12,opt,name=cutoverBinlogGtid,proto3" json:"cutoverBinlogGtid,omitempty"`
}

func (m *ValidationStatus) Reset()         { *m = ValidationStatus{} }
func (m *ValidationStatus) String() string { return proto.CompactTextString(m) }
func (*ValidationStatus) ProtoMessage()    {}
func (*ValidationStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{34}
}
func (m *ValidationStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValidationStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValidationStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValidationStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidationStatus.Merge(m, src)
}
func (m *ValidationStatus) XXX_Size() int {
	return m.Size()
}
func (m *ValidationStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidationStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ValidationStatus proto.InternalMessageInfo

func (m *ValidationStatus) GetTask() string {
	if m != nil {
		return m.Task
	}
	return ""
}

func (m *ValidationStatus) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *ValidationStatus) GetMode() string {
	if m != nil {
		return m.Mode
	}
	return ""
}

func (m *ValidationStatus) GetStage() Stage {
	if m != nil {
		return m.Stage
	}
	return Stage_InvalidStage
}

func (m *ValidationStatus) GetValidatorBinlog() string {
	if m != nil {
		return m.ValidatorBinlog
	}
	return ""
}

func (m *ValidationStatus) GetValidatorBinlogGtid() string {
	if m != nil {
		return m.ValidatorBinlogGtid
	}
	return ""
}

func (m *ValidationStatus) GetResult() *ProcessResult {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *ValidationStatus) GetProcessedRowsStatus() string {
	if m != nil {
		return m.ProcessedRowsStatus
	}
	return ""
}

func (m *ValidationStatus) GetPendingRowsStatus() string {
	if m != nil {
		return m.PendingRowsStatus
	}
	return ""
}

func (m *ValidationStatus) GetErrorRowsStatus() string {
	if m != nil {
		return m.ErrorRowsStatus
	}
	return ""
}

func (m *ValidationStatus) GetCutoverBinlogPos() string {
	if m != nil {
		return m.CutoverBinlogPos
	}
	return ""
}

func (m *ValidationStatus) GetCutoverBinlogGtid() string {
	if m != nil {
		return m.CutoverBinlogGtid
	}
	return ""
}

type ValidationTableStatus struct {
	Source   string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	SrcTable string `protobuf:"bytes,2,opt,name=srcTable,proto3" json:"srcTable,omitempty"`
	DstTable string `protobuf:"bytes,3,opt,name=dstTable,proto3" json:"dstTable,omitempty"`
	Stage    Stage  `protobuf:"varint,4,opt,name=stage,proto3,enum=pb.Stage" json:"stage,omitempty"`
	Message  string `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ValidationTableStatus) Reset()         { *m = ValidationTableStatus{} }
func (m *ValidationTableStatus) String() string { return proto.CompactTextString(m) }
func (*ValidationTableStatus) ProtoMessage()    {}
func (*ValidationTableStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{35}
}
func (m *ValidationTableStatus) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValidationTableStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValidationTableStatus.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValidationTableStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidationTableStatus.Merge(m, src)
}
func (m *ValidationTableStatus) XXX_Size() int {
	return m.Size()
}
func (m *ValidationTableStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidationTableStatus.DiscardUnknown(m)
}

var xxx_messageInfo_ValidationTableStatus proto.InternalMessageInfo

func (m *ValidationTableStatus) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *ValidationTableStatus) GetSrcTable() string {
	if m != nil {
		return m.SrcTable
	}
	return ""
}

func (m *ValidationTableStatus) GetDstTable() string {
	if m != nil {
		return m.DstTable
	}
	return ""
}

func (m *ValidationTableStatus) GetStage() Stage {
	if m != nil {
		return m.Stage
	}
	return Stage_InvalidStage
}

func (m *ValidationTableStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type GetValidationStatusResponse struct {
	Result        bool                     `protobuf:"varint,1,opt,name=result,proto3" json:"result,omitempty"`
	Msg           string                   `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	Validators    []*ValidationStatus      `protobuf:"bytes,3,rep,name=validators,proto3" json:"validators,omitempty"`
	TableStatuses []*ValidationTableStatus `protobuf:"bytes,4,rep,name=tableStatuses,proto3" json:"tableStatuses,omitempty"`
}

func (m *GetValidationStatusResponse) Reset()         { *m = GetValidationStatusResponse{} }
func (m *GetValidationStatusResponse) String() string { return proto.CompactTextString(m) }
func (*GetValidationStatusResponse) ProtoMessage()    {}
func (*GetValidationStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{36}
}
func (m *GetValidationStatusResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetValidationStatusResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetValidationStatusResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetValidationStatusResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetValidationStatusResponse.Merge(m, src)
}
func (m *GetValidationStatusResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetValidationStatusResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetValidationStatusResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetValidationStatusResponse proto.InternalMessageInfo

func (m *GetValidationStatusResponse) GetResult() bool {
	if m != nil {
		return m.Result
	}
	return false
}

func (m *GetValidationStatusResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *GetValidationStatusResponse) GetValidators() []*ValidationStatus {
	if m != nil {
		return m.Validators
	}
	return nil
}

func (m *GetValidationStatusResponse) GetTableStatuses() []*ValidationTableStatus {
	if m != nil {
		return m.TableStatuses
	}
	return nil
}

type GetValidationErrorRequest struct {
	ErrState ValidateErrorState `protobuf:"varint,1,opt,name=errState,proto3,enum=pb.ValidateErrorState" json:"errState,omitempty"`
	TaskName string             `protobuf:"bytes,2,opt,name=taskName,proto3" json:"taskName,omitempty"`
}

func (m *GetValidationErrorRequest) Reset()         { *m = GetValidationErrorRequest{} }
func (m *GetValidationErrorRequest) String() string { return proto.CompactTextString(m) }
func (*GetValidationErrorRequest) ProtoMessage()    {}
func (*GetValidationErrorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{37}
}
func (m *GetValidationErrorRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetValidationErrorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetValidationErrorRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetValidationErrorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetValidationErrorRequest.Merge(m, src)
}
func (m *GetValidationErrorRequest) XXX_Size() int {
	return m.Size()
}
func (m *GetValidationErrorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetValidationErrorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetValidationErrorRequest proto.InternalMessageInfo

func (m *GetValidationErrorRequest) GetErrState() ValidateErrorState {
	if m != nil {
		return m.ErrState
	}
	return ValidateErrorState_InvalidErr
}

func (m *GetValidationErrorRequest) GetTaskName() string {
	if m != nil {
		return m.TaskName
	}
	return ""
}

type ValidationError struct {
	Id        string             `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Source    string             `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	SrcTable  string             `protobuf:"bytes,3,opt,name=srcTable,proto3" json:"srcTable,omitempty"`
	SrcData   string             `protobuf:"bytes,4,opt,name=srcData,proto3" json:"srcData,omitempty"`
	DstTable  string             `protobuf:"bytes,5,opt,name=dstTable,proto3" json:"dstTable,omitempty"`
	DstData   string             `protobuf:"bytes,6,opt,name=dstData,proto3" json:"dstData,omitempty"`
	ErrorType string             `protobuf:"bytes,7,opt,name=errorType,proto3" json:"errorType,omitempty"`
	Status    ValidateErrorState `protobuf:"varint,8,opt,name=status,proto3,enum=pb.ValidateErrorState" json:"status,omitempty"`
	Time      string             `protobuf:"bytes,9,opt,name=time,proto3" json:"time,omitempty"`
	Message   string             `protobuf:"bytes,10,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ValidationError) Reset()         { *m = ValidationError{} }
func (m *ValidationError) String() string { return proto.CompactTextString(m) }
func (*ValidationError) ProtoMessage()    {}
func (*ValidationError) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{38}
}
func (m *ValidationError) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ValidationError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ValidationError.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ValidationError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ValidationError.Merge(m, src)
}
func (m *ValidationError) XXX_Size() int {
	return m.Size()
}
func (m *ValidationError) XXX_DiscardUnknown() {
	xxx_messageInfo_ValidationError.DiscardUnknown(m)
}

var xxx_messageInfo_ValidationError proto.InternalMessageInfo

func (m *ValidationError) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ValidationError) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *ValidationError) GetSrcTable() string {
	if m != nil {
		return m.SrcTable
	}
	return ""
}

func (m *ValidationError) GetSrcData() string {
	if m != nil {
		return m.SrcData
	}
	return ""
}

func (m *ValidationError) GetDstTable() string {
	if m != nil {
		return m.DstTable
	}
	return ""
}

func (m *ValidationError) GetDstData() string {
	if m != nil {
		return m.DstData
	}
	return ""
}

func (m *ValidationError) GetErrorType() string {
	if m != nil {
		return m.ErrorType
	}
	return ""
}

func (m *ValidationError) GetStatus() ValidateErrorState {
	if m != nil {
		return m.Status
	}
	return ValidateErrorState_InvalidErr
}

func (m *ValidationError) GetTime() string {
	if m != nil {
		return m.Time
	}
	return ""
}

func (m *ValidationError) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

type GetValidationErrorResponse struct {
	Result bool               `protobuf:"varint,1,opt,name=result,proto3" json:"result,omitempty"`
	Msg    string             `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
	Error  []*ValidationError `protobuf:"bytes,3,rep,name=error,proto3" json:"error,omitempty"`
}

func (m *GetValidationErrorResponse) Reset()         { *m = GetValidationErrorResponse{} }
func (m *GetValidationErrorResponse) String() string { return proto.CompactTextString(m) }
func (*GetValidationErrorResponse) ProtoMessage()    {}
func (*GetValidationErrorResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{39}
}
func (m *GetValidationErrorResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GetValidationErrorResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GetValidationErrorResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GetValidationErrorResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetValidationErrorResponse.Merge(m, src)
}
func (m *GetValidationErrorResponse) XXX_Size() int {
	return m.Size()
}
func (m *GetValidationErrorResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetValidationErrorResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetValidationErrorResponse proto.InternalMessageInfo

func (m *GetValidationErrorResponse) GetResult() bool {
	if m != nil {
		return m.Result
	}
	return false
}

func (m *GetValidationErrorResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

func (m *GetValidationErrorResponse) GetError() []*ValidationError {
	if m != nil {
		return m.Error
	}
	return nil
}

type OperateValidationErrorRequest struct {
	Op         ValidationErrOp `protobuf:"varint,1,opt,name=op,proto3,enum=pb.ValidationErrOp" json:"op,omitempty"`
	IsAllError bool            `protobuf:"varint,2,opt,name=isAllError,proto3" json:"isAllError,omitempty"`
	TaskName   string          `protobuf:"bytes,3,opt,name=taskName,proto3" json:"taskName,omitempty"`
	ErrId      uint64          `protobuf:"varint,4,opt,name=errId,proto3" json:"errId,omitempty"`
}

func (m *OperateValidationErrorRequest) Reset()         { *m = OperateValidationErrorRequest{} }
func (m *OperateValidationErrorRequest) String() string { return proto.CompactTextString(m) }
func (*OperateValidationErrorRequest) ProtoMessage()    {}
func (*OperateValidationErrorRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{40}
}
func (m *OperateValidationErrorRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OperateValidationErrorRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OperateValidationErrorRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OperateValidationErrorRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperateValidationErrorRequest.Merge(m, src)
}
func (m *OperateValidationErrorRequest) XXX_Size() int {
	return m.Size()
}
func (m *OperateValidationErrorRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_OperateValidationErrorRequest.DiscardUnknown(m)
}

var xxx_messageInfo_OperateValidationErrorRequest proto.InternalMessageInfo

func (m *OperateValidationErrorRequest) GetOp() ValidationErrOp {
	if m != nil {
		return m.Op
	}
	return ValidationErrOp_InvalidErrOp
}

func (m *OperateValidationErrorRequest) GetIsAllError() bool {
	if m != nil {
		return m.IsAllError
	}
	return false
}

func (m *OperateValidationErrorRequest) GetTaskName() string {
	if m != nil {
		return m.TaskName
	}
	return ""
}

func (m *OperateValidationErrorRequest) GetErrId() uint64 {
	if m != nil {
		return m.ErrId
	}
	return 0
}

type OperateValidationErrorResponse struct {
	Result bool   `protobuf:"varint,1,opt,name=result,proto3" json:"result,omitempty"`
	Msg    string `protobuf:"bytes,2,opt,name=msg,proto3" json:"msg,omitempty"`
}

func (m *OperateValidationErrorResponse) Reset()         { *m = OperateValidationErrorResponse{} }
func (m *OperateValidationErrorResponse) String() string { return proto.CompactTextString(m) }
func (*OperateValidationErrorResponse) ProtoMessage()    {}
func (*OperateValidationErrorResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{41}
}
func (m *OperateValidationErrorResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OperateValidationErrorResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OperateValidationErrorResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OperateValidationErrorResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperateValidationErrorResponse.Merge(m, src)
}
func (m *OperateValidationErrorResponse) XXX_Size() int {
	return m.Size()
}
func (m *OperateValidationErrorResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_OperateValidationErrorResponse.DiscardUnknown(m)
}

var xxx_messageInfo_OperateValidationErrorResponse proto.InternalMessageInfo

func (m *OperateValidationErrorResponse) GetResult() bool {
	if m != nil {
		return m.Result
	}
	return false
}

func (m *OperateValidationErrorResponse) GetMsg() string {
	if m != nil {
		return m.Msg
	}
	return ""
}

type UpdateValidationWorkerRequest struct {
	TaskName   string `protobuf:"bytes,1,opt,name=taskName,proto3" json:"taskName,omitempty"`
	BinlogPos  string `protobuf:"bytes,2,opt,name=binlogPos,proto3" json:"binlogPos,omitempty"`
	BinlogGTID string `protobuf:"bytes,3,opt,name=binlogGTID,proto3" json:"binlogGTID,omitempty"`
}

func (m *UpdateValidationWorkerRequest) Reset()         { *m = UpdateValidationWorkerRequest{} }
func (m *UpdateValidationWorkerRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateValidationWorkerRequest) ProtoMessage()    {}
func (*UpdateValidationWorkerRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_51a1b9e17fd67b10, []int{42}
}
func (m *UpdateValidationWorkerRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *UpdateValidationWorkerRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_UpdateValidationWorkerRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *UpdateValidationWorkerRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateValidationWorkerRequest.Merge(m, src)
}
func (m *UpdateValidationWorkerRequest) XXX_Size() int {
	return m.Size()
}
func (m *UpdateValidationWorkerRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateValidationWorkerRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateValidationWorkerRequest proto.InternalMessageInfo

func (m *UpdateValidationWorkerRequest) GetTaskName() string {
	if m != nil {
		return m.TaskName
	}
	return ""
}

func (m *UpdateValidationWorkerRequest) GetBinlogPos() string {
	if m != nil {
		return m.BinlogPos
	}
	return ""
}

func (m *UpdateValidationWorkerRequest) GetBinlogGTID() string {
	if m != nil {
		return m.BinlogGTID
	}
	return ""
}

func init() {
	proto.RegisterEnum("pb.TaskOp", TaskOp_name, TaskOp_value)
	proto.RegisterEnum("pb.Stage", Stage_name, Stage_value)
	proto.RegisterEnum("pb.UnitType", UnitType_name, UnitType_value)
	proto.RegisterEnum("pb.RelayOp", RelayOp_name, RelayOp_value)
	proto.RegisterEnum("pb.SchemaOp", SchemaOp_name, SchemaOp_value)
	proto.RegisterEnum("pb.V1MetaOp", V1MetaOp_name, V1MetaOp_value)
	proto.RegisterEnum("pb.ErrorOp", ErrorOp_name, ErrorOp_value)
	proto.RegisterEnum("pb.ValidatorOp", ValidatorOp_name, ValidatorOp_value)
	proto.RegisterEnum("pb.ValidateErrorState", ValidateErrorState_name, ValidateErrorState_value)
	proto.RegisterEnum("pb.ValidationErrOp", ValidationErrOp_name, ValidationErrOp_value)
	proto.RegisterType((*QueryStatusRequest)(nil), "pb.QueryStatusRequest")
	proto.RegisterType((*CommonWorkerResponse)(nil), "pb.CommonWorkerResponse")
	proto.RegisterType((*QueryStatusResponse)(nil), "pb.QueryStatusResponse")
	proto.RegisterType((*CheckStatus)(nil), "pb.CheckStatus")
	proto.RegisterType((*DumpStatus)(nil), "pb.DumpStatus")
	proto.RegisterType((*LoadStatus)(nil), "pb.LoadStatus")
	proto.RegisterType((*ShardingGroup)(nil), "pb.ShardingGroup")
	proto.RegisterType((*SyncStatus)(nil), "pb.SyncStatus")
	proto.RegisterType((*SourceStatus)(nil), "pb.SourceStatus")
	proto.RegisterType((*RelayStatus)(nil), "pb.RelayStatus")
	proto.RegisterType((*SubTaskStatus)(nil), "pb.SubTaskStatus")
	proto.RegisterType((*SubTaskStatusList)(nil), "pb.SubTaskStatusList")
	proto.RegisterType((*CheckError)(nil), "pb.CheckError")
	proto.RegisterType((*DumpError)(nil), "pb.DumpError")
	proto.RegisterType((*LoadError)(nil), "pb.LoadError")
	proto.RegisterType((*SyncSQLError)(nil), "pb.SyncSQLError")
	proto.RegisterType((*SyncError)(nil), "pb.SyncError")
	proto.RegisterType((*SourceError)(nil), "pb.SourceError")
	proto.RegisterType((*RelayError)(nil), "pb.RelayError")
	proto.RegisterType((*SubTaskError)(nil), "pb.SubTaskError")
	proto.RegisterType((*SubTaskErrorList)(nil), "pb.SubTaskErrorList")
	proto.RegisterType((*ProcessResult)(nil), "pb.ProcessResult")
	proto.RegisterType((*ProcessError)(nil), "pb.ProcessError")
	proto.RegisterType((*PurgeRelayRequest)(nil), "pb.PurgeRelayRequest")
	proto.RegisterType((*OperateWorkerSchemaRequest)(nil), "pb.OperateWorkerSchemaRequest")
	proto.RegisterType((*V1SubTaskMeta)(nil), "pb.V1SubTaskMeta")
	proto.RegisterType((*OperateV1MetaRequest)(nil), "pb.OperateV1MetaRequest")
	proto.RegisterType((*OperateV1MetaResponse)(nil), "pb.OperateV1MetaResponse")
	proto.RegisterMapType((map[string]*V1SubTaskMeta)(nil), "pb.OperateV1MetaResponse.MetaEntry")
	proto.RegisterType((*HandleWorkerErrorRequest)(nil), "pb.HandleWorkerErrorRequest")
	proto.RegisterType((*GetWorkerCfgRequest)(nil), "pb.GetWorkerCfgRequest")
	proto.RegisterType((*GetWorkerCfgResponse)(nil), "pb.GetWorkerCfgResponse")
	proto.RegisterType((*CheckSubtasksCanUpdateRequest)(nil), "pb.CheckSubtasksCanUpdateRequest")
	proto.RegisterType((*CheckSubtasksCanUpdateResponse)(nil), "pb.CheckSubtasksCanUpdateResponse")
	proto.RegisterType((*GetValidationStatusRequest)(nil), "pb.GetValidationStatusRequest")
	proto.RegisterType((*ValidationStatus)(nil), "pb.ValidationStatus")
	proto.RegisterType((*ValidationTableStatus)(nil), "pb.ValidationTableStatus")
	proto.RegisterType((*GetValidationStatusResponse)(nil), "pb.GetValidationStatusResponse")
	proto.RegisterType((*GetValidationErrorRequest)(nil), "pb.GetValidationErrorRequest")
	proto.RegisterType((*ValidationError)(nil), "pb.ValidationError")
	proto.RegisterType((*GetValidationErrorResponse)(nil), "pb.GetValidationErrorResponse")
	proto.RegisterType((*OperateValidationErrorRequest)(nil), "pb.OperateValidationErrorRequest")
	proto.RegisterType((*OperateValidationErrorResponse)(nil), "pb.OperateValidationErrorResponse")
	proto.RegisterType((*UpdateValidationWorkerRequest)(nil), "pb.UpdateValidationWorkerRequest")
}

func init() { proto.RegisterFile("dmworker.proto", fileDescriptor_51a1b9e17fd67b10) }

var fileDescriptor_51a1b9e17fd67b10 = []byte{
	// 2972 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x3a, 0x4d, 0x6f, 0xdc, 0xd6,
	0xb5, 0x43, 0x72, 0x3e, 0xcf, 0x8c, 0x24, 0xea, 0x4a, 0xf6, 0x9b, 0x28, 0xf6, 0x44, 0xa1, 0x83,
	0x3c, 0x45, 0xc8, 0x13, 0x12, 0xbd, 0x3c, 0xe4, 0x21, 0x40, 0x9b, 0xc4, 0x92, 0x23, 0x3b, 0x95,
	0x23, 0x9b, 0x52, 0xdc, 0x55, 0x81, 0x52, 0x9c, 0xab, 0x11, 0x2b, 0x0e, 0x49, 0x93, 0x1c, 0x09,
	0x5a, 0x14, 0xdd, 0x75, 0xdb, 0x6e, 0x5a, 0xa0, 0x45, 0x37, 0x2d, 0xd0, 0x6d, 0x17, 0xfd, 0x01,
	0xdd, 0xb5, 0xcd, 0x32, 0xe8, 0xaa, 0xab, 0xa2, 0x48, 0xfe, 0x45, 0x17, 0x45, 0x71, 0xce, 0xbd,
	0x97, 0xbc, 0x9c, 0x0f, 0x39, 0x2e, 0xd0, 0x1d, 0xcf, 0xc7, 0x3d, 0xf7, 0xf0, 0x7c, 0x1f, 0xce,
	0xc0, 0xf2, 0x70, 0x7c, 0x15, 0xa7, 0x17, 0x3c, 0xdd, 0x49, 0xd2, 0x38, 0x8f, 0x99, 0x99, 0x9c,
	0x3a, 0x5b, 0xc0, 0x9e, 0x4e, 0x78, 0x7a, 0x7d, 0x9c, 0x7b, 0xf9, 0x24, 0x73, 0xf9, 0xf3, 0x09,
	0xcf, 0x72, 0xc6, 0xa0, 0x1e, 0x79, 0x63, 0xde, 0x37, 0x36, 0x8d, 0xad, 0x8e, 0x4b, 0xcf, 0x4e,
	0x02, 0xeb, 0x7b, 0xf1, 0x78, 0x1c, 0x47, 0xdf, 0x25, 0x19, 0x2e, 0xcf, 0x92, 0x38, 0xca, 0x38,
	0xbb, 0x0d, 0xcd, 0x94, 0x67, 0x93, 0x30, 0x27, 0xee, 0xb6, 0x2b, 0x21, 0x66, 0x83, 0x35, 0xce,
	0x46, 0x7d, 0x93, 0x44, 0xe0, 0x23, 0x72, 0x66, 0xf1, 0x24, 0xf5, 0x79, 0xdf, 0x22, 0xa4, 0x84,
	0x10, 0x2f, 0xf4, 0xea, 0xd7, 0x05, 0x5e, 0x40, 0xce, 0xef, 0x0c, 0x58, 0xab, 0x28, 0xf7, 0xd2,
	0x37, 0xbe, 0x07, 0x3d, 0x71, 0x87, 0x90, 0x40, 0xf7, 0x76, 0x77, 0xed, 0x9d, 0xe4, 0x74, 0xe7,
	0x58, 0xc3, 0xbb, 0x15, 0x2e, 0xf6, 0x3e, 0x2c, 0x65, 0x93, 0xd3, 0x13, 0x2f, 0xbb, 0x90, 0xc7,
	0xea, 0x9b, 0xd6, 0x56, 0x77, 0x77, 0x95, 0x8e, 0xe9, 0x04, 0xb7, 0xca, 0xe7, 0xfc, 0xd6, 0x80,
	0xee, 0xde, 0x39, 0xf7, 0x25, 0x8c, 0x8a, 0x26, 0x5e, 0x96, 0xf1, 0xa1, 0x52, 0x54, 0x40, 0x6c,
	0x1d, 0x1a, 0x79, 0x9c, 0x7b, 0x21, 0xa9, 0xda, 0x70, 0x05, 0xc0, 0x06, 0x00, 0xd9, 0xc4, 0xf7,
	0x79, 0x96, 0x9d, 0x4d, 0x42, 0x52, 0xb5, 0xe1, 0x6a, 0x18, 0x94, 0x76, 0xe6, 0x05, 0x21, 0x1f,
	0x92, 0x99, 0x1a, 0xae, 0x84, 0x58, 0x1f, 0x5a, 0x57, 0x5e, 0x1a, 0x05, 0xd1, 0xa8, 0xdf, 0x20,
	0x82, 0x02, 0xf1, 0xc4, 0x90, 0xe7, 0x5e, 0x10, 0xf6, 0x9b, 0x9b, 0xc6, 0x56, 0xcf, 0x95, 0x90,
	0xf3, 0x4f, 0x03, 0x60, 0x7f, 0x32, 0x4e, 0xa4, 0x9a, 0x9b, 0xd0, 0x25, 0x0d, 0x4e, 0xbc, 0xd3,
	0x90, 0x67, 0xa4, 0xab, 0xe5, 0xea, 0x28, 0xb6, 0x05, 0x2b, 0x7e, 0x3c, 0x4e, 0x42, 0x9e, 0xf3,
	0xa1, 0xe4, 0x42, 0xd5, 0x0d, 0x77, 0x1a, 0xcd, 0xde, 0x80, 0xa5, 0xb3, 0x20, 0x0a, 0xb2, 0x73,
	0x3e, 0xbc, 0x7f, 0x9d, 0x73, 0x61, 0x72, 0xc3, 0xad, 0x22, 0x99, 0x03, 0x3d, 0x85, 0x70, 0xe3,
	0xab, 0x8c, 0x5e, 0xc8, 0x70, 0x2b, 0x38, 0xf6, 0x36, 0xac, 0xf2, 0x2c, 0x0f, 0xc6, 0x5e, 0xce,
	0x4f, 0x50, 0x15, 0x62, 0x6c, 0x10, 0xe3, 0x2c, 0x01, 0x7d, 0x7f, 0x9a, 0x64, 0xf4, 0x9e, 0x96,
	0x8b, 0x8f, 0x6c, 0x03, 0xda, 0x49, 0x1a, 0x8f, 0x52, 0x9e, 0x65, 0xfd, 0x16, 0x85, 0x44, 0x01,
	0x3b, 0x5f, 0x18, 0x00, 0x87, 0xb1, 0x37, 0x94, 0x06, 0x98, 0x51, 0x5a, 0x98, 0x60, 0x4a, 0xe9,
	0x01, 0x00, 0xd9, 0x44, 0xb0, 0x98, 0xc4, 0xa2, 0x61, 0x2a, 0x17, 0x5a, 0xd5, 0x0b, 0xf1, 0xec,
	0x98, 0xe7, 0xde, 0xfd, 0x20, 0x0a, 0xe3, 0x91, 0x0c, 0x73, 0x0d, 0xc3, 0xde, 0x84, 0xe5, 0x12,
	0x3a, 0x38, 0x79, 0xb4, 0x4f, 0x6f, 0xda, 0x71, 0xa7, 0xb0, 0xb3, 0xaf, 0xe9, 0xfc, 0xcc, 0x80,
	0xa5, 0xe3, 0x73, 0x2f, 0x1d, 0x06, 0xd1, 0xe8, 0x20, 0x8d, 0x27, 0x09, 0x7a, 0x3d, 0xf7, 0xd2,
	0x11, 0xcf, 0x65, 0xfa, 0x4a, 0x08, 0x93, 0x7a, 0x7f, 0xff, 0x10, 0x35, 0xb7, 0x30, 0xa9, 0xf1,
	0x59, 0xbc, 0x79, 0x9a, 0xe5, 0x87, 0xb1, 0xef, 0xe5, 0x41, 0x1c, 0x49, 0xc5, 0xab, 0x48, 0x4a,
	0xdc, 0xeb, 0xc8, 0xa7, 0xc8, 0xb3, 0x28, 0x71, 0x09, 0xc2, 0x37, 0x9e, 0x44, 0x92, 0xd2, 0x20,
	0x4a, 0x01, 0x3b, 0x7f, 0x6c, 0x00, 0x1c, 0x5f, 0x47, 0xfe, 0x54, 0x8c, 0x3d, 0xb8, 0xe4, 0x51,
	0x5e, 0x8d, 0x31, 0x81, 0x42, 0x61, 0x22, 0xe4, 0x12, 0x65, 0xdc, 0x02, 0x66, 0x77, 0xa0, 0x93,
	0x72, 0x9f, 0x47, 0x39, 0x12, 0x2d, 0x22, 0x96, 0x08, 0x8c, 0xa6, 0xb1, 0x97, 0xe5, 0x3c, 0xad,
	0x98, 0xb7, 0x82, 0x63, 0xdb, 0x60, 0xeb, 0xf0, 0x41, 0x1e, 0x0c, 0xa5, 0x89, 0x67, 0xf0, 0x28,
	0x8f, 0x5e, 0x42, 0xc9, 0x6b, 0x0a, 0x79, 0x3a, 0x0e, 0xe5, 0xe9, 0x30, 0xc9, 0x13, 0x51, 0x36,
	0x83, 0x47, 0x79, 0xa7, 0x61, 0xec, 0x5f, 0x04, 0xd1, 0x88, 0x1c, 0xd0, 0x26, 0x53, 0x55, 0x70,
	0xec, 0x5b, 0x60, 0x4f, 0xa2, 0x94, 0x67, 0x71, 0x78, 0xc9, 0x87, 0xe4, 0xc7, 0xac, 0xdf, 0xd1,
	0xca, 0x8e, 0xee, 0x61, 0x77, 0x86, 0x55, 0xf3, 0x10, 0x88, 0x4a, 0x23, 0x3d, 0x34, 0x00, 0x38,
	0x25, 0x45, 0x4e, 0xae, 0x13, 0xde, 0xef, 0x8a, 0xb8, 0x2b, 0x31, 0xec, 0x1d, 0x58, 0xcb, 0xb8,
	0x1f, 0x47, 0xc3, 0xec, 0x3e, 0x3f, 0x0f, 0xa2, 0xe1, 0x63, 0xb2, 0x45, 0xbf, 0x47, 0x26, 0x9e,
	0x47, 0xc2, 0x88, 0x21, 0xc5, 0xf7, 0xf7, 0x0f, 0x8f, 0xae, 0x22, 0x9e, 0xf6, 0x97, 0x44, 0xc4,
	0x54, 0x90, 0xe8, 0x6e, 0x3f, 0x8e, 0xce, 0xc2, 0xc0, 0xcf, 0x1f, 0x67, 0xa3, 0xfe, 0x32, 0xf1,
	0xe8, 0x28, 0x74, 0x69, 0x5e, 0xa4, 0xf5, 0x8a, 0x70, 0x69, 0x81, 0x28, 0x82, 0xc1, 0x4d, 0xb2,
	0xbe, 0xad, 0x05, 0x83, 0xab, 0x07, 0x03, 0x12, 0x57, 0xf5, 0x60, 0x70, 0x45, 0x30, 0x04, 0xf1,
	0x49, 0x99, 0xa7, 0x6c, 0xd3, 0xd8, 0xaa, 0xbb, 0x15, 0x1c, 0x3a, 0x6f, 0x38, 0x19, 0x27, 0x8f,
	0x8e, 0x34, 0xbe, 0x35, 0xe2, 0x9b, 0xc1, 0x3b, 0xbf, 0x32, 0xa0, 0xa7, 0xf7, 0x0a, 0xad, 0x8b,
	0x19, 0x0b, 0xba, 0x98, 0xa9, 0x77, 0x31, 0xf6, 0x56, 0xd1, 0xad, 0x44, 0xf7, 0x21, 0x7f, 0x3e,
	0x49, 0x63, 0x2c, 0xeb, 0x2e, 0x11, 0x8a, 0x06, 0xf6, 0x2e, 0x74, 0x53, 0x1e, 0x7a, 0xd7, 0x45,
	0xdb, 0x41, 0xfe, 0x15, 0xe4, 0x77, 0x4b, 0xb4, 0xab, 0xf3, 0x38, 0x7f, 0x36, 0xa1, 0xab, 0x11,
	0x67, 0x72, 0xc1, 0xf8, 0x86, 0xb9, 0x60, 0x2e, 0xc8, 0x85, 0x4d, 0xa5, 0xd2, 0xe4, 0x74, 0x3f,
	0x48, 0x65, 0x79, 0xd0, 0x51, 0x05, 0x47, 0x25, 0xf9, 0x74, 0x14, 0x76, 0x0f, 0x0d, 0xd4, 0x52,
	0x6f, 0x1a, 0xcd, 0x76, 0x80, 0x11, 0x6a, 0xcf, 0xcb, 0xfd, 0xf3, 0xcf, 0x13, 0x19, 0x8d, 0x4d,
	0x0a, 0xe9, 0x39, 0x14, 0xf6, 0x1a, 0x34, 0xb2, 0xdc, 0x1b, 0x71, 0x4a, 0xbd, 0xe5, 0xdd, 0x0e,
	0xa5, 0x0a, 0x22, 0x5c, 0x81, 0xd7, 0x8c, 0xdf, 0x7e, 0x81, 0xf1, 0x9d, 0xdf, 0x5b, 0xb0, 0x54,
	0xe9, 0xee, 0xf3, 0xa6, 0xa0, 0xf2, 0x46, 0x73, 0xc1, 0x8d, 0x9b, 0x50, 0x9f, 0x44, 0x81, 0x70,
	0xf6, 0xf2, 0x6e, 0x0f, 0xe9, 0x9f, 0x47, 0x41, 0x8e, 0xd9, 0xe6, 0x12, 0x45, 0xd3, 0xa9, 0xfe,
	0xa2, 0x80, 0x78, 0x07, 0xd6, 0xca, 0x54, 0xdf, 0xdf, 0x3f, 0x3c, 0x8c, 0xfd, 0x8b, 0xa2, 0x37,
	0xcc, 0x23, 0x31, 0x26, 0x66, 0x20, 0x2a, 0x59, 0x0f, 0x6b, 0x62, 0x0a, 0xfa, 0x6f, 0x68, 0xf8,
	0x38, 0x95, 0x90, 0x95, 0x64, 0x40, 0x69, 0x63, 0xca, 0xc3, 0x9a, 0x2b, 0xe8, 0xec, 0x0d, 0xa8,
	0x63, 0xfc, 0x4b, 0x5b, 0x2d, 0x23, 0x5f, 0x39, 0x26, 0x3c, 0xac, 0xb9, 0x44, 0x45, 0xae, 0x30,
	0xf6, 0x86, 0xfd, 0x4e, 0xc9, 0x55, 0xf6, 0x52, 0xe4, 0x42, 0x2a, 0x72, 0x61, 0x0d, 0xa2, 0x7a,
	0x24, 0xb9, 0xca, 0x76, 0x80, 0x5c, 0x48, 0x65, 0xef, 0x01, 0x5c, 0x7a, 0x61, 0x30, 0x14, 0xcd,
	0xa7, 0x4b, 0xbc, 0xeb, 0xc8, 0xfb, 0xac, 0xc0, 0xca, 0xa8, 0xd7, 0xf8, 0xee, 0xb7, 0xa1, 0x99,
	0x89, 0xf0, 0xff, 0x36, 0xac, 0x56, 0x7c, 0x76, 0x18, 0x64, 0x64, 0x60, 0x41, 0xee, 0x1b, 0x8b,
	0x06, 0x37, 0x75, 0x7e, 0x00, 0x40, 0x96, 0x78, 0x90, 0xa6, 0x71, 0xaa, 0x06, 0x48, 0xa3, 0x18,
	0x20, 0x9d, 0xbb, 0xd0, 0x41, 0x0b, 0xdc, 0x40, 0xc6, 0x57, 0x5f, 0x44, 0x4e, 0xa0, 0x47, 0xef,
	0xfc, 0xf4, 0x70, 0x01, 0x07, 0xdb, 0x85, 0x75, 0x31, 0xc5, 0x89, 0x24, 0x78, 0x12, 0x67, 0x01,
	0x59, 0x42, 0xa4, 0xe3, 0x5c, 0x1a, 0xd6, 0x46, 0x8e, 0xe2, 0x8e, 0x9f, 0x1e, 0xaa, 0x39, 0x43,
	0xc1, 0xce, 0xff, 0x41, 0x07, 0x6f, 0x14, 0xd7, 0x6d, 0x41, 0x93, 0x08, 0xca, 0x0e, 0x76, 0xe1,
	0x04, 0xa9, 0x90, 0x2b, 0xe9, 0xce, 0x4f, 0x0c, 0xe8, 0x8a, 0x22, 0x27, 0x4e, 0xbe, 0x6c, 0x8d,
	0xdb, 0xac, 0x1c, 0x57, 0x55, 0x42, 0x97, 0xb8, 0x03, 0x40, 0x65, 0x4a, 0x30, 0xd4, 0xcb, 0xa0,
	0x28, 0xb1, 0xae, 0xc6, 0x81, 0x8e, 0x29, 0xa1, 0x39, 0xa6, 0xfd, 0x85, 0x09, 0x3d, 0xe9, 0x52,
	0xc1, 0xf2, 0x1f, 0x4a, 0x56, 0x99, 0x4f, 0x75, 0x3d, 0x9f, 0xde, 0x54, 0xf9, 0xd4, 0x28, 0x5f,
	0xa3, 0x8c, 0xa2, 0x32, 0x9d, 0xee, 0xc9, 0x74, 0x6a, 0x12, 0xdb, 0x92, 0x4a, 0x27, 0xc5, 0x25,
	0xb2, 0xe9, 0x9e, 0xcc, 0xa6, 0x56, 0xc9, 0x54, 0x84, 0x54, 0x91, 0x4c, 0xf7, 0x64, 0x32, 0xb5,
	0x4b, 0xa6, 0xc2, 0xcd, 0x2a, 0x97, 0xee, 0xb7, 0xa0, 0x41, 0xee, 0x74, 0x3e, 0x00, 0x5b, 0x37,
	0x0d, 0xe5, 0xc4, 0x9b, 0x92, 0x58, 0x09, 0x05, 0x8d, 0xc9, 0x95, 0x67, 0x9f, 0xc3, 0x52, 0xa5,
	0x14, 0xe1, 0x04, 0x11, 0x64, 0x7b, 0x5e, 0xe4, 0xf3, 0xb0, 0xd8, 0x63, 0x34, 0x8c, 0x16, 0x64,
	0x66, 0x29, 0x59, 0x8a, 0xa8, 0x04, 0x99, 0xb6, 0x8d, 0x58, 0x95, 0x6d, 0xe4, 0x2f, 0x06, 0xf4,
	0xf4, 0x03, 0xb8, 0xd0, 0x3c, 0x48, 0xd3, 0xbd, 0x78, 0x28, 0xbc, 0xd9, 0x70, 0x15, 0x88, 0xa1,
	0x8f, 0x8f, 0xa1, 0x97, 0x65, 0x32, 0x02, 0x0b, 0x58, 0xd2, 0x8e, 0xfd, 0x38, 0x51, 0xfb, 0x65,
	0x01, 0x4b, 0xda, 0x21, 0xbf, 0xe4, 0xa1, 0x6c, 0x50, 0x05, 0x8c, 0xb7, 0x3d, 0xe6, 0x59, 0x86,
	0x61, 0x22, 0xea, 0xaa, 0x02, 0xf1, 0x94, 0xeb, 0x5d, 0xed, 0x79, 0x93, 0x8c, 0xcb, 0x19, 0xb0,
	0x80, 0xd1, 0x2c, 0xb8, 0x07, 0x7b, 0x69, 0x3c, 0x89, 0xd4, 0xe4, 0xa7, 0x61, 0x9c, 0x2b, 0x58,
	0x7d, 0x32, 0x49, 0x47, 0x9c, 0x82, 0x58, 0xad, 0xd5, 0x1b, 0xd0, 0x0e, 0x22, 0xcf, 0xcf, 0x83,
	0x4b, 0x2e, 0x2d, 0x59, 0xc0, 0x18, 0xbf, 0x79, 0x30, 0xe6, 0x72, 0xf4, 0xa5, 0x67, 0xe4, 0x3f,
	0x0b, 0x42, 0x4e, 0x71, 0x2d, 0x5f, 0x49, 0xc1, 0x94, 0xa2, 0xa2, 0x27, 0xcb, 0xa5, 0x59, 0x40,
	0xce, 0x2f, 0x4d, 0xd8, 0x38, 0x4a, 0x78, 0xea, 0xe5, 0x5c, 0x2c, 0xea, 0xc7, 0xfe, 0x39, 0x1f,
	0x7b, 0x4a, 0x85, 0x3b, 0x60, 0xc6, 0x09, 0x5d, 0x2e, 0xe3, 0x5d, 0x90, 0x8f, 0x12, 0xd7, 0x8c,
	0x13, 0x52, 0xc2, 0xcb, 0x2e, 0xa4, 0x6d, 0xe9, 0x79, 0xe1, 0xd6, 0xbe, 0x01, 0xed, 0xa1, 0x97,
	0x7b, 0xa7, 0x5e, 0xc6, 0x95, 0x4d, 0x15, 0x4c, 0x0b, 0x2e, 0xee, 0x83, 0xd2, 0xa2, 0x02, 0x20,
	0x49, 0x74, 0x9b, 0xb4, 0xa6, 0x84, 0x90, 0xfb, 0x2c, 0x9c, 0x64, 0xe7, 0x64, 0xc6, 0xb6, 0x2b,
	0x00, 0xd4, 0xa5, 0x88, 0xf9, 0xb6, 0x6c, 0x17, 0x03, 0x80, 0xb3, 0x34, 0x1e, 0x8b, 0xc2, 0x42,
	0x0d, 0xa8, 0xed, 0x6a, 0x18, 0x45, 0x3f, 0x11, 0xeb, 0x0f, 0x94, 0x74, 0x81, 0x71, 0x72, 0x58,
	0x7a, 0xf6, 0xae, 0x0c, 0xfb, 0xc7, 0x3c, 0xf7, 0xd8, 0x86, 0x66, 0x0e, 0x40, 0x73, 0x20, 0x45,
	0x1a, 0xe3, 0x85, 0xd5, 0x43, 0x95, 0x1c, 0x4b, 0x2b, 0x39, 0xca, 0x82, 0x75, 0x0a, 0x71, 0x7a,
	0x76, 0xde, 0x83, 0x75, 0xe9, 0x91, 0x67, 0xef, 0xe2, 0xad, 0x0b, 0x7d, 0x21, 0xc8, 0xe2, 0x7a,
	0xe7, 0x4f, 0x06, 0xdc, 0x9a, 0x3a, 0xf6, 0xd2, 0xdf, 0x3f, 0xde, 0x87, 0x3a, 0x2e, 0x90, 0x7d,
	0x8b, 0x52, 0xf3, 0x1e, 0xde, 0x31, 0x57, 0xe4, 0x0e, 0x02, 0x0f, 0xa2, 0x3c, 0xbd, 0x76, 0xe9,
	0xc0, 0xc6, 0xa7, 0xd0, 0x29, 0x50, 0x28, 0xf7, 0x82, 0x5f, 0xab, 0xea, 0x7b, 0xc1, 0xaf, 0x71,
	0xa2, 0xb8, 0xf4, 0xc2, 0x89, 0x30, 0x8d, 0x6c, 0xb0, 0x15, 0xc3, 0xba, 0x82, 0xfe, 0x81, 0xf9,
	0xff, 0x86, 0xf3, 0x43, 0xe8, 0x3f, 0xf4, 0xa2, 0x61, 0x28, 0xe3, 0x51, 0x14, 0x05, 0x69, 0x82,
	0x57, 0x35, 0x13, 0x74, 0x51, 0x0a, 0x51, 0x6f, 0x88, 0xc6, 0x3b, 0xd0, 0x39, 0x55, 0xed, 0x50,
	0x1a, 0xbe, 0x44, 0x50, 0xcc, 0x3c, 0x0f, 0x33, 0xb9, 0xa6, 0xd2, 0xb3, 0x73, 0x0b, 0xd6, 0x0e,
	0x78, 0x2e, 0xee, 0xde, 0x3b, 0x1b, 0xc9, 0x9b, 0x9d, 0x2d, 0x58, 0xaf, 0xa2, 0xa5, 0x71, 0x6d,
	0xb0, 0xfc, 0xb3, 0xa2, 0xd5, 0xf8, 0x67, 0x23, 0xe7, 0x18, 0xee, 0x8a, 0x69, 0x69, 0x72, 0x8a,
	0x2a, 0x60, 0xe9, 0xfb, 0x3c, 0x19, 0x7a, 0x39, 0x57, 0x2f, 0xb1, 0x0b, 0xeb, 0x99, 0xa0, 0xed,
	0x9d, 0x8d, 0x4e, 0xe2, 0x71, 0x78, 0x9c, 0xa7, 0x41, 0xa4, 0x64, 0xcc, 0xa5, 0x39, 0x87, 0x30,
	0x58, 0x24, 0x54, 0x2a, 0xd2, 0x87, 0x96, 0xfc, 0xf8, 0x23, 0xdd, 0xac, 0xc0, 0x59, 0x3f, 0x3b,
	0x23, 0xd8, 0x38, 0xe0, 0xf9, 0xcc, 0xcc, 0x54, 0x96, 0x1d, 0xbc, 0xe3, 0xb3, 0xb2, 0x3d, 0x16,
	0x30, 0xfb, 0x1f, 0xe8, 0x9d, 0x05, 0x61, 0xce, 0x53, 0xb9, 0x73, 0xcc, 0xc4, 0x7a, 0x85, 0xec,
	0xfc, 0xcd, 0x02, 0x7b, 0xfa, 0x9a, 0xc2, 0x4f, 0xc6, 0xdc, 0xaa, 0x61, 0x56, 0xaa, 0x06, 0x83,
	0xfa, 0x18, 0x0b, 0xbb, 0xcc, 0x19, 0x7c, 0x2e, 0x13, 0xad, 0xbe, 0x20, 0xd1, 0xb6, 0x60, 0x45,
	0x4e, 0x7f, 0xb1, 0xda, 0x6b, 0xe4, 0x02, 0x31, 0x85, 0xc6, 0x81, 0x79, 0x0a, 0x45, 0xeb, 0x86,
	0xa8, 0x37, 0xf3, 0x48, 0xda, 0x34, 0xde, 0xfa, 0x06, 0xd3, 0x78, 0x22, 0x08, 0xe2, 0x13, 0x95,
	0x34, 0x59, 0x5b, 0x08, 0x9f, 0x43, 0x62, 0x6f, 0xc3, 0x6a, 0xc2, 0x23, 0x5c, 0xdc, 0x35, 0xfe,
	0x0e, 0xf1, 0xcf, 0x12, 0xf0, 0x35, 0xa9, 0x55, 0x6a, 0xbc, 0x20, 0x5e, 0x73, 0x0a, 0x8d, 0x1b,
	0x9c, 0x3f, 0xc9, 0xe3, 0x4b, 0xb5, 0xaa, 0x61, 0x32, 0x88, 0xe5, 0x7e, 0x06, 0x8f, 0x3a, 0x54,
	0x70, 0x64, 0x90, 0x9e, 0xd0, 0x61, 0x86, 0xe0, 0xfc, 0xc6, 0x80, 0x5b, 0xa5, 0x83, 0xe9, 0xa3,
	0xde, 0x0b, 0xf6, 0xde, 0x0d, 0x68, 0x67, 0xa9, 0x4f, 0x9c, 0xaa, 0x27, 0x2b, 0x98, 0x7a, 0x44,
	0x96, 0x0b, 0x9a, 0x6c, 0x60, 0x0a, 0x7e, 0xb1, 0xd7, 0xfb, 0xd0, 0x1a, 0x57, 0x1b, 0xb3, 0x04,
	0x9d, 0x3f, 0x18, 0xf0, 0xea, 0xdc, 0x78, 0xff, 0x37, 0x3e, 0x10, 0x43, 0x11, 0x14, 0x99, 0x2c,
	0x93, 0x37, 0xef, 0x1f, 0x38, 0xc9, 0x7c, 0x08, 0x4b, 0x79, 0x69, 0x19, 0xae, 0x3e, 0x10, 0xbf,
	0x52, 0x3d, 0xa8, 0x19, 0xcf, 0xad, 0xf2, 0x3b, 0x17, 0xf0, 0x4a, 0x45, 0xff, 0x4a, 0x4d, 0xdc,
	0xa5, 0xf9, 0x1e, 0x79, 0xb9, 0xac, 0x8c, 0xb7, 0x35, 0xc1, 0x62, 0x9e, 0x26, 0xaa, 0x5b, 0xf0,
	0x55, 0x52, 0xdc, 0xac, 0xa6, 0xb8, 0xf3, 0x6b, 0x13, 0x56, 0xa6, 0xae, 0x62, 0xcb, 0x60, 0x06,
	0x43, 0xe9, 0x48, 0x33, 0x18, 0x2e, 0x4c, 0x57, 0xdd, 0xb9, 0xd6, 0x94, 0x73, 0xb1, 0x40, 0xa5,
	0xfe, 0xbe, 0x97, 0x7b, 0xb2, 0xff, 0x2b, 0xb0, 0xe2, 0xf6, 0xc6, 0x94, 0xdb, 0xfb, 0xd0, 0x1a,
	0x66, 0x39, 0x9d, 0x12, 0x59, 0xa9, 0x40, 0x2c, 0xed, 0x14, 0xe7, 0xf4, 0xa9, 0x4a, 0x4c, 0x54,
	0x25, 0x82, 0xed, 0x14, 0x4b, 0x5d, 0xfb, 0x46, 0x9b, 0x48, 0xae, 0x62, 0x9e, 0xea, 0xc8, 0xa2,
	0x84, 0xf3, 0x94, 0x16, 0x51, 0x50, 0x8d, 0xa8, 0xe7, 0x53, 0x05, 0x54, 0x3a, 0xe4, 0xa5, 0xe3,
	0xe9, 0x2d, 0x35, 0x66, 0x8b, 0x50, 0x5a, 0xab, 0x46, 0x44, 0x65, 0xd2, 0xfe, 0xb9, 0x01, 0x77,
	0x55, 0x33, 0x9e, 0x1f, 0x08, 0xf7, 0xb4, 0xe6, 0x38, 0x2b, 0x49, 0x36, 0x49, 0x9a, 0xcf, 0x3f,
	0x0e, 0x43, 0xb1, 0x58, 0x99, 0x6a, 0x3e, 0x57, 0x98, 0x4a, 0x64, 0x58, 0x53, 0xc5, 0x7f, 0x9d,
	0xb4, 0x7d, 0x24, 0x7e, 0x50, 0xa8, 0xbb, 0x02, 0x70, 0x3e, 0x85, 0xc1, 0x22, 0xbd, 0x5e, 0xd6,
	0x1e, 0xce, 0x35, 0xdc, 0x15, 0x6d, 0xad, 0x14, 0xa5, 0x7e, 0x3e, 0x7a, 0x71, 0x6f, 0xaa, 0xf4,
	0x7a, 0x73, 0xba, 0xd7, 0x17, 0x9f, 0x36, 0xe9, 0x73, 0xb9, 0xa5, 0x7f, 0xda, 0x44, 0xcc, 0xf6,
	0x05, 0x34, 0xc5, 0x30, 0xc7, 0x96, 0xa0, 0xf3, 0x28, 0xa2, 0xf4, 0x3d, 0x4a, 0xec, 0x1a, 0x6b,
	0x43, 0xfd, 0x38, 0x8f, 0x13, 0xdb, 0x60, 0x1d, 0x68, 0x3c, 0xc1, 0x69, 0xde, 0x36, 0x19, 0x40,
	0x13, 0xab, 0xfd, 0x98, 0xdb, 0x16, 0xa2, 0x8f, 0x73, 0x2f, 0xcd, 0xed, 0x3a, 0xa2, 0x85, 0xfe,
	0x76, 0x83, 0x2d, 0x03, 0x7c, 0x3c, 0xc9, 0x63, 0xc9, 0xd6, 0x44, 0xda, 0x3e, 0x0f, 0x79, 0xce,
	0xed, 0xd6, 0xf6, 0x8f, 0xe8, 0xc8, 0x08, 0xc7, 0x87, 0x9e, 0xbc, 0x8b, 0x60, 0xbb, 0xc6, 0x5a,
	0x60, 0x7d, 0xc6, 0xaf, 0x6c, 0x83, 0x75, 0xa1, 0xe5, 0x4e, 0xa2, 0x28, 0x88, 0x46, 0xe2, 0x3e,
	0xba, 0x7a, 0x68, 0x5b, 0x48, 0x40, 0x85, 0x12, 0x3e, 0xb4, 0xeb, 0xac, 0x07, 0xed, 0x4f, 0xe4,
	0xcf, 0x0e, 0x76, 0x03, 0x49, 0xc8, 0x86, 0x67, 0x9a, 0x48, 0xa2, 0xcb, 0x11, 0x6a, 0x21, 0x44,
	0xa7, 0x10, 0x6a, 0x6f, 0x1f, 0x41, 0x5b, 0x6d, 0xae, 0x6c, 0x05, 0xba, 0x52, 0x07, 0x44, 0xd9,
	0x35, 0x7c, 0x21, 0x1a, 0x36, 0x6c, 0x03, 0x5f, 0x1e, 0x77, 0x50, 0xdb, 0xc4, 0x27, 0x5c, 0x34,
	0x6d, 0x8b, 0x0c, 0x72, 0x1d, 0xf9, 0x76, 0x1d, 0x19, 0x69, 0x61, 0xb1, 0x87, 0xdb, 0x8f, 0xa1,
	0x45, 0x8f, 0x47, 0x38, 0x87, 0x2d, 0x4b, 0x79, 0x12, 0x63, 0xd7, 0xd0, 0xa6, 0x78, 0xbb, 0xe0,
	0x36, 0xd0, 0x36, 0xf4, 0x3a, 0x02, 0x36, 0x51, 0x05, 0x61, 0x27, 0x81, 0xb0, 0xb6, 0x7f, 0x6c,
	0x40, 0x5b, 0xad, 0x1a, 0x6c, 0x0d, 0x56, 0x94, 0x91, 0x24, 0x4a, 0x48, 0x3c, 0xe0, 0xb9, 0x40,
	0xd8, 0x06, 0x5d, 0x50, 0x80, 0x26, 0xda, 0xd5, 0xe5, 0xe3, 0xf8, 0x92, 0x4b, 0x8c, 0x85, 0x57,
	0xe2, 0x66, 0x2b, 0xe1, 0x3a, 0x1e, 0x40, 0x98, 0xaa, 0x8c, 0xdd, 0x60, 0xb7, 0x81, 0x21, 0xf8,
	0x38, 0x18, 0x61, 0x24, 0x8b, 0xf9, 0x3f, 0xb3, 0x9b, 0xdb, 0x1f, 0x41, 0x5b, 0x8d, 0xd9, 0x9a,
	0x1e, 0x0a, 0x55, 0xe8, 0x21, 0x10, 0xb6, 0x51, 0x5e, 0x2c, 0x31, 0xe6, 0xf6, 0x33, 0x5a, 0x4f,
	0x71, 0x4a, 0xd5, 0x2c, 0x23, 0x31, 0x32, 0xbc, 0x2e, 0x82, 0x44, 0x3a, 0x9c, 0x27, 0xa1, 0xe7,
	0x17, 0x01, 0x76, 0xc9, 0xd3, 0xdc, 0xb6, 0xf0, 0xf9, 0x51, 0xf4, 0x03, 0xee, 0x63, 0x84, 0xa1,
	0x1b, 0x82, 0x2c, 0xb7, 0x1b, 0xdb, 0x87, 0xd0, 0x7d, 0xa6, 0x7a, 0xcc, 0x51, 0x82, 0x2f, 0xa0,
	0x94, 0x2b, 0xb1, 0x76, 0x0d, 0xef, 0xa4, 0xe8, 0x2c, 0xb0, 0xb6, 0xc1, 0x56, 0x61, 0x09, 0xbd,
	0x51, 0xa2, 0xcc, 0xed, 0xa7, 0xc0, 0x66, 0xab, 0x23, 0x1a, 0xad, 0x54, 0xd8, 0xae, 0xa1, 0x26,
	0x9f, 0xf1, 0x2b, 0x7c, 0x26, 0x1f, 0x3e, 0x1a, 0x45, 0x71, 0xca, 0x89, 0xa6, 0x7c, 0x48, 0xdf,
	0x17, 0x11, 0x61, 0x6d, 0x3f, 0x9b, 0xea, 0x23, 0x47, 0x89, 0x16, 0xee, 0x04, 0xdb, 0x35, 0x0a,
	0x3e, 0x92, 0x22, 0x10, 0xd2, 0x80, 0x24, 0x46, 0x60, 0x4c, 0xbc, 0x68, 0x2f, 0xe4, 0x5e, 0x2a,
	0x60, 0x6b, 0xf7, 0x1f, 0x4d, 0x68, 0x8a, 0xaa, 0xc0, 0x3e, 0x82, 0xae, 0xf6, 0x8b, 0x2f, 0xa3,
	0x22, 0x3f, 0xfb, 0xfb, 0xf4, 0xc6, 0x7f, 0xcd, 0xe0, 0x45, 0x65, 0x72, 0x6a, 0xec, 0x43, 0x80,
	0x72, 0xf1, 0x66, 0xb7, 0x68, 0x9a, 0x9b, 0x5e, 0xc4, 0x37, 0xfa, 0xf4, 0xc9, 0x66, 0xce, 0xaf,
	0xd9, 0x4e, 0x8d, 0x7d, 0x07, 0x96, 0x64, 0xf9, 0x13, 0xa1, 0xc5, 0x06, 0xda, 0xda, 0x34, 0x67,
	0xa5, 0xbe, 0x51, 0xd8, 0x27, 0x85, 0x30, 0x11, 0x3e, 0xac, 0x3f, 0x67, 0x07, 0x13, 0x62, 0x5e,
	0x59, 0xb8, 0x9d, 0x39, 0x35, 0x76, 0x00, 0x5d, 0xb1, 0x43, 0x89, 0xa2, 0x7e, 0x07, 0x79, 0x17,
	0x2d, 0x55, 0x37, 0x2a, 0xb4, 0x07, 0x3d, 0x7d, 0xed, 0x61, 0x64, 0xc9, 0x39, 0xfb, 0x91, 0x10,
	0x32, 0x6f, 0x43, 0x72, 0x6a, 0xcc, 0x83, 0xdb, 0xf3, 0x97, 0x17, 0xf6, 0x7a, 0xf9, 0x6d, 0x79,
	0xc1, 0xb6, 0xb4, 0xe1, 0xdc, 0xc4, 0x52, 0x5c, 0xf1, 0x3d, 0xe8, 0x17, 0x97, 0x17, 0x61, 0x2d,
	0xa3, 0x62, 0x20, 0x55, 0x5b, 0xb0, 0xef, 0x6c, 0xbc, 0xb6, 0x90, 0x5e, 0x88, 0x3f, 0x81, 0xd5,
	0x92, 0x21, 0x16, 0xe6, 0x63, 0x77, 0x67, 0xce, 0x55, 0xcc, 0x3a, 0x58, 0x44, 0x2e, 0xa4, 0x7e,
	0xbf, 0xdc, 0xd8, 0xab, 0x92, 0x5f, 0xd7, 0x7d, 0x3b, 0x5f, 0xba, 0x73, 0x13, 0x4b, 0x71, 0xc3,
	0x13, 0x58, 0xa9, 0xf4, 0x53, 0x25, 0xfb, 0xc6, 0x26, 0x7b, 0x53, 0x40, 0xdc, 0xef, 0x7f, 0xf1,
	0xd5, 0xc0, 0xf8, 0xf2, 0xab, 0x81, 0xf1, 0xf7, 0xaf, 0x06, 0xc6, 0x4f, 0xbf, 0x1e, 0xd4, 0xbe,
	0xfc, 0x7a, 0x50, 0xfb, 0xeb, 0xd7, 0x83, 0xda, 0x69, 0x93, 0xfe, 0x25, 0xf2, 0xbf, 0xff, 0x0a,
	0x00, 0x00, 0xff, 0xff, 0x1d, 0x07, 0x2d, 0x0f, 0x37, 0x22, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// WorkerClient is the client API for Worker service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WorkerClient interface {
	QueryStatus(ctx context.Context, in *QueryStatusRequest, opts ...grpc.CallOption) (*QueryStatusResponse, error)
	// PurgeRelay purges relay log files for this dm-worker
	PurgeRelay(ctx context.Context, in *PurgeRelayRequest, opts ...grpc.CallOption) (*CommonWorkerResponse, error)
	// Operate (get/set/remove) schema for a specified table in tracker.
	// a `set`/`remove` operation should be an one-time operation (only take effect once),
	// so we use a gRPC method rather than a etcd operation now (no persistent operation state).
	OperateSchema(ctx context.Context, in *OperateWorkerSchemaRequest, opts ...grpc.CallOption) (*CommonWorkerResponse, error)
	OperateV1Meta(ctx context.Context, in *OperateV1MetaRequest, opts ...grpc.CallOption) (*OperateV1MetaResponse, error)
	HandleError(ctx context.Context, in *HandleWorkerErrorRequest, opts ...grpc.CallOption) (*CommonWorkerResponse, error)
	GetWorkerCfg(ctx context.Context, in *GetWorkerCfgRequest, opts ...grpc.CallOption) (*GetWorkerCfgResponse, error)
	// only some fields of the configuration of the subtask in the sync phase can be updated
	CheckSubtasksCanUpdate(ctx context.Context, in *CheckSubtasksCanUpdateRequest, opts ...grpc.CallOption) (*CheckSubtasksCanUpdateResponse, error)
	GetWorkerValidatorStatus(ctx context.Context, in *GetValidationStatusRequest, opts ...grpc.CallOption) (*GetValidationStatusResponse, error)
	GetValidatorError(ctx context.Context, in *GetValidationErrorRequest, opts ...grpc.CallOption) (*GetValidationErrorResponse, error)
	OperateValidatorError(ctx context.Context, in *OperateValidationErrorRequest, opts ...grpc.CallOption) (*OperateValidationErrorResponse, error)
	UpdateValidator(ctx context.Context, in *UpdateValidationWorkerRequest, opts ...grpc.CallOption) (*CommonWorkerResponse, error)
}

type workerClient struct {
	cc *grpc.ClientConn
}

func NewWorkerClient(cc *grpc.ClientConn) WorkerClient {
	return &workerClient{cc}
}

func (c *workerClient) QueryStatus(ctx context.Context, in *QueryStatusRequest, opts ...grpc.CallOption) (*QueryStatusResponse, error) {
	out := new(QueryStatusResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/QueryStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) PurgeRelay(ctx context.Context, in *PurgeRelayRequest, opts ...grpc.CallOption) (*CommonWorkerResponse, error) {
	out := new(CommonWorkerResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/PurgeRelay", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) OperateSchema(ctx context.Context, in *OperateWorkerSchemaRequest, opts ...grpc.CallOption) (*CommonWorkerResponse, error) {
	out := new(CommonWorkerResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/OperateSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) OperateV1Meta(ctx context.Context, in *OperateV1MetaRequest, opts ...grpc.CallOption) (*OperateV1MetaResponse, error) {
	out := new(OperateV1MetaResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/OperateV1Meta", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) HandleError(ctx context.Context, in *HandleWorkerErrorRequest, opts ...grpc.CallOption) (*CommonWorkerResponse, error) {
	out := new(CommonWorkerResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/HandleError", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) GetWorkerCfg(ctx context.Context, in *GetWorkerCfgRequest, opts ...grpc.CallOption) (*GetWorkerCfgResponse, error) {
	out := new(GetWorkerCfgResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/GetWorkerCfg", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) CheckSubtasksCanUpdate(ctx context.Context, in *CheckSubtasksCanUpdateRequest, opts ...grpc.CallOption) (*CheckSubtasksCanUpdateResponse, error) {
	out := new(CheckSubtasksCanUpdateResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/CheckSubtasksCanUpdate", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) GetWorkerValidatorStatus(ctx context.Context, in *GetValidationStatusRequest, opts ...grpc.CallOption) (*GetValidationStatusResponse, error) {
	out := new(GetValidationStatusResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/GetWorkerValidatorStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) GetValidatorError(ctx context.Context, in *GetValidationErrorRequest, opts ...grpc.CallOption) (*GetValidationErrorResponse, error) {
	out := new(GetValidationErrorResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/GetValidatorError", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) OperateValidatorError(ctx context.Context, in *OperateValidationErrorRequest, opts ...grpc.CallOption) (*OperateValidationErrorResponse, error) {
	out := new(OperateValidationErrorResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/OperateValidatorError", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *workerClient) UpdateValidator(ctx context.Context, in *UpdateValidationWorkerRequest, opts ...grpc.CallOption) (*CommonWorkerResponse, error) {
	out := new(CommonWorkerResponse)
	err := c.cc.Invoke(ctx, "/pb.Worker/UpdateValidator", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WorkerServer is the server API for Worker service.
type WorkerServer interface {
	QueryStatus(context.Context, *QueryStatusRequest) (*QueryStatusResponse, error)
	// PurgeRelay purges relay log files for this dm-worker
	PurgeRelay(context.Context, *PurgeRelayRequest) (*CommonWorkerResponse, error)
	// Operate (get/set/remove) schema for a specified table in tracker.
	// a `set`/`remove` operation should be an one-time operation (only take effect once),
	// so we use a gRPC method rather than a etcd operation now (no persistent operation state).
	OperateSchema(context.Context, *OperateWorkerSchemaRequest) (*CommonWorkerResponse, error)
	OperateV1Meta(context.Context, *OperateV1MetaRequest) (*OperateV1MetaResponse, error)
	HandleError(context.Context, *HandleWorkerErrorRequest) (*CommonWorkerResponse, error)
	GetWorkerCfg(context.Context, *GetWorkerCfgRequest) (*GetWorkerCfgResponse, error)
	// only some fields of the configuration of the subtask in the sync phase can be updated
	CheckSubtasksCanUpdate(context.Context, *CheckSubtasksCanUpdateRequest) (*CheckSubtasksCanUpdateResponse, error)
	GetWorkerValidatorStatus(context.Context, *GetValidationStatusRequest) (*GetValidationStatusResponse, error)
	GetValidatorError(context.Context, *GetValidationErrorRequest) (*GetValidationErrorResponse, error)
	OperateValidatorError(context.Context, *OperateValidationErrorRequest) (*OperateValidationErrorResponse, error)
	UpdateValidator(context.Context, *UpdateValidationWorkerRequest) (*CommonWorkerResponse, error)
}

// UnimplementedWorkerServer can be embedded to have forward compatible implementations.
type UnimplementedWorkerServer struct {
}

func (*UnimplementedWorkerServer) QueryStatus(ctx context.Context, req *QueryStatusRequest) (*QueryStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryStatus not implemented")
}
func (*UnimplementedWorkerServer) PurgeRelay(ctx context.Context, req *PurgeRelayRequest) (*CommonWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeRelay not implemented")
}
func (*UnimplementedWorkerServer) OperateSchema(ctx context.Context, req *OperateWorkerSchemaRequest) (*CommonWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OperateSchema not implemented")
}
func (*UnimplementedWorkerServer) OperateV1Meta(ctx context.Context, req *OperateV1MetaRequest) (*OperateV1MetaResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OperateV1Meta not implemented")
}
func (*UnimplementedWorkerServer) HandleError(ctx context.Context, req *HandleWorkerErrorRequest) (*CommonWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method HandleError not implemented")
}
func (*UnimplementedWorkerServer) GetWorkerCfg(ctx context.Context, req *GetWorkerCfgRequest) (*GetWorkerCfgResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkerCfg not implemented")
}
func (*UnimplementedWorkerServer) CheckSubtasksCanUpdate(ctx context.Context, req *CheckSubtasksCanUpdateRequest) (*CheckSubtasksCanUpdateResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckSubtasksCanUpdate not implemented")
}
func (*UnimplementedWorkerServer) GetWorkerValidatorStatus(ctx context.Context, req *GetValidationStatusRequest) (*GetValidationStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetWorkerValidatorStatus not implemented")
}
func (*UnimplementedWorkerServer) GetValidatorError(ctx context.Context, req *GetValidationErrorRequest) (*GetValidationErrorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetValidatorError not implemented")
}
func (*UnimplementedWorkerServer) OperateValidatorError(ctx context.Context, req *OperateValidationErrorRequest) (*OperateValidationErrorResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method OperateValidatorError not implemented")
}
func (*UnimplementedWorkerServer) UpdateValidator(ctx context.Context, req *UpdateValidationWorkerRequest) (*CommonWorkerResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateValidator not implemented")
}

func RegisterWorkerServer(s *grpc.Server, srv WorkerServer) {
	s.RegisterService(&_Worker_serviceDesc, srv)
}

func _Worker_QueryStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).QueryStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/QueryStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).QueryStatus(ctx, req.(*QueryStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_PurgeRelay_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeRelayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).PurgeRelay(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/PurgeRelay",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).PurgeRelay(ctx, req.(*PurgeRelayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_OperateSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OperateWorkerSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).OperateSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/OperateSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).OperateSchema(ctx, req.(*OperateWorkerSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_OperateV1Meta_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OperateV1MetaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).OperateV1Meta(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/OperateV1Meta",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).OperateV1Meta(ctx, req.(*OperateV1MetaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_HandleError_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleWorkerErrorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).HandleError(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/HandleError",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).HandleError(ctx, req.(*HandleWorkerErrorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_GetWorkerCfg_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetWorkerCfgRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).GetWorkerCfg(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/GetWorkerCfg",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).GetWorkerCfg(ctx, req.(*GetWorkerCfgRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_CheckSubtasksCanUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckSubtasksCanUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).CheckSubtasksCanUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/CheckSubtasksCanUpdate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).CheckSubtasksCanUpdate(ctx, req.(*CheckSubtasksCanUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_GetWorkerValidatorStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValidationStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).GetWorkerValidatorStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/GetWorkerValidatorStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).GetWorkerValidatorStatus(ctx, req.(*GetValidationStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_GetValidatorError_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValidationErrorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).GetValidatorError(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/GetValidatorError",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).GetValidatorError(ctx, req.(*GetValidationErrorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_OperateValidatorError_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(OperateValidationErrorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).OperateValidatorError(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/OperateValidatorError",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).OperateValidatorError(ctx, req.(*OperateValidationErrorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Worker_UpdateValidator_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateValidationWorkerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WorkerServer).UpdateValidator(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/pb.Worker/UpdateValidator",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WorkerServer).UpdateValidator(ctx, req.(*UpdateValidationWorkerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Worker_serviceDesc = grpc.ServiceDesc{
	ServiceName: "pb.Worker",
	HandlerType: (*WorkerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "QueryStatus",
			Handler:    _Worker_QueryStatus_Handler,
		},
		{
			MethodName: "PurgeRelay",
			Handler:    _Worker_PurgeRelay_Handler,
		},
		{
			MethodName: "OperateSchema",
			Handler:    _Worker_OperateSchema_Handler,
		},
		{
			MethodName: "OperateV1Meta",
			Handler:    _Worker_OperateV1Meta_Handler,
		},
		{
			MethodName: "HandleError",
			Handler:    _Worker_HandleError_Handler,
		},
		{
			MethodName: "GetWorkerCfg",
			Handler:    _Worker_GetWorkerCfg_Handler,
		},
		{
			MethodName: "CheckSubtasksCanUpdate",
			Handler:    _Worker_CheckSubtasksCanUpdate_Handler,
		},
		{
			MethodName: "GetWorkerValidatorStatus",
			Handler:    _Worker_GetWorkerValidatorStatus_Handler,
		},
		{
			MethodName: "GetValidatorError",
			Handler:    _Worker_GetValidatorError_Handler,
		},
		{
			MethodName: "OperateValidatorError",
			Handler:    _Worker_OperateValidatorError_Handler,
		},
		{
			MethodName: "UpdateValidator",
			Handler:    _Worker_UpdateValidator_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "dmworker.proto",
}

func (m *QueryStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CommonWorkerResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CommonWorkerResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CommonWorkerResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Worker) > 0 {
		i -= len(m.Worker)
		copy(dAtA[i:], m.Worker)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Worker)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0x12
	}
	if m.Result {
		i--
		if m.Result {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *QueryStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *QueryStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SubTaskStatus) > 0 {
		for iNdEx := len(m.SubTaskStatus) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.SubTaskStatus[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if m.SourceStatus != nil {
		{
			size, err := m.SourceStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0x12
	}
	if m.Result {
		i--
		if m.Result {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *CheckStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Detail) > 0 {
		i -= len(m.Detail)
		copy(dAtA[i:], m.Detail)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Detail)))
		i--
		dAtA[i] = 0x32
	}
	if m.Warning != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Warning))
		i--
		dAtA[i] = 0x28
	}
	if m.Failed != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Failed))
		i--
		dAtA[i] = 0x20
	}
	if m.Successful != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Successful))
		i--
		dAtA[i] = 0x18
	}
	if m.Total != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Total))
		i--
		dAtA[i] = 0x10
	}
	if m.Passed {
		i--
		if m.Passed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *DumpStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DumpStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DumpStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Progress) > 0 {
		i -= len(m.Progress)
		copy(dAtA[i:], m.Progress)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Progress)))
		i--
		dAtA[i] = 0x3a
	}
	if m.Bps != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Bps))
		i--
		dAtA[i] = 0x30
	}
	if m.EstimateTotalRows != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.EstimateTotalRows))))
		i--
		dAtA[i] = 0x29
	}
	if m.FinishedRows != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.FinishedRows))))
		i--
		dAtA[i] = 0x21
	}
	if m.FinishedBytes != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.FinishedBytes))))
		i--
		dAtA[i] = 0x19
	}
	if m.CompletedTables != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.CompletedTables))))
		i--
		dAtA[i] = 0x11
	}
	if m.TotalTables != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.TotalTables))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *LoadStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Bps != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Bps))
		i--
		dAtA[i] = 0x30
	}
	if len(m.MetaBinlogGTID) > 0 {
		i -= len(m.MetaBinlogGTID)
		copy(dAtA[i:], m.MetaBinlogGTID)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.MetaBinlogGTID)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.MetaBinlog) > 0 {
		i -= len(m.MetaBinlog)
		copy(dAtA[i:], m.MetaBinlog)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.MetaBinlog)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Progress) > 0 {
		i -= len(m.Progress)
		copy(dAtA[i:], m.Progress)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Progress)))
		i--
		dAtA[i] = 0x1a
	}
	if m.TotalBytes != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.TotalBytes))
		i--
		dAtA[i] = 0x10
	}
	if m.FinishedBytes != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.FinishedBytes))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ShardingGroup) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ShardingGroup) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ShardingGroup) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Unsynced) > 0 {
		for iNdEx := len(m.Unsynced) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Unsynced[iNdEx])
			copy(dAtA[i:], m.Unsynced[iNdEx])
			i = encodeVarintDmworker(dAtA, i, uint64(len(m.Unsynced[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Synced) > 0 {
		for iNdEx := len(m.Synced) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Synced[iNdEx])
			copy(dAtA[i:], m.Synced[iNdEx])
			i = encodeVarintDmworker(dAtA, i, uint64(len(m.Synced[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.FirstLocation) > 0 {
		i -= len(m.FirstLocation)
		copy(dAtA[i:], m.FirstLocation)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.FirstLocation)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.DDLs) > 0 {
		for iNdEx := len(m.DDLs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.DDLs[iNdEx])
			copy(dAtA[i:], m.DDLs[iNdEx])
			i = encodeVarintDmworker(dAtA, i, uint64(len(m.DDLs[iNdEx])))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.Target) > 0 {
		i -= len(m.Target)
		copy(dAtA[i:], m.Target)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Target)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SyncStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.DumpIOTotalBytes != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.DumpIOTotalBytes))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.IoTotalBytes != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.IoTotalBytes))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.RecentRps != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.RecentRps))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.TotalRps != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.TotalRps))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.TotalRows != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.TotalRows))
		i--
		dAtA[i] = 0x78
	}
	if len(m.ConflictMsg) > 0 {
		i -= len(m.ConflictMsg)
		copy(dAtA[i:], m.ConflictMsg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ConflictMsg)))
		i--
		dAtA[i] = 0x72
	}
	if len(m.BlockDDLOwner) > 0 {
		i -= len(m.BlockDDLOwner)
		copy(dAtA[i:], m.BlockDDLOwner)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.BlockDDLOwner)))
		i--
		dAtA[i] = 0x6a
	}
	if m.SecondsBehindMaster != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.SecondsBehindMaster))
		i--
		dAtA[i] = 0x60
	}
	if len(m.BinlogType) > 0 {
		i -= len(m.BinlogType)
		copy(dAtA[i:], m.BinlogType)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.BinlogType)))
		i--
		dAtA[i] = 0x5a
	}
	if m.Synced {
		i--
		if m.Synced {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if len(m.UnresolvedGroups) > 0 {
		for iNdEx := len(m.UnresolvedGroups) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.UnresolvedGroups[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.BlockingDDLs) > 0 {
		for iNdEx := len(m.BlockingDDLs) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.BlockingDDLs[iNdEx])
			copy(dAtA[i:], m.BlockingDDLs[iNdEx])
			i = encodeVarintDmworker(dAtA, i, uint64(len(m.BlockingDDLs[iNdEx])))
			i--
			dAtA[i] = 0x42
		}
	}
	if len(m.SyncerBinlogGtid) > 0 {
		i -= len(m.SyncerBinlogGtid)
		copy(dAtA[i:], m.SyncerBinlogGtid)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.SyncerBinlogGtid)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.SyncerBinlog) > 0 {
		i -= len(m.SyncerBinlog)
		copy(dAtA[i:], m.SyncerBinlog)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.SyncerBinlog)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.MasterBinlogGtid) > 0 {
		i -= len(m.MasterBinlogGtid)
		copy(dAtA[i:], m.MasterBinlogGtid)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.MasterBinlogGtid)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.MasterBinlog) > 0 {
		i -= len(m.MasterBinlog)
		copy(dAtA[i:], m.MasterBinlog)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.MasterBinlog)))
		i--
		dAtA[i] = 0x22
	}
	if m.RecentTps != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.RecentTps))
		i--
		dAtA[i] = 0x18
	}
	if m.TotalTps != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.TotalTps))
		i--
		dAtA[i] = 0x10
	}
	if m.TotalEvents != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.TotalEvents))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *SourceStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SourceStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SourceStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RelayStatus != nil {
		{
			size, err := m.RelayStatus.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Result != nil {
		{
			size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Worker) > 0 {
		i -= len(m.Worker)
		copy(dAtA[i:], m.Worker)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Worker)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RelayStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RelayStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RelayStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	if m.Stage != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Stage))
		i--
		dAtA[i] = 0x38
	}
	if m.RelayCatchUpMaster {
		i--
		if m.RelayCatchUpMaster {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x30
	}
	if len(m.RelayBinlogGtid) > 0 {
		i -= len(m.RelayBinlogGtid)
		copy(dAtA[i:], m.RelayBinlogGtid)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.RelayBinlogGtid)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.RelayBinlog) > 0 {
		i -= len(m.RelayBinlog)
		copy(dAtA[i:], m.RelayBinlog)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.RelayBinlog)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.RelaySubDir) > 0 {
		i -= len(m.RelaySubDir)
		copy(dAtA[i:], m.RelaySubDir)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.RelaySubDir)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.MasterBinlogGtid) > 0 {
		i -= len(m.MasterBinlogGtid)
		copy(dAtA[i:], m.MasterBinlogGtid)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.MasterBinlogGtid)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.MasterBinlog) > 0 {
		i -= len(m.MasterBinlog)
		copy(dAtA[i:], m.MasterBinlog)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.MasterBinlog)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SubTaskStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubTaskStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Validation != nil {
		{
			size, err := m.Validation.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x5a
	}
	if m.Status != nil {
		{
			size := m.Status.Size()
			i -= size
			if _, err := m.Status.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if len(m.UnresolvedDDLLockID) > 0 {
		i -= len(m.UnresolvedDDLLockID)
		copy(dAtA[i:], m.UnresolvedDDLLockID)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.UnresolvedDDLLockID)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Result != nil {
		{
			size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if m.Unit != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Unit))
		i--
		dAtA[i] = 0x18
	}
	if m.Stage != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Stage))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SubTaskStatus_Msg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskStatus_Msg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Msg)
	copy(dAtA[i:], m.Msg)
	i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
	i--
	dAtA[i] = 0x32
	return len(dAtA) - i, nil
}
func (m *SubTaskStatus_Check) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskStatus_Check) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Check != nil {
		{
			size, err := m.Check.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *SubTaskStatus_Dump) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskStatus_Dump) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Dump != nil {
		{
			size, err := m.Dump.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *SubTaskStatus_Load) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskStatus_Load) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Load != nil {
		{
			size, err := m.Load.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x4a
	}
	return len(dAtA) - i, nil
}
func (m *SubTaskStatus_Sync) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskStatus_Sync) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Sync != nil {
		{
			size, err := m.Sync.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x52
	}
	return len(dAtA) - i, nil
}
func (m *SubTaskStatusList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubTaskStatusList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskStatusList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Status) > 0 {
		for iNdEx := len(m.Status) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Status[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CheckError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *DumpError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DumpError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *DumpError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *LoadError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LoadError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *LoadError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SyncSQLError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncSQLError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncSQLError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.ErrorSQL) > 0 {
		i -= len(m.ErrorSQL)
		copy(dAtA[i:], m.ErrorSQL)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ErrorSQL)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.FailedBinlogPosition) > 0 {
		i -= len(m.FailedBinlogPosition)
		copy(dAtA[i:], m.FailedBinlogPosition)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.FailedBinlogPosition)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SyncError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SyncError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SyncError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Errors) > 0 {
		for iNdEx := len(m.Errors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Errors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *SourceError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SourceError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SourceError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.RelayError != nil {
		{
			size, err := m.RelayError.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x22
	}
	if len(m.SourceError) > 0 {
		i -= len(m.SourceError)
		copy(dAtA[i:], m.SourceError)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.SourceError)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Worker) > 0 {
		i -= len(m.Worker)
		copy(dAtA[i:], m.Worker)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Worker)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *RelayError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RelayError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *RelayError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SubTaskError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubTaskError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		{
			size := m.Error.Size()
			i -= size
			if _, err := m.Error.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	if m.Unit != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Unit))
		i--
		dAtA[i] = 0x18
	}
	if m.Stage != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Stage))
		i--
		dAtA[i] = 0x10
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *SubTaskError_Msg) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskError_Msg) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	i -= len(m.Msg)
	copy(dAtA[i:], m.Msg)
	i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
	i--
	dAtA[i] = 0x22
	return len(dAtA) - i, nil
}
func (m *SubTaskError_Check) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskError_Check) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Check != nil {
		{
			size, err := m.Check.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	return len(dAtA) - i, nil
}
func (m *SubTaskError_Dump) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskError_Dump) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Dump != nil {
		{
			size, err := m.Dump.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x32
	}
	return len(dAtA) - i, nil
}
func (m *SubTaskError_Load) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskError_Load) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Load != nil {
		{
			size, err := m.Load.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	return len(dAtA) - i, nil
}
func (m *SubTaskError_Sync) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskError_Sync) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Sync != nil {
		{
			size, err := m.Sync.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x42
	}
	return len(dAtA) - i, nil
}
func (m *SubTaskErrorList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubTaskErrorList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *SubTaskErrorList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Error) > 0 {
		for iNdEx := len(m.Error) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Error[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProcessResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessResult) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessResult) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Detail) > 0 {
		i -= len(m.Detail)
		copy(dAtA[i:], m.Detail)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Detail)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Errors) > 0 {
		for iNdEx := len(m.Errors) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Errors[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.IsCanceled {
		i--
		if m.IsCanceled {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ProcessError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProcessError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Workaround) > 0 {
		i -= len(m.Workaround)
		copy(dAtA[i:], m.Workaround)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Workaround)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.RawCause) > 0 {
		i -= len(m.RawCause)
		copy(dAtA[i:], m.RawCause)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.RawCause)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.ErrLevel) > 0 {
		i -= len(m.ErrLevel)
		copy(dAtA[i:], m.ErrLevel)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ErrLevel)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.ErrScope) > 0 {
		i -= len(m.ErrScope)
		copy(dAtA[i:], m.ErrScope)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ErrScope)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.ErrClass) > 0 {
		i -= len(m.ErrClass)
		copy(dAtA[i:], m.ErrClass)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ErrClass)))
		i--
		dAtA[i] = 0x12
	}
	if m.ErrCode != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.ErrCode))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *PurgeRelayRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PurgeRelayRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *PurgeRelayRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SubDir) > 0 {
		i -= len(m.SubDir)
		copy(dAtA[i:], m.SubDir)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.SubDir)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Filename) > 0 {
		i -= len(m.Filename)
		copy(dAtA[i:], m.Filename)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Filename)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Time != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Time))
		i--
		dAtA[i] = 0x10
	}
	if m.Inactive {
		i--
		if m.Inactive {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OperateWorkerSchemaRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperateWorkerSchemaRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OperateWorkerSchemaRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FromTarget {
		i--
		if m.FromTarget {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x50
	}
	if m.FromSource {
		i--
		if m.FromSource {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.Sync {
		i--
		if m.Sync {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x40
	}
	if m.Flush {
		i--
		if m.Flush {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x38
	}
	if len(m.Schema) > 0 {
		i -= len(m.Schema)
		copy(dAtA[i:], m.Schema)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Schema)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.Table) > 0 {
		i -= len(m.Table)
		copy(dAtA[i:], m.Table)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Table)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.Database) > 0 {
		i -= len(m.Database)
		copy(dAtA[i:], m.Database)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Database)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Task) > 0 {
		i -= len(m.Task)
		copy(dAtA[i:], m.Task)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Task)))
		i--
		dAtA[i] = 0x12
	}
	if m.Op != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Op))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *V1SubTaskMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *V1SubTaskMeta) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *V1SubTaskMeta) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Task) > 0 {
		i -= len(m.Task)
		copy(dAtA[i:], m.Task)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Task)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Name) > 0 {
		i -= len(m.Name)
		copy(dAtA[i:], m.Name)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Name)))
		i--
		dAtA[i] = 0x1a
	}
	if m.Stage != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Stage))
		i--
		dAtA[i] = 0x10
	}
	if m.Op != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Op))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OperateV1MetaRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperateV1MetaRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OperateV1MetaRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Op != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Op))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OperateV1MetaResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperateV1MetaResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OperateV1MetaResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Meta) > 0 {
		for k := range m.Meta {
			v := m.Meta[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintDmworker(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintDmworker(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintDmworker(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0x12
	}
	if m.Result {
		i--
		if m.Result {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *HandleWorkerErrorRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleWorkerErrorRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *HandleWorkerErrorRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Sqls) > 0 {
		for iNdEx := len(m.Sqls) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Sqls[iNdEx])
			copy(dAtA[i:], m.Sqls[iNdEx])
			i = encodeVarintDmworker(dAtA, i, uint64(len(m.Sqls[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.BinlogPos) > 0 {
		i -= len(m.BinlogPos)
		copy(dAtA[i:], m.BinlogPos)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.BinlogPos)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Task) > 0 {
		i -= len(m.Task)
		copy(dAtA[i:], m.Task)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Task)))
		i--
		dAtA[i] = 0x12
	}
	if m.Op != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Op))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetWorkerCfgRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWorkerCfgRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWorkerCfgRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GetWorkerCfgResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetWorkerCfgResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetWorkerCfgResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Cfg) > 0 {
		i -= len(m.Cfg)
		copy(dAtA[i:], m.Cfg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Cfg)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckSubtasksCanUpdateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckSubtasksCanUpdateRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckSubtasksCanUpdateRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.SubtaskCfgTomlString) > 0 {
		i -= len(m.SubtaskCfgTomlString)
		copy(dAtA[i:], m.SubtaskCfgTomlString)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.SubtaskCfgTomlString)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckSubtasksCanUpdateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckSubtasksCanUpdateResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckSubtasksCanUpdateResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0x12
	}
	if m.Success {
		i--
		if m.Success {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetValidationStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetValidationStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetValidationStatusRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.FilterStatus != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.FilterStatus))
		i--
		dAtA[i] = 0x10
	}
	if len(m.TaskName) > 0 {
		i -= len(m.TaskName)
		copy(dAtA[i:], m.TaskName)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.TaskName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ValidationStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValidationStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ValidationStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.CutoverBinlogGtid) > 0 {
		i -= len(m.CutoverBinlogGtid)
		copy(dAtA[i:], m.CutoverBinlogGtid)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.CutoverBinlogGtid)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.CutoverBinlogPos) > 0 {
		i -= len(m.CutoverBinlogPos)
		copy(dAtA[i:], m.CutoverBinlogPos)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.CutoverBinlogPos)))
		i--
		dAtA[i] = 0x5a
	}
	if len(m.ErrorRowsStatus) > 0 {
		i -= len(m.ErrorRowsStatus)
		copy(dAtA[i:], m.ErrorRowsStatus)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ErrorRowsStatus)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.PendingRowsStatus) > 0 {
		i -= len(m.PendingRowsStatus)
		copy(dAtA[i:], m.PendingRowsStatus)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.PendingRowsStatus)))
		i--
		dAtA[i] = 0x4a
	}
	if len(m.ProcessedRowsStatus) > 0 {
		i -= len(m.ProcessedRowsStatus)
		copy(dAtA[i:], m.ProcessedRowsStatus)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ProcessedRowsStatus)))
		i--
		dAtA[i] = 0x42
	}
	if m.Result != nil {
		{
			size, err := m.Result.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintDmworker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x3a
	}
	if len(m.ValidatorBinlogGtid) > 0 {
		i -= len(m.ValidatorBinlogGtid)
		copy(dAtA[i:], m.ValidatorBinlogGtid)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ValidatorBinlogGtid)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.ValidatorBinlog) > 0 {
		i -= len(m.ValidatorBinlog)
		copy(dAtA[i:], m.ValidatorBinlog)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ValidatorBinlog)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Stage != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Stage))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Mode) > 0 {
		i -= len(m.Mode)
		copy(dAtA[i:], m.Mode)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Mode)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Task) > 0 {
		i -= len(m.Task)
		copy(dAtA[i:], m.Task)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Task)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ValidationTableStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValidationTableStatus) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ValidationTableStatus) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x2a
	}
	if m.Stage != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Stage))
		i--
		dAtA[i] = 0x20
	}
	if len(m.DstTable) > 0 {
		i -= len(m.DstTable)
		copy(dAtA[i:], m.DstTable)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.DstTable)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.SrcTable) > 0 {
		i -= len(m.SrcTable)
		copy(dAtA[i:], m.SrcTable)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.SrcTable)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetValidationStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetValidationStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetValidationStatusResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TableStatuses) > 0 {
		for iNdEx := len(m.TableStatuses) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.TableStatuses[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Validators) > 0 {
		for iNdEx := len(m.Validators) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Validators[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0x12
	}
	if m.Result {
		i--
		if m.Result {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GetValidationErrorRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetValidationErrorRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetValidationErrorRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.TaskName) > 0 {
		i -= len(m.TaskName)
		copy(dAtA[i:], m.TaskName)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.TaskName)))
		i--
		dAtA[i] = 0x12
	}
	if m.ErrState != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.ErrState))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *ValidationError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValidationError) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ValidationError) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x52
	}
	if len(m.Time) > 0 {
		i -= len(m.Time)
		copy(dAtA[i:], m.Time)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Time)))
		i--
		dAtA[i] = 0x4a
	}
	if m.Status != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x40
	}
	if len(m.ErrorType) > 0 {
		i -= len(m.ErrorType)
		copy(dAtA[i:], m.ErrorType)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.ErrorType)))
		i--
		dAtA[i] = 0x3a
	}
	if len(m.DstData) > 0 {
		i -= len(m.DstData)
		copy(dAtA[i:], m.DstData)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.DstData)))
		i--
		dAtA[i] = 0x32
	}
	if len(m.DstTable) > 0 {
		i -= len(m.DstTable)
		copy(dAtA[i:], m.DstTable)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.DstTable)))
		i--
		dAtA[i] = 0x2a
	}
	if len(m.SrcData) > 0 {
		i -= len(m.SrcData)
		copy(dAtA[i:], m.SrcData)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.SrcData)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.SrcTable) > 0 {
		i -= len(m.SrcTable)
		copy(dAtA[i:], m.SrcTable)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.SrcTable)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Source) > 0 {
		i -= len(m.Source)
		copy(dAtA[i:], m.Source)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Source)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Id) > 0 {
		i -= len(m.Id)
		copy(dAtA[i:], m.Id)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Id)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GetValidationErrorResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetValidationErrorResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GetValidationErrorResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Error) > 0 {
		for iNdEx := len(m.Error) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Error[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintDmworker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0x12
	}
	if m.Result {
		i--
		if m.Result {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OperateValidationErrorRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperateValidationErrorRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OperateValidationErrorRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.ErrId != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.ErrId))
		i--
		dAtA[i] = 0x20
	}
	if len(m.TaskName) > 0 {
		i -= len(m.TaskName)
		copy(dAtA[i:], m.TaskName)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.TaskName)))
		i--
		dAtA[i] = 0x1a
	}
	if m.IsAllError {
		i--
		if m.IsAllError {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if m.Op != 0 {
		i = encodeVarintDmworker(dAtA, i, uint64(m.Op))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *OperateValidationErrorResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OperateValidationErrorResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *OperateValidationErrorResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Msg) > 0 {
		i -= len(m.Msg)
		copy(dAtA[i:], m.Msg)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.Msg)))
		i--
		dAtA[i] = 0x12
	}
	if m.Result {
		i--
		if m.Result {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *UpdateValidationWorkerRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UpdateValidationWorkerRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *UpdateValidationWorkerRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.BinlogGTID) > 0 {
		i -= len(m.BinlogGTID)
		copy(dAtA[i:], m.BinlogGTID)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.BinlogGTID)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.BinlogPos) > 0 {
		i -= len(m.BinlogPos)
		copy(dAtA[i:], m.BinlogPos)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.BinlogPos)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.TaskName) > 0 {
		i -= len(m.TaskName)
		copy(dAtA[i:], m.TaskName)
		i = encodeVarintDmworker(dAtA, i, uint64(len(m.TaskName)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintDmworker(dAtA []byte, offset int, v uint64) int {
	offset -= sovDmworker(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *QueryStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *CommonWorkerResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result {
		n += 2
	}
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Worker)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *QueryStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result {
		n += 2
	}
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.SourceStatus != nil {
		l = m.SourceStatus.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	if len(m.SubTaskStatus) > 0 {
		for _, e := range m.SubTaskStatus {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	return n
}

func (m *CheckStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Passed {
		n += 2
	}
	if m.Total != 0 {
		n += 1 + sovDmworker(uint64(m.Total))
	}
	if m.Successful != 0 {
		n += 1 + sovDmworker(uint64(m.Successful))
	}
	if m.Failed != 0 {
		n += 1 + sovDmworker(uint64(m.Failed))
	}
	if m.Warning != 0 {
		n += 1 + sovDmworker(uint64(m.Warning))
	}
	l = len(m.Detail)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *DumpStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalTables != 0 {
		n += 1 + sovDmworker(uint64(m.TotalTables))
	}
	if m.CompletedTables != 0 {
		n += 9
	}
	if m.FinishedBytes != 0 {
		n += 9
	}
	if m.FinishedRows != 0 {
		n += 9
	}
	if m.EstimateTotalRows != 0 {
		n += 9
	}
	if m.Bps != 0 {
		n += 1 + sovDmworker(uint64(m.Bps))
	}
	l = len(m.Progress)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *LoadStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.FinishedBytes != 0 {
		n += 1 + sovDmworker(uint64(m.FinishedBytes))
	}
	if m.TotalBytes != 0 {
		n += 1 + sovDmworker(uint64(m.TotalBytes))
	}
	l = len(m.Progress)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.MetaBinlog)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.MetaBinlogGTID)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Bps != 0 {
		n += 1 + sovDmworker(uint64(m.Bps))
	}
	return n
}

func (m *ShardingGroup) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Target)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if len(m.DDLs) > 0 {
		for _, s := range m.DDLs {
			l = len(s)
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	l = len(m.FirstLocation)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if len(m.Synced) > 0 {
		for _, s := range m.Synced {
			l = len(s)
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	if len(m.Unsynced) > 0 {
		for _, s := range m.Unsynced {
			l = len(s)
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	return n
}

func (m *SyncStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.TotalEvents != 0 {
		n += 1 + sovDmworker(uint64(m.TotalEvents))
	}
	if m.TotalTps != 0 {
		n += 1 + sovDmworker(uint64(m.TotalTps))
	}
	if m.RecentTps != 0 {
		n += 1 + sovDmworker(uint64(m.RecentTps))
	}
	l = len(m.MasterBinlog)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.MasterBinlogGtid)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.SyncerBinlog)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.SyncerBinlogGtid)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if len(m.BlockingDDLs) > 0 {
		for _, s := range m.BlockingDDLs {
			l = len(s)
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	if len(m.UnresolvedGroups) > 0 {
		for _, e := range m.UnresolvedGroups {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	if m.Synced {
		n += 2
	}
	l = len(m.BinlogType)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.SecondsBehindMaster != 0 {
		n += 1 + sovDmworker(uint64(m.SecondsBehindMaster))
	}
	l = len(m.BlockDDLOwner)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.ConflictMsg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.TotalRows != 0 {
		n += 1 + sovDmworker(uint64(m.TotalRows))
	}
	if m.TotalRps != 0 {
		n += 2 + sovDmworker(uint64(m.TotalRps))
	}
	if m.RecentRps != 0 {
		n += 2 + sovDmworker(uint64(m.RecentRps))
	}
	if m.IoTotalBytes != 0 {
		n += 2 + sovDmworker(uint64(m.IoTotalBytes))
	}
	if m.DumpIOTotalBytes != 0 {
		n += 2 + sovDmworker(uint64(m.DumpIOTotalBytes))
	}
	return n
}

func (m *SourceStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Worker)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Result != nil {
		l = m.Result.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.RelayStatus != nil {
		l = m.RelayStatus.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *RelayStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.MasterBinlog)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.MasterBinlogGtid)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.RelaySubDir)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.RelayBinlog)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.RelayBinlogGtid)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.RelayCatchUpMaster {
		n += 2
	}
	if m.Stage != 0 {
		n += 1 + sovDmworker(uint64(m.Stage))
	}
	if m.Result != nil {
		l = m.Result.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *SubTaskStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Stage != 0 {
		n += 1 + sovDmworker(uint64(m.Stage))
	}
	if m.Unit != 0 {
		n += 1 + sovDmworker(uint64(m.Unit))
	}
	if m.Result != nil {
		l = m.Result.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.UnresolvedDDLLockID)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Status != nil {
		n += m.Status.Size()
	}
	if m.Validation != nil {
		l = m.Validation.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *SubTaskStatus_Msg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	n += 1 + l + sovDmworker(uint64(l))
	return n
}
func (m *SubTaskStatus_Check) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Check != nil {
		l = m.Check.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}
func (m *SubTaskStatus_Dump) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Dump != nil {
		l = m.Dump.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}
func (m *SubTaskStatus_Load) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Load != nil {
		l = m.Load.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}
func (m *SubTaskStatus_Sync) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Sync != nil {
		l = m.Sync.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}
func (m *SubTaskStatusList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Status) > 0 {
		for _, e := range m.Status {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	return n
}

func (m *CheckError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *DumpError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *LoadError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *SyncSQLError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.FailedBinlogPosition)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.ErrorSQL)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *SyncError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	return n
}

func (m *SourceError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Worker)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.SourceError)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.RelayError != nil {
		l = m.RelayError.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *RelayError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *SubTaskError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Stage != 0 {
		n += 1 + sovDmworker(uint64(m.Stage))
	}
	if m.Unit != 0 {
		n += 1 + sovDmworker(uint64(m.Unit))
	}
	if m.Error != nil {
		n += m.Error.Size()
	}
	return n
}

func (m *SubTaskError_Msg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Msg)
	n += 1 + l + sovDmworker(uint64(l))
	return n
}
func (m *SubTaskError_Check) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Check != nil {
		l = m.Check.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}
func (m *SubTaskError_Dump) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Dump != nil {
		l = m.Dump.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}
func (m *SubTaskError_Load) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Load != nil {
		l = m.Load.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}
func (m *SubTaskError_Sync) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Sync != nil {
		l = m.Sync.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}
func (m *SubTaskErrorList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Error) > 0 {
		for _, e := range m.Error {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	return n
}

func (m *ProcessResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.IsCanceled {
		n += 2
	}
	if len(m.Errors) > 0 {
		for _, e := range m.Errors {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	l = len(m.Detail)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *ProcessError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ErrCode != 0 {
		n += 1 + sovDmworker(uint64(m.ErrCode))
	}
	l = len(m.ErrClass)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.ErrScope)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.ErrLevel)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.RawCause)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Workaround)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *PurgeRelayRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Inactive {
		n += 2
	}
	if m.Time != 0 {
		n += 1 + sovDmworker(uint64(m.Time))
	}
	l = len(m.Filename)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.SubDir)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *OperateWorkerSchemaRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Op != 0 {
		n += 1 + sovDmworker(uint64(m.Op))
	}
	l = len(m.Task)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Database)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Table)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Schema)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Flush {
		n += 2
	}
	if m.Sync {
		n += 2
	}
	if m.FromSource {
		n += 2
	}
	if m.FromTarget {
		n += 2
	}
	return n
}

func (m *V1SubTaskMeta) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Op != 0 {
		n += 1 + sovDmworker(uint64(m.Op))
	}
	if m.Stage != 0 {
		n += 1 + sovDmworker(uint64(m.Stage))
	}
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Task)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *OperateV1MetaRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Op != 0 {
		n += 1 + sovDmworker(uint64(m.Op))
	}
	return n
}

func (m *OperateV1MetaResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result {
		n += 2
	}
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if len(m.Meta) > 0 {
		for k, v := range m.Meta {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovDmworker(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovDmworker(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovDmworker(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *HandleWorkerErrorRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Op != 0 {
		n += 1 + sovDmworker(uint64(m.Op))
	}
	l = len(m.Task)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.BinlogPos)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if len(m.Sqls) > 0 {
		for _, s := range m.Sqls {
			l = len(s)
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	return n
}

func (m *GetWorkerCfgRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GetWorkerCfgResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Cfg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *CheckSubtasksCanUpdateRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.SubtaskCfgTomlString)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *CheckSubtasksCanUpdateResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Success {
		n += 2
	}
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *GetValidationStatusRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TaskName)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.FilterStatus != 0 {
		n += 1 + sovDmworker(uint64(m.FilterStatus))
	}
	return n
}

func (m *ValidationStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Task)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Mode)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Stage != 0 {
		n += 1 + sovDmworker(uint64(m.Stage))
	}
	l = len(m.ValidatorBinlog)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.ValidatorBinlogGtid)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Result != nil {
		l = m.Result.Size()
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.ProcessedRowsStatus)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.PendingRowsStatus)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.ErrorRowsStatus)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.CutoverBinlogPos)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.CutoverBinlogGtid)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *ValidationTableStatus) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.SrcTable)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.DstTable)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Stage != 0 {
		n += 1 + sovDmworker(uint64(m.Stage))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *GetValidationStatusResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result {
		n += 2
	}
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if len(m.Validators) > 0 {
		for _, e := range m.Validators {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	if len(m.TableStatuses) > 0 {
		for _, e := range m.TableStatuses {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	return n
}

func (m *GetValidationErrorRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.ErrState != 0 {
		n += 1 + sovDmworker(uint64(m.ErrState))
	}
	l = len(m.TaskName)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *ValidationError) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Id)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.SrcTable)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.SrcData)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.DstTable)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.DstData)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.ErrorType)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.Status != 0 {
		n += 1 + sovDmworker(uint64(m.Status))
	}
	l = len(m.Time)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *GetValidationErrorResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result {
		n += 2
	}
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if len(m.Error) > 0 {
		for _, e := range m.Error {
			l = e.Size()
			n += 1 + l + sovDmworker(uint64(l))
		}
	}
	return n
}

func (m *OperateValidationErrorRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Op != 0 {
		n += 1 + sovDmworker(uint64(m.Op))
	}
	if m.IsAllError {
		n += 2
	}
	l = len(m.TaskName)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	if m.ErrId != 0 {
		n += 1 + sovDmworker(uint64(m.ErrId))
	}
	return n
}

func (m *OperateValidationErrorResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result {
		n += 2
	}
	l = len(m.Msg)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func (m *UpdateValidationWorkerRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TaskName)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.BinlogPos)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	l = len(m.BinlogGTID)
	if l > 0 {
		n += 1 + l + sovDmworker(uint64(l))
	}
	return n
}

func sovDmworker(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozDmworker(x uint64) (n int) {
	return sovDmworker(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *QueryStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CommonWorkerResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CommonWorkerResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CommonWorkerResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Result = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Worker", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Worker = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Result = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceStatus == nil {
				m.SourceStatus = &SourceStatus{}
			}
			if err := m.SourceStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubTaskStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubTaskStatus = append(m.SubTaskStatus, &SubTaskStatus{})
			if err := m.SubTaskStatus[len(m.SubTaskStatus)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Passed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Passed = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Total", wireType)
			}
			m.Total = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Total |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Successful", wireType)
			}
			m.Successful = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Successful |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Failed", wireType)
			}
			m.Failed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Failed |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Warning", wireType)
			}
			m.Warning = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Warning |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Detail = append(m.Detail[:0], dAtA[iNdEx:postIndex]...)
			if m.Detail == nil {
				m.Detail = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DumpStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DumpStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DumpStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalTables", wireType)
			}
			m.TotalTables = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalTables |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field CompletedTables", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.CompletedTables = float64(math.Float64frombits(v))
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinishedBytes", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.FinishedBytes = float64(math.Float64frombits(v))
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinishedRows", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.FinishedRows = float64(math.Float64frombits(v))
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field EstimateTotalRows", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.EstimateTotalRows = float64(math.Float64frombits(v))
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bps", wireType)
			}
			m.Bps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Bps |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Progress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Progress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoadStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoadStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FinishedBytes", wireType)
			}
			m.FinishedBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FinishedBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalBytes", wireType)
			}
			m.TotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Progress", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Progress = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetaBinlog", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetaBinlog = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetaBinlogGTID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MetaBinlogGTID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bps", wireType)
			}
			m.Bps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Bps |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ShardingGroup) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ShardingGroup: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ShardingGroup: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Target = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DDLs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DDLs = append(m.DDLs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstLocation", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FirstLocation = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Synced", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Synced = append(m.Synced, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unsynced", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Unsynced = append(m.Unsynced, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalEvents", wireType)
			}
			m.TotalEvents = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalEvents |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalTps", wireType)
			}
			m.TotalTps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalTps |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecentTps", wireType)
			}
			m.RecentTps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RecentTps |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MasterBinlog", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MasterBinlog = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MasterBinlogGtid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MasterBinlogGtid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncerBinlog", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SyncerBinlog = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SyncerBinlogGtid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SyncerBinlogGtid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockingDDLs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BlockingDDLs = append(m.BlockingDDLs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnresolvedGroups", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UnresolvedGroups = append(m.UnresolvedGroups, &ShardingGroup{})
			if err := m.UnresolvedGroups[len(m.UnresolvedGroups)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Synced", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Synced = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinlogType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BinlogType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SecondsBehindMaster", wireType)
			}
			m.SecondsBehindMaster = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SecondsBehindMaster |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BlockDDLOwner", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BlockDDLOwner = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConflictMsg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConflictMsg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalRows", wireType)
			}
			m.TotalRows = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalRows |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalRps", wireType)
			}
			m.TotalRps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalRps |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RecentRps", wireType)
			}
			m.RecentRps = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RecentRps |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IoTotalBytes", wireType)
			}
			m.IoTotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IoTotalBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DumpIOTotalBytes", wireType)
			}
			m.DumpIOTotalBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DumpIOTotalBytes |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SourceStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SourceStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SourceStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Worker", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Worker = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &ProcessResult{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelayStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RelayStatus == nil {
				m.RelayStatus = &RelayStatus{}
			}
			if err := m.RelayStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RelayStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RelayStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RelayStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MasterBinlog", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MasterBinlog = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MasterBinlogGtid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MasterBinlogGtid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelaySubDir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RelaySubDir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelayBinlog", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RelayBinlog = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelayBinlogGtid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RelayBinlogGtid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelayCatchUpMaster", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RelayCatchUpMaster = bool(v != 0)
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			m.Stage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Stage |= Stage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &ProcessResult{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubTaskStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubTaskStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubTaskStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			m.Stage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Stage |= Stage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			m.Unit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Unit |= UnitType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &ProcessResult{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnresolvedDDLLockID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UnresolvedDDLLockID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = &SubTaskStatus_Msg{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Check", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckStatus{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Status = &SubTaskStatus_Check{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dump", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DumpStatus{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Status = &SubTaskStatus_Dump{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Load", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LoadStatus{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Status = &SubTaskStatus_Load{v}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sync", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SyncStatus{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Status = &SubTaskStatus_Sync{v}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validation", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Validation == nil {
				m.Validation = &ValidationStatus{}
			}
			if err := m.Validation.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubTaskStatusList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubTaskStatusList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubTaskStatusList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Status = append(m.Status, &SubTaskStatus{})
			if err := m.Status[len(m.Status)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DumpError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DumpError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DumpError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LoadError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LoadError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LoadError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncSQLError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncSQLError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncSQLError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FailedBinlogPosition", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.FailedBinlogPosition = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorSQL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorSQL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SyncError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SyncError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SyncError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, &SyncSQLError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SourceError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SourceError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SourceError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Worker", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Worker = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceError", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceError = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RelayError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RelayError == nil {
				m.RelayError = &RelayError{}
			}
			if err := m.RelayError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RelayError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RelayError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RelayError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubTaskError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubTaskError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubTaskError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			m.Stage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Stage |= Stage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unit", wireType)
			}
			m.Unit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Unit |= UnitType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = &SubTaskError_Msg{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Check", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CheckError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Error = &SubTaskError_Check{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dump", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DumpError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Error = &SubTaskError_Dump{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Load", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &LoadError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Error = &SubTaskError_Load{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sync", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SyncError{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Error = &SubTaskError_Sync{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubTaskErrorList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubTaskErrorList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubTaskErrorList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = append(m.Error, &SubTaskError{})
			if err := m.Error[len(m.Error)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsCanceled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsCanceled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Errors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Errors = append(m.Errors, &ProcessError{})
			if err := m.Errors[len(m.Errors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Detail = append(m.Detail[:0], dAtA[iNdEx:postIndex]...)
			if m.Detail == nil {
				m.Detail = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrCode", wireType)
			}
			m.ErrCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ErrCode |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrClass", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrClass = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrScope", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrScope = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrLevel", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrLevel = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawCause", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawCause = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Workaround", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Workaround = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PurgeRelayRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PurgeRelayRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PurgeRelayRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inactive", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inactive = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			m.Time = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Time |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filename", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filename = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubDir", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubDir = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OperateWorkerSchemaRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OperateWorkerSchemaRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OperateWorkerSchemaRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			m.Op = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Op |= SchemaOp(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Task = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Table = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Schema", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Schema = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flush", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Flush = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sync", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Sync = bool(v != 0)
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromSource", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FromSource = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FromTarget", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FromTarget = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *V1SubTaskMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: V1SubTaskMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: V1SubTaskMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			m.Op = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Op |= TaskOp(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			m.Stage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Stage |= Stage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Task = append(m.Task[:0], dAtA[iNdEx:postIndex]...)
			if m.Task == nil {
				m.Task = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OperateV1MetaRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OperateV1MetaRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OperateV1MetaRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			m.Op = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Op |= V1MetaOp(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OperateV1MetaResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OperateV1MetaResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OperateV1MetaResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Result = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Meta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Meta == nil {
				m.Meta = make(map[string]*V1SubTaskMeta)
			}
			var mapkey string
			var mapvalue *V1SubTaskMeta
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowDmworker
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDmworker
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthDmworker
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthDmworker
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowDmworker
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthDmworker
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthDmworker
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &V1SubTaskMeta{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipDmworker(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthDmworker
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Meta[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HandleWorkerErrorRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleWorkerErrorRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleWorkerErrorRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			m.Op = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Op |= ErrorOp(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Task = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinlogPos", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BinlogPos = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sqls", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sqls = append(m.Sqls, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWorkerCfgRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWorkerCfgRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWorkerCfgRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetWorkerCfgResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetWorkerCfgResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetWorkerCfgResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cfg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cfg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckSubtasksCanUpdateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckSubtasksCanUpdateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckSubtasksCanUpdateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubtaskCfgTomlString", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubtaskCfgTomlString = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckSubtasksCanUpdateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckSubtasksCanUpdateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckSubtasksCanUpdateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Success", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Success = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetValidationStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetValidationStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetValidationStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterStatus", wireType)
			}
			m.FilterStatus = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FilterStatus |= Stage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValidationStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValidationStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValidationStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Task = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			m.Stage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Stage |= Stage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidatorBinlog", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValidatorBinlog = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidatorBinlogGtid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ValidatorBinlogGtid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Result == nil {
				m.Result = &ProcessResult{}
			}
			if err := m.Result.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProcessedRowsStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProcessedRowsStatus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PendingRowsStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PendingRowsStatus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorRowsStatus", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorRowsStatus = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CutoverBinlogPos", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CutoverBinlogPos = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CutoverBinlogGtid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CutoverBinlogGtid = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValidationTableStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValidationTableStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValidationTableStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SrcTable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SrcTable = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DstTable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DstTable = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stage", wireType)
			}
			m.Stage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Stage |= Stage(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetValidationStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetValidationStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetValidationStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Result = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validators", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Validators = append(m.Validators, &ValidationStatus{})
			if err := m.Validators[len(m.Validators)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableStatuses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TableStatuses = append(m.TableStatuses, &ValidationTableStatus{})
			if err := m.TableStatuses[len(m.TableStatuses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetValidationErrorRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetValidationErrorRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetValidationErrorRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrState", wireType)
			}
			m.ErrState = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ErrState |= ValidateErrorState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValidationError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValidationError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValidationError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Id", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Id = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SrcTable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SrcTable = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SrcData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SrcData = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DstTable", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DstTable = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DstData", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DstData = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= ValidateErrorState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Time", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Time = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetValidationErrorResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetValidationErrorResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetValidationErrorResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Result = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Error = append(m.Error, &ValidationError{})
			if err := m.Error[len(m.Error)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OperateValidationErrorRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OperateValidationErrorRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OperateValidationErrorRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Op", wireType)
			}
			m.Op = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Op |= ValidationErrOp(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsAllError", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsAllError = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrId", wireType)
			}
			m.ErrId = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ErrId |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OperateValidationErrorResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OperateValidationErrorResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OperateValidationErrorResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Result", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Result = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateValidationWorkerRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateValidationWorkerRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateValidationWorkerRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinlogPos", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BinlogPos = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BinlogGTID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDmworker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthDmworker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BinlogGTID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDmworker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthDmworker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDmworker(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDmworker
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDmworker
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthDmworker
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupDmworker
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthDmworker
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthDmworker        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDmworker          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupDmworker = fmt.Errorf("proto: unexpected end of group")
)
