## TFSA-2021-045: Division by 0 in `Reverse`

### CVE Number
CVE-2021-29556

### Impact
An attacker can cause a denial of service via a FPE runtime error in
`tf.raw_ops.Reverse`:

```python
import tensorflow as tf

tensor_input = tf.constant([], shape=[0, 1, 1], dtype=tf.int32)
dims = tf.constant([False, True, False], shape=[3], dtype=tf.bool)

tf.raw_ops.Reverse(tensor=tensor_input, dims=dims)
```

This is because the
[implementation](https://github.com/tensorflow/tensorflow/blob/36229ea9e9451dac14a8b1f4711c435a1d84a594/tensorflow/core/kernels/reverse_op.cc#L75-L76)
performs a division based on the first dimension of the tensor argument:

```cc
const int64 N = input.dim_size(0);
const int64 cost_per_unit = input.NumElements() / N;
```

Since this is controlled by the user, an attacker can trigger a denial of
service.

### Patches
We have patched the issue in GitHub commit
[4071d8e2f6c45c1955a811fee757ca2adbe462c1](https://github.com/tensorflow/tensorflow/commit/4071d8e2f6c45c1955a811fee757ca2adbe462c1).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by Ying Wang and Yakun Zhang of Baidu
X-Team.
