% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMB.R
\name{TMB.Version}
\alias{TMB.Version}
\title{Version information on API and ABI.}
\usage{
TMB.Version()
}
\value{
List with components \code{package} (API version) and \code{abi} (ABI version) inspired by corresponding function in the \code{Matrix} package.
}
\description{
The R interface to \code{TMB} roughly consists of two components: (1) The 'API' i.e. R functions documented in this manual and (2) C-level entry points, here referred to as the 'ABI', which controls the C++ code. The latter can be shown by \code{getDLLRegisteredRoutines(DLL)} where \code{DLL} is the shared library generated by the \link{compile} function (or by a package linking to \code{TMB}).
A DLL compiled with one version of \code{TMB} can be used with another version of \code{TMB} provided that the 'ABI' is the same. We therefore define the 'ABI version' as the oldest ABI compatible version. This number can then be used to tell if re-compilation of a DLL is necessary after updating \code{TMB}.
}
