% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/insight-package.R
\docType{package}
\name{insight-package}
\alias{insight-package}
\alias{insight}
\title{insight: A Unified Interface to Access Information from Model Objects in R.}
\description{
When fitting any statistical model, there are many useful pieces of information
that are simultaneously calculated and stored beyond coefficient estimates
and general model fit statistics. Although there exist some generic functions
to obtain model information and data, many package-specific modelling functions
do not provide such methods to allow users to access such valuable information.

\strong{insight} is an R-package that fills this important gap by providing a
suite of functions to support almost any model (see a list of the many models
supported below in the \strong{List of Supported Packages and Models} section).
The goal of \strong{insight}, then, is to provide tools to provide \emph{easy},
\emph{intuitive}, and \emph{consistent} access to information contained in model
objects. These tools aid applied research in virtually any field who fit,
diagnose, and present statistical models by streamlining access to every
aspect of many model objects via consistent syntax and output.

References: Lüdecke et al. (2019) \doi{10.21105/joss.01412}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://easystats.github.io/insight/}
  \item Report bugs at \url{https://github.com/easystats/insight/issues}
}

}
\author{
\strong{Maintainer}: Daniel Lüdecke \email{officialeasystats@gmail.com} (\href{https://orcid.org/0000-0002-8895-3206}{ORCID})

Authors:
\itemize{
  \item Dominique Makowski \email{dom.makowski@gmail.com} (\href{https://orcid.org/0000-0001-5375-9967}{ORCID}) [contributor]
  \item Indrajeet Patil \email{patilindrajeet.science@gmail.com} (\href{https://orcid.org/0000-0003-1995-6531}{ORCID}) [contributor]
  \item Philip Waggoner \email{philip.waggoner@gmail.com} (\href{https://orcid.org/0000-0002-7825-7573}{ORCID}) [contributor]
  \item Mattan S. Ben-Shachar \email{matanshm@post.bgu.ac.il} (\href{https://orcid.org/0000-0002-4287-4801}{ORCID}) [contributor]
  \item Brenton M. Wiernik \email{brenton@wiernik.org} (\href{https://orcid.org/0000-0001-9560-6336}{ORCID}) [contributor]
  \item Vincent Arel-Bundock \email{vincent.arel-bundock@umontreal.ca} (\href{https://orcid.org/0000-0003-2042-7063}{ORCID}) [contributor]
  \item Etienne Bacher \email{etienne.bacher@protonmail.com} (\href{https://orcid.org/0000-0002-9271-5075}{ORCID}) [contributor]
}

Other contributors:
\itemize{
  \item Alex Hayes \email{alexpghayes@gmail.com} (\href{https://orcid.org/0000-0002-4985-5160}{ORCID}) [reviewer]
  \item Grant McDermott \email{grantmcd@uoregon.edu} (\href{https://orcid.org/0000-0001-7883-8573}{ORCID}) [contributor]
  \item Rémi Thériault \email{remi.theriault@mail.mcgill.ca} (\href{https://orcid.org/0000-0003-4315-6788}{ORCID}) [contributor]
  \item Alex Reinhart \email{areinhar@stat.cmu.edu} (\href{https://orcid.org/0000-0002-6658-514X}{ORCID}) [contributor]
}

}
\keyword{internal}
