% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable_sizes.R
\name{height}
\alias{height}
\alias{height_all}
\title{Set flextable rows height}
\usage{
height(x, i = NULL, height, part = "body", unit = "in")

height_all(x, height, part = "all", unit = "in")
}
\arguments{
\item{x}{a 'flextable' object, see \link{flextable-package} to learn how to create
'flextable' object.}

\item{i}{row selector, see section \emph{Row selection with the \code{i} parameter}
in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.}

\item{height}{height in inches}

\item{part}{part selector, see section \emph{Part selection with the \code{part}
parameter} in <\code{\link[=flextable_selectors]{Selectors in flextable}}>.
Value 'all' is not allowed by the function.}

\item{unit}{unit for height, one of "in", "cm", "mm".}
}
\description{
control rows height for a part of the flextable when the line
height adjustment is "atleast" or "exact" (see \code{\link[=hrule]{hrule()}}).
}
\note{
This function has no effect when the rule for line height is set to
"auto" (see \code{\link[=hrule]{hrule()}}), which is the default case, except with PowerPoint
which does not support this automatic line height adjustment feature.
}
\section{height_all}{

\code{height_all} is a convenient function for
setting the same height to all rows (selected
with argument \code{part}).
}

\examples{
ft_1 <- flextable(head(iris))
ft_1 <- height(ft_1, height = .5)
ft_1 <- hrule(ft_1, rule = "exact")
ft_1


ft_2 <- flextable(head(iris))
ft_2 <- height_all(ft_2, height = 1)
ft_2 <- hrule(ft_2, rule = "exact")
ft_2
}
\seealso{
Other functions for flextable size management: 
\code{\link{autofit}()},
\code{\link{dim.flextable}()},
\code{\link{dim_pretty}()},
\code{\link{fit_to_width}()},
\code{\link{flextable_dim}()},
\code{\link{hrule}()},
\code{\link{ncol_keys}()},
\code{\link{nrow_part}()},
\code{\link{width}()}
}
\concept{functions for flextable size management}
