% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compact_summary.R
\name{compact_summary}
\alias{compact_summary}
\title{Compact Summary of a Dataset}
\usage{
compact_summary(x, show_type = FALSE, show_na = FALSE, max_levels = 10L)
}
\arguments{
\item{x}{A data.frame.}

\item{show_type}{If \code{TRUE}, a \emph{Type} column is added when the
object is rendered as a flextable.}

\item{show_na}{If \code{TRUE}, a \emph{NA} column showing the count of
missing values per column is added when rendered as a
flextable.}

\item{max_levels}{Maximum number of levels or unique values
displayed for factor and character columns. Additional
values are replaced by \code{", ..."}.}
}
\value{
A data.frame with additional class \code{"compact_summary"}.
}
\description{
Produces a compact summary of a data.frame. Each row of the
result describes one column of the input with a type-specific
synopsis.

Supported types and their summaries:
\itemize{
\item \strong{numeric / integer}: count of non-\code{NA} values, min and max.
\item \strong{character}: number of unique values, first values listed.
\item \strong{factor}: number of levels, levels listed.
\item \strong{logical}: count of non-\code{NA} values, counts of \code{TRUE} and
\code{FALSE}.
\item \strong{Date}: count of non-\code{NA} values, date range.
\item \strong{POSIXct / POSIXlt}: count of non-\code{NA} values, datetime
range.
\item \strong{hms / difftime}: count of non-\code{NA} values, time range.
}

Character and factor columns share the same summary layout
but report a different type label.

The result has class \code{"compact_summary"} and can be converted
into a flextable with \code{\link[=as_flextable]{as_flextable()}}.
}
\examples{
z <- compact_summary(iris)
as_flextable(z)

z <- compact_summary(iris, show_type = TRUE, show_na = TRUE)
as_flextable(z)
}
\seealso{
\code{\link[=as_flextable.compact_summary]{as_flextable.compact_summary()}}

Other as_flextable methods: 
\code{\link{as_flextable}()},
\code{\link{as_flextable.compact_summary}()},
\code{\link{as_flextable.data.frame}()},
\code{\link{as_flextable.gam}()},
\code{\link{as_flextable.glm}()},
\code{\link{as_flextable.grouped_data}()},
\code{\link{as_flextable.htest}()},
\code{\link{as_flextable.kmeans}()},
\code{\link{as_flextable.lm}()},
\code{\link{as_flextable.merMod}()},
\code{\link{as_flextable.pam}()},
\code{\link{as_flextable.summarizor}()},
\code{\link{as_flextable.table}()},
\code{\link{as_flextable.tabular}()},
\code{\link{as_flextable.tabulator}()},
\code{\link{as_flextable.xtable}()}
}
\concept{as_flextable methods}
