% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_content.R
\name{as_qmd}
\alias{as_qmd}
\title{Quarto inline markdown chunk}
\usage{
as_qmd(x, display = x)
}
\arguments{
\item{x}{character vector of Quarto markdown content.}

\item{display}{character vector of display text used
as fallback when the Lua filter is not active.
Defaults to \code{x}.}
}
\description{
\code{as_qmd()} creates a chunk for inline Quarto markdown
content (text-level) that fits within a table
cell paragraph. This enables cross-references
(\verb{@fig-xxx}, \verb{@tbl-xxx}), links, bold/italic, math,
inline code, shortcodes and other inline Quarto markdown
features inside flextable cells.

It is not designed for block-level elements such as
headings, bullet lists or fenced code blocks.

The chunk is used with \code{\link[=compose]{compose()}}, \code{\link[=append_chunks]{append_chunks()}}
or \code{\link[=prepend_chunks]{prepend_chunks()}}. It requires the \code{flextable-qmd} Lua
filter extension (see \code{\link[=use_flextable_qmd]{use_flextable_qmd()}}) and works with
HTML, PDF and Word (docx) Quarto output formats.
}
\section{Setup}{

\enumerate{
\item Install the extension once per project:
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{flextable::use_flextable_qmd()
}\if{html}{\out{</div>}}
\enumerate{
\item Add the filter to your Quarto document YAML.
For HTML and PDF, a single line is enough:
}

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{filters:
  - flextable-qmd
}\if{html}{\out{</div>}}

For Word (docx), an additional post-render filter
removes the wrapper table that Quarto adds around
labelled flextables:

\if{html}{\out{<div class="sourceCode yaml">}}\preformatted{filters:
  - flextable-qmd
  - at: post-render
    path: _extensions/flextable-qmd/unwrap-float.lua
}\if{html}{\out{</div>}}
}

\section{Supported markdown}{

\itemize{
\item Cross-references: \verb{@fig-xxx}, \verb{@tbl-xxx}
\item Bold / italic: \verb{**bold**}, \verb{*italic*}
\item Inline code: \code{`code`}
\item Links: \verb{[text](url)} (internal and external)
\item Math: \verb{$\\\\alpha + \\\\beta$}
\item Shortcodes and other Quarto markdown constructs
}
}

\section{Limitations}{


Each table cell in a flextable contains a single paragraph
built from inline chunks (see \code{\link[=as_paragraph]{as_paragraph()}}). There is no
mechanism to insert block-level structures (multiple
paragraphs, lists, headings, fenced code blocks, callouts,
etc.) inside a cell. Because \code{as_qmd()} produces one of
these inline chunks, only inline markdown is supported.
}

\examples{
library(flextable)

dat <- data.frame(
  label = c("Bold", "Link", "Code"),
  content = c(
    "This is **bold** text",
    "Visit [Quarto](https://quarto.org)",
    "Use `print()` here"
  )
)
ft <- flextable(dat)
ft <- mk_par(ft, j = "content",
  value = as_paragraph(as_qmd(content)))
ft
}
\seealso{
\code{\link[=use_flextable_qmd]{use_flextable_qmd()}} to install the Lua filter extension,
\code{\link[=knit_print.flextable]{knit_print.flextable()}} for rendering options in knitr documents.

Other chunk elements for paragraph: 
\code{\link{as_b}()},
\code{\link{as_bracket}()},
\code{\link{as_chunk}()},
\code{\link{as_equation}()},
\code{\link{as_highlight}()},
\code{\link{as_i}()},
\code{\link{as_image}()},
\code{\link{as_strike}()},
\code{\link{as_sub}()},
\code{\link{as_sup}()},
\code{\link{as_word_field}()},
\code{\link{colorize}()},
\code{\link{gg_chunk}()},
\code{\link{grid_chunk}()},
\code{\link{hyperlink_text}()},
\code{\link{linerange}()},
\code{\link{minibar}()},
\code{\link{plot_chunk}()}
}
\concept{chunk elements for paragraph}
