% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multcomp.R
\name{tidy.confint.glht}
\alias{tidy.confint.glht}
\title{Tidy a(n) confint.glht object}
\usage{
\method{tidy}{confint.glht}(x, ...)
}
\arguments{
\item{x}{A \code{confint.glht} object created by calling
\code{\link[multcomp:methods]{multcomp::confint.glht()}} on a \code{glht} object created with
\code{\link[multcomp:glht]{multcomp::glht()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Two exceptions here are:
\itemize{
\item \code{tidy()} methods will warn when supplied an \code{exponentiate} argument if
it will be ignored.
\item \code{augment()} methods will warn when supplied a \code{newdata} argument if it
will be ignored.
}}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{
\dontshow{if (rlang::is_installed(c("multcomp", "ggplot2"))) withAutoprint(\{ # examplesIf}

# load libraries for models and data
library(multcomp)
library(ggplot2)

amod <- aov(breaks ~ wool + tension, data = warpbreaks)
wht <- glht(amod, linfct = mcp(tension = "Tukey"))

tidy(wht)

ggplot(wht, aes(lhs, estimate)) +
  geom_point()

CI <- confint(wht)

tidy(CI)

ggplot(CI, aes(lhs, estimate, ymin = lwr, ymax = upr)) +
  geom_pointrange()

tidy(summary(wht))
ggplot(mapping = aes(lhs, estimate)) +
  geom_linerange(aes(ymin = lwr, ymax = upr), data = CI) +
  geom_point(aes(size = p), data = summary(wht)) +
  scale_size(trans = "reverse")

cld <- cld(wht)
tidy(cld)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[multcomp:methods]{multcomp::confint.glht()}}, \code{\link[multcomp:glht]{multcomp::glht()}}

Other multcomp tidiers: 
\code{\link{tidy.cld}()},
\code{\link{tidy.glht}()},
\code{\link{tidy.summary.glht}()}
}
\concept{multcomp tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{contrast}{Levels being compared.}
  \item{estimate}{The estimated value of the regression term.}

}
