# generated by datamodel-codegen:
#   filename:  allof_with_required_inherited_comprehensive.yaml
#   timestamp: 2019-07-26T00:00:00+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from pydantic import BaseModel, constr


class Status(Enum):
    active = 'active'
    inactive = 'inactive'


class BaseType(BaseModel):
    id: Optional[int] = None


class ObjectWithProps(BaseModel):
    nested: Optional[str] = None


class AllofPrimitivesWithConstraints(BaseModel):
    pass


class AllofWithPattern(BaseModel):
    pass


class AllofWithUnique(BaseModel):
    pass


class Level2(BaseModel):
    level3: Optional[str] = None


class Level1(BaseModel):
    level2: Optional[Level2] = None


class DeepNested(BaseModel):
    level1: Optional[Level1] = None


class ProjectedEntity(BaseModel):
    primitive_string: Optional[str] = None
    primitive_int: Optional[int] = None
    primitive_number: Optional[float] = None
    primitive_bool: Optional[bool] = None
    ref_field: Optional[BaseType] = None
    enum_field: Optional[Status] = None
    array_with_ref: Optional[List[BaseType]] = None
    array_with_primitive: Optional[List[str]] = None
    object_with_props: Optional[ObjectWithProps] = None
    object_with_additional: Optional[Dict[str, int]] = None
    anyof_field: Optional[Union[str, int]] = None
    oneof_field: Optional[Union[bool, float]] = None
    allof_single_ref: Optional[BaseType] = None
    allof_multiple_refs: Optional[BaseType] = None
    allof_primitives_with_constraints: Optional[AllofPrimitivesWithConstraints] = None
    allof_with_pattern: Optional[AllofWithPattern] = None
    allof_with_unique: Optional[AllofWithUnique] = None
    type_list: Optional[str] = None
    deep_nested: Optional[DeepNested] = None


class Entity(ProjectedEntity):
    extra: Optional[str] = None
    primitive_string: str
    primitive_int: int
    primitive_number: float
    primitive_bool: bool
    ref_field: BaseType
    enum_field: Status
    array_with_ref: List[BaseType]
    array_with_primitive: List[str]
    object_with_props: Dict[str, Any]
    object_with_additional: Dict[str, int]
    anyof_field: Union[str, int]
    oneof_field: Union[bool, float]
    allof_single_ref: BaseType
    allof_multiple_refs: BaseType
    allof_primitives_with_constraints: constr(min_length=5, max_length=100)
    allof_with_pattern: constr(regex=r'(?=^[a-z]+)(?=[0-9]$)')
    allof_with_unique: List[str]
    type_list: Optional[str]
    deep_nested: Dict[str, Any]
