# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .arm_base_model_py3 import ARMBaseModel


class BandwidthSchedule(ARMBaseModel):
    """The bandwidth schedule details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param start: Required. The start time of the schedule in UTC.
    :type start: str
    :param stop: Required. The stop time of the schedule in UTC.
    :type stop: str
    :param rate_in_mbps: Required. The bandwidth rate in Mbps.
    :type rate_in_mbps: int
    :param days: Required. The days of the week when this schedule is
     applicable.
    :type days: list[str or ~azure.mgmt.edgegateway.models.DayOfWeek]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'start': {'required': True},
        'stop': {'required': True},
        'rate_in_mbps': {'required': True},
        'days': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'start': {'key': 'properties.start', 'type': 'str'},
        'stop': {'key': 'properties.stop', 'type': 'str'},
        'rate_in_mbps': {'key': 'properties.rateInMbps', 'type': 'int'},
        'days': {'key': 'properties.days', 'type': '[str]'},
    }

    def __init__(self, *, start: str, stop: str, rate_in_mbps: int, days, **kwargs) -> None:
        super(BandwidthSchedule, self).__init__(**kwargs)
        self.start = start
        self.stop = stop
        self.rate_in_mbps = rate_in_mbps
        self.days = days
