# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.datamigration import DataMigrationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataMigrationManagementDatabaseMigrationsSqlDbOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataMigrationManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_sql_db_get(self, resource_group):
        response = self.client.database_migrations_sql_db.get(
            resource_group_name=resource_group.name,
            sql_db_instance_name="str",
            target_db_name="str",
            api_version="2025-03-15-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_sql_db_begin_create_or_update(self, resource_group):
        response = self.client.database_migrations_sql_db.begin_create_or_update(
            resource_group_name=resource_group.name,
            sql_db_instance_name="str",
            target_db_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "properties": {
                    "kind": "SqlDb",
                    "endedOn": "2020-02-20 00:00:00",
                    "migrationFailureError": {"code": "str", "message": "str"},
                    "migrationOperationId": "str",
                    "migrationService": "str",
                    "migrationStatus": "str",
                    "migrationStatusDetails": {
                        "listOfCopyProgressDetails": [
                            {
                                "copyDuration": 0,
                                "copyStart": "2020-02-20 00:00:00",
                                "copyThroughput": 0.0,
                                "dataRead": 0,
                                "dataWritten": 0,
                                "parallelCopyType": "str",
                                "rowsCopied": 0,
                                "rowsRead": 0,
                                "status": "str",
                                "tableName": "str",
                                "usedParallelCopies": 0,
                            }
                        ],
                        "migrationState": "str",
                        "sqlDataCopyErrors": ["str"],
                    },
                    "offlineConfiguration": {"offline": bool},
                    "provisioningError": "str",
                    "provisioningState": "str",
                    "scope": "str",
                    "sourceDatabaseName": "str",
                    "sourceServerName": "str",
                    "sourceSqlConnection": {
                        "authentication": "str",
                        "dataSource": "str",
                        "encryptConnection": bool,
                        "password": "str",
                        "trustServerCertificate": bool,
                        "userName": "str",
                    },
                    "startedOn": "2020-02-20 00:00:00",
                    "tableList": ["str"],
                    "targetDatabaseCollation": "str",
                    "targetSqlConnection": {
                        "authentication": "str",
                        "dataSource": "str",
                        "encryptConnection": bool,
                        "password": "str",
                        "trustServerCertificate": bool,
                        "userName": "str",
                    },
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_sql_db_begin_delete(self, resource_group):
        response = self.client.database_migrations_sql_db.begin_delete(
            resource_group_name=resource_group.name,
            sql_db_instance_name="str",
            target_db_name="str",
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_migrations_sql_db_begin_cancel(self, resource_group):
        response = self.client.database_migrations_sql_db.begin_cancel(
            resource_group_name=resource_group.name,
            sql_db_instance_name="str",
            target_db_name="str",
            parameters={"migrationOperationId": "str"},
            api_version="2025-03-15-preview",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
