with text_io;                           use text_io;
with Witness_Interface;
with Monodromy_Interface;

function use_c2fac ( job : integer32;
                     a : C_intarrs.Pointer;
                     b : C_intarrs.Pointer;
                     c : C_dblarrs.Pointer;
                     vrblvl : integer32 := 0 ) return integer32 is

  procedure Write_Menu is
  begin
    new_line;
    put_line("General MENU to use factorization in PHCpack from C :");
    put_line("  0. display this menu;");
    put_line("  1. read an embedding of a polynomial system;");
    put_line("  2. initialize the sampling machine;");
    put_line("  3. assign coefficient of a slice;");
    put_line("  4. store a random gamma constant in PHCpack;");
    put_line("  5. compute a new witness set on the new slices;");
    put_line("  6. swaps slices and solution sets to turn back;");
    put_line("  7. copy embedded system from sampler to systems container;");
    put_line("  8. copy original solutions from sampler to container;");
    put_line("  9. copy solutions from monodromy grid in container;");
    put_line(" 10. initialize maximum number of monodromy loops;");
    put_line(" 11. copy solutions in container to Monodromy_Permutations;");
    put_line(" 12. compute permutation by last stored solution list;");
    put_line(" 13. update the monodromy breakup with a new permutation;");
    put_line(" 14. write the current monodromy breakup;");
    put_line(" 15. apply the linear trace to certify the monodromy breakup;");
    put_line(" 16. returns the diagnostics of the trace grid;");
    put_line(" 17. compute the difference in the trace sum for a factor;");
    put_line(" 18. find the index of a solution label in a slice;");
    put_line(" 19. initialize number of slices in Sampling_Operations;");
    put_line(" 20. adds a new slice to Sampling_Operations;");
    put_line(" 21. retrieves a slice from Sampling_Operations;");
    put_line(" 22. sets target slices to a previously stored set of slices;");
    put_line(" 23. completes one loop starting at one solution;");
    put_line(" 24. read a witness set from file, given by name;");
    put_line(" 25. writes system and solutions as a witness set to file;");
    put_line(" 26. returns current number of irreducible factors;");
    put_line(" 27. gets labels of witness points of an irreducible factor;");
    put_line(" 28. set the state of monodromy permutations to silent.");
  end Write_Menu;

  function Handle_Jobs return integer32 is

    use Witness_Interface;
    use Monodromy_Interface;

  begin
    case job is
      when   0 => Write_Menu; return 0;
      when   1 => return Witness_Standard_Polynomial_Prompt(a,b,vrblvl-1);
      when   2 => return Monodromy_Standard_Initialize_Sampler(a,vrblvl-1);
      when   3 => return Monodromy_Standard_Set_Coefficient(a,b,c,vrblvl-1);
      when   4 => return Monodromy_Standard_Store_Gamma(a,c,vrblvl-1);
      when   5 => return Monodromy_Standard_Sample(vrblvl-1);
      when   6 => return Monodromy_Standard_Swap_Slices(vrblvl-1);
      when   7 => return Monodromy_Standard_Copy_System(vrblvl-1);
      when   8 => return Monodromy_Standard_Copy_Solutions(vrblvl-1);
      when   9 => return Monodromy_Standard_Grid_Solutions(a,vrblvl-1);
      when  10 => return Monodromy_Standard_Init_Permutations(a,b,vrblvl-1);
      when  11 => return Monodromy_Standard_Perm_Solutions(vrblvl-1);
      when  12 => return Monodromy_Standard_Permutation(b,vrblvl-1);
      when  13 => return Monodromy_Standard_Update(a,b,vrblvl-1);
      when  14 => return Monodromy_Standard_Write(vrblvl-1);
      when  15 => return Monodromy_Standard_Trace_Test(a,vrblvl-1);
      when  16 => return Monodromy_Standard_Diagnostics(c,vrblvl-1);
      when  17 => return Monodromy_Standard_Trace_Sum(a,b,c,vrblvl-1);
      when  18 => return Monodromy_Standard_Index(a,b,vrblvl-1);
      when  19 => return Monodromy_Standard_Initialize_Slices(a,vrblvl-1);
      when  20 => return Monodromy_Standard_Add_Slice(a,c,vrblvl-1);
      when  21 => return Monodromy_Standard_Get_Slice(a,b,c,vrblvl-1);
      when  22 => return Monodromy_Standard_Set_Target(a,vrblvl-1);
      when  23 => return Monodromy_Standard_Loop(a,b,vrblvl-1);
      when  24 => return Witness_Standard_Polynomial_Read(a,b,vrblvl-1);
      when  25 => return Witness_Standard_Polynomial_Write(a,b,vrblvl-1);
      when  26 => return Monodromy_Standard_Factor_Count(a,vrblvl-1);
      when  27 => return Monodromy_Standard_Get_Factor(a,b,vrblvl-1);
      when  28 => return Monodromy_Standard_Set_Silent(vrblvl-1);
      when  29 => return Monodromy_Standard_Random(c,vrblvl-1);
      when  30 => return Monodromy_Standard_Set_Verbose(vrblvl-1);
      when  31 => return Witness_DoblDobl_Polynomial_Prompt(a,b,vrblvl-1);
      when  32 => return Monodromy_DoblDobl_Initialize_Sampler(a,vrblvl-1);
      when  33 => return Monodromy_DoblDobl_Set_Coefficient(a,b,c,vrblvl-1);
      when  34 => return Monodromy_DoblDobl_Store_Gamma(a,c,vrblvl-1);
      when  35 => return Monodromy_DoblDobl_Sample(vrblvl-1);
      when  36 => return Monodromy_DoblDobl_Swap_Slices(vrblvl-1);
      when  37 => return Monodromy_DoblDobl_Copy_System(vrblvl-1);
      when  38 => return Monodromy_DoblDobl_Copy_Solutions(vrblvl-1);
      when  39 => return Monodromy_DoblDobl_Grid_Solutions(a,vrblvl-1);
      when  40 => return Monodromy_DoblDobl_Init_Permutations(a,b,vrblvl-1);
      when  41 => return Monodromy_DoblDobl_Perm_Solutions(vrblvl-1);
      when  42 => return Monodromy_DoblDobl_Permutation(b,vrblvl-1);
      when  43 => return Monodromy_DoblDobl_Update(a,b,vrblvl-1);
      when  44 => return Monodromy_DoblDobl_Write(vrblvl-1);
      when  45 => return Monodromy_DoblDobl_Trace_Test(a,vrblvl-1);
      when  46 => return Monodromy_DoblDobl_Diagnostics(c,vrblvl-1);
      when  47 => return Monodromy_DoblDobl_Trace_Sum(a,b,c,vrblvl-1);
      when  48 => return Monodromy_DoblDobl_Index(a,b,vrblvl-1);
      when  49 => return Monodromy_DoblDobl_Initialize_Slices(a,vrblvl-1);
      when  52 => return Monodromy_DoblDobl_Set_Target(a,vrblvl-1);
      when  53 => return Monodromy_DoblDobl_Loop(a,b,vrblvl-1);
      when  54 => return Witness_DoblDobl_Polynomial_Read(a,b,vrblvl-1);
      when  55 => return Witness_DoblDobl_Polynomial_Write(a,b,vrblvl-1);
      when  56 => return Monodromy_DoblDobl_Factor_Count(a,vrblvl-1);
      when  57 => return Monodromy_DoblDobl_Get_Factor(a,b,vrblvl-1);
      when  58 => return Monodromy_DoblDobl_Set_Silent(vrblvl-1);
      when  59 => return Monodromy_DoblDobl_Random(c,vrblvl-1);
      when  60 => return Monodromy_DoblDobl_Set_Verbose(vrblvl-1);
      when  61 => return Witness_QuadDobl_Polynomial_Prompt(a,b,vrblvl-1);
      when  62 => return Monodromy_QuadDobl_Initialize_Sampler(a,vrblvl-1);
      when  63 => return Monodromy_QuadDobl_Set_Coefficient(a,b,c,vrblvl-1);
      when  64 => return Monodromy_QuadDobl_Store_Gamma(a,c,vrblvl-1);
      when  65 => return Monodromy_QuadDobl_Sample(vrblvl-1);
      when  66 => return Monodromy_QuadDobl_Swap_Slices(vrblvl-1);
      when  67 => return Monodromy_QuadDobl_Copy_System(vrblvl-1);
      when  68 => return Monodromy_QuadDobl_Copy_Solutions(vrblvl-1);
      when  69 => return Monodromy_QuadDobl_Grid_Solutions(a,vrblvl-1);
      when  70 => return Monodromy_QuadDobl_Init_Permutations(a,b,vrblvl-1);
      when  71 => return Monodromy_QuadDobl_Perm_Solutions(vrblvl-1);
      when  72 => return Monodromy_QuadDobl_Permutation(b,vrblvl-1);
      when  73 => return Monodromy_QuadDobl_Update(a,b,vrblvl-1);
      when  74 => return Monodromy_QuadDobl_Write(vrblvl-1);
      when  75 => return Monodromy_QuadDobl_Trace_Test(a,vrblvl-1);
      when  76 => return Monodromy_QuadDobl_Diagnostics(c,vrblvl-1);
      when  77 => return Monodromy_QuadDobl_Trace_Sum(a,b,c,vrblvl-1);
      when  78 => return Monodromy_QuadDobl_Index(a,b,vrblvl-1);
      when  79 => return Monodromy_QuadDobl_Initialize_Slices(a,vrblvl-1);
      when  82 => return Monodromy_QuadDobl_Set_Target(a,vrblvl-1);
      when  83 => return Monodromy_QuadDobl_Loop(a,b,vrblvl-1);
      when  84 => return Witness_QuadDobl_Polynomial_Read(a,b,vrblvl-1);
      when  85 => return Witness_QuadDobl_Polynomial_Write(a,b,vrblvl-1);
      when  86 => return Monodromy_QuadDobl_Factor_Count(a,vrblvl-1);
      when  87 => return Monodromy_QuadDobl_Get_Factor(a,b,vrblvl-1);
      when  88 => return Monodromy_QuadDobl_Set_Silent(vrblvl-1);
      when  89 => return Monodromy_QuadDobl_Random(c,vrblvl-1);
      when  90 => return Monodromy_QuadDobl_Set_Verbose(vrblvl-1);
      when  91 => return Witness_Standard_Laurent_Prompt(a,b,vrblvl-1);
      when  92 => return Witness_DoblDobl_Laurent_Prompt(a,b,vrblvl-1);
      when  93 => return Witness_QuadDobl_Laurent_Prompt(a,b,vrblvl-1);
      when  94 => return Witness_Standard_Laurent_Read(a,b,vrblvl-1);
      when  95 => return Witness_DoblDobl_Laurent_Read(a,b,vrblvl-1);
      when  96 => return Witness_QuadDobl_Laurent_Read(a,b,vrblvl-1);
      when  97 => return Monodromy_Standard_Init_Laurent_Sampler(a,vrblvl-1);
      when  98 => return Monodromy_DoblDobl_Init_Laurent_Sampler(a,vrblvl-1);
      when  99 => return Monodromy_QuadDobl_Init_Laurent_Sampler(a,vrblvl-1);
      when 100 => return Monodromy_Standard_Copy_Laurent_System(vrblvl-1);
      when 101 => return Monodromy_DoblDobl_Copy_Laurent_System(vrblvl-1);
      when 102 => return Monodromy_QuadDobl_Copy_Laurent_System(vrblvl-1);
      when others => put_line("  Sorry.  Invalid operation."); return -1;
    end case;
  end Handle_Jobs;

begin
  return Handle_Jobs;
end use_c2fac;
