from __future__ import annotations

from typing import Callable

from mypy.plugin import FunctionContext, Plugin
from mypy.types import CallableType, Type, get_proper_type


class MyPlugin(Plugin):
    def get_function_hook(self, fullname: str) -> Callable[[FunctionContext], Type] | None:
        if fullname == "m.decorator1":
            return decorator_call_hook
        if fullname == "m._decorated":  # This is a dummy name generated by the plugin
            return decorate_hook
        return None


def decorator_call_hook(ctx: FunctionContext) -> Type:
    default = get_proper_type(ctx.default_return_type)
    if isinstance(default, CallableType):
        return default.copy_modified(name="m._decorated")
    return ctx.default_return_type


def decorate_hook(ctx: FunctionContext) -> Type:
    default = get_proper_type(ctx.default_return_type)
    if isinstance(default, CallableType):
        return default.copy_modified(ret_type=ctx.api.named_generic_type("builtins.str", []))
    return ctx.default_return_type


def plugin(version: str) -> type[MyPlugin]:
    return MyPlugin
