#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes
#include <QObject>
#include <QPointF>
#include <QtQml>


/////////////////////// Local includes
#include "jsclassregistrar.h"
#include "pappsomspp/export-import-config.h"

namespace pappso
{

  /*  BEGIN CLASS JS REFERENCE
   *  namespace: pappso
   *  class name: QPointF
   */

class PMSPP_LIB_DECL QPointFJs : public QObject
{
  Q_OBJECT
  Q_PROPERTY(double x READ x WRITE setX NOTIFY xChanged)
  Q_PROPERTY(double y READ y WRITE setY NOTIFY yChanged)
  QML_NAMED_ELEMENT(QPointF)

  public:
  Q_INVOKABLE explicit QPointFJs(QObject *parent = nullptr);
  Q_INVOKABLE explicit QPointFJs(double x, double y, QObject *parent = nullptr);
  Q_INVOKABLE explicit QPointFJs(const QPointF &pointf, QObject *parent = nullptr);

  Q_INVOKABLE double x() const;
  Q_INVOKABLE void setX(double x);

  Q_INVOKABLE double y() const;
  Q_INVOKABLE void setY(double y);

  const QPointF &point() const;
  void setPointF(const QPointF &pointf);

  static void registerJsConstructor(QJSEngine *engine);

  signals:
  void xChanged();
  void yChanged();

  private:
  QPointF m_pointf;
};

  /*  END CLASS JS REFERENCE
   *  namespace: pappso
   *  class name: QPointF
   */

PAPPSO_REGISTER_JS_CLASS(pappso, QPointFJs)

} // namespace pappso
