
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_lapack.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dbdsqr( const char *uplo, HYPRE_Int *n, HYPRE_Int *ncvt, HYPRE_Int *nru, HYPRE_Int *ncc, HYPRE_Real *d__, HYPRE_Real *e, HYPRE_Real *vt, HYPRE_Int *ldvt, HYPRE_Real *u, HYPRE_Int *ldu, HYPRE_Real *c__, HYPRE_Int *ldc, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dbdsqr)( uplo, n, ncvt, nru, ncc, d__, e, vt, ldvt, u, ldu, c__, ldc, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgebd2( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *d__, HYPRE_Real *e, HYPRE_Real *tauq, HYPRE_Real *taup, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgebd2)( m, n, a, lda, d__, e, tauq, taup, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgebrd( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *d__, HYPRE_Real *e, HYPRE_Real *tauq, HYPRE_Real *taup, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgebrd)( m, n, a, lda, d__, e, tauq, taup, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgelq2( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgelq2)( m, n, a, lda, tau, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgelqf( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgelqf)( m, n, a, lda, tau, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgels( char *trans, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *nrhs, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgels)( trans, m, n, nrhs, a, lda, b, ldb, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgeqr2( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgeqr2)( m, n, a, lda, tau, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgeqrf( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgeqrf)( m, n, a, lda, tau, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgesvd( char *jobu, char *jobvt, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *s, HYPRE_Real *u, HYPRE_Int *ldu, HYPRE_Real *vt, HYPRE_Int *ldvt, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgesvd)( jobu, jobvt, m, n, a, lda, s, u, ldu, vt, ldvt, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgetf2( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Int *ipiv, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgetf2)( m, n, a, lda, ipiv, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgetrf( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Int *ipiv, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgetrf)( m, n, a, lda, ipiv, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgetri( HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Int *ipiv, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgetri)( n, a, lda, ipiv, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dgetrs( const char *trans, HYPRE_Int *n, HYPRE_Int *nrhs, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Int *ipiv, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dgetrs)( trans, n, nrhs, a, lda, ipiv, b, ldb, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dlasq1( HYPRE_Int *n, HYPRE_Real *d__, HYPRE_Real *e, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dlasq1)( n, d__, e, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dlasq2( HYPRE_Int *n, HYPRE_Real *z__, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dlasq2)( n, z__, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dlasrt( const char *id, HYPRE_Int *n, HYPRE_Real *d__, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dlasrt)( id, n, d__, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorg2l( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorg2l)( m, n, k, a, lda, tau, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorg2r( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorg2r)( m, n, k, a, lda, tau, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorgbr( const char *vect, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorgbr)( vect, m, n, k, a, lda, tau, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorgl2( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorgl2)( m, n, k, a, lda, tau, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorglq( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorglq)( m, n, k, a, lda, tau, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorgql( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorgql)( m, n, k, a, lda, tau, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorgqr( HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorgqr)( m, n, k, a, lda, tau, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorgtr( const char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorgtr)( uplo, n, a, lda, tau, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorm2r( const char *side, const char *trans, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *c__, HYPRE_Int *ldc, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorm2r)( side, trans, m, n, k, a, lda, tau, c__, ldc, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dormbr( const char *vect, const char *side, const char *trans, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *c__, HYPRE_Int *ldc, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dormbr)( vect, side, trans, m, n, k, a, lda, tau, c__, ldc, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dorml2( const char *side, const char *trans, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *c__, HYPRE_Int *ldc, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dorml2)( side, trans, m, n, k, a, lda, tau, c__, ldc, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dormlq( const char *side, const char *trans, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *c__, HYPRE_Int *ldc, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dormlq)( side, trans, m, n, k, a, lda, tau, c__, ldc, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dormqr( const char *side, const char *trans, HYPRE_Int *m, HYPRE_Int *n, HYPRE_Int *k, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *tau, HYPRE_Real *c__, HYPRE_Int *ldc, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dormqr)( side, trans, m, n, k, a, lda, tau, c__, ldc, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dpotf2( const char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dpotf2)( uplo, n, a, lda, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dpotrf( const char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dpotrf)( uplo, n, a, lda, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dpotrs( char *uplo, HYPRE_Int *n, HYPRE_Int *nrhs, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dpotrs)( uplo, n, nrhs, a, lda, b, ldb, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsteqr( const char *compz, HYPRE_Int *n, HYPRE_Real *d__, HYPRE_Real *e, HYPRE_Real *z__, HYPRE_Int *ldz, HYPRE_Real *work, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsteqr)( compz, n, d__, e, z__, ldz, work, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsterf( HYPRE_Int *n, HYPRE_Real *d__, HYPRE_Real *e, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsterf)( n, d__, e, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsyev( const char *jobz, const char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *w, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsyev)( jobz, uplo, n, a, lda, w, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsygs2( HYPRE_Int *itype, const char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsygs2)( itype, uplo, n, a, lda, b, ldb, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsygst( HYPRE_Int *itype, const char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsygst)( itype, uplo, n, a, lda, b, ldb, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsygv( HYPRE_Int *itype, char *jobz, char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *b, HYPRE_Int *ldb, HYPRE_Real *w, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsygv)( itype, jobz, uplo, n, a, lda, b, ldb, w, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsytd2( const char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *d__, HYPRE_Real *e, HYPRE_Real *tau, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsytd2)( uplo, n, a, lda, d__, e, tau, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dsytrd( const char *uplo, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Real *d__, HYPRE_Real *e, HYPRE_Real *tau, HYPRE_Real *work, HYPRE_Int *lwork, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dsytrd)( uplo, n, a, lda, d__, e, tau, work, lwork, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dtrti2( const char *uplo, const char *diag, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dtrti2)( uplo, diag, n, a, lda, info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_dtrtri( const char *uplo, const char *diag, HYPRE_Int *n, HYPRE_Real *a, HYPRE_Int *lda, HYPRE_Int *info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_dtrtri)( uplo, diag, n, a, lda, info );
}


#endif

