/*
 *  JLib - Jacob's Library.
 *  Copyright (C) 2003, 2004  Juan Carlos Seijo Prez
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 * 
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 * 
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 *  Juan Carlos Seijo Prez
 *  jacob@mainreactor.net
 */

/** Polgono cerrado genrico
 * @file J2DPolygon.h
 * @author Juan Carlos Seijo Prez
 * @date 01/02/2004 
 */

#ifndef _J2DPOLYGON_INCLUDED
#define _J2DPOLYGON_INCLUDED

#include <JLib/Util/JTypes.h>
#include <JLib/Util/JLoadSave.h>
#include <JLib/Math/J2DVector.h>
#include <string.h>
#include <math.h>

/** Polgono cerrado genrico.
 * Consta de varios vrtices conectados correlativamente.
 */
class J2DPolygon : public JLoadSave
{
protected:
	s32 numVertices;                      /**< Nmero de vrtices del polgono */
	J2DPoint* vertices;                   /**< Vrtices del polgono */
	J2DVector* segments;                  /**< Segmentos del polgono */
	J2DVector* normals;                   /**< Normales a los segmentos del polgono */

public:
	/** Constructor.
	 * Crea un polgono vaco.
	 */
	J2DPolygon() : numVertices(0), vertices(0), segments(0), normals(0) {}
	
	
	/** Constructor.
	 * Crea un polgono cerrado a partir de los vrtices dados.
	 * @param _numVertices Nmero de vrtices.
	 * @param _vertices Vrtices.
	 */
	J2DPolygon(s32 _numVertices, J2DPoint *_vertices) : numVertices(0), vertices(0), segments(0), normals(0)
	{Init(_numVertices, _vertices);}

	/** Inicializa el polgono con los vrtices dados.
	 * @param _numVertices Nmero de vrtices.
	 * @param _vertices Vrtices.
	 */
	void Init(s32 _numVertices, J2DPoint *_vertices);
	
	/** Destructor.
	 * Libera memoria.
	 */
	virtual ~J2DPolygon() {Destroy();}
	
	/** Destruye el objeto y lo deja como si se acabar de crear con J2DPolygon.
	 */
	void Destroy();

	/** Determina si el punto dado est dentro del polgono.
	 * Por convenio, si un polgono est definido en 
	 * sentido antihorario (CCW) entonces un punto est dentro si cae dentro del 
	 * contorno cerrado del polgono. Si se define en sentido horario (CW), los puntos 
	 * de dentro del contorno cerrado del polgono estn fuera.
	 * @param x coordenada x del punto.
	 * @param y coordenada y del punto.
	 * @return true si el punto dado est dentro, false en caso contrario.
	 */
	bool IsInside(J2DScalar x, J2DScalar y);

  /** Carga el polgono
	 * @param f Fichero posicionado en este recurso
   * @return 0 Si todo fue bien, 1 si hay error de E/S y 2 si hay error
   * en los datos.
	 */
	u32 Load(JFile &f);

  /** Salva el polgono
	 * @param f Fichero posicionado en este recurso
   * @return 0 Si todo fue bien, 1 si hay error de E/S y 2 si hay error
   * en los datos.
	 */
	u32 Save(JFile &f);
};

#endif // _J2DPOLYGON_INCLUDED
