// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/shopping/merchant/accounts/v1beta/account_tax.proto

package accountspb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The tax settings of a merchant account. All methods require the admin role.
type AccountTax struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the tax setting.
	// Format:
	// "{account_tax.name=accounts/{account}}"
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The ID of the account to which these account tax settings
	// belong.
	Account int64 `protobuf:"varint,2,opt,name=account,proto3" json:"account,omitempty"`
	// Tax rules. "Define the tax rules in each region.
	// No tax will be presented if a region has no rule."
	TaxRules []*TaxRule `protobuf:"bytes,3,rep,name=tax_rules,json=taxRules,proto3" json:"tax_rules,omitempty"`
}

func (x *AccountTax) Reset() {
	*x = AccountTax{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccountTax) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccountTax) ProtoMessage() {}

func (x *AccountTax) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccountTax.ProtoReflect.Descriptor instead.
func (*AccountTax) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescGZIP(), []int{0}
}

func (x *AccountTax) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AccountTax) GetAccount() int64 {
	if x != nil {
		return x.Account
	}
	return 0
}

func (x *AccountTax) GetTaxRules() []*TaxRule {
	if x != nil {
		return x.TaxRules
	}
	return nil
}

// Request to get tax settings
type GetAccountTaxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name from which tax settings will be retrieved
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetAccountTaxRequest) Reset() {
	*x = GetAccountTaxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetAccountTaxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetAccountTaxRequest) ProtoMessage() {}

func (x *GetAccountTaxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetAccountTaxRequest.ProtoReflect.Descriptor instead.
func (*GetAccountTaxRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescGZIP(), []int{1}
}

func (x *GetAccountTaxRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request to update the tax settings
type UpdateAccountTaxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The tax setting that will be updated
	AccountTax *AccountTax `protobuf:"bytes,1,opt,name=account_tax,json=accountTax,proto3" json:"account_tax,omitempty"`
	// The list of fields to be updated
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateAccountTaxRequest) Reset() {
	*x = UpdateAccountTaxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateAccountTaxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateAccountTaxRequest) ProtoMessage() {}

func (x *UpdateAccountTaxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateAccountTaxRequest.ProtoReflect.Descriptor instead.
func (*UpdateAccountTaxRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateAccountTaxRequest) GetAccountTax() *AccountTax {
	if x != nil {
		return x.AccountTax
	}
	return nil
}

func (x *UpdateAccountTaxRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request to list all sub-account tax settings only for the requesting merchant
// This method can only be called on a multi-client account, otherwise it'll
// return an error.
type ListAccountTaxRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of account tax.
	// Format: accounts/{account}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of tax settings to return in the response, used for
	// paging.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The token returned by the previous request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListAccountTaxRequest) Reset() {
	*x = ListAccountTaxRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountTaxRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountTaxRequest) ProtoMessage() {}

func (x *ListAccountTaxRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountTaxRequest.ProtoReflect.Descriptor instead.
func (*ListAccountTaxRequest) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescGZIP(), []int{3}
}

func (x *ListAccountTaxRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListAccountTaxRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListAccountTaxRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response to account tax list request
// This method can only be called on a multi-client account, otherwise it'll
// return an error.
type ListAccountTaxResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Page of accounttax settings
	AccountTaxes []*AccountTax `protobuf:"bytes,1,rep,name=account_taxes,json=accountTaxes,proto3" json:"account_taxes,omitempty"`
	// The token for the retrieval of the next page of account tax settings.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListAccountTaxResponse) Reset() {
	*x = ListAccountTaxResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListAccountTaxResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAccountTaxResponse) ProtoMessage() {}

func (x *ListAccountTaxResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAccountTaxResponse.ProtoReflect.Descriptor instead.
func (*ListAccountTaxResponse) Descriptor() ([]byte, []int) {
	return file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescGZIP(), []int{4}
}

func (x *ListAccountTaxResponse) GetAccountTaxes() []*AccountTax {
	if x != nil {
		return x.AccountTaxes
	}
	return nil
}

func (x *ListAccountTaxResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_shopping_merchant_accounts_v1beta_account_tax_proto protoreflect.FileDescriptor

var file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x74, 0x61, 0x78, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x28, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65,
	0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72,
	0x63, 0x68, 0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x74, 0x61, 0x78, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xff, 0x01, 0x0a, 0x0a, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x54, 0x61, 0x78, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x09, 0x74,
	0x61, 0x78, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x78, 0x52, 0x75, 0x6c,
	0x65, 0x52, 0x08, 0x74, 0x61, 0x78, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x3a, 0x69, 0xea, 0x41, 0x66,
	0x0a, 0x25, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x12, 0x23, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0x2f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x74, 0x61, 0x78, 0x2f, 0x7b, 0x74, 0x61, 0x78, 0x7d, 0x2a, 0x0c, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x65, 0x73, 0x32, 0x0a, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x22, 0x59, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70,
	0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xb2, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5a, 0x0a,
	0x0b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x9a, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61,
	0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59,
	0x0a, 0x0d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x78, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73,
	0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x0c, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x32, 0x84, 0x06, 0x0a, 0x11, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc5, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54,
	0x61, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63,
	0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x22,
	0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f,
	0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x74, 0x61, 0x78, 0x2f, 0x2a, 0x7d, 0x12,
	0xd5, 0x01, 0x0a, 0x0e, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54,
	0x61, 0x78, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f,
	0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x74, 0x61, 0x78, 0x12, 0x85, 0x02, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2e, 0x6d,
	0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x41, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x61, 0x78, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e,
	0x67, 0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x54, 0x61, 0x78, 0x22, 0x78, 0xda, 0x41, 0x17, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x5f, 0x74, 0x61, 0x78, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0xda, 0x41, 0x0b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x78, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74,
	0x61, 0x78, 0x32, 0x3b, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x74, 0x61,
	0x78, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x74, 0x61, 0x78, 0x2f, 0x2a, 0x7d, 0x1a,
	0x47, 0xca, 0x41, 0x1a, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x61, 0x70, 0x69, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41,
	0x27, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x91, 0x01, 0x0a, 0x2c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67,
	0x2e, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x2e, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x0f, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x54, 0x61, 0x78, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x2f, 0x6d, 0x65, 0x72, 0x63, 0x68,
	0x61, 0x6e, 0x74, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70,
	0x62, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescOnce sync.Once
	file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescData = file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDesc
)

func file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescGZIP() []byte {
	file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescOnce.Do(func() {
		file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescData)
	})
	return file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDescData
}

var file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_shopping_merchant_accounts_v1beta_account_tax_proto_goTypes = []interface{}{
	(*AccountTax)(nil),              // 0: google.shopping.merchant.accounts.v1beta.AccountTax
	(*GetAccountTaxRequest)(nil),    // 1: google.shopping.merchant.accounts.v1beta.GetAccountTaxRequest
	(*UpdateAccountTaxRequest)(nil), // 2: google.shopping.merchant.accounts.v1beta.UpdateAccountTaxRequest
	(*ListAccountTaxRequest)(nil),   // 3: google.shopping.merchant.accounts.v1beta.ListAccountTaxRequest
	(*ListAccountTaxResponse)(nil),  // 4: google.shopping.merchant.accounts.v1beta.ListAccountTaxResponse
	(*TaxRule)(nil),                 // 5: google.shopping.merchant.accounts.v1beta.TaxRule
	(*fieldmaskpb.FieldMask)(nil),   // 6: google.protobuf.FieldMask
}
var file_google_shopping_merchant_accounts_v1beta_account_tax_proto_depIdxs = []int32{
	5, // 0: google.shopping.merchant.accounts.v1beta.AccountTax.tax_rules:type_name -> google.shopping.merchant.accounts.v1beta.TaxRule
	0, // 1: google.shopping.merchant.accounts.v1beta.UpdateAccountTaxRequest.account_tax:type_name -> google.shopping.merchant.accounts.v1beta.AccountTax
	6, // 2: google.shopping.merchant.accounts.v1beta.UpdateAccountTaxRequest.update_mask:type_name -> google.protobuf.FieldMask
	0, // 3: google.shopping.merchant.accounts.v1beta.ListAccountTaxResponse.account_taxes:type_name -> google.shopping.merchant.accounts.v1beta.AccountTax
	1, // 4: google.shopping.merchant.accounts.v1beta.AccountTaxService.GetAccountTax:input_type -> google.shopping.merchant.accounts.v1beta.GetAccountTaxRequest
	3, // 5: google.shopping.merchant.accounts.v1beta.AccountTaxService.ListAccountTax:input_type -> google.shopping.merchant.accounts.v1beta.ListAccountTaxRequest
	2, // 6: google.shopping.merchant.accounts.v1beta.AccountTaxService.UpdateAccountTax:input_type -> google.shopping.merchant.accounts.v1beta.UpdateAccountTaxRequest
	0, // 7: google.shopping.merchant.accounts.v1beta.AccountTaxService.GetAccountTax:output_type -> google.shopping.merchant.accounts.v1beta.AccountTax
	4, // 8: google.shopping.merchant.accounts.v1beta.AccountTaxService.ListAccountTax:output_type -> google.shopping.merchant.accounts.v1beta.ListAccountTaxResponse
	0, // 9: google.shopping.merchant.accounts.v1beta.AccountTaxService.UpdateAccountTax:output_type -> google.shopping.merchant.accounts.v1beta.AccountTax
	7, // [7:10] is the sub-list for method output_type
	4, // [4:7] is the sub-list for method input_type
	4, // [4:4] is the sub-list for extension type_name
	4, // [4:4] is the sub-list for extension extendee
	0, // [0:4] is the sub-list for field type_name
}

func init() { file_google_shopping_merchant_accounts_v1beta_account_tax_proto_init() }
func file_google_shopping_merchant_accounts_v1beta_account_tax_proto_init() {
	if File_google_shopping_merchant_accounts_v1beta_account_tax_proto != nil {
		return
	}
	file_google_shopping_merchant_accounts_v1beta_tax_rule_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccountTax); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetAccountTaxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateAccountTaxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountTaxRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListAccountTaxResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_shopping_merchant_accounts_v1beta_account_tax_proto_goTypes,
		DependencyIndexes: file_google_shopping_merchant_accounts_v1beta_account_tax_proto_depIdxs,
		MessageInfos:      file_google_shopping_merchant_accounts_v1beta_account_tax_proto_msgTypes,
	}.Build()
	File_google_shopping_merchant_accounts_v1beta_account_tax_proto = out.File
	file_google_shopping_merchant_accounts_v1beta_account_tax_proto_rawDesc = nil
	file_google_shopping_merchant_accounts_v1beta_account_tax_proto_goTypes = nil
	file_google_shopping_merchant_accounts_v1beta_account_tax_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AccountTaxServiceClient is the client API for AccountTaxService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AccountTaxServiceClient interface {
	// Returns the tax rules that match the conditions of GetAccountTaxRequest
	GetAccountTax(ctx context.Context, in *GetAccountTaxRequest, opts ...grpc.CallOption) (*AccountTax, error)
	// Lists the tax settings of the sub-accounts only in your
	// Merchant Center account.
	// This method can only be called on a multi-client account, otherwise it'll
	// return an error.
	ListAccountTax(ctx context.Context, in *ListAccountTaxRequest, opts ...grpc.CallOption) (*ListAccountTaxResponse, error)
	// Updates the tax settings of the account.
	UpdateAccountTax(ctx context.Context, in *UpdateAccountTaxRequest, opts ...grpc.CallOption) (*AccountTax, error)
}

type accountTaxServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAccountTaxServiceClient(cc grpc.ClientConnInterface) AccountTaxServiceClient {
	return &accountTaxServiceClient{cc}
}

func (c *accountTaxServiceClient) GetAccountTax(ctx context.Context, in *GetAccountTaxRequest, opts ...grpc.CallOption) (*AccountTax, error) {
	out := new(AccountTax)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.AccountTaxService/GetAccountTax", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountTaxServiceClient) ListAccountTax(ctx context.Context, in *ListAccountTaxRequest, opts ...grpc.CallOption) (*ListAccountTaxResponse, error) {
	out := new(ListAccountTaxResponse)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.AccountTaxService/ListAccountTax", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *accountTaxServiceClient) UpdateAccountTax(ctx context.Context, in *UpdateAccountTaxRequest, opts ...grpc.CallOption) (*AccountTax, error) {
	out := new(AccountTax)
	err := c.cc.Invoke(ctx, "/google.shopping.merchant.accounts.v1beta.AccountTaxService/UpdateAccountTax", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AccountTaxServiceServer is the server API for AccountTaxService service.
type AccountTaxServiceServer interface {
	// Returns the tax rules that match the conditions of GetAccountTaxRequest
	GetAccountTax(context.Context, *GetAccountTaxRequest) (*AccountTax, error)
	// Lists the tax settings of the sub-accounts only in your
	// Merchant Center account.
	// This method can only be called on a multi-client account, otherwise it'll
	// return an error.
	ListAccountTax(context.Context, *ListAccountTaxRequest) (*ListAccountTaxResponse, error)
	// Updates the tax settings of the account.
	UpdateAccountTax(context.Context, *UpdateAccountTaxRequest) (*AccountTax, error)
}

// UnimplementedAccountTaxServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAccountTaxServiceServer struct {
}

func (*UnimplementedAccountTaxServiceServer) GetAccountTax(context.Context, *GetAccountTaxRequest) (*AccountTax, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAccountTax not implemented")
}
func (*UnimplementedAccountTaxServiceServer) ListAccountTax(context.Context, *ListAccountTaxRequest) (*ListAccountTaxResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAccountTax not implemented")
}
func (*UnimplementedAccountTaxServiceServer) UpdateAccountTax(context.Context, *UpdateAccountTaxRequest) (*AccountTax, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccountTax not implemented")
}

func RegisterAccountTaxServiceServer(s *grpc.Server, srv AccountTaxServiceServer) {
	s.RegisterService(&_AccountTaxService_serviceDesc, srv)
}

func _AccountTaxService_GetAccountTax_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAccountTaxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountTaxServiceServer).GetAccountTax(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.AccountTaxService/GetAccountTax",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountTaxServiceServer).GetAccountTax(ctx, req.(*GetAccountTaxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountTaxService_ListAccountTax_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAccountTaxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountTaxServiceServer).ListAccountTax(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.AccountTaxService/ListAccountTax",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountTaxServiceServer).ListAccountTax(ctx, req.(*ListAccountTaxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AccountTaxService_UpdateAccountTax_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccountTaxRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AccountTaxServiceServer).UpdateAccountTax(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.shopping.merchant.accounts.v1beta.AccountTaxService/UpdateAccountTax",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AccountTaxServiceServer).UpdateAccountTax(ctx, req.(*UpdateAccountTaxRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AccountTaxService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.shopping.merchant.accounts.v1beta.AccountTaxService",
	HandlerType: (*AccountTaxServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAccountTax",
			Handler:    _AccountTaxService_GetAccountTax_Handler,
		},
		{
			MethodName: "ListAccountTax",
			Handler:    _AccountTaxService_ListAccountTax_Handler,
		},
		{
			MethodName: "UpdateAccountTax",
			Handler:    _AccountTaxService_UpdateAccountTax_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/shopping/merchant/accounts/v1beta/account_tax.proto",
}
