//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrate

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	credential     azcore.TokenCredential
	options        *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - Azure Subscription Id in which project was created.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID, credential: credential,
		options: options.Clone(),
	}, nil
}

// NewAssessedMachinesClient creates a new instance of AssessedMachinesClient.
func (c *ClientFactory) NewAssessedMachinesClient() *AssessedMachinesClient {
	subClient, _ := NewAssessedMachinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewAssessmentsClient creates a new instance of AssessmentsClient.
func (c *ClientFactory) NewAssessmentsClient() *AssessmentsClient {
	subClient, _ := NewAssessmentsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewGroupsClient creates a new instance of GroupsClient.
func (c *ClientFactory) NewGroupsClient() *GroupsClient {
	subClient, _ := NewGroupsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewHyperVCollectorsClient creates a new instance of HyperVCollectorsClient.
func (c *ClientFactory) NewHyperVCollectorsClient() *HyperVCollectorsClient {
	subClient, _ := NewHyperVCollectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewImportCollectorsClient creates a new instance of ImportCollectorsClient.
func (c *ClientFactory) NewImportCollectorsClient() *ImportCollectorsClient {
	subClient, _ := NewImportCollectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewMachinesClient creates a new instance of MachinesClient.
func (c *ClientFactory) NewMachinesClient() *MachinesClient {
	subClient, _ := NewMachinesClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	subClient, _ := NewOperationsClient(c.credential, c.options)
	return subClient
}

// NewPrivateEndpointConnectionClient creates a new instance of PrivateEndpointConnectionClient.
func (c *ClientFactory) NewPrivateEndpointConnectionClient() *PrivateEndpointConnectionClient {
	subClient, _ := NewPrivateEndpointConnectionClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewPrivateLinkResourceClient creates a new instance of PrivateLinkResourceClient.
func (c *ClientFactory) NewPrivateLinkResourceClient() *PrivateLinkResourceClient {
	subClient, _ := NewPrivateLinkResourceClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewProjectsClient creates a new instance of ProjectsClient.
func (c *ClientFactory) NewProjectsClient() *ProjectsClient {
	subClient, _ := NewProjectsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewServerCollectorsClient creates a new instance of ServerCollectorsClient.
func (c *ClientFactory) NewServerCollectorsClient() *ServerCollectorsClient {
	subClient, _ := NewServerCollectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}

// NewVMwareCollectorsClient creates a new instance of VMwareCollectorsClient.
func (c *ClientFactory) NewVMwareCollectorsClient() *VMwareCollectorsClient {
	subClient, _ := NewVMwareCollectorsClient(c.subscriptionID, c.credential, c.options)
	return subClient
}
