//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappservice

import (
	"encoding/json"
	"io"
)

// CertificateOrdersClientCreateOrUpdateCertificateResponse contains the response from method CertificateOrdersClient.BeginCreateOrUpdateCertificate.
type CertificateOrdersClientCreateOrUpdateCertificateResponse struct {
	// Key Vault container ARM resource for a certificate that is purchased through Azure.
	CertificateResource
}

// CertificateOrdersClientCreateOrUpdateResponse contains the response from method CertificateOrdersClient.BeginCreateOrUpdate.
type CertificateOrdersClientCreateOrUpdateResponse struct {
	// SSL certificate purchase order.
	CertificateOrder
}

// CertificateOrdersClientDeleteCertificateResponse contains the response from method CertificateOrdersClient.DeleteCertificate.
type CertificateOrdersClientDeleteCertificateResponse struct {
	// placeholder for future response values
}

// CertificateOrdersClientDeleteResponse contains the response from method CertificateOrdersClient.Delete.
type CertificateOrdersClientDeleteResponse struct {
	// placeholder for future response values
}

// CertificateOrdersClientGetCertificateResponse contains the response from method CertificateOrdersClient.GetCertificate.
type CertificateOrdersClientGetCertificateResponse struct {
	// Key Vault container ARM resource for a certificate that is purchased through Azure.
	CertificateResource
}

// CertificateOrdersClientGetResponse contains the response from method CertificateOrdersClient.Get.
type CertificateOrdersClientGetResponse struct {
	// SSL certificate purchase order.
	CertificateOrder
}

// CertificateOrdersClientListByResourceGroupResponse contains the response from method CertificateOrdersClient.NewListByResourceGroupPager.
type CertificateOrdersClientListByResourceGroupResponse struct {
	// Collection of certificate orders.
	CertificateOrderCollection
}

// CertificateOrdersClientListCertificatesResponse contains the response from method CertificateOrdersClient.NewListCertificatesPager.
type CertificateOrdersClientListCertificatesResponse struct {
	// Collection of certificate order certificates.
	CertificateCollection
}

// CertificateOrdersClientListResponse contains the response from method CertificateOrdersClient.NewListPager.
type CertificateOrdersClientListResponse struct {
	// Collection of certificate orders.
	CertificateOrderCollection
}

// CertificateOrdersClientReissueResponse contains the response from method CertificateOrdersClient.Reissue.
type CertificateOrdersClientReissueResponse struct {
	// placeholder for future response values
}

// CertificateOrdersClientRenewResponse contains the response from method CertificateOrdersClient.Renew.
type CertificateOrdersClientRenewResponse struct {
	// placeholder for future response values
}

// CertificateOrdersClientResendEmailResponse contains the response from method CertificateOrdersClient.ResendEmail.
type CertificateOrdersClientResendEmailResponse struct {
	// placeholder for future response values
}

// CertificateOrdersClientResendRequestEmailsResponse contains the response from method CertificateOrdersClient.ResendRequestEmails.
type CertificateOrdersClientResendRequestEmailsResponse struct {
	// placeholder for future response values
}

// CertificateOrdersClientRetrieveCertificateActionsResponse contains the response from method CertificateOrdersClient.RetrieveCertificateActions.
type CertificateOrdersClientRetrieveCertificateActionsResponse struct {
	// Array of CertificateOrderAction
	CertificateOrderActionArray []*CertificateOrderAction
}

// CertificateOrdersClientRetrieveCertificateEmailHistoryResponse contains the response from method CertificateOrdersClient.RetrieveCertificateEmailHistory.
type CertificateOrdersClientRetrieveCertificateEmailHistoryResponse struct {
	// Array of CertificateEmail
	CertificateEmailArray []*CertificateEmail
}

// CertificateOrdersClientRetrieveSiteSealResponse contains the response from method CertificateOrdersClient.RetrieveSiteSeal.
type CertificateOrdersClientRetrieveSiteSealResponse struct {
	// Site seal
	SiteSeal
}

// CertificateOrdersClientUpdateCertificateResponse contains the response from method CertificateOrdersClient.UpdateCertificate.
type CertificateOrdersClientUpdateCertificateResponse struct {
	// Key Vault container ARM resource for a certificate that is purchased through Azure.
	CertificateResource
}

// CertificateOrdersClientUpdateResponse contains the response from method CertificateOrdersClient.Update.
type CertificateOrdersClientUpdateResponse struct {
	// SSL certificate purchase order.
	CertificateOrder
}

// CertificateOrdersClientValidatePurchaseInformationResponse contains the response from method CertificateOrdersClient.ValidatePurchaseInformation.
type CertificateOrdersClientValidatePurchaseInformationResponse struct {
	// placeholder for future response values
}

// CertificateOrdersClientVerifyDomainOwnershipResponse contains the response from method CertificateOrdersClient.VerifyDomainOwnership.
type CertificateOrdersClientVerifyDomainOwnershipResponse struct {
	// placeholder for future response values
}

// CertificateOrdersDiagnosticsClientGetAppServiceCertificateOrderDetectorResponseResponse contains the response from method
// CertificateOrdersDiagnosticsClient.GetAppServiceCertificateOrderDetectorResponse.
type CertificateOrdersDiagnosticsClientGetAppServiceCertificateOrderDetectorResponseResponse struct {
	// Class representing Response from Detector
	DetectorResponse
}

// CertificateOrdersDiagnosticsClientListAppServiceCertificateOrderDetectorResponseResponse contains the response from method
// CertificateOrdersDiagnosticsClient.NewListAppServiceCertificateOrderDetectorResponsePager.
type CertificateOrdersDiagnosticsClientListAppServiceCertificateOrderDetectorResponseResponse struct {
	// Collection of detector responses
	DetectorResponseCollection
}

// CertificateRegistrationProviderClientListOperationsResponse contains the response from method CertificateRegistrationProviderClient.NewListOperationsPager.
type CertificateRegistrationProviderClientListOperationsResponse struct {
	// Collection of Azure resource manager operation metadata.
	CsmOperationCollection
}

// CertificatesClientCreateOrUpdateResponse contains the response from method CertificatesClient.CreateOrUpdate.
type CertificatesClientCreateOrUpdateResponse struct {
	// SSL certificate for an app.
	AppCertificate
}

// CertificatesClientDeleteResponse contains the response from method CertificatesClient.Delete.
type CertificatesClientDeleteResponse struct {
	// placeholder for future response values
}

// CertificatesClientGetResponse contains the response from method CertificatesClient.Get.
type CertificatesClientGetResponse struct {
	// SSL certificate for an app.
	AppCertificate
}

// CertificatesClientListByResourceGroupResponse contains the response from method CertificatesClient.NewListByResourceGroupPager.
type CertificatesClientListByResourceGroupResponse struct {
	// Collection of certificates.
	AppCertificateCollection
}

// CertificatesClientListResponse contains the response from method CertificatesClient.NewListPager.
type CertificatesClientListResponse struct {
	// Collection of certificates.
	AppCertificateCollection
}

// CertificatesClientUpdateResponse contains the response from method CertificatesClient.Update.
type CertificatesClientUpdateResponse struct {
	// SSL certificate for an app.
	AppCertificate
}

// ContainerAppsClientCreateOrUpdateResponse contains the response from method ContainerAppsClient.BeginCreateOrUpdate.
type ContainerAppsClientCreateOrUpdateResponse struct {
	// Container App.
	ContainerApp
}

// ContainerAppsClientDeleteResponse contains the response from method ContainerAppsClient.BeginDelete.
type ContainerAppsClientDeleteResponse struct {
	// placeholder for future response values
}

// ContainerAppsClientGetResponse contains the response from method ContainerAppsClient.Get.
type ContainerAppsClientGetResponse struct {
	// Container App.
	ContainerApp
}

// ContainerAppsClientListByResourceGroupResponse contains the response from method ContainerAppsClient.NewListByResourceGroupPager.
type ContainerAppsClientListByResourceGroupResponse struct {
	// Container App collection ARM resource.
	ContainerAppCollection
}

// ContainerAppsClientListBySubscriptionResponse contains the response from method ContainerAppsClient.NewListBySubscriptionPager.
type ContainerAppsClientListBySubscriptionResponse struct {
	// Container App collection ARM resource.
	ContainerAppCollection
}

// ContainerAppsClientListSecretsResponse contains the response from method ContainerAppsClient.ListSecrets.
type ContainerAppsClientListSecretsResponse struct {
	// Container App Secrets Collection ARM resource.
	SecretsCollection
}

// ContainerAppsRevisionsClientActivateRevisionResponse contains the response from method ContainerAppsRevisionsClient.ActivateRevision.
type ContainerAppsRevisionsClientActivateRevisionResponse struct {
	// placeholder for future response values
}

// ContainerAppsRevisionsClientDeactivateRevisionResponse contains the response from method ContainerAppsRevisionsClient.DeactivateRevision.
type ContainerAppsRevisionsClientDeactivateRevisionResponse struct {
	// placeholder for future response values
}

// ContainerAppsRevisionsClientGetRevisionResponse contains the response from method ContainerAppsRevisionsClient.GetRevision.
type ContainerAppsRevisionsClientGetRevisionResponse struct {
	// Container App Revision.
	Revision
}

// ContainerAppsRevisionsClientListRevisionsResponse contains the response from method ContainerAppsRevisionsClient.NewListRevisionsPager.
type ContainerAppsRevisionsClientListRevisionsResponse struct {
	// Container App Revisions collection ARM resource.
	RevisionCollection
}

// ContainerAppsRevisionsClientRestartRevisionResponse contains the response from method ContainerAppsRevisionsClient.RestartRevision.
type ContainerAppsRevisionsClientRestartRevisionResponse struct {
	// placeholder for future response values
}

// DeletedWebAppsClientGetDeletedWebAppByLocationResponse contains the response from method DeletedWebAppsClient.GetDeletedWebAppByLocation.
type DeletedWebAppsClientGetDeletedWebAppByLocationResponse struct {
	// A deleted app.
	DeletedSite
}

// DeletedWebAppsClientListByLocationResponse contains the response from method DeletedWebAppsClient.NewListByLocationPager.
type DeletedWebAppsClientListByLocationResponse struct {
	// Collection of deleted apps.
	DeletedWebAppCollection
}

// DeletedWebAppsClientListResponse contains the response from method DeletedWebAppsClient.NewListPager.
type DeletedWebAppsClientListResponse struct {
	// Collection of deleted apps.
	DeletedWebAppCollection
}

// DiagnosticsClientExecuteSiteAnalysisResponse contains the response from method DiagnosticsClient.ExecuteSiteAnalysis.
type DiagnosticsClientExecuteSiteAnalysisResponse struct {
	// Class representing a diagnostic analysis done on an application
	DiagnosticAnalysis
}

// DiagnosticsClientExecuteSiteAnalysisSlotResponse contains the response from method DiagnosticsClient.ExecuteSiteAnalysisSlot.
type DiagnosticsClientExecuteSiteAnalysisSlotResponse struct {
	// Class representing a diagnostic analysis done on an application
	DiagnosticAnalysis
}

// DiagnosticsClientExecuteSiteDetectorResponse contains the response from method DiagnosticsClient.ExecuteSiteDetector.
type DiagnosticsClientExecuteSiteDetectorResponse struct {
	// Class representing Response from Diagnostic Detectors
	DiagnosticDetectorResponse
}

// DiagnosticsClientExecuteSiteDetectorSlotResponse contains the response from method DiagnosticsClient.ExecuteSiteDetectorSlot.
type DiagnosticsClientExecuteSiteDetectorSlotResponse struct {
	// Class representing Response from Diagnostic Detectors
	DiagnosticDetectorResponse
}

// DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse contains the response from method DiagnosticsClient.GetHostingEnvironmentDetectorResponse.
type DiagnosticsClientGetHostingEnvironmentDetectorResponseResponse struct {
	// Class representing Response from Detector
	DetectorResponse
}

// DiagnosticsClientGetSiteAnalysisResponse contains the response from method DiagnosticsClient.GetSiteAnalysis.
type DiagnosticsClientGetSiteAnalysisResponse struct {
	// Definition of Analysis
	AnalysisDefinition
}

// DiagnosticsClientGetSiteAnalysisSlotResponse contains the response from method DiagnosticsClient.GetSiteAnalysisSlot.
type DiagnosticsClientGetSiteAnalysisSlotResponse struct {
	// Definition of Analysis
	AnalysisDefinition
}

// DiagnosticsClientGetSiteDetectorResponse contains the response from method DiagnosticsClient.GetSiteDetector.
type DiagnosticsClientGetSiteDetectorResponse struct {
	// ARM resource for a detector definition
	DetectorDefinitionResource
}

// DiagnosticsClientGetSiteDetectorResponseResponse contains the response from method DiagnosticsClient.GetSiteDetectorResponse.
type DiagnosticsClientGetSiteDetectorResponseResponse struct {
	// Class representing Response from Detector
	DetectorResponse
}

// DiagnosticsClientGetSiteDetectorResponseSlotResponse contains the response from method DiagnosticsClient.GetSiteDetectorResponseSlot.
type DiagnosticsClientGetSiteDetectorResponseSlotResponse struct {
	// Class representing Response from Detector
	DetectorResponse
}

// DiagnosticsClientGetSiteDetectorSlotResponse contains the response from method DiagnosticsClient.GetSiteDetectorSlot.
type DiagnosticsClientGetSiteDetectorSlotResponse struct {
	// ARM resource for a detector definition
	DetectorDefinitionResource
}

// DiagnosticsClientGetSiteDiagnosticCategoryResponse contains the response from method DiagnosticsClient.GetSiteDiagnosticCategory.
type DiagnosticsClientGetSiteDiagnosticCategoryResponse struct {
	// Class representing detector definition
	DiagnosticCategory
}

// DiagnosticsClientGetSiteDiagnosticCategorySlotResponse contains the response from method DiagnosticsClient.GetSiteDiagnosticCategorySlot.
type DiagnosticsClientGetSiteDiagnosticCategorySlotResponse struct {
	// Class representing detector definition
	DiagnosticCategory
}

// DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse contains the response from method DiagnosticsClient.NewListHostingEnvironmentDetectorResponsesPager.
type DiagnosticsClientListHostingEnvironmentDetectorResponsesResponse struct {
	// Collection of detector responses
	DetectorResponseCollection
}

// DiagnosticsClientListSiteAnalysesResponse contains the response from method DiagnosticsClient.NewListSiteAnalysesPager.
type DiagnosticsClientListSiteAnalysesResponse struct {
	// Collection of Diagnostic Analyses
	DiagnosticAnalysisCollection
}

// DiagnosticsClientListSiteAnalysesSlotResponse contains the response from method DiagnosticsClient.NewListSiteAnalysesSlotPager.
type DiagnosticsClientListSiteAnalysesSlotResponse struct {
	// Collection of Diagnostic Analyses
	DiagnosticAnalysisCollection
}

// DiagnosticsClientListSiteDetectorResponsesResponse contains the response from method DiagnosticsClient.NewListSiteDetectorResponsesPager.
type DiagnosticsClientListSiteDetectorResponsesResponse struct {
	// Collection of detector responses
	DetectorResponseCollection
}

// DiagnosticsClientListSiteDetectorResponsesSlotResponse contains the response from method DiagnosticsClient.NewListSiteDetectorResponsesSlotPager.
type DiagnosticsClientListSiteDetectorResponsesSlotResponse struct {
	// Collection of detector responses
	DetectorResponseCollection
}

// DiagnosticsClientListSiteDetectorsResponse contains the response from method DiagnosticsClient.NewListSiteDetectorsPager.
type DiagnosticsClientListSiteDetectorsResponse struct {
	// Collection of Diagnostic Detectors
	DiagnosticDetectorCollection
}

// DiagnosticsClientListSiteDetectorsSlotResponse contains the response from method DiagnosticsClient.NewListSiteDetectorsSlotPager.
type DiagnosticsClientListSiteDetectorsSlotResponse struct {
	// Collection of Diagnostic Detectors
	DiagnosticDetectorCollection
}

// DiagnosticsClientListSiteDiagnosticCategoriesResponse contains the response from method DiagnosticsClient.NewListSiteDiagnosticCategoriesPager.
type DiagnosticsClientListSiteDiagnosticCategoriesResponse struct {
	// Collection of Diagnostic Categories
	DiagnosticCategoryCollection
}

// DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse contains the response from method DiagnosticsClient.NewListSiteDiagnosticCategoriesSlotPager.
type DiagnosticsClientListSiteDiagnosticCategoriesSlotResponse struct {
	// Collection of Diagnostic Categories
	DiagnosticCategoryCollection
}

// DomainRegistrationProviderClientListOperationsResponse contains the response from method DomainRegistrationProviderClient.NewListOperationsPager.
type DomainRegistrationProviderClientListOperationsResponse struct {
	// Collection of Azure resource manager operation metadata.
	CsmOperationCollection
}

// DomainsClientCheckAvailabilityResponse contains the response from method DomainsClient.CheckAvailability.
type DomainsClientCheckAvailabilityResponse struct {
	// Domain availability check result.
	DomainAvailabilityCheckResult
}

// DomainsClientCreateOrUpdateOwnershipIdentifierResponse contains the response from method DomainsClient.CreateOrUpdateOwnershipIdentifier.
type DomainsClientCreateOrUpdateOwnershipIdentifierResponse struct {
	// Domain ownership Identifier.
	DomainOwnershipIdentifier
}

// DomainsClientCreateOrUpdateResponse contains the response from method DomainsClient.BeginCreateOrUpdate.
type DomainsClientCreateOrUpdateResponse struct {
	// Information about a domain.
	Domain
}

// DomainsClientDeleteOwnershipIdentifierResponse contains the response from method DomainsClient.DeleteOwnershipIdentifier.
type DomainsClientDeleteOwnershipIdentifierResponse struct {
	// placeholder for future response values
}

// DomainsClientDeleteResponse contains the response from method DomainsClient.Delete.
type DomainsClientDeleteResponse struct {
	// placeholder for future response values
}

// DomainsClientGetControlCenterSsoRequestResponse contains the response from method DomainsClient.GetControlCenterSsoRequest.
type DomainsClientGetControlCenterSsoRequestResponse struct {
	// Single sign-on request information for domain management.
	DomainControlCenterSsoRequest
}

// DomainsClientGetOwnershipIdentifierResponse contains the response from method DomainsClient.GetOwnershipIdentifier.
type DomainsClientGetOwnershipIdentifierResponse struct {
	// Domain ownership Identifier.
	DomainOwnershipIdentifier
}

// DomainsClientGetResponse contains the response from method DomainsClient.Get.
type DomainsClientGetResponse struct {
	// Information about a domain.
	Domain
}

// DomainsClientListByResourceGroupResponse contains the response from method DomainsClient.NewListByResourceGroupPager.
type DomainsClientListByResourceGroupResponse struct {
	// Collection of domains.
	DomainCollection
}

// DomainsClientListOwnershipIdentifiersResponse contains the response from method DomainsClient.NewListOwnershipIdentifiersPager.
type DomainsClientListOwnershipIdentifiersResponse struct {
	// Collection of domain ownership identifiers.
	DomainOwnershipIdentifierCollection
}

// DomainsClientListRecommendationsResponse contains the response from method DomainsClient.NewListRecommendationsPager.
type DomainsClientListRecommendationsResponse struct {
	// Collection of domain name identifiers.
	NameIdentifierCollection
}

// DomainsClientListResponse contains the response from method DomainsClient.NewListPager.
type DomainsClientListResponse struct {
	// Collection of domains.
	DomainCollection
}

// DomainsClientRenewResponse contains the response from method DomainsClient.Renew.
type DomainsClientRenewResponse struct {
	// placeholder for future response values
}

// DomainsClientTransferOutResponse contains the response from method DomainsClient.TransferOut.
type DomainsClientTransferOutResponse struct {
	// Information about a domain.
	Domain
}

// DomainsClientUpdateOwnershipIdentifierResponse contains the response from method DomainsClient.UpdateOwnershipIdentifier.
type DomainsClientUpdateOwnershipIdentifierResponse struct {
	// Domain ownership Identifier.
	DomainOwnershipIdentifier
}

// DomainsClientUpdateResponse contains the response from method DomainsClient.Update.
type DomainsClientUpdateResponse struct {
	// Information about a domain.
	Domain
}

// EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse contains the response from method EnvironmentsClient.BeginApproveOrRejectPrivateEndpointConnection.
type EnvironmentsClientApproveOrRejectPrivateEndpointConnectionResponse struct {
	// Remote Private Endpoint Connection ARM resource.
	RemotePrivateEndpointConnectionARMResource
}

// EnvironmentsClientChangeVnetResponse contains the response from method EnvironmentsClient.BeginChangeVnet.
type EnvironmentsClientChangeVnetResponse struct {
	// Collection of App Service apps.
	WebAppCollection
}

// EnvironmentsClientCreateOrUpdateMultiRolePoolResponse contains the response from method EnvironmentsClient.BeginCreateOrUpdateMultiRolePool.
type EnvironmentsClientCreateOrUpdateMultiRolePoolResponse struct {
	// Worker pool of an App Service Environment ARM resource.
	WorkerPoolResource
}

// EnvironmentsClientCreateOrUpdateResponse contains the response from method EnvironmentsClient.BeginCreateOrUpdate.
type EnvironmentsClientCreateOrUpdateResponse struct {
	// App Service Environment ARM resource.
	EnvironmentResource
}

// EnvironmentsClientCreateOrUpdateWorkerPoolResponse contains the response from method EnvironmentsClient.BeginCreateOrUpdateWorkerPool.
type EnvironmentsClientCreateOrUpdateWorkerPoolResponse struct {
	// Worker pool of an App Service Environment ARM resource.
	WorkerPoolResource
}

// EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse contains the response from method EnvironmentsClient.DeleteAseCustomDNSSuffixConfiguration.
type EnvironmentsClientDeleteAseCustomDNSSuffixConfigurationResponse struct {
	// Anything
	Interface any
}

// EnvironmentsClientDeletePrivateEndpointConnectionResponse contains the response from method EnvironmentsClient.BeginDeletePrivateEndpointConnection.
type EnvironmentsClientDeletePrivateEndpointConnectionResponse struct {
	// Anything
	Interface any
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EnvironmentsClientDeletePrivateEndpointConnectionResponse.
func (e *EnvironmentsClientDeletePrivateEndpointConnectionResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &e.Interface)
}

// EnvironmentsClientDeleteResponse contains the response from method EnvironmentsClient.BeginDelete.
type EnvironmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse contains the response from method EnvironmentsClient.GetAseCustomDNSSuffixConfiguration.
type EnvironmentsClientGetAseCustomDNSSuffixConfigurationResponse struct {
	// Full view of the custom domain suffix configuration for ASEv3.
	CustomDNSSuffixConfiguration
}

// EnvironmentsClientGetAseV3NetworkingConfigurationResponse contains the response from method EnvironmentsClient.GetAseV3NetworkingConfiguration.
type EnvironmentsClientGetAseV3NetworkingConfigurationResponse struct {
	// Full view of networking configuration for an ASE.
	AseV3NetworkingConfiguration
}

// EnvironmentsClientGetDiagnosticsItemResponse contains the response from method EnvironmentsClient.GetDiagnosticsItem.
type EnvironmentsClientGetDiagnosticsItemResponse struct {
	// Diagnostics for an App Service Environment.
	HostingEnvironmentDiagnostics
}

// EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse contains the response from method EnvironmentsClient.NewGetInboundNetworkDependenciesEndpointsPager.
type EnvironmentsClientGetInboundNetworkDependenciesEndpointsResponse struct {
	// Collection of Inbound Environment Endpoints
	InboundEnvironmentEndpointCollection
}

// EnvironmentsClientGetMultiRolePoolResponse contains the response from method EnvironmentsClient.GetMultiRolePool.
type EnvironmentsClientGetMultiRolePoolResponse struct {
	// Worker pool of an App Service Environment ARM resource.
	WorkerPoolResource
}

// EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse contains the response from method EnvironmentsClient.NewGetOutboundNetworkDependenciesEndpointsPager.
type EnvironmentsClientGetOutboundNetworkDependenciesEndpointsResponse struct {
	// Collection of Outbound Environment Endpoints
	OutboundEnvironmentEndpointCollection
}

// EnvironmentsClientGetPrivateEndpointConnectionListResponse contains the response from method EnvironmentsClient.NewGetPrivateEndpointConnectionListPager.
type EnvironmentsClientGetPrivateEndpointConnectionListResponse struct {
	PrivateEndpointConnectionCollection
}

// EnvironmentsClientGetPrivateEndpointConnectionResponse contains the response from method EnvironmentsClient.GetPrivateEndpointConnection.
type EnvironmentsClientGetPrivateEndpointConnectionResponse struct {
	// Remote Private Endpoint Connection ARM resource.
	RemotePrivateEndpointConnectionARMResource
}

// EnvironmentsClientGetPrivateLinkResourcesResponse contains the response from method EnvironmentsClient.GetPrivateLinkResources.
type EnvironmentsClientGetPrivateLinkResourcesResponse struct {
	// Wrapper for a collection of private link resources
	PrivateLinkResourcesWrapper
}

// EnvironmentsClientGetResponse contains the response from method EnvironmentsClient.Get.
type EnvironmentsClientGetResponse struct {
	// App Service Environment ARM resource.
	EnvironmentResource
}

// EnvironmentsClientGetVipInfoResponse contains the response from method EnvironmentsClient.GetVipInfo.
type EnvironmentsClientGetVipInfoResponse struct {
	// Describes main public IP address and any extra virtual IPs.
	AddressResponse
}

// EnvironmentsClientGetWorkerPoolResponse contains the response from method EnvironmentsClient.GetWorkerPool.
type EnvironmentsClientGetWorkerPoolResponse struct {
	// Worker pool of an App Service Environment ARM resource.
	WorkerPoolResource
}

// EnvironmentsClientListAppServicePlansResponse contains the response from method EnvironmentsClient.NewListAppServicePlansPager.
type EnvironmentsClientListAppServicePlansResponse struct {
	// Collection of App Service plans.
	PlanCollection
}

// EnvironmentsClientListByResourceGroupResponse contains the response from method EnvironmentsClient.NewListByResourceGroupPager.
type EnvironmentsClientListByResourceGroupResponse struct {
	// Collection of App Service Environments.
	EnvironmentCollection
}

// EnvironmentsClientListCapacitiesResponse contains the response from method EnvironmentsClient.NewListCapacitiesPager.
type EnvironmentsClientListCapacitiesResponse struct {
	// Collection of stamp capacities.
	StampCapacityCollection
}

// EnvironmentsClientListDiagnosticsResponse contains the response from method EnvironmentsClient.ListDiagnostics.
type EnvironmentsClientListDiagnosticsResponse struct {
	// Array of HostingEnvironmentDiagnostics
	HostingEnvironmentDiagnosticsArray []*HostingEnvironmentDiagnostics
}

// EnvironmentsClientListMultiRoleMetricDefinitionsResponse contains the response from method EnvironmentsClient.NewListMultiRoleMetricDefinitionsPager.
type EnvironmentsClientListMultiRoleMetricDefinitionsResponse struct {
	// Collection of metric definitions.
	ResourceMetricDefinitionCollection
}

// EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse contains the response from method EnvironmentsClient.NewListMultiRolePoolInstanceMetricDefinitionsPager.
type EnvironmentsClientListMultiRolePoolInstanceMetricDefinitionsResponse struct {
	// Collection of metric definitions.
	ResourceMetricDefinitionCollection
}

// EnvironmentsClientListMultiRolePoolSKUsResponse contains the response from method EnvironmentsClient.NewListMultiRolePoolSKUsPager.
type EnvironmentsClientListMultiRolePoolSKUsResponse struct {
	// Collection of SKU information.
	SKUInfoCollection
}

// EnvironmentsClientListMultiRolePoolsResponse contains the response from method EnvironmentsClient.NewListMultiRolePoolsPager.
type EnvironmentsClientListMultiRolePoolsResponse struct {
	// Collection of worker pools.
	WorkerPoolCollection
}

// EnvironmentsClientListMultiRoleUsagesResponse contains the response from method EnvironmentsClient.NewListMultiRoleUsagesPager.
type EnvironmentsClientListMultiRoleUsagesResponse struct {
	// Collection of usages.
	UsageCollection
}

// EnvironmentsClientListOperationsResponse contains the response from method EnvironmentsClient.ListOperations.
type EnvironmentsClientListOperationsResponse struct {
	// Array of Operation
	OperationArray []*Operation
}

// EnvironmentsClientListResponse contains the response from method EnvironmentsClient.NewListPager.
type EnvironmentsClientListResponse struct {
	// Collection of App Service Environments.
	EnvironmentCollection
}

// EnvironmentsClientListUsagesResponse contains the response from method EnvironmentsClient.NewListUsagesPager.
type EnvironmentsClientListUsagesResponse struct {
	// Collection of CSM usage quotas.
	CsmUsageQuotaCollection
}

// EnvironmentsClientListWebAppsResponse contains the response from method EnvironmentsClient.NewListWebAppsPager.
type EnvironmentsClientListWebAppsResponse struct {
	// Collection of App Service apps.
	WebAppCollection
}

// EnvironmentsClientListWebWorkerMetricDefinitionsResponse contains the response from method EnvironmentsClient.NewListWebWorkerMetricDefinitionsPager.
type EnvironmentsClientListWebWorkerMetricDefinitionsResponse struct {
	// Collection of metric definitions.
	ResourceMetricDefinitionCollection
}

// EnvironmentsClientListWebWorkerUsagesResponse contains the response from method EnvironmentsClient.NewListWebWorkerUsagesPager.
type EnvironmentsClientListWebWorkerUsagesResponse struct {
	// Collection of usages.
	UsageCollection
}

// EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse contains the response from method EnvironmentsClient.NewListWorkerPoolInstanceMetricDefinitionsPager.
type EnvironmentsClientListWorkerPoolInstanceMetricDefinitionsResponse struct {
	// Collection of metric definitions.
	ResourceMetricDefinitionCollection
}

// EnvironmentsClientListWorkerPoolSKUsResponse contains the response from method EnvironmentsClient.NewListWorkerPoolSKUsPager.
type EnvironmentsClientListWorkerPoolSKUsResponse struct {
	// Collection of SKU information.
	SKUInfoCollection
}

// EnvironmentsClientListWorkerPoolsResponse contains the response from method EnvironmentsClient.NewListWorkerPoolsPager.
type EnvironmentsClientListWorkerPoolsResponse struct {
	// Collection of worker pools.
	WorkerPoolCollection
}

// EnvironmentsClientRebootResponse contains the response from method EnvironmentsClient.Reboot.
type EnvironmentsClientRebootResponse struct {
	// placeholder for future response values
}

// EnvironmentsClientResumeResponse contains the response from method EnvironmentsClient.BeginResume.
type EnvironmentsClientResumeResponse struct {
	// Collection of App Service apps.
	WebAppCollection
}

// EnvironmentsClientSuspendResponse contains the response from method EnvironmentsClient.BeginSuspend.
type EnvironmentsClientSuspendResponse struct {
	// Collection of App Service apps.
	WebAppCollection
}

// EnvironmentsClientTestUpgradeAvailableNotificationResponse contains the response from method EnvironmentsClient.TestUpgradeAvailableNotification.
type EnvironmentsClientTestUpgradeAvailableNotificationResponse struct {
	// placeholder for future response values
}

// EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse contains the response from method EnvironmentsClient.UpdateAseCustomDNSSuffixConfiguration.
type EnvironmentsClientUpdateAseCustomDNSSuffixConfigurationResponse struct {
	// Full view of the custom domain suffix configuration for ASEv3.
	CustomDNSSuffixConfiguration
}

// EnvironmentsClientUpdateAseNetworkingConfigurationResponse contains the response from method EnvironmentsClient.UpdateAseNetworkingConfiguration.
type EnvironmentsClientUpdateAseNetworkingConfigurationResponse struct {
	// Full view of networking configuration for an ASE.
	AseV3NetworkingConfiguration
}

// EnvironmentsClientUpdateMultiRolePoolResponse contains the response from method EnvironmentsClient.UpdateMultiRolePool.
type EnvironmentsClientUpdateMultiRolePoolResponse struct {
	// Worker pool of an App Service Environment ARM resource.
	WorkerPoolResource
}

// EnvironmentsClientUpdateResponse contains the response from method EnvironmentsClient.Update.
type EnvironmentsClientUpdateResponse struct {
	// App Service Environment ARM resource.
	EnvironmentResource
}

// EnvironmentsClientUpdateWorkerPoolResponse contains the response from method EnvironmentsClient.UpdateWorkerPool.
type EnvironmentsClientUpdateWorkerPoolResponse struct {
	// Worker pool of an App Service Environment ARM resource.
	WorkerPoolResource
}

// EnvironmentsClientUpgradeResponse contains the response from method EnvironmentsClient.BeginUpgrade.
type EnvironmentsClientUpgradeResponse struct {
	// placeholder for future response values
}

// GetUsagesInLocationClientListResponse contains the response from method GetUsagesInLocationClient.NewListPager.
type GetUsagesInLocationClientListResponse struct {
	// Collection of CSM usage quotas.
	CsmUsageQuotaCollection
}

// GlobalClientGetDeletedWebAppResponse contains the response from method GlobalClient.GetDeletedWebApp.
type GlobalClientGetDeletedWebAppResponse struct {
	// A deleted app.
	DeletedSite
}

// GlobalClientGetDeletedWebAppSnapshotsResponse contains the response from method GlobalClient.GetDeletedWebAppSnapshots.
type GlobalClientGetDeletedWebAppSnapshotsResponse struct {
	// Array of Snapshot
	SnapshotArray []*Snapshot
}

// GlobalClientGetSubscriptionOperationWithAsyncResponseResponse contains the response from method GlobalClient.GetSubscriptionOperationWithAsyncResponse.
type GlobalClientGetSubscriptionOperationWithAsyncResponseResponse struct {
	// placeholder for future response values
}

// KubeEnvironmentsClientCreateOrUpdateResponse contains the response from method KubeEnvironmentsClient.BeginCreateOrUpdate.
type KubeEnvironmentsClientCreateOrUpdateResponse struct {
	// A Kubernetes cluster specialized for web workloads by Azure App Service
	KubeEnvironment
}

// KubeEnvironmentsClientDeleteResponse contains the response from method KubeEnvironmentsClient.BeginDelete.
type KubeEnvironmentsClientDeleteResponse struct {
	// placeholder for future response values
}

// KubeEnvironmentsClientGetResponse contains the response from method KubeEnvironmentsClient.Get.
type KubeEnvironmentsClientGetResponse struct {
	// A Kubernetes cluster specialized for web workloads by Azure App Service
	KubeEnvironment
}

// KubeEnvironmentsClientListByResourceGroupResponse contains the response from method KubeEnvironmentsClient.NewListByResourceGroupPager.
type KubeEnvironmentsClientListByResourceGroupResponse struct {
	// Collection of Kubernetes Environments
	KubeEnvironmentCollection
}

// KubeEnvironmentsClientListBySubscriptionResponse contains the response from method KubeEnvironmentsClient.NewListBySubscriptionPager.
type KubeEnvironmentsClientListBySubscriptionResponse struct {
	// Collection of Kubernetes Environments
	KubeEnvironmentCollection
}

// KubeEnvironmentsClientUpdateResponse contains the response from method KubeEnvironmentsClient.Update.
type KubeEnvironmentsClientUpdateResponse struct {
	// A Kubernetes cluster specialized for web workloads by Azure App Service
	KubeEnvironment
}

// PlansClientCreateOrUpdateResponse contains the response from method PlansClient.BeginCreateOrUpdate.
type PlansClientCreateOrUpdateResponse struct {
	// App Service plan.
	Plan
}

// PlansClientCreateOrUpdateVnetRouteResponse contains the response from method PlansClient.CreateOrUpdateVnetRoute.
type PlansClientCreateOrUpdateVnetRouteResponse struct {
	// Virtual Network route contract used to pass routing information for a Virtual Network.
	VnetRoute
}

// PlansClientDeleteHybridConnectionResponse contains the response from method PlansClient.DeleteHybridConnection.
type PlansClientDeleteHybridConnectionResponse struct {
	// placeholder for future response values
}

// PlansClientDeleteResponse contains the response from method PlansClient.Delete.
type PlansClientDeleteResponse struct {
	// placeholder for future response values
}

// PlansClientDeleteVnetRouteResponse contains the response from method PlansClient.DeleteVnetRoute.
type PlansClientDeleteVnetRouteResponse struct {
	// placeholder for future response values
}

// PlansClientGetHybridConnectionPlanLimitResponse contains the response from method PlansClient.GetHybridConnectionPlanLimit.
type PlansClientGetHybridConnectionPlanLimitResponse struct {
	// Hybrid Connection limits contract. This is used to return the plan limits of Hybrid Connections.
	HybridConnectionLimits
}

// PlansClientGetHybridConnectionResponse contains the response from method PlansClient.GetHybridConnection.
type PlansClientGetHybridConnectionResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// PlansClientGetResponse contains the response from method PlansClient.Get.
type PlansClientGetResponse struct {
	// App Service plan.
	Plan
}

// PlansClientGetRouteForVnetResponse contains the response from method PlansClient.GetRouteForVnet.
type PlansClientGetRouteForVnetResponse struct {
	// Array of VnetRoute
	VnetRouteArray []*VnetRoute
}

// PlansClientGetServerFarmSKUsResponse contains the response from method PlansClient.GetServerFarmSKUs.
type PlansClientGetServerFarmSKUsResponse struct {
	// Anything
	Interface any
}

// PlansClientGetVnetFromServerFarmResponse contains the response from method PlansClient.GetVnetFromServerFarm.
type PlansClientGetVnetFromServerFarmResponse struct {
	// Virtual Network information ARM resource.
	VnetInfoResource
}

// PlansClientGetVnetGatewayResponse contains the response from method PlansClient.GetVnetGateway.
type PlansClientGetVnetGatewayResponse struct {
	// The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.
	VnetGateway
}

// PlansClientListByResourceGroupResponse contains the response from method PlansClient.NewListByResourceGroupPager.
type PlansClientListByResourceGroupResponse struct {
	// Collection of App Service plans.
	PlanCollection
}

// PlansClientListCapabilitiesResponse contains the response from method PlansClient.ListCapabilities.
type PlansClientListCapabilitiesResponse struct {
	// Array of Capability
	CapabilityArray []*Capability
}

// PlansClientListHybridConnectionKeysResponse contains the response from method PlansClient.ListHybridConnectionKeys.
type PlansClientListHybridConnectionKeysResponse struct {
	// Hybrid Connection key contract. This has the send key name and value for a Hybrid Connection.
	HybridConnectionKey
}

// PlansClientListHybridConnectionsResponse contains the response from method PlansClient.NewListHybridConnectionsPager.
type PlansClientListHybridConnectionsResponse struct {
	// Collection of hostname bindings.
	HybridConnectionCollection
}

// PlansClientListResponse contains the response from method PlansClient.NewListPager.
type PlansClientListResponse struct {
	// Collection of App Service plans.
	PlanCollection
}

// PlansClientListRoutesForVnetResponse contains the response from method PlansClient.ListRoutesForVnet.
type PlansClientListRoutesForVnetResponse struct {
	// Array of VnetRoute
	VnetRouteArray []*VnetRoute
}

// PlansClientListUsagesResponse contains the response from method PlansClient.NewListUsagesPager.
type PlansClientListUsagesResponse struct {
	// Collection of CSM usage quotas.
	CsmUsageQuotaCollection
}

// PlansClientListVnetsResponse contains the response from method PlansClient.ListVnets.
type PlansClientListVnetsResponse struct {
	// Array of VnetInfoResource
	VnetInfoResourceArray []*VnetInfoResource
}

// PlansClientListWebAppsByHybridConnectionResponse contains the response from method PlansClient.NewListWebAppsByHybridConnectionPager.
type PlansClientListWebAppsByHybridConnectionResponse struct {
	// Collection of resources.
	ResourceCollection
}

// PlansClientListWebAppsResponse contains the response from method PlansClient.NewListWebAppsPager.
type PlansClientListWebAppsResponse struct {
	// Collection of App Service apps.
	WebAppCollection
}

// PlansClientRebootWorkerResponse contains the response from method PlansClient.RebootWorker.
type PlansClientRebootWorkerResponse struct {
	// placeholder for future response values
}

// PlansClientRestartWebAppsResponse contains the response from method PlansClient.RestartWebApps.
type PlansClientRestartWebAppsResponse struct {
	// placeholder for future response values
}

// PlansClientUpdateResponse contains the response from method PlansClient.Update.
type PlansClientUpdateResponse struct {
	// App Service plan.
	Plan
}

// PlansClientUpdateVnetGatewayResponse contains the response from method PlansClient.UpdateVnetGateway.
type PlansClientUpdateVnetGatewayResponse struct {
	// The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.
	VnetGateway
}

// PlansClientUpdateVnetRouteResponse contains the response from method PlansClient.UpdateVnetRoute.
type PlansClientUpdateVnetRouteResponse struct {
	// Virtual Network route contract used to pass routing information for a Virtual Network.
	VnetRoute
}

// ProviderClientGetAvailableStacksOnPremResponse contains the response from method ProviderClient.NewGetAvailableStacksOnPremPager.
type ProviderClientGetAvailableStacksOnPremResponse struct {
	// Collection of Application Stacks
	ApplicationStackCollection
}

// ProviderClientGetAvailableStacksResponse contains the response from method ProviderClient.NewGetAvailableStacksPager.
type ProviderClientGetAvailableStacksResponse struct {
	// Collection of Application Stacks
	ApplicationStackCollection
}

// ProviderClientGetFunctionAppStacksForLocationResponse contains the response from method ProviderClient.NewGetFunctionAppStacksForLocationPager.
type ProviderClientGetFunctionAppStacksForLocationResponse struct {
	// Collection of Function app Stacks
	FunctionAppStackCollection
}

// ProviderClientGetFunctionAppStacksResponse contains the response from method ProviderClient.NewGetFunctionAppStacksPager.
type ProviderClientGetFunctionAppStacksResponse struct {
	// Collection of Function app Stacks
	FunctionAppStackCollection
}

// ProviderClientGetWebAppStacksForLocationResponse contains the response from method ProviderClient.NewGetWebAppStacksForLocationPager.
type ProviderClientGetWebAppStacksForLocationResponse struct {
	// Collection of Web app Stacks
	WebAppStackCollection
}

// ProviderClientGetWebAppStacksResponse contains the response from method ProviderClient.NewGetWebAppStacksPager.
type ProviderClientGetWebAppStacksResponse struct {
	// Collection of Web app Stacks
	WebAppStackCollection
}

// ProviderClientListOperationsResponse contains the response from method ProviderClient.NewListOperationsPager.
type ProviderClientListOperationsResponse struct {
	// Collection of Azure resource manager operation metadata.
	CsmOperationCollection
}

// RecommendationsClientDisableAllForHostingEnvironmentResponse contains the response from method RecommendationsClient.DisableAllForHostingEnvironment.
type RecommendationsClientDisableAllForHostingEnvironmentResponse struct {
	// placeholder for future response values
}

// RecommendationsClientDisableAllForWebAppResponse contains the response from method RecommendationsClient.DisableAllForWebApp.
type RecommendationsClientDisableAllForWebAppResponse struct {
	// placeholder for future response values
}

// RecommendationsClientDisableRecommendationForHostingEnvironmentResponse contains the response from method RecommendationsClient.DisableRecommendationForHostingEnvironment.
type RecommendationsClientDisableRecommendationForHostingEnvironmentResponse struct {
	// placeholder for future response values
}

// RecommendationsClientDisableRecommendationForSiteResponse contains the response from method RecommendationsClient.DisableRecommendationForSite.
type RecommendationsClientDisableRecommendationForSiteResponse struct {
	// placeholder for future response values
}

// RecommendationsClientDisableRecommendationForSubscriptionResponse contains the response from method RecommendationsClient.DisableRecommendationForSubscription.
type RecommendationsClientDisableRecommendationForSubscriptionResponse struct {
	// placeholder for future response values
}

// RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse contains the response from method RecommendationsClient.GetRuleDetailsByHostingEnvironment.
type RecommendationsClientGetRuleDetailsByHostingEnvironmentResponse struct {
	// Represents a recommendation rule that the recommendation engine can perform.
	RecommendationRule
}

// RecommendationsClientGetRuleDetailsByWebAppResponse contains the response from method RecommendationsClient.GetRuleDetailsByWebApp.
type RecommendationsClientGetRuleDetailsByWebAppResponse struct {
	// Represents a recommendation rule that the recommendation engine can perform.
	RecommendationRule
}

// RecommendationsClientListHistoryForHostingEnvironmentResponse contains the response from method RecommendationsClient.NewListHistoryForHostingEnvironmentPager.
type RecommendationsClientListHistoryForHostingEnvironmentResponse struct {
	// Collection of recommendations.
	RecommendationCollection
}

// RecommendationsClientListHistoryForWebAppResponse contains the response from method RecommendationsClient.NewListHistoryForWebAppPager.
type RecommendationsClientListHistoryForWebAppResponse struct {
	// Collection of recommendations.
	RecommendationCollection
}

// RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse contains the response from method RecommendationsClient.NewListRecommendedRulesForHostingEnvironmentPager.
type RecommendationsClientListRecommendedRulesForHostingEnvironmentResponse struct {
	// Collection of recommendations.
	RecommendationCollection
}

// RecommendationsClientListRecommendedRulesForWebAppResponse contains the response from method RecommendationsClient.NewListRecommendedRulesForWebAppPager.
type RecommendationsClientListRecommendedRulesForWebAppResponse struct {
	// Collection of recommendations.
	RecommendationCollection
}

// RecommendationsClientListResponse contains the response from method RecommendationsClient.NewListPager.
type RecommendationsClientListResponse struct {
	// Collection of recommendations.
	RecommendationCollection
}

// RecommendationsClientResetAllFiltersForHostingEnvironmentResponse contains the response from method RecommendationsClient.ResetAllFiltersForHostingEnvironment.
type RecommendationsClientResetAllFiltersForHostingEnvironmentResponse struct {
	// placeholder for future response values
}

// RecommendationsClientResetAllFiltersForWebAppResponse contains the response from method RecommendationsClient.ResetAllFiltersForWebApp.
type RecommendationsClientResetAllFiltersForWebAppResponse struct {
	// placeholder for future response values
}

// RecommendationsClientResetAllFiltersResponse contains the response from method RecommendationsClient.ResetAllFilters.
type RecommendationsClientResetAllFiltersResponse struct {
	// placeholder for future response values
}

// ResourceHealthMetadataClientGetBySiteResponse contains the response from method ResourceHealthMetadataClient.GetBySite.
type ResourceHealthMetadataClientGetBySiteResponse struct {
	// Used for getting ResourceHealthCheck settings.
	ResourceHealthMetadata
}

// ResourceHealthMetadataClientGetBySiteSlotResponse contains the response from method ResourceHealthMetadataClient.GetBySiteSlot.
type ResourceHealthMetadataClientGetBySiteSlotResponse struct {
	// Used for getting ResourceHealthCheck settings.
	ResourceHealthMetadata
}

// ResourceHealthMetadataClientListByResourceGroupResponse contains the response from method ResourceHealthMetadataClient.NewListByResourceGroupPager.
type ResourceHealthMetadataClientListByResourceGroupResponse struct {
	// Collection of resource health metadata.
	ResourceHealthMetadataCollection
}

// ResourceHealthMetadataClientListBySiteResponse contains the response from method ResourceHealthMetadataClient.NewListBySitePager.
type ResourceHealthMetadataClientListBySiteResponse struct {
	// Collection of resource health metadata.
	ResourceHealthMetadataCollection
}

// ResourceHealthMetadataClientListBySiteSlotResponse contains the response from method ResourceHealthMetadataClient.NewListBySiteSlotPager.
type ResourceHealthMetadataClientListBySiteSlotResponse struct {
	// Collection of resource health metadata.
	ResourceHealthMetadataCollection
}

// ResourceHealthMetadataClientListResponse contains the response from method ResourceHealthMetadataClient.NewListPager.
type ResourceHealthMetadataClientListResponse struct {
	// Collection of resource health metadata.
	ResourceHealthMetadataCollection
}

// StaticSitesClientApproveOrRejectPrivateEndpointConnectionResponse contains the response from method StaticSitesClient.BeginApproveOrRejectPrivateEndpointConnection.
type StaticSitesClientApproveOrRejectPrivateEndpointConnectionResponse struct {
	// Remote Private Endpoint Connection ARM resource.
	RemotePrivateEndpointConnectionARMResource
}

// StaticSitesClientCreateOrUpdateBasicAuthResponse contains the response from method StaticSitesClient.CreateOrUpdateBasicAuth.
type StaticSitesClientCreateOrUpdateBasicAuthResponse struct {
	// Static site basic auth properties ARM resource.
	StaticSiteBasicAuthPropertiesARMResource
}

// StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse contains the response from method StaticSitesClient.CreateOrUpdateBuildDatabaseConnection.
type StaticSitesClientCreateOrUpdateBuildDatabaseConnectionResponse struct {
	// Static Site Database Connection resource.
	DatabaseConnection
}

// StaticSitesClientCreateOrUpdateDatabaseConnectionResponse contains the response from method StaticSitesClient.CreateOrUpdateDatabaseConnection.
type StaticSitesClientCreateOrUpdateDatabaseConnectionResponse struct {
	// Static Site Database Connection resource.
	DatabaseConnection
}

// StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse contains the response from method StaticSitesClient.CreateOrUpdateStaticSiteAppSettings.
type StaticSitesClientCreateOrUpdateStaticSiteAppSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse contains the response from method StaticSitesClient.CreateOrUpdateStaticSiteBuildAppSettings.
type StaticSitesClientCreateOrUpdateStaticSiteBuildAppSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse contains the response from method StaticSitesClient.CreateOrUpdateStaticSiteBuildFunctionAppSettings.
type StaticSitesClientCreateOrUpdateStaticSiteBuildFunctionAppSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientCreateOrUpdateStaticSiteCustomDomainResponse contains the response from method StaticSitesClient.BeginCreateOrUpdateStaticSiteCustomDomain.
type StaticSitesClientCreateOrUpdateStaticSiteCustomDomainResponse struct {
	// Static Site Custom Domain Overview ARM resource.
	StaticSiteCustomDomainOverviewARMResource
}

// StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse contains the response from method StaticSitesClient.CreateOrUpdateStaticSiteFunctionAppSettings.
type StaticSitesClientCreateOrUpdateStaticSiteFunctionAppSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientCreateOrUpdateStaticSiteResponse contains the response from method StaticSitesClient.BeginCreateOrUpdateStaticSite.
type StaticSitesClientCreateOrUpdateStaticSiteResponse struct {
	// Static Site ARM resource.
	StaticSiteARMResource
}

// StaticSitesClientCreateUserRolesInvitationLinkResponse contains the response from method StaticSitesClient.CreateUserRolesInvitationLink.
type StaticSitesClientCreateUserRolesInvitationLinkResponse struct {
	// Static sites user roles invitation link resource.
	StaticSiteUserInvitationResponseResource
}

// StaticSitesClientCreateZipDeploymentForStaticSiteBuildResponse contains the response from method StaticSitesClient.BeginCreateZipDeploymentForStaticSiteBuild.
type StaticSitesClientCreateZipDeploymentForStaticSiteBuildResponse struct {
	// placeholder for future response values
}

// StaticSitesClientCreateZipDeploymentForStaticSiteResponse contains the response from method StaticSitesClient.BeginCreateZipDeploymentForStaticSite.
type StaticSitesClientCreateZipDeploymentForStaticSiteResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDeleteBuildDatabaseConnectionResponse contains the response from method StaticSitesClient.DeleteBuildDatabaseConnection.
type StaticSitesClientDeleteBuildDatabaseConnectionResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDeleteDatabaseConnectionResponse contains the response from method StaticSitesClient.DeleteDatabaseConnection.
type StaticSitesClientDeleteDatabaseConnectionResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDeletePrivateEndpointConnectionResponse contains the response from method StaticSitesClient.BeginDeletePrivateEndpointConnection.
type StaticSitesClientDeletePrivateEndpointConnectionResponse struct {
	// Anything
	Interface any
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StaticSitesClientDeletePrivateEndpointConnectionResponse.
func (s *StaticSitesClientDeletePrivateEndpointConnectionResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &s.Interface)
}

// StaticSitesClientDeleteStaticSiteBuildResponse contains the response from method StaticSitesClient.BeginDeleteStaticSiteBuild.
type StaticSitesClientDeleteStaticSiteBuildResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDeleteStaticSiteCustomDomainResponse contains the response from method StaticSitesClient.BeginDeleteStaticSiteCustomDomain.
type StaticSitesClientDeleteStaticSiteCustomDomainResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDeleteStaticSiteResponse contains the response from method StaticSitesClient.BeginDeleteStaticSite.
type StaticSitesClientDeleteStaticSiteResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDeleteStaticSiteUserResponse contains the response from method StaticSitesClient.DeleteStaticSiteUser.
type StaticSitesClientDeleteStaticSiteUserResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDetachStaticSiteResponse contains the response from method StaticSitesClient.BeginDetachStaticSite.
type StaticSitesClientDetachStaticSiteResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildResponse contains the response from method StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSiteBuild.
type StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteBuildResponse struct {
	// placeholder for future response values
}

// StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteResponse contains the response from method StaticSitesClient.DetachUserProvidedFunctionAppFromStaticSite.
type StaticSitesClientDetachUserProvidedFunctionAppFromStaticSiteResponse struct {
	// placeholder for future response values
}

// StaticSitesClientGetBasicAuthResponse contains the response from method StaticSitesClient.GetBasicAuth.
type StaticSitesClientGetBasicAuthResponse struct {
	// Static site basic auth properties ARM resource.
	StaticSiteBasicAuthPropertiesARMResource
}

// StaticSitesClientGetBuildDatabaseConnectionResponse contains the response from method StaticSitesClient.GetBuildDatabaseConnection.
type StaticSitesClientGetBuildDatabaseConnectionResponse struct {
	// Static Site Database Connection resource.
	DatabaseConnection
}

// StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse contains the response from method StaticSitesClient.GetBuildDatabaseConnectionWithDetails.
type StaticSitesClientGetBuildDatabaseConnectionWithDetailsResponse struct {
	// Static Site Database Connection resource.
	DatabaseConnection
}

// StaticSitesClientGetBuildDatabaseConnectionsResponse contains the response from method StaticSitesClient.NewGetBuildDatabaseConnectionsPager.
type StaticSitesClientGetBuildDatabaseConnectionsResponse struct {
	// Collection of static site database connections.
	DatabaseConnectionCollection
}

// StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse contains the response from method StaticSitesClient.NewGetBuildDatabaseConnectionsWithDetailsPager.
type StaticSitesClientGetBuildDatabaseConnectionsWithDetailsResponse struct {
	// Collection of static site database connections.
	DatabaseConnectionCollection
}

// StaticSitesClientGetDatabaseConnectionResponse contains the response from method StaticSitesClient.GetDatabaseConnection.
type StaticSitesClientGetDatabaseConnectionResponse struct {
	// Static Site Database Connection resource.
	DatabaseConnection
}

// StaticSitesClientGetDatabaseConnectionWithDetailsResponse contains the response from method StaticSitesClient.GetDatabaseConnectionWithDetails.
type StaticSitesClientGetDatabaseConnectionWithDetailsResponse struct {
	// Static Site Database Connection resource.
	DatabaseConnection
}

// StaticSitesClientGetDatabaseConnectionsResponse contains the response from method StaticSitesClient.NewGetDatabaseConnectionsPager.
type StaticSitesClientGetDatabaseConnectionsResponse struct {
	// Collection of static site database connections.
	DatabaseConnectionCollection
}

// StaticSitesClientGetDatabaseConnectionsWithDetailsResponse contains the response from method StaticSitesClient.NewGetDatabaseConnectionsWithDetailsPager.
type StaticSitesClientGetDatabaseConnectionsWithDetailsResponse struct {
	// Collection of static site database connections.
	DatabaseConnectionCollection
}

// StaticSitesClientGetLinkedBackendForBuildResponse contains the response from method StaticSitesClient.GetLinkedBackendForBuild.
type StaticSitesClientGetLinkedBackendForBuildResponse struct {
	// Static Site Linked Backend ARM resource.
	StaticSiteLinkedBackendARMResource
}

// StaticSitesClientGetLinkedBackendResponse contains the response from method StaticSitesClient.GetLinkedBackend.
type StaticSitesClientGetLinkedBackendResponse struct {
	// Static Site Linked Backend ARM resource.
	StaticSiteLinkedBackendARMResource
}

// StaticSitesClientGetLinkedBackendsForBuildResponse contains the response from method StaticSitesClient.NewGetLinkedBackendsForBuildPager.
type StaticSitesClientGetLinkedBackendsForBuildResponse struct {
	// Collection of static site linked backends.
	StaticSiteLinkedBackendsCollection
}

// StaticSitesClientGetLinkedBackendsResponse contains the response from method StaticSitesClient.NewGetLinkedBackendsPager.
type StaticSitesClientGetLinkedBackendsResponse struct {
	// Collection of static site linked backends.
	StaticSiteLinkedBackendsCollection
}

// StaticSitesClientGetPrivateEndpointConnectionListResponse contains the response from method StaticSitesClient.NewGetPrivateEndpointConnectionListPager.
type StaticSitesClientGetPrivateEndpointConnectionListResponse struct {
	PrivateEndpointConnectionCollection
}

// StaticSitesClientGetPrivateEndpointConnectionResponse contains the response from method StaticSitesClient.GetPrivateEndpointConnection.
type StaticSitesClientGetPrivateEndpointConnectionResponse struct {
	// Remote Private Endpoint Connection ARM resource.
	RemotePrivateEndpointConnectionARMResource
}

// StaticSitesClientGetPrivateLinkResourcesResponse contains the response from method StaticSitesClient.GetPrivateLinkResources.
type StaticSitesClientGetPrivateLinkResourcesResponse struct {
	// Wrapper for a collection of private link resources
	PrivateLinkResourcesWrapper
}

// StaticSitesClientGetStaticSiteBuildResponse contains the response from method StaticSitesClient.GetStaticSiteBuild.
type StaticSitesClientGetStaticSiteBuildResponse struct {
	// Static Site Build ARM resource.
	StaticSiteBuildARMResource
}

// StaticSitesClientGetStaticSiteBuildsResponse contains the response from method StaticSitesClient.NewGetStaticSiteBuildsPager.
type StaticSitesClientGetStaticSiteBuildsResponse struct {
	// Collection of static site builds.
	StaticSiteBuildCollection
}

// StaticSitesClientGetStaticSiteCustomDomainResponse contains the response from method StaticSitesClient.GetStaticSiteCustomDomain.
type StaticSitesClientGetStaticSiteCustomDomainResponse struct {
	// Static Site Custom Domain Overview ARM resource.
	StaticSiteCustomDomainOverviewARMResource
}

// StaticSitesClientGetStaticSiteResponse contains the response from method StaticSitesClient.GetStaticSite.
type StaticSitesClientGetStaticSiteResponse struct {
	// Static Site ARM resource.
	StaticSiteARMResource
}

// StaticSitesClientGetStaticSitesByResourceGroupResponse contains the response from method StaticSitesClient.NewGetStaticSitesByResourceGroupPager.
type StaticSitesClientGetStaticSitesByResourceGroupResponse struct {
	// Collection of static sites.
	StaticSiteCollection
}

// StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse contains the response from method StaticSitesClient.GetUserProvidedFunctionAppForStaticSiteBuild.
type StaticSitesClientGetUserProvidedFunctionAppForStaticSiteBuildResponse struct {
	// Static Site User Provided Function App ARM resource.
	StaticSiteUserProvidedFunctionAppARMResource
}

// StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse contains the response from method StaticSitesClient.GetUserProvidedFunctionAppForStaticSite.
type StaticSitesClientGetUserProvidedFunctionAppForStaticSiteResponse struct {
	// Static Site User Provided Function App ARM resource.
	StaticSiteUserProvidedFunctionAppARMResource
}

// StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse contains the response from method StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSiteBuildPager.
type StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteBuildResponse struct {
	// Collection of static site user provided function apps.
	StaticSiteUserProvidedFunctionAppsCollection
}

// StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse contains the response from method StaticSitesClient.NewGetUserProvidedFunctionAppsForStaticSitePager.
type StaticSitesClientGetUserProvidedFunctionAppsForStaticSiteResponse struct {
	// Collection of static site user provided function apps.
	StaticSiteUserProvidedFunctionAppsCollection
}

// StaticSitesClientLinkBackendResponse contains the response from method StaticSitesClient.BeginLinkBackend.
type StaticSitesClientLinkBackendResponse struct {
	// Static Site Linked Backend ARM resource.
	StaticSiteLinkedBackendARMResource
}

// StaticSitesClientLinkBackendToBuildResponse contains the response from method StaticSitesClient.BeginLinkBackendToBuild.
type StaticSitesClientLinkBackendToBuildResponse struct {
	// Static Site Linked Backend ARM resource.
	StaticSiteLinkedBackendARMResource
}

// StaticSitesClientListBasicAuthResponse contains the response from method StaticSitesClient.NewListBasicAuthPager.
type StaticSitesClientListBasicAuthResponse struct {
	// Collection of static site basic auth.
	StaticSiteBasicAuthPropertiesCollection
}

// StaticSitesClientListResponse contains the response from method StaticSitesClient.NewListPager.
type StaticSitesClientListResponse struct {
	// Collection of static sites.
	StaticSiteCollection
}

// StaticSitesClientListStaticSiteAppSettingsResponse contains the response from method StaticSitesClient.ListStaticSiteAppSettings.
type StaticSitesClientListStaticSiteAppSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientListStaticSiteBuildAppSettingsResponse contains the response from method StaticSitesClient.ListStaticSiteBuildAppSettings.
type StaticSitesClientListStaticSiteBuildAppSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse contains the response from method StaticSitesClient.ListStaticSiteBuildFunctionAppSettings.
type StaticSitesClientListStaticSiteBuildFunctionAppSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientListStaticSiteBuildFunctionsResponse contains the response from method StaticSitesClient.NewListStaticSiteBuildFunctionsPager.
type StaticSitesClientListStaticSiteBuildFunctionsResponse struct {
	// Collection of static site functions.
	StaticSiteFunctionOverviewCollection
}

// StaticSitesClientListStaticSiteConfiguredRolesResponse contains the response from method StaticSitesClient.ListStaticSiteConfiguredRoles.
type StaticSitesClientListStaticSiteConfiguredRolesResponse struct {
	// String list resource.
	StringList
}

// StaticSitesClientListStaticSiteCustomDomainsResponse contains the response from method StaticSitesClient.NewListStaticSiteCustomDomainsPager.
type StaticSitesClientListStaticSiteCustomDomainsResponse struct {
	// Collection of static site custom domains.
	StaticSiteCustomDomainOverviewCollection
}

// StaticSitesClientListStaticSiteFunctionAppSettingsResponse contains the response from method StaticSitesClient.ListStaticSiteFunctionAppSettings.
type StaticSitesClientListStaticSiteFunctionAppSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientListStaticSiteFunctionsResponse contains the response from method StaticSitesClient.NewListStaticSiteFunctionsPager.
type StaticSitesClientListStaticSiteFunctionsResponse struct {
	// Collection of static site functions.
	StaticSiteFunctionOverviewCollection
}

// StaticSitesClientListStaticSiteSecretsResponse contains the response from method StaticSitesClient.ListStaticSiteSecrets.
type StaticSitesClientListStaticSiteSecretsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// StaticSitesClientListStaticSiteUsersResponse contains the response from method StaticSitesClient.NewListStaticSiteUsersPager.
type StaticSitesClientListStaticSiteUsersResponse struct {
	// Collection of static site custom users.
	StaticSiteUserCollection
}

// StaticSitesClientPreviewWorkflowResponse contains the response from method StaticSitesClient.PreviewWorkflow.
type StaticSitesClientPreviewWorkflowResponse struct {
	// Preview for the Static Site Workflow to be generated
	StaticSitesWorkflowPreview
}

// StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteBuildResponse contains the response from method StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSiteBuild.
type StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteBuildResponse struct {
	// Static Site User Provided Function App ARM resource.
	StaticSiteUserProvidedFunctionAppARMResource
}

// StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteResponse contains the response from method StaticSitesClient.BeginRegisterUserProvidedFunctionAppWithStaticSite.
type StaticSitesClientRegisterUserProvidedFunctionAppWithStaticSiteResponse struct {
	// Static Site User Provided Function App ARM resource.
	StaticSiteUserProvidedFunctionAppARMResource
}

// StaticSitesClientResetStaticSiteAPIKeyResponse contains the response from method StaticSitesClient.ResetStaticSiteAPIKey.
type StaticSitesClientResetStaticSiteAPIKeyResponse struct {
	// placeholder for future response values
}

// StaticSitesClientUnlinkBackendFromBuildResponse contains the response from method StaticSitesClient.UnlinkBackendFromBuild.
type StaticSitesClientUnlinkBackendFromBuildResponse struct {
	// placeholder for future response values
}

// StaticSitesClientUnlinkBackendResponse contains the response from method StaticSitesClient.UnlinkBackend.
type StaticSitesClientUnlinkBackendResponse struct {
	// placeholder for future response values
}

// StaticSitesClientUpdateBuildDatabaseConnectionResponse contains the response from method StaticSitesClient.UpdateBuildDatabaseConnection.
type StaticSitesClientUpdateBuildDatabaseConnectionResponse struct {
	// Static Site Database Connection resource.
	DatabaseConnection
}

// StaticSitesClientUpdateDatabaseConnectionResponse contains the response from method StaticSitesClient.UpdateDatabaseConnection.
type StaticSitesClientUpdateDatabaseConnectionResponse struct {
	// Static Site Database Connection resource.
	DatabaseConnection
}

// StaticSitesClientUpdateStaticSiteResponse contains the response from method StaticSitesClient.UpdateStaticSite.
type StaticSitesClientUpdateStaticSiteResponse struct {
	// Static Site ARM resource.
	StaticSiteARMResource
}

// StaticSitesClientUpdateStaticSiteUserResponse contains the response from method StaticSitesClient.UpdateStaticSiteUser.
type StaticSitesClientUpdateStaticSiteUserResponse struct {
	// Static Site User ARM resource.
	StaticSiteUserARMResource
}

// StaticSitesClientValidateBackendForBuildResponse contains the response from method StaticSitesClient.BeginValidateBackendForBuild.
type StaticSitesClientValidateBackendForBuildResponse struct {
	// placeholder for future response values
}

// StaticSitesClientValidateBackendResponse contains the response from method StaticSitesClient.BeginValidateBackend.
type StaticSitesClientValidateBackendResponse struct {
	// placeholder for future response values
}

// StaticSitesClientValidateCustomDomainCanBeAddedToStaticSiteResponse contains the response from method StaticSitesClient.BeginValidateCustomDomainCanBeAddedToStaticSite.
type StaticSitesClientValidateCustomDomainCanBeAddedToStaticSiteResponse struct {
	// placeholder for future response values
}

// TopLevelDomainsClientGetResponse contains the response from method TopLevelDomainsClient.Get.
type TopLevelDomainsClientGetResponse struct {
	// A top level domain object.
	TopLevelDomain
}

// TopLevelDomainsClientListAgreementsResponse contains the response from method TopLevelDomainsClient.NewListAgreementsPager.
type TopLevelDomainsClientListAgreementsResponse struct {
	// Collection of top-level domain legal agreements.
	TldLegalAgreementCollection
}

// TopLevelDomainsClientListResponse contains the response from method TopLevelDomainsClient.NewListPager.
type TopLevelDomainsClientListResponse struct {
	// Collection of Top-level domains.
	TopLevelDomainCollection
}

// WebAppsClientAddPremierAddOnResponse contains the response from method WebAppsClient.AddPremierAddOn.
type WebAppsClientAddPremierAddOnResponse struct {
	// Premier add-on.
	PremierAddOn
}

// WebAppsClientAddPremierAddOnSlotResponse contains the response from method WebAppsClient.AddPremierAddOnSlot.
type WebAppsClientAddPremierAddOnSlotResponse struct {
	// Premier add-on.
	PremierAddOn
}

// WebAppsClientAnalyzeCustomHostnameResponse contains the response from method WebAppsClient.AnalyzeCustomHostname.
type WebAppsClientAnalyzeCustomHostnameResponse struct {
	// Custom domain analysis.
	CustomHostnameAnalysisResult
}

// WebAppsClientAnalyzeCustomHostnameSlotResponse contains the response from method WebAppsClient.AnalyzeCustomHostnameSlot.
type WebAppsClientAnalyzeCustomHostnameSlotResponse struct {
	// Custom domain analysis.
	CustomHostnameAnalysisResult
}

// WebAppsClientApplySlotConfigToProductionResponse contains the response from method WebAppsClient.ApplySlotConfigToProduction.
type WebAppsClientApplySlotConfigToProductionResponse struct {
	// placeholder for future response values
}

// WebAppsClientApplySlotConfigurationSlotResponse contains the response from method WebAppsClient.ApplySlotConfigurationSlot.
type WebAppsClientApplySlotConfigurationSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientApproveOrRejectPrivateEndpointConnectionResponse contains the response from method WebAppsClient.BeginApproveOrRejectPrivateEndpointConnection.
type WebAppsClientApproveOrRejectPrivateEndpointConnectionResponse struct {
	// Remote Private Endpoint Connection ARM resource.
	RemotePrivateEndpointConnectionARMResource
}

// WebAppsClientApproveOrRejectPrivateEndpointConnectionSlotResponse contains the response from method WebAppsClient.BeginApproveOrRejectPrivateEndpointConnectionSlot.
type WebAppsClientApproveOrRejectPrivateEndpointConnectionSlotResponse struct {
	// Remote Private Endpoint Connection ARM resource.
	RemotePrivateEndpointConnectionARMResource
}

// WebAppsClientBackupResponse contains the response from method WebAppsClient.Backup.
type WebAppsClientBackupResponse struct {
	// Backup description.
	BackupItem
}

// WebAppsClientBackupSlotResponse contains the response from method WebAppsClient.BackupSlot.
type WebAppsClientBackupSlotResponse struct {
	// Backup description.
	BackupItem
}

// WebAppsClientCreateDeploymentResponse contains the response from method WebAppsClient.CreateDeployment.
type WebAppsClientCreateDeploymentResponse struct {
	// User credentials used for publishing activity.
	Deployment
}

// WebAppsClientCreateDeploymentSlotResponse contains the response from method WebAppsClient.CreateDeploymentSlot.
type WebAppsClientCreateDeploymentSlotResponse struct {
	// User credentials used for publishing activity.
	Deployment
}

// WebAppsClientCreateFunctionResponse contains the response from method WebAppsClient.BeginCreateFunction.
type WebAppsClientCreateFunctionResponse struct {
	// Function information.
	FunctionEnvelope
}

// WebAppsClientCreateInstanceFunctionSlotResponse contains the response from method WebAppsClient.BeginCreateInstanceFunctionSlot.
type WebAppsClientCreateInstanceFunctionSlotResponse struct {
	// Function information.
	FunctionEnvelope
}

// WebAppsClientCreateInstanceMSDeployOperationResponse contains the response from method WebAppsClient.BeginCreateInstanceMSDeployOperation.
type WebAppsClientCreateInstanceMSDeployOperationResponse struct {
	// MSDeploy ARM response
	MSDeployStatus
}

// WebAppsClientCreateInstanceMSDeployOperationSlotResponse contains the response from method WebAppsClient.BeginCreateInstanceMSDeployOperationSlot.
type WebAppsClientCreateInstanceMSDeployOperationSlotResponse struct {
	// MSDeploy ARM response
	MSDeployStatus
}

// WebAppsClientCreateMSDeployOperationResponse contains the response from method WebAppsClient.BeginCreateMSDeployOperation.
type WebAppsClientCreateMSDeployOperationResponse struct {
	// MSDeploy ARM response
	MSDeployStatus
}

// WebAppsClientCreateMSDeployOperationSlotResponse contains the response from method WebAppsClient.BeginCreateMSDeployOperationSlot.
type WebAppsClientCreateMSDeployOperationSlotResponse struct {
	// MSDeploy ARM response
	MSDeployStatus
}

// WebAppsClientCreateOneDeployOperationResponse contains the response from method WebAppsClient.CreateOneDeployOperation.
type WebAppsClientCreateOneDeployOperationResponse struct {
	// Anything
	Interface any
}

// WebAppsClientCreateOrUpdateConfigurationResponse contains the response from method WebAppsClient.CreateOrUpdateConfiguration.
type WebAppsClientCreateOrUpdateConfigurationResponse struct {
	// Web app configuration ARM resource.
	SiteConfigResource
}

// WebAppsClientCreateOrUpdateConfigurationSlotResponse contains the response from method WebAppsClient.CreateOrUpdateConfigurationSlot.
type WebAppsClientCreateOrUpdateConfigurationSlotResponse struct {
	// Web app configuration ARM resource.
	SiteConfigResource
}

// WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse contains the response from method WebAppsClient.CreateOrUpdateDomainOwnershipIdentifier.
type WebAppsClientCreateOrUpdateDomainOwnershipIdentifierResponse struct {
	// A domain specific resource identifier.
	Identifier
}

// WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse contains the response from method WebAppsClient.CreateOrUpdateDomainOwnershipIdentifierSlot.
type WebAppsClientCreateOrUpdateDomainOwnershipIdentifierSlotResponse struct {
	// A domain specific resource identifier.
	Identifier
}

// WebAppsClientCreateOrUpdateFunctionSecretResponse contains the response from method WebAppsClient.CreateOrUpdateFunctionSecret.
type WebAppsClientCreateOrUpdateFunctionSecretResponse struct {
	// Function key info.
	KeyInfo
}

// WebAppsClientCreateOrUpdateFunctionSecretSlotResponse contains the response from method WebAppsClient.CreateOrUpdateFunctionSecretSlot.
type WebAppsClientCreateOrUpdateFunctionSecretSlotResponse struct {
	// Function key info.
	KeyInfo
}

// WebAppsClientCreateOrUpdateHostNameBindingResponse contains the response from method WebAppsClient.CreateOrUpdateHostNameBinding.
type WebAppsClientCreateOrUpdateHostNameBindingResponse struct {
	// A hostname binding object.
	HostNameBinding
}

// WebAppsClientCreateOrUpdateHostNameBindingSlotResponse contains the response from method WebAppsClient.CreateOrUpdateHostNameBindingSlot.
type WebAppsClientCreateOrUpdateHostNameBindingSlotResponse struct {
	// A hostname binding object.
	HostNameBinding
}

// WebAppsClientCreateOrUpdateHostSecretResponse contains the response from method WebAppsClient.CreateOrUpdateHostSecret.
type WebAppsClientCreateOrUpdateHostSecretResponse struct {
	// Function key info.
	KeyInfo
}

// WebAppsClientCreateOrUpdateHostSecretSlotResponse contains the response from method WebAppsClient.CreateOrUpdateHostSecretSlot.
type WebAppsClientCreateOrUpdateHostSecretSlotResponse struct {
	// Function key info.
	KeyInfo
}

// WebAppsClientCreateOrUpdateHybridConnectionResponse contains the response from method WebAppsClient.CreateOrUpdateHybridConnection.
type WebAppsClientCreateOrUpdateHybridConnectionResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// WebAppsClientCreateOrUpdateHybridConnectionSlotResponse contains the response from method WebAppsClient.CreateOrUpdateHybridConnectionSlot.
type WebAppsClientCreateOrUpdateHybridConnectionSlotResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// WebAppsClientCreateOrUpdatePublicCertificateResponse contains the response from method WebAppsClient.CreateOrUpdatePublicCertificate.
type WebAppsClientCreateOrUpdatePublicCertificateResponse struct {
	// Public certificate object
	PublicCertificate
}

// WebAppsClientCreateOrUpdatePublicCertificateSlotResponse contains the response from method WebAppsClient.CreateOrUpdatePublicCertificateSlot.
type WebAppsClientCreateOrUpdatePublicCertificateSlotResponse struct {
	// Public certificate object
	PublicCertificate
}

// WebAppsClientCreateOrUpdateRelayServiceConnectionResponse contains the response from method WebAppsClient.CreateOrUpdateRelayServiceConnection.
type WebAppsClientCreateOrUpdateRelayServiceConnectionResponse struct {
	// Hybrid Connection for an App Service app.
	RelayServiceConnectionEntity
}

// WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse contains the response from method WebAppsClient.CreateOrUpdateRelayServiceConnectionSlot.
type WebAppsClientCreateOrUpdateRelayServiceConnectionSlotResponse struct {
	// Hybrid Connection for an App Service app.
	RelayServiceConnectionEntity
}

// WebAppsClientCreateOrUpdateResponse contains the response from method WebAppsClient.BeginCreateOrUpdate.
type WebAppsClientCreateOrUpdateResponse struct {
	// A web app, a mobile app backend, or an API app.
	Site
}

// WebAppsClientCreateOrUpdateSlotResponse contains the response from method WebAppsClient.BeginCreateOrUpdateSlot.
type WebAppsClientCreateOrUpdateSlotResponse struct {
	// A web app, a mobile app backend, or an API app.
	Site
}

// WebAppsClientCreateOrUpdateSourceControlResponse contains the response from method WebAppsClient.BeginCreateOrUpdateSourceControl.
type WebAppsClientCreateOrUpdateSourceControlResponse struct {
	// Source control configuration for an app.
	SiteSourceControl
}

// WebAppsClientCreateOrUpdateSourceControlSlotResponse contains the response from method WebAppsClient.BeginCreateOrUpdateSourceControlSlot.
type WebAppsClientCreateOrUpdateSourceControlSlotResponse struct {
	// Source control configuration for an app.
	SiteSourceControl
}

// WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse contains the response from method WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck.
type WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckResponse struct {
	// Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
	SwiftVirtualNetwork
}

// WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse contains the response from method WebAppsClient.CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot.
type WebAppsClientCreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse struct {
	// Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
	SwiftVirtualNetwork
}

// WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse contains the response from method WebAppsClient.CreateOrUpdateVnetConnectionGateway.
type WebAppsClientCreateOrUpdateVnetConnectionGatewayResponse struct {
	// The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.
	VnetGateway
}

// WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse contains the response from method WebAppsClient.CreateOrUpdateVnetConnectionGatewaySlot.
type WebAppsClientCreateOrUpdateVnetConnectionGatewaySlotResponse struct {
	// The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.
	VnetGateway
}

// WebAppsClientCreateOrUpdateVnetConnectionResponse contains the response from method WebAppsClient.CreateOrUpdateVnetConnection.
type WebAppsClientCreateOrUpdateVnetConnectionResponse struct {
	// Virtual Network information ARM resource.
	VnetInfoResource
}

// WebAppsClientCreateOrUpdateVnetConnectionSlotResponse contains the response from method WebAppsClient.CreateOrUpdateVnetConnectionSlot.
type WebAppsClientCreateOrUpdateVnetConnectionSlotResponse struct {
	// Virtual Network information ARM resource.
	VnetInfoResource
}

// WebAppsClientDeleteBackupConfigurationResponse contains the response from method WebAppsClient.DeleteBackupConfiguration.
type WebAppsClientDeleteBackupConfigurationResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteBackupConfigurationSlotResponse contains the response from method WebAppsClient.DeleteBackupConfigurationSlot.
type WebAppsClientDeleteBackupConfigurationSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteBackupResponse contains the response from method WebAppsClient.DeleteBackup.
type WebAppsClientDeleteBackupResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteBackupSlotResponse contains the response from method WebAppsClient.DeleteBackupSlot.
type WebAppsClientDeleteBackupSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteContinuousWebJobResponse contains the response from method WebAppsClient.DeleteContinuousWebJob.
type WebAppsClientDeleteContinuousWebJobResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteContinuousWebJobSlotResponse contains the response from method WebAppsClient.DeleteContinuousWebJobSlot.
type WebAppsClientDeleteContinuousWebJobSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteDeploymentResponse contains the response from method WebAppsClient.DeleteDeployment.
type WebAppsClientDeleteDeploymentResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteDeploymentSlotResponse contains the response from method WebAppsClient.DeleteDeploymentSlot.
type WebAppsClientDeleteDeploymentSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteDomainOwnershipIdentifierResponse contains the response from method WebAppsClient.DeleteDomainOwnershipIdentifier.
type WebAppsClientDeleteDomainOwnershipIdentifierResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteDomainOwnershipIdentifierSlotResponse contains the response from method WebAppsClient.DeleteDomainOwnershipIdentifierSlot.
type WebAppsClientDeleteDomainOwnershipIdentifierSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteFunctionResponse contains the response from method WebAppsClient.DeleteFunction.
type WebAppsClientDeleteFunctionResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteFunctionSecretResponse contains the response from method WebAppsClient.DeleteFunctionSecret.
type WebAppsClientDeleteFunctionSecretResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteFunctionSecretSlotResponse contains the response from method WebAppsClient.DeleteFunctionSecretSlot.
type WebAppsClientDeleteFunctionSecretSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteHostNameBindingResponse contains the response from method WebAppsClient.DeleteHostNameBinding.
type WebAppsClientDeleteHostNameBindingResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteHostNameBindingSlotResponse contains the response from method WebAppsClient.DeleteHostNameBindingSlot.
type WebAppsClientDeleteHostNameBindingSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteHostSecretResponse contains the response from method WebAppsClient.DeleteHostSecret.
type WebAppsClientDeleteHostSecretResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteHostSecretSlotResponse contains the response from method WebAppsClient.DeleteHostSecretSlot.
type WebAppsClientDeleteHostSecretSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteHybridConnectionResponse contains the response from method WebAppsClient.DeleteHybridConnection.
type WebAppsClientDeleteHybridConnectionResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteHybridConnectionSlotResponse contains the response from method WebAppsClient.DeleteHybridConnectionSlot.
type WebAppsClientDeleteHybridConnectionSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteInstanceFunctionSlotResponse contains the response from method WebAppsClient.DeleteInstanceFunctionSlot.
type WebAppsClientDeleteInstanceFunctionSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteInstanceProcessResponse contains the response from method WebAppsClient.DeleteInstanceProcess.
type WebAppsClientDeleteInstanceProcessResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteInstanceProcessSlotResponse contains the response from method WebAppsClient.DeleteInstanceProcessSlot.
type WebAppsClientDeleteInstanceProcessSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeletePremierAddOnResponse contains the response from method WebAppsClient.DeletePremierAddOn.
type WebAppsClientDeletePremierAddOnResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeletePremierAddOnSlotResponse contains the response from method WebAppsClient.DeletePremierAddOnSlot.
type WebAppsClientDeletePremierAddOnSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeletePrivateEndpointConnectionResponse contains the response from method WebAppsClient.BeginDeletePrivateEndpointConnection.
type WebAppsClientDeletePrivateEndpointConnectionResponse struct {
	// Anything
	Interface any
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppsClientDeletePrivateEndpointConnectionResponse.
func (w *WebAppsClientDeletePrivateEndpointConnectionResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &w.Interface)
}

// WebAppsClientDeletePrivateEndpointConnectionSlotResponse contains the response from method WebAppsClient.BeginDeletePrivateEndpointConnectionSlot.
type WebAppsClientDeletePrivateEndpointConnectionSlotResponse struct {
	// Anything
	Interface any
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppsClientDeletePrivateEndpointConnectionSlotResponse.
func (w *WebAppsClientDeletePrivateEndpointConnectionSlotResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &w.Interface)
}

// WebAppsClientDeleteProcessResponse contains the response from method WebAppsClient.DeleteProcess.
type WebAppsClientDeleteProcessResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteProcessSlotResponse contains the response from method WebAppsClient.DeleteProcessSlot.
type WebAppsClientDeleteProcessSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeletePublicCertificateResponse contains the response from method WebAppsClient.DeletePublicCertificate.
type WebAppsClientDeletePublicCertificateResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeletePublicCertificateSlotResponse contains the response from method WebAppsClient.DeletePublicCertificateSlot.
type WebAppsClientDeletePublicCertificateSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteRelayServiceConnectionResponse contains the response from method WebAppsClient.DeleteRelayServiceConnection.
type WebAppsClientDeleteRelayServiceConnectionResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteRelayServiceConnectionSlotResponse contains the response from method WebAppsClient.DeleteRelayServiceConnectionSlot.
type WebAppsClientDeleteRelayServiceConnectionSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteResponse contains the response from method WebAppsClient.Delete.
type WebAppsClientDeleteResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteSiteExtensionResponse contains the response from method WebAppsClient.DeleteSiteExtension.
type WebAppsClientDeleteSiteExtensionResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteSiteExtensionSlotResponse contains the response from method WebAppsClient.DeleteSiteExtensionSlot.
type WebAppsClientDeleteSiteExtensionSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteSlotResponse contains the response from method WebAppsClient.DeleteSlot.
type WebAppsClientDeleteSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteSourceControlResponse contains the response from method WebAppsClient.DeleteSourceControl.
type WebAppsClientDeleteSourceControlResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteSourceControlSlotResponse contains the response from method WebAppsClient.DeleteSourceControlSlot.
type WebAppsClientDeleteSourceControlSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteSwiftVirtualNetworkResponse contains the response from method WebAppsClient.DeleteSwiftVirtualNetwork.
type WebAppsClientDeleteSwiftVirtualNetworkResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteSwiftVirtualNetworkSlotResponse contains the response from method WebAppsClient.DeleteSwiftVirtualNetworkSlot.
type WebAppsClientDeleteSwiftVirtualNetworkSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteTriggeredWebJobResponse contains the response from method WebAppsClient.DeleteTriggeredWebJob.
type WebAppsClientDeleteTriggeredWebJobResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteTriggeredWebJobSlotResponse contains the response from method WebAppsClient.DeleteTriggeredWebJobSlot.
type WebAppsClientDeleteTriggeredWebJobSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteVnetConnectionResponse contains the response from method WebAppsClient.DeleteVnetConnection.
type WebAppsClientDeleteVnetConnectionResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeleteVnetConnectionSlotResponse contains the response from method WebAppsClient.DeleteVnetConnectionSlot.
type WebAppsClientDeleteVnetConnectionSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeployWorkflowArtifactsResponse contains the response from method WebAppsClient.DeployWorkflowArtifacts.
type WebAppsClientDeployWorkflowArtifactsResponse struct {
	// placeholder for future response values
}

// WebAppsClientDeployWorkflowArtifactsSlotResponse contains the response from method WebAppsClient.DeployWorkflowArtifactsSlot.
type WebAppsClientDeployWorkflowArtifactsSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientDiscoverBackupResponse contains the response from method WebAppsClient.DiscoverBackup.
type WebAppsClientDiscoverBackupResponse struct {
	// Description of a restore request.
	RestoreRequest
}

// WebAppsClientDiscoverBackupSlotResponse contains the response from method WebAppsClient.DiscoverBackupSlot.
type WebAppsClientDiscoverBackupSlotResponse struct {
	// Description of a restore request.
	RestoreRequest
}

// WebAppsClientGenerateNewSitePublishingPasswordResponse contains the response from method WebAppsClient.GenerateNewSitePublishingPassword.
type WebAppsClientGenerateNewSitePublishingPasswordResponse struct {
	// placeholder for future response values
}

// WebAppsClientGenerateNewSitePublishingPasswordSlotResponse contains the response from method WebAppsClient.GenerateNewSitePublishingPasswordSlot.
type WebAppsClientGenerateNewSitePublishingPasswordSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientGetAppSettingKeyVaultReferenceResponse contains the response from method WebAppsClient.GetAppSettingKeyVaultReference.
type WebAppsClientGetAppSettingKeyVaultReferenceResponse struct {
	// Description of site key vault references.
	APIKVReference
}

// WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse contains the response from method WebAppsClient.GetAppSettingKeyVaultReferenceSlot.
type WebAppsClientGetAppSettingKeyVaultReferenceSlotResponse struct {
	// Description of site key vault references.
	APIKVReference
}

// WebAppsClientGetAppSettingsKeyVaultReferencesResponse contains the response from method WebAppsClient.NewGetAppSettingsKeyVaultReferencesPager.
type WebAppsClientGetAppSettingsKeyVaultReferencesResponse struct {
	APIKVReferenceCollection
}

// WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse contains the response from method WebAppsClient.NewGetAppSettingsKeyVaultReferencesSlotPager.
type WebAppsClientGetAppSettingsKeyVaultReferencesSlotResponse struct {
	APIKVReferenceCollection
}

// WebAppsClientGetAuthSettingsResponse contains the response from method WebAppsClient.GetAuthSettings.
type WebAppsClientGetAuthSettingsResponse struct {
	// Configuration settings for the Azure App Service Authentication / Authorization feature.
	SiteAuthSettings
}

// WebAppsClientGetAuthSettingsSlotResponse contains the response from method WebAppsClient.GetAuthSettingsSlot.
type WebAppsClientGetAuthSettingsSlotResponse struct {
	// Configuration settings for the Azure App Service Authentication / Authorization feature.
	SiteAuthSettings
}

// WebAppsClientGetAuthSettingsV2Response contains the response from method WebAppsClient.GetAuthSettingsV2.
type WebAppsClientGetAuthSettingsV2Response struct {
	// Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
	SiteAuthSettingsV2
}

// WebAppsClientGetAuthSettingsV2SlotResponse contains the response from method WebAppsClient.GetAuthSettingsV2Slot.
type WebAppsClientGetAuthSettingsV2SlotResponse struct {
	// Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
	SiteAuthSettingsV2
}

// WebAppsClientGetAuthSettingsV2WithoutSecretsResponse contains the response from method WebAppsClient.GetAuthSettingsV2WithoutSecrets.
type WebAppsClientGetAuthSettingsV2WithoutSecretsResponse struct {
	// Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
	SiteAuthSettingsV2
}

// WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse contains the response from method WebAppsClient.GetAuthSettingsV2WithoutSecretsSlot.
type WebAppsClientGetAuthSettingsV2WithoutSecretsSlotResponse struct {
	// Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
	SiteAuthSettingsV2
}

// WebAppsClientGetBackupConfigurationResponse contains the response from method WebAppsClient.GetBackupConfiguration.
type WebAppsClientGetBackupConfigurationResponse struct {
	// Description of a backup which will be performed.
	BackupRequest
}

// WebAppsClientGetBackupConfigurationSlotResponse contains the response from method WebAppsClient.GetBackupConfigurationSlot.
type WebAppsClientGetBackupConfigurationSlotResponse struct {
	// Description of a backup which will be performed.
	BackupRequest
}

// WebAppsClientGetBackupStatusResponse contains the response from method WebAppsClient.GetBackupStatus.
type WebAppsClientGetBackupStatusResponse struct {
	// Backup description.
	BackupItem
}

// WebAppsClientGetBackupStatusSlotResponse contains the response from method WebAppsClient.GetBackupStatusSlot.
type WebAppsClientGetBackupStatusSlotResponse struct {
	// Backup description.
	BackupItem
}

// WebAppsClientGetConfigurationResponse contains the response from method WebAppsClient.GetConfiguration.
type WebAppsClientGetConfigurationResponse struct {
	// Web app configuration ARM resource.
	SiteConfigResource
}

// WebAppsClientGetConfigurationSlotResponse contains the response from method WebAppsClient.GetConfigurationSlot.
type WebAppsClientGetConfigurationSlotResponse struct {
	// Web app configuration ARM resource.
	SiteConfigResource
}

// WebAppsClientGetConfigurationSnapshotResponse contains the response from method WebAppsClient.GetConfigurationSnapshot.
type WebAppsClientGetConfigurationSnapshotResponse struct {
	// Web app configuration ARM resource.
	SiteConfigResource
}

// WebAppsClientGetConfigurationSnapshotSlotResponse contains the response from method WebAppsClient.GetConfigurationSnapshotSlot.
type WebAppsClientGetConfigurationSnapshotSlotResponse struct {
	// Web app configuration ARM resource.
	SiteConfigResource
}

// WebAppsClientGetContainerLogsZipResponse contains the response from method WebAppsClient.GetContainerLogsZip.
type WebAppsClientGetContainerLogsZipResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientGetContainerLogsZipSlotResponse contains the response from method WebAppsClient.GetContainerLogsZipSlot.
type WebAppsClientGetContainerLogsZipSlotResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientGetContinuousWebJobResponse contains the response from method WebAppsClient.GetContinuousWebJob.
type WebAppsClientGetContinuousWebJobResponse struct {
	// Continuous Web Job Information.
	ContinuousWebJob
}

// WebAppsClientGetContinuousWebJobSlotResponse contains the response from method WebAppsClient.GetContinuousWebJobSlot.
type WebAppsClientGetContinuousWebJobSlotResponse struct {
	// Continuous Web Job Information.
	ContinuousWebJob
}

// WebAppsClientGetDeploymentResponse contains the response from method WebAppsClient.GetDeployment.
type WebAppsClientGetDeploymentResponse struct {
	// User credentials used for publishing activity.
	Deployment
}

// WebAppsClientGetDeploymentSlotResponse contains the response from method WebAppsClient.GetDeploymentSlot.
type WebAppsClientGetDeploymentSlotResponse struct {
	// User credentials used for publishing activity.
	Deployment
}

// WebAppsClientGetDiagnosticLogsConfigurationResponse contains the response from method WebAppsClient.GetDiagnosticLogsConfiguration.
type WebAppsClientGetDiagnosticLogsConfigurationResponse struct {
	// Configuration of App Service site logs.
	SiteLogsConfig
}

// WebAppsClientGetDiagnosticLogsConfigurationSlotResponse contains the response from method WebAppsClient.GetDiagnosticLogsConfigurationSlot.
type WebAppsClientGetDiagnosticLogsConfigurationSlotResponse struct {
	// Configuration of App Service site logs.
	SiteLogsConfig
}

// WebAppsClientGetDomainOwnershipIdentifierResponse contains the response from method WebAppsClient.GetDomainOwnershipIdentifier.
type WebAppsClientGetDomainOwnershipIdentifierResponse struct {
	// A domain specific resource identifier.
	Identifier
}

// WebAppsClientGetDomainOwnershipIdentifierSlotResponse contains the response from method WebAppsClient.GetDomainOwnershipIdentifierSlot.
type WebAppsClientGetDomainOwnershipIdentifierSlotResponse struct {
	// A domain specific resource identifier.
	Identifier
}

// WebAppsClientGetFtpAllowedResponse contains the response from method WebAppsClient.GetFtpAllowed.
type WebAppsClientGetFtpAllowedResponse struct {
	// Publishing Credentials Policies parameters.
	CsmPublishingCredentialsPoliciesEntity
}

// WebAppsClientGetFtpAllowedSlotResponse contains the response from method WebAppsClient.GetFtpAllowedSlot.
type WebAppsClientGetFtpAllowedSlotResponse struct {
	// Publishing Credentials Policies parameters.
	CsmPublishingCredentialsPoliciesEntity
}

// WebAppsClientGetFunctionResponse contains the response from method WebAppsClient.GetFunction.
type WebAppsClientGetFunctionResponse struct {
	// Function information.
	FunctionEnvelope
}

// WebAppsClientGetFunctionsAdminTokenResponse contains the response from method WebAppsClient.GetFunctionsAdminToken.
type WebAppsClientGetFunctionsAdminTokenResponse struct {
	Value *string
}

// WebAppsClientGetFunctionsAdminTokenSlotResponse contains the response from method WebAppsClient.GetFunctionsAdminTokenSlot.
type WebAppsClientGetFunctionsAdminTokenSlotResponse struct {
	Value *string
}

// WebAppsClientGetHostNameBindingResponse contains the response from method WebAppsClient.GetHostNameBinding.
type WebAppsClientGetHostNameBindingResponse struct {
	// A hostname binding object.
	HostNameBinding
}

// WebAppsClientGetHostNameBindingSlotResponse contains the response from method WebAppsClient.GetHostNameBindingSlot.
type WebAppsClientGetHostNameBindingSlotResponse struct {
	// A hostname binding object.
	HostNameBinding
}

// WebAppsClientGetHybridConnectionResponse contains the response from method WebAppsClient.GetHybridConnection.
type WebAppsClientGetHybridConnectionResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// WebAppsClientGetHybridConnectionSlotResponse contains the response from method WebAppsClient.GetHybridConnectionSlot.
type WebAppsClientGetHybridConnectionSlotResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// WebAppsClientGetInstanceFunctionSlotResponse contains the response from method WebAppsClient.GetInstanceFunctionSlot.
type WebAppsClientGetInstanceFunctionSlotResponse struct {
	// Function information.
	FunctionEnvelope
}

// WebAppsClientGetInstanceInfoResponse contains the response from method WebAppsClient.GetInstanceInfo.
type WebAppsClientGetInstanceInfoResponse struct {
	WebSiteInstanceStatus
}

// WebAppsClientGetInstanceInfoSlotResponse contains the response from method WebAppsClient.GetInstanceInfoSlot.
type WebAppsClientGetInstanceInfoSlotResponse struct {
	WebSiteInstanceStatus
}

// WebAppsClientGetInstanceMSDeployLogResponse contains the response from method WebAppsClient.GetInstanceMSDeployLog.
type WebAppsClientGetInstanceMSDeployLogResponse struct {
	// MSDeploy log
	MSDeployLog
}

// WebAppsClientGetInstanceMSDeployLogSlotResponse contains the response from method WebAppsClient.GetInstanceMSDeployLogSlot.
type WebAppsClientGetInstanceMSDeployLogSlotResponse struct {
	// MSDeploy log
	MSDeployLog
}

// WebAppsClientGetInstanceMsDeployStatusResponse contains the response from method WebAppsClient.GetInstanceMsDeployStatus.
type WebAppsClientGetInstanceMsDeployStatusResponse struct {
	// MSDeploy ARM response
	MSDeployStatus
}

// WebAppsClientGetInstanceMsDeployStatusSlotResponse contains the response from method WebAppsClient.GetInstanceMsDeployStatusSlot.
type WebAppsClientGetInstanceMsDeployStatusSlotResponse struct {
	// MSDeploy ARM response
	MSDeployStatus
}

// WebAppsClientGetInstanceProcessDumpResponse contains the response from method WebAppsClient.GetInstanceProcessDump.
type WebAppsClientGetInstanceProcessDumpResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientGetInstanceProcessDumpSlotResponse contains the response from method WebAppsClient.GetInstanceProcessDumpSlot.
type WebAppsClientGetInstanceProcessDumpSlotResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientGetInstanceProcessModuleResponse contains the response from method WebAppsClient.GetInstanceProcessModule.
type WebAppsClientGetInstanceProcessModuleResponse struct {
	// Process Module Information.
	ProcessModuleInfo
}

// WebAppsClientGetInstanceProcessModuleSlotResponse contains the response from method WebAppsClient.GetInstanceProcessModuleSlot.
type WebAppsClientGetInstanceProcessModuleSlotResponse struct {
	// Process Module Information.
	ProcessModuleInfo
}

// WebAppsClientGetInstanceProcessResponse contains the response from method WebAppsClient.GetInstanceProcess.
type WebAppsClientGetInstanceProcessResponse struct {
	// Process Information.
	ProcessInfo
}

// WebAppsClientGetInstanceProcessSlotResponse contains the response from method WebAppsClient.GetInstanceProcessSlot.
type WebAppsClientGetInstanceProcessSlotResponse struct {
	// Process Information.
	ProcessInfo
}

// WebAppsClientGetInstanceWorkflowSlotResponse contains the response from method WebAppsClient.GetInstanceWorkflowSlot.
type WebAppsClientGetInstanceWorkflowSlotResponse struct {
	// Workflow properties definition.
	WorkflowEnvelope
}

// WebAppsClientGetMSDeployLogResponse contains the response from method WebAppsClient.GetMSDeployLog.
type WebAppsClientGetMSDeployLogResponse struct {
	// MSDeploy log
	MSDeployLog
}

// WebAppsClientGetMSDeployLogSlotResponse contains the response from method WebAppsClient.GetMSDeployLogSlot.
type WebAppsClientGetMSDeployLogSlotResponse struct {
	// MSDeploy log
	MSDeployLog
}

// WebAppsClientGetMSDeployStatusResponse contains the response from method WebAppsClient.GetMSDeployStatus.
type WebAppsClientGetMSDeployStatusResponse struct {
	// MSDeploy ARM response
	MSDeployStatus
}

// WebAppsClientGetMSDeployStatusSlotResponse contains the response from method WebAppsClient.GetMSDeployStatusSlot.
type WebAppsClientGetMSDeployStatusSlotResponse struct {
	// MSDeploy ARM response
	MSDeployStatus
}

// WebAppsClientGetMigrateMySQLStatusResponse contains the response from method WebAppsClient.GetMigrateMySQLStatus.
type WebAppsClientGetMigrateMySQLStatusResponse struct {
	// MySQL migration status.
	MigrateMySQLStatus
}

// WebAppsClientGetMigrateMySQLStatusSlotResponse contains the response from method WebAppsClient.GetMigrateMySQLStatusSlot.
type WebAppsClientGetMigrateMySQLStatusSlotResponse struct {
	// MySQL migration status.
	MigrateMySQLStatus
}

// WebAppsClientGetNetworkTraceOperationResponse contains the response from method WebAppsClient.GetNetworkTraceOperation.
type WebAppsClientGetNetworkTraceOperationResponse struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// WebAppsClientGetNetworkTraceOperationSlotResponse contains the response from method WebAppsClient.GetNetworkTraceOperationSlot.
type WebAppsClientGetNetworkTraceOperationSlotResponse struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// WebAppsClientGetNetworkTraceOperationSlotV2Response contains the response from method WebAppsClient.GetNetworkTraceOperationSlotV2.
type WebAppsClientGetNetworkTraceOperationSlotV2Response struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// WebAppsClientGetNetworkTraceOperationV2Response contains the response from method WebAppsClient.GetNetworkTraceOperationV2.
type WebAppsClientGetNetworkTraceOperationV2Response struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// WebAppsClientGetNetworkTracesResponse contains the response from method WebAppsClient.GetNetworkTraces.
type WebAppsClientGetNetworkTracesResponse struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// WebAppsClientGetNetworkTracesSlotResponse contains the response from method WebAppsClient.GetNetworkTracesSlot.
type WebAppsClientGetNetworkTracesSlotResponse struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// WebAppsClientGetNetworkTracesSlotV2Response contains the response from method WebAppsClient.GetNetworkTracesSlotV2.
type WebAppsClientGetNetworkTracesSlotV2Response struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// WebAppsClientGetNetworkTracesV2Response contains the response from method WebAppsClient.GetNetworkTracesV2.
type WebAppsClientGetNetworkTracesV2Response struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// WebAppsClientGetOneDeployStatusResponse contains the response from method WebAppsClient.GetOneDeployStatus.
type WebAppsClientGetOneDeployStatusResponse struct {
	// Anything
	Interface any
}

// WebAppsClientGetPremierAddOnResponse contains the response from method WebAppsClient.GetPremierAddOn.
type WebAppsClientGetPremierAddOnResponse struct {
	// Premier add-on.
	PremierAddOn
}

// WebAppsClientGetPremierAddOnSlotResponse contains the response from method WebAppsClient.GetPremierAddOnSlot.
type WebAppsClientGetPremierAddOnSlotResponse struct {
	// Premier add-on.
	PremierAddOn
}

// WebAppsClientGetPrivateAccessResponse contains the response from method WebAppsClient.GetPrivateAccess.
type WebAppsClientGetPrivateAccessResponse struct {
	// Description of the parameters of Private Access for a Web Site.
	PrivateAccess
}

// WebAppsClientGetPrivateAccessSlotResponse contains the response from method WebAppsClient.GetPrivateAccessSlot.
type WebAppsClientGetPrivateAccessSlotResponse struct {
	// Description of the parameters of Private Access for a Web Site.
	PrivateAccess
}

// WebAppsClientGetPrivateEndpointConnectionListResponse contains the response from method WebAppsClient.NewGetPrivateEndpointConnectionListPager.
type WebAppsClientGetPrivateEndpointConnectionListResponse struct {
	PrivateEndpointConnectionCollection
}

// WebAppsClientGetPrivateEndpointConnectionListSlotResponse contains the response from method WebAppsClient.NewGetPrivateEndpointConnectionListSlotPager.
type WebAppsClientGetPrivateEndpointConnectionListSlotResponse struct {
	PrivateEndpointConnectionCollection
}

// WebAppsClientGetPrivateEndpointConnectionResponse contains the response from method WebAppsClient.GetPrivateEndpointConnection.
type WebAppsClientGetPrivateEndpointConnectionResponse struct {
	// Remote Private Endpoint Connection ARM resource.
	RemotePrivateEndpointConnectionARMResource
}

// WebAppsClientGetPrivateEndpointConnectionSlotResponse contains the response from method WebAppsClient.GetPrivateEndpointConnectionSlot.
type WebAppsClientGetPrivateEndpointConnectionSlotResponse struct {
	// Remote Private Endpoint Connection ARM resource.
	RemotePrivateEndpointConnectionARMResource
}

// WebAppsClientGetPrivateLinkResourcesResponse contains the response from method WebAppsClient.GetPrivateLinkResources.
type WebAppsClientGetPrivateLinkResourcesResponse struct {
	// Wrapper for a collection of private link resources
	PrivateLinkResourcesWrapper
}

// WebAppsClientGetPrivateLinkResourcesSlotResponse contains the response from method WebAppsClient.GetPrivateLinkResourcesSlot.
type WebAppsClientGetPrivateLinkResourcesSlotResponse struct {
	// Wrapper for a collection of private link resources
	PrivateLinkResourcesWrapper
}

// WebAppsClientGetProcessDumpResponse contains the response from method WebAppsClient.GetProcessDump.
type WebAppsClientGetProcessDumpResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientGetProcessDumpSlotResponse contains the response from method WebAppsClient.GetProcessDumpSlot.
type WebAppsClientGetProcessDumpSlotResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientGetProcessModuleResponse contains the response from method WebAppsClient.GetProcessModule.
type WebAppsClientGetProcessModuleResponse struct {
	// Process Module Information.
	ProcessModuleInfo
}

// WebAppsClientGetProcessModuleSlotResponse contains the response from method WebAppsClient.GetProcessModuleSlot.
type WebAppsClientGetProcessModuleSlotResponse struct {
	// Process Module Information.
	ProcessModuleInfo
}

// WebAppsClientGetProcessResponse contains the response from method WebAppsClient.GetProcess.
type WebAppsClientGetProcessResponse struct {
	// Process Information.
	ProcessInfo
}

// WebAppsClientGetProcessSlotResponse contains the response from method WebAppsClient.GetProcessSlot.
type WebAppsClientGetProcessSlotResponse struct {
	// Process Information.
	ProcessInfo
}

// WebAppsClientGetProductionSiteDeploymentStatusResponse contains the response from method WebAppsClient.BeginGetProductionSiteDeploymentStatus.
type WebAppsClientGetProductionSiteDeploymentStatusResponse struct {
	// Deployment status response payload.
	CsmDeploymentStatus
}

// WebAppsClientGetPublicCertificateResponse contains the response from method WebAppsClient.GetPublicCertificate.
type WebAppsClientGetPublicCertificateResponse struct {
	// Public certificate object
	PublicCertificate
}

// WebAppsClientGetPublicCertificateSlotResponse contains the response from method WebAppsClient.GetPublicCertificateSlot.
type WebAppsClientGetPublicCertificateSlotResponse struct {
	// Public certificate object
	PublicCertificate
}

// WebAppsClientGetRelayServiceConnectionResponse contains the response from method WebAppsClient.GetRelayServiceConnection.
type WebAppsClientGetRelayServiceConnectionResponse struct {
	// Hybrid Connection for an App Service app.
	RelayServiceConnectionEntity
}

// WebAppsClientGetRelayServiceConnectionSlotResponse contains the response from method WebAppsClient.GetRelayServiceConnectionSlot.
type WebAppsClientGetRelayServiceConnectionSlotResponse struct {
	// Hybrid Connection for an App Service app.
	RelayServiceConnectionEntity
}

// WebAppsClientGetResponse contains the response from method WebAppsClient.Get.
type WebAppsClientGetResponse struct {
	// A web app, a mobile app backend, or an API app.
	Site
}

// WebAppsClientGetScmAllowedResponse contains the response from method WebAppsClient.GetScmAllowed.
type WebAppsClientGetScmAllowedResponse struct {
	// Publishing Credentials Policies parameters.
	CsmPublishingCredentialsPoliciesEntity
}

// WebAppsClientGetScmAllowedSlotResponse contains the response from method WebAppsClient.GetScmAllowedSlot.
type WebAppsClientGetScmAllowedSlotResponse struct {
	// Publishing Credentials Policies parameters.
	CsmPublishingCredentialsPoliciesEntity
}

// WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse contains the response from method WebAppsClient.GetSiteConnectionStringKeyVaultReference.
type WebAppsClientGetSiteConnectionStringKeyVaultReferenceResponse struct {
	// Description of site key vault references.
	APIKVReference
}

// WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse contains the response from method WebAppsClient.GetSiteConnectionStringKeyVaultReferenceSlot.
type WebAppsClientGetSiteConnectionStringKeyVaultReferenceSlotResponse struct {
	// Description of site key vault references.
	APIKVReference
}

// WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse contains the response from method WebAppsClient.NewGetSiteConnectionStringKeyVaultReferencesPager.
type WebAppsClientGetSiteConnectionStringKeyVaultReferencesResponse struct {
	APIKVReferenceCollection
}

// WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse contains the response from method WebAppsClient.NewGetSiteConnectionStringKeyVaultReferencesSlotPager.
type WebAppsClientGetSiteConnectionStringKeyVaultReferencesSlotResponse struct {
	APIKVReferenceCollection
}

// WebAppsClientGetSiteExtensionResponse contains the response from method WebAppsClient.GetSiteExtension.
type WebAppsClientGetSiteExtensionResponse struct {
	// Site Extension Information.
	SiteExtensionInfo
}

// WebAppsClientGetSiteExtensionSlotResponse contains the response from method WebAppsClient.GetSiteExtensionSlot.
type WebAppsClientGetSiteExtensionSlotResponse struct {
	// Site Extension Information.
	SiteExtensionInfo
}

// WebAppsClientGetSitePhpErrorLogFlagResponse contains the response from method WebAppsClient.GetSitePhpErrorLogFlag.
type WebAppsClientGetSitePhpErrorLogFlagResponse struct {
	// Used for getting PHP error logging flag.
	SitePhpErrorLogFlag
}

// WebAppsClientGetSitePhpErrorLogFlagSlotResponse contains the response from method WebAppsClient.GetSitePhpErrorLogFlagSlot.
type WebAppsClientGetSitePhpErrorLogFlagSlotResponse struct {
	// Used for getting PHP error logging flag.
	SitePhpErrorLogFlag
}

// WebAppsClientGetSlotResponse contains the response from method WebAppsClient.GetSlot.
type WebAppsClientGetSlotResponse struct {
	// A web app, a mobile app backend, or an API app.
	Site
}

// WebAppsClientGetSlotSiteDeploymentStatusSlotResponse contains the response from method WebAppsClient.BeginGetSlotSiteDeploymentStatusSlot.
type WebAppsClientGetSlotSiteDeploymentStatusSlotResponse struct {
	// Deployment status response payload.
	CsmDeploymentStatus
}

// WebAppsClientGetSourceControlResponse contains the response from method WebAppsClient.GetSourceControl.
type WebAppsClientGetSourceControlResponse struct {
	// Source control configuration for an app.
	SiteSourceControl
}

// WebAppsClientGetSourceControlSlotResponse contains the response from method WebAppsClient.GetSourceControlSlot.
type WebAppsClientGetSourceControlSlotResponse struct {
	// Source control configuration for an app.
	SiteSourceControl
}

// WebAppsClientGetSwiftVirtualNetworkConnectionResponse contains the response from method WebAppsClient.GetSwiftVirtualNetworkConnection.
type WebAppsClientGetSwiftVirtualNetworkConnectionResponse struct {
	// Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
	SwiftVirtualNetwork
}

// WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse contains the response from method WebAppsClient.GetSwiftVirtualNetworkConnectionSlot.
type WebAppsClientGetSwiftVirtualNetworkConnectionSlotResponse struct {
	// Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
	SwiftVirtualNetwork
}

// WebAppsClientGetTriggeredWebJobHistoryResponse contains the response from method WebAppsClient.GetTriggeredWebJobHistory.
type WebAppsClientGetTriggeredWebJobHistoryResponse struct {
	// Triggered Web Job History. List of Triggered Web Job Run Information elements.
	TriggeredJobHistory
}

// WebAppsClientGetTriggeredWebJobHistorySlotResponse contains the response from method WebAppsClient.GetTriggeredWebJobHistorySlot.
type WebAppsClientGetTriggeredWebJobHistorySlotResponse struct {
	// Triggered Web Job History. List of Triggered Web Job Run Information elements.
	TriggeredJobHistory
}

// WebAppsClientGetTriggeredWebJobResponse contains the response from method WebAppsClient.GetTriggeredWebJob.
type WebAppsClientGetTriggeredWebJobResponse struct {
	// Triggered Web Job Information.
	TriggeredWebJob
}

// WebAppsClientGetTriggeredWebJobSlotResponse contains the response from method WebAppsClient.GetTriggeredWebJobSlot.
type WebAppsClientGetTriggeredWebJobSlotResponse struct {
	// Triggered Web Job Information.
	TriggeredWebJob
}

// WebAppsClientGetVnetConnectionGatewayResponse contains the response from method WebAppsClient.GetVnetConnectionGateway.
type WebAppsClientGetVnetConnectionGatewayResponse struct {
	// The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.
	VnetGateway
}

// WebAppsClientGetVnetConnectionGatewaySlotResponse contains the response from method WebAppsClient.GetVnetConnectionGatewaySlot.
type WebAppsClientGetVnetConnectionGatewaySlotResponse struct {
	// The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.
	VnetGateway
}

// WebAppsClientGetVnetConnectionResponse contains the response from method WebAppsClient.GetVnetConnection.
type WebAppsClientGetVnetConnectionResponse struct {
	// Virtual Network information ARM resource.
	VnetInfoResource
}

// WebAppsClientGetVnetConnectionSlotResponse contains the response from method WebAppsClient.GetVnetConnectionSlot.
type WebAppsClientGetVnetConnectionSlotResponse struct {
	// Virtual Network information ARM resource.
	VnetInfoResource
}

// WebAppsClientGetWebJobResponse contains the response from method WebAppsClient.GetWebJob.
type WebAppsClientGetWebJobResponse struct {
	// Web Job Information.
	WebJob
}

// WebAppsClientGetWebJobSlotResponse contains the response from method WebAppsClient.GetWebJobSlot.
type WebAppsClientGetWebJobSlotResponse struct {
	// Web Job Information.
	WebJob
}

// WebAppsClientGetWebSiteContainerLogsResponse contains the response from method WebAppsClient.GetWebSiteContainerLogs.
type WebAppsClientGetWebSiteContainerLogsResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientGetWebSiteContainerLogsSlotResponse contains the response from method WebAppsClient.GetWebSiteContainerLogsSlot.
type WebAppsClientGetWebSiteContainerLogsSlotResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientGetWorkflowResponse contains the response from method WebAppsClient.GetWorkflow.
type WebAppsClientGetWorkflowResponse struct {
	// Workflow properties definition.
	WorkflowEnvelope
}

// WebAppsClientInstallSiteExtensionResponse contains the response from method WebAppsClient.BeginInstallSiteExtension.
type WebAppsClientInstallSiteExtensionResponse struct {
	// Site Extension Information.
	SiteExtensionInfo
}

// WebAppsClientInstallSiteExtensionSlotResponse contains the response from method WebAppsClient.BeginInstallSiteExtensionSlot.
type WebAppsClientInstallSiteExtensionSlotResponse struct {
	// Site Extension Information.
	SiteExtensionInfo
}

// WebAppsClientIsCloneableResponse contains the response from method WebAppsClient.IsCloneable.
type WebAppsClientIsCloneableResponse struct {
	// Represents whether or not an app is cloneable.
	SiteCloneability
}

// WebAppsClientIsCloneableSlotResponse contains the response from method WebAppsClient.IsCloneableSlot.
type WebAppsClientIsCloneableSlotResponse struct {
	// Represents whether or not an app is cloneable.
	SiteCloneability
}

// WebAppsClientListApplicationSettingsResponse contains the response from method WebAppsClient.ListApplicationSettings.
type WebAppsClientListApplicationSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientListApplicationSettingsSlotResponse contains the response from method WebAppsClient.ListApplicationSettingsSlot.
type WebAppsClientListApplicationSettingsSlotResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientListAzureStorageAccountsResponse contains the response from method WebAppsClient.ListAzureStorageAccounts.
type WebAppsClientListAzureStorageAccountsResponse struct {
	// AzureStorageInfo dictionary resource.
	AzureStoragePropertyDictionaryResource
}

// WebAppsClientListAzureStorageAccountsSlotResponse contains the response from method WebAppsClient.ListAzureStorageAccountsSlot.
type WebAppsClientListAzureStorageAccountsSlotResponse struct {
	// AzureStorageInfo dictionary resource.
	AzureStoragePropertyDictionaryResource
}

// WebAppsClientListBackupStatusSecretsResponse contains the response from method WebAppsClient.ListBackupStatusSecrets.
type WebAppsClientListBackupStatusSecretsResponse struct {
	// Backup description.
	BackupItem
}

// WebAppsClientListBackupStatusSecretsSlotResponse contains the response from method WebAppsClient.ListBackupStatusSecretsSlot.
type WebAppsClientListBackupStatusSecretsSlotResponse struct {
	// Backup description.
	BackupItem
}

// WebAppsClientListBackupsResponse contains the response from method WebAppsClient.NewListBackupsPager.
type WebAppsClientListBackupsResponse struct {
	// Collection of backup items.
	BackupItemCollection
}

// WebAppsClientListBackupsSlotResponse contains the response from method WebAppsClient.NewListBackupsSlotPager.
type WebAppsClientListBackupsSlotResponse struct {
	// Collection of backup items.
	BackupItemCollection
}

// WebAppsClientListBasicPublishingCredentialsPoliciesResponse contains the response from method WebAppsClient.NewListBasicPublishingCredentialsPoliciesPager.
type WebAppsClientListBasicPublishingCredentialsPoliciesResponse struct {
	// Publishing Credentials Policies entity collection ARM resource.
	PublishingCredentialsPoliciesCollection
}

// WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse contains the response from method WebAppsClient.NewListBasicPublishingCredentialsPoliciesSlotPager.
type WebAppsClientListBasicPublishingCredentialsPoliciesSlotResponse struct {
	// Publishing Credentials Policies entity collection ARM resource.
	PublishingCredentialsPoliciesCollection
}

// WebAppsClientListByResourceGroupResponse contains the response from method WebAppsClient.NewListByResourceGroupPager.
type WebAppsClientListByResourceGroupResponse struct {
	// Collection of App Service apps.
	WebAppCollection
}

// WebAppsClientListConfigurationSnapshotInfoResponse contains the response from method WebAppsClient.NewListConfigurationSnapshotInfoPager.
type WebAppsClientListConfigurationSnapshotInfoResponse struct {
	// Collection of metadata for the app configuration snapshots that can be restored.
	SiteConfigurationSnapshotInfoCollection
}

// WebAppsClientListConfigurationSnapshotInfoSlotResponse contains the response from method WebAppsClient.NewListConfigurationSnapshotInfoSlotPager.
type WebAppsClientListConfigurationSnapshotInfoSlotResponse struct {
	// Collection of metadata for the app configuration snapshots that can be restored.
	SiteConfigurationSnapshotInfoCollection
}

// WebAppsClientListConfigurationsResponse contains the response from method WebAppsClient.NewListConfigurationsPager.
type WebAppsClientListConfigurationsResponse struct {
	// Collection of site configurations.
	SiteConfigResourceCollection
}

// WebAppsClientListConfigurationsSlotResponse contains the response from method WebAppsClient.NewListConfigurationsSlotPager.
type WebAppsClientListConfigurationsSlotResponse struct {
	// Collection of site configurations.
	SiteConfigResourceCollection
}

// WebAppsClientListConnectionStringsResponse contains the response from method WebAppsClient.ListConnectionStrings.
type WebAppsClientListConnectionStringsResponse struct {
	// String dictionary resource.
	ConnectionStringDictionary
}

// WebAppsClientListConnectionStringsSlotResponse contains the response from method WebAppsClient.ListConnectionStringsSlot.
type WebAppsClientListConnectionStringsSlotResponse struct {
	// String dictionary resource.
	ConnectionStringDictionary
}

// WebAppsClientListContinuousWebJobsResponse contains the response from method WebAppsClient.NewListContinuousWebJobsPager.
type WebAppsClientListContinuousWebJobsResponse struct {
	// Collection of Kudu continuous web job information elements.
	ContinuousWebJobCollection
}

// WebAppsClientListContinuousWebJobsSlotResponse contains the response from method WebAppsClient.NewListContinuousWebJobsSlotPager.
type WebAppsClientListContinuousWebJobsSlotResponse struct {
	// Collection of Kudu continuous web job information elements.
	ContinuousWebJobCollection
}

// WebAppsClientListDeploymentLogResponse contains the response from method WebAppsClient.ListDeploymentLog.
type WebAppsClientListDeploymentLogResponse struct {
	// User credentials used for publishing activity.
	Deployment
}

// WebAppsClientListDeploymentLogSlotResponse contains the response from method WebAppsClient.ListDeploymentLogSlot.
type WebAppsClientListDeploymentLogSlotResponse struct {
	// User credentials used for publishing activity.
	Deployment
}

// WebAppsClientListDeploymentsResponse contains the response from method WebAppsClient.NewListDeploymentsPager.
type WebAppsClientListDeploymentsResponse struct {
	// Collection of app deployments.
	DeploymentCollection
}

// WebAppsClientListDeploymentsSlotResponse contains the response from method WebAppsClient.NewListDeploymentsSlotPager.
type WebAppsClientListDeploymentsSlotResponse struct {
	// Collection of app deployments.
	DeploymentCollection
}

// WebAppsClientListDomainOwnershipIdentifiersResponse contains the response from method WebAppsClient.NewListDomainOwnershipIdentifiersPager.
type WebAppsClientListDomainOwnershipIdentifiersResponse struct {
	// Collection of identifiers.
	IdentifierCollection
}

// WebAppsClientListDomainOwnershipIdentifiersSlotResponse contains the response from method WebAppsClient.NewListDomainOwnershipIdentifiersSlotPager.
type WebAppsClientListDomainOwnershipIdentifiersSlotResponse struct {
	// Collection of identifiers.
	IdentifierCollection
}

// WebAppsClientListFunctionKeysResponse contains the response from method WebAppsClient.ListFunctionKeys.
type WebAppsClientListFunctionKeysResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientListFunctionKeysSlotResponse contains the response from method WebAppsClient.ListFunctionKeysSlot.
type WebAppsClientListFunctionKeysSlotResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientListFunctionSecretsResponse contains the response from method WebAppsClient.ListFunctionSecrets.
type WebAppsClientListFunctionSecretsResponse struct {
	// Function secrets.
	FunctionSecrets
}

// WebAppsClientListFunctionSecretsSlotResponse contains the response from method WebAppsClient.ListFunctionSecretsSlot.
type WebAppsClientListFunctionSecretsSlotResponse struct {
	// Function secrets.
	FunctionSecrets
}

// WebAppsClientListFunctionsResponse contains the response from method WebAppsClient.NewListFunctionsPager.
type WebAppsClientListFunctionsResponse struct {
	// Collection of Kudu function information elements.
	FunctionEnvelopeCollection
}

// WebAppsClientListHostKeysResponse contains the response from method WebAppsClient.ListHostKeys.
type WebAppsClientListHostKeysResponse struct {
	// Functions host level keys.
	HostKeys
}

// WebAppsClientListHostKeysSlotResponse contains the response from method WebAppsClient.ListHostKeysSlot.
type WebAppsClientListHostKeysSlotResponse struct {
	// Functions host level keys.
	HostKeys
}

// WebAppsClientListHostNameBindingsResponse contains the response from method WebAppsClient.NewListHostNameBindingsPager.
type WebAppsClientListHostNameBindingsResponse struct {
	// Collection of hostname bindings.
	HostNameBindingCollection
}

// WebAppsClientListHostNameBindingsSlotResponse contains the response from method WebAppsClient.NewListHostNameBindingsSlotPager.
type WebAppsClientListHostNameBindingsSlotResponse struct {
	// Collection of hostname bindings.
	HostNameBindingCollection
}

// WebAppsClientListHybridConnectionsResponse contains the response from method WebAppsClient.ListHybridConnections.
type WebAppsClientListHybridConnectionsResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// WebAppsClientListHybridConnectionsSlotResponse contains the response from method WebAppsClient.ListHybridConnectionsSlot.
type WebAppsClientListHybridConnectionsSlotResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// WebAppsClientListInstanceFunctionsSlotResponse contains the response from method WebAppsClient.NewListInstanceFunctionsSlotPager.
type WebAppsClientListInstanceFunctionsSlotResponse struct {
	// Collection of Kudu function information elements.
	FunctionEnvelopeCollection
}

// WebAppsClientListInstanceIdentifiersResponse contains the response from method WebAppsClient.NewListInstanceIdentifiersPager.
type WebAppsClientListInstanceIdentifiersResponse struct {
	// Collection of app instances.
	WebAppInstanceStatusCollection
}

// WebAppsClientListInstanceIdentifiersSlotResponse contains the response from method WebAppsClient.NewListInstanceIdentifiersSlotPager.
type WebAppsClientListInstanceIdentifiersSlotResponse struct {
	// Collection of app instances.
	WebAppInstanceStatusCollection
}

// WebAppsClientListInstanceProcessModulesResponse contains the response from method WebAppsClient.NewListInstanceProcessModulesPager.
type WebAppsClientListInstanceProcessModulesResponse struct {
	// Collection of Kudu thread information elements.
	ProcessModuleInfoCollection
}

// WebAppsClientListInstanceProcessModulesSlotResponse contains the response from method WebAppsClient.NewListInstanceProcessModulesSlotPager.
type WebAppsClientListInstanceProcessModulesSlotResponse struct {
	// Collection of Kudu thread information elements.
	ProcessModuleInfoCollection
}

// WebAppsClientListInstanceProcessThreadsResponse contains the response from method WebAppsClient.NewListInstanceProcessThreadsPager.
type WebAppsClientListInstanceProcessThreadsResponse struct {
	// Collection of Kudu thread information elements.
	ProcessThreadInfoCollection
}

// WebAppsClientListInstanceProcessThreadsSlotResponse contains the response from method WebAppsClient.NewListInstanceProcessThreadsSlotPager.
type WebAppsClientListInstanceProcessThreadsSlotResponse struct {
	// Collection of Kudu thread information elements.
	ProcessThreadInfoCollection
}

// WebAppsClientListInstanceProcessesResponse contains the response from method WebAppsClient.NewListInstanceProcessesPager.
type WebAppsClientListInstanceProcessesResponse struct {
	// Collection of Kudu process information elements.
	ProcessInfoCollection
}

// WebAppsClientListInstanceProcessesSlotResponse contains the response from method WebAppsClient.NewListInstanceProcessesSlotPager.
type WebAppsClientListInstanceProcessesSlotResponse struct {
	// Collection of Kudu process information elements.
	ProcessInfoCollection
}

// WebAppsClientListInstanceWorkflowsSlotResponse contains the response from method WebAppsClient.NewListInstanceWorkflowsSlotPager.
type WebAppsClientListInstanceWorkflowsSlotResponse struct {
	// Collection of Kudu workflow information elements.
	WorkflowEnvelopeCollection
}

// WebAppsClientListMetadataResponse contains the response from method WebAppsClient.ListMetadata.
type WebAppsClientListMetadataResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientListMetadataSlotResponse contains the response from method WebAppsClient.ListMetadataSlot.
type WebAppsClientListMetadataSlotResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientListNetworkFeaturesResponse contains the response from method WebAppsClient.ListNetworkFeatures.
type WebAppsClientListNetworkFeaturesResponse struct {
	// Full view of network features for an app (presently VNET integration and Hybrid Connections).
	NetworkFeatures
}

// WebAppsClientListNetworkFeaturesSlotResponse contains the response from method WebAppsClient.ListNetworkFeaturesSlot.
type WebAppsClientListNetworkFeaturesSlotResponse struct {
	// Full view of network features for an app (presently VNET integration and Hybrid Connections).
	NetworkFeatures
}

// WebAppsClientListPerfMonCountersResponse contains the response from method WebAppsClient.NewListPerfMonCountersPager.
type WebAppsClientListPerfMonCountersResponse struct {
	// Collection of performance monitor counters.
	PerfMonCounterCollection
}

// WebAppsClientListPerfMonCountersSlotResponse contains the response from method WebAppsClient.NewListPerfMonCountersSlotPager.
type WebAppsClientListPerfMonCountersSlotResponse struct {
	// Collection of performance monitor counters.
	PerfMonCounterCollection
}

// WebAppsClientListPremierAddOnsResponse contains the response from method WebAppsClient.ListPremierAddOns.
type WebAppsClientListPremierAddOnsResponse struct {
	// Premier add-on.
	PremierAddOn
}

// WebAppsClientListPremierAddOnsSlotResponse contains the response from method WebAppsClient.ListPremierAddOnsSlot.
type WebAppsClientListPremierAddOnsSlotResponse struct {
	// Premier add-on.
	PremierAddOn
}

// WebAppsClientListProcessModulesResponse contains the response from method WebAppsClient.NewListProcessModulesPager.
type WebAppsClientListProcessModulesResponse struct {
	// Collection of Kudu thread information elements.
	ProcessModuleInfoCollection
}

// WebAppsClientListProcessModulesSlotResponse contains the response from method WebAppsClient.NewListProcessModulesSlotPager.
type WebAppsClientListProcessModulesSlotResponse struct {
	// Collection of Kudu thread information elements.
	ProcessModuleInfoCollection
}

// WebAppsClientListProcessThreadsResponse contains the response from method WebAppsClient.NewListProcessThreadsPager.
type WebAppsClientListProcessThreadsResponse struct {
	// Collection of Kudu thread information elements.
	ProcessThreadInfoCollection
}

// WebAppsClientListProcessThreadsSlotResponse contains the response from method WebAppsClient.NewListProcessThreadsSlotPager.
type WebAppsClientListProcessThreadsSlotResponse struct {
	// Collection of Kudu thread information elements.
	ProcessThreadInfoCollection
}

// WebAppsClientListProcessesResponse contains the response from method WebAppsClient.NewListProcessesPager.
type WebAppsClientListProcessesResponse struct {
	// Collection of Kudu process information elements.
	ProcessInfoCollection
}

// WebAppsClientListProcessesSlotResponse contains the response from method WebAppsClient.NewListProcessesSlotPager.
type WebAppsClientListProcessesSlotResponse struct {
	// Collection of Kudu process information elements.
	ProcessInfoCollection
}

// WebAppsClientListProductionSiteDeploymentStatusesResponse contains the response from method WebAppsClient.NewListProductionSiteDeploymentStatusesPager.
type WebAppsClientListProductionSiteDeploymentStatusesResponse struct {
	// Deployment status collection ARM resource.
	CsmDeploymentStatusCollection
}

// WebAppsClientListPublicCertificatesResponse contains the response from method WebAppsClient.NewListPublicCertificatesPager.
type WebAppsClientListPublicCertificatesResponse struct {
	// Collection of public certificates
	PublicCertificateCollection
}

// WebAppsClientListPublicCertificatesSlotResponse contains the response from method WebAppsClient.NewListPublicCertificatesSlotPager.
type WebAppsClientListPublicCertificatesSlotResponse struct {
	// Collection of public certificates
	PublicCertificateCollection
}

// WebAppsClientListPublishingCredentialsResponse contains the response from method WebAppsClient.BeginListPublishingCredentials.
type WebAppsClientListPublishingCredentialsResponse struct {
	// User credentials used for publishing activity.
	User
}

// WebAppsClientListPublishingCredentialsSlotResponse contains the response from method WebAppsClient.BeginListPublishingCredentialsSlot.
type WebAppsClientListPublishingCredentialsSlotResponse struct {
	// User credentials used for publishing activity.
	User
}

// WebAppsClientListPublishingProfileXMLWithSecretsResponse contains the response from method WebAppsClient.ListPublishingProfileXMLWithSecrets.
type WebAppsClientListPublishingProfileXMLWithSecretsResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientListPublishingProfileXMLWithSecretsSlotResponse contains the response from method WebAppsClient.ListPublishingProfileXMLWithSecretsSlot.
type WebAppsClientListPublishingProfileXMLWithSecretsSlotResponse struct {
	// Body contains the streaming response.
	Body io.ReadCloser
}

// WebAppsClientListRelayServiceConnectionsResponse contains the response from method WebAppsClient.ListRelayServiceConnections.
type WebAppsClientListRelayServiceConnectionsResponse struct {
	// Hybrid Connection for an App Service app.
	RelayServiceConnectionEntity
}

// WebAppsClientListRelayServiceConnectionsSlotResponse contains the response from method WebAppsClient.ListRelayServiceConnectionsSlot.
type WebAppsClientListRelayServiceConnectionsSlotResponse struct {
	// Hybrid Connection for an App Service app.
	RelayServiceConnectionEntity
}

// WebAppsClientListResponse contains the response from method WebAppsClient.NewListPager.
type WebAppsClientListResponse struct {
	// Collection of App Service apps.
	WebAppCollection
}

// WebAppsClientListSiteBackupsResponse contains the response from method WebAppsClient.NewListSiteBackupsPager.
type WebAppsClientListSiteBackupsResponse struct {
	// Collection of backup items.
	BackupItemCollection
}

// WebAppsClientListSiteBackupsSlotResponse contains the response from method WebAppsClient.NewListSiteBackupsSlotPager.
type WebAppsClientListSiteBackupsSlotResponse struct {
	// Collection of backup items.
	BackupItemCollection
}

// WebAppsClientListSiteExtensionsResponse contains the response from method WebAppsClient.NewListSiteExtensionsPager.
type WebAppsClientListSiteExtensionsResponse struct {
	// Collection of Kudu site extension information elements.
	SiteExtensionInfoCollection
}

// WebAppsClientListSiteExtensionsSlotResponse contains the response from method WebAppsClient.NewListSiteExtensionsSlotPager.
type WebAppsClientListSiteExtensionsSlotResponse struct {
	// Collection of Kudu site extension information elements.
	SiteExtensionInfoCollection
}

// WebAppsClientListSitePushSettingsResponse contains the response from method WebAppsClient.ListSitePushSettings.
type WebAppsClientListSitePushSettingsResponse struct {
	// Push settings for the App.
	PushSettings
}

// WebAppsClientListSitePushSettingsSlotResponse contains the response from method WebAppsClient.ListSitePushSettingsSlot.
type WebAppsClientListSitePushSettingsSlotResponse struct {
	// Push settings for the App.
	PushSettings
}

// WebAppsClientListSlotConfigurationNamesResponse contains the response from method WebAppsClient.ListSlotConfigurationNames.
type WebAppsClientListSlotConfigurationNamesResponse struct {
	// Slot Config names azure resource.
	SlotConfigNamesResource
}

// WebAppsClientListSlotDifferencesFromProductionResponse contains the response from method WebAppsClient.NewListSlotDifferencesFromProductionPager.
type WebAppsClientListSlotDifferencesFromProductionResponse struct {
	// Collection of slot differences.
	SlotDifferenceCollection
}

// WebAppsClientListSlotDifferencesSlotResponse contains the response from method WebAppsClient.NewListSlotDifferencesSlotPager.
type WebAppsClientListSlotDifferencesSlotResponse struct {
	// Collection of slot differences.
	SlotDifferenceCollection
}

// WebAppsClientListSlotSiteDeploymentStatusesSlotResponse contains the response from method WebAppsClient.NewListSlotSiteDeploymentStatusesSlotPager.
type WebAppsClientListSlotSiteDeploymentStatusesSlotResponse struct {
	// Deployment status collection ARM resource.
	CsmDeploymentStatusCollection
}

// WebAppsClientListSlotsResponse contains the response from method WebAppsClient.NewListSlotsPager.
type WebAppsClientListSlotsResponse struct {
	// Collection of App Service apps.
	WebAppCollection
}

// WebAppsClientListSnapshotsFromDRSecondaryResponse contains the response from method WebAppsClient.NewListSnapshotsFromDRSecondaryPager.
type WebAppsClientListSnapshotsFromDRSecondaryResponse struct {
	// Collection of snapshots which can be used to revert an app to a previous time.
	SnapshotCollection
}

// WebAppsClientListSnapshotsFromDRSecondarySlotResponse contains the response from method WebAppsClient.NewListSnapshotsFromDRSecondarySlotPager.
type WebAppsClientListSnapshotsFromDRSecondarySlotResponse struct {
	// Collection of snapshots which can be used to revert an app to a previous time.
	SnapshotCollection
}

// WebAppsClientListSnapshotsResponse contains the response from method WebAppsClient.NewListSnapshotsPager.
type WebAppsClientListSnapshotsResponse struct {
	// Collection of snapshots which can be used to revert an app to a previous time.
	SnapshotCollection
}

// WebAppsClientListSnapshotsSlotResponse contains the response from method WebAppsClient.NewListSnapshotsSlotPager.
type WebAppsClientListSnapshotsSlotResponse struct {
	// Collection of snapshots which can be used to revert an app to a previous time.
	SnapshotCollection
}

// WebAppsClientListSyncFunctionTriggersResponse contains the response from method WebAppsClient.ListSyncFunctionTriggers.
type WebAppsClientListSyncFunctionTriggersResponse struct {
	// Function secrets.
	FunctionSecrets
}

// WebAppsClientListSyncFunctionTriggersSlotResponse contains the response from method WebAppsClient.ListSyncFunctionTriggersSlot.
type WebAppsClientListSyncFunctionTriggersSlotResponse struct {
	// Function secrets.
	FunctionSecrets
}

// WebAppsClientListSyncStatusResponse contains the response from method WebAppsClient.ListSyncStatus.
type WebAppsClientListSyncStatusResponse struct {
	// placeholder for future response values
}

// WebAppsClientListSyncStatusSlotResponse contains the response from method WebAppsClient.ListSyncStatusSlot.
type WebAppsClientListSyncStatusSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientListTriggeredWebJobHistoryResponse contains the response from method WebAppsClient.NewListTriggeredWebJobHistoryPager.
type WebAppsClientListTriggeredWebJobHistoryResponse struct {
	// Collection of Kudu continuous web job information elements.
	TriggeredJobHistoryCollection
}

// WebAppsClientListTriggeredWebJobHistorySlotResponse contains the response from method WebAppsClient.NewListTriggeredWebJobHistorySlotPager.
type WebAppsClientListTriggeredWebJobHistorySlotResponse struct {
	// Collection of Kudu continuous web job information elements.
	TriggeredJobHistoryCollection
}

// WebAppsClientListTriggeredWebJobsResponse contains the response from method WebAppsClient.NewListTriggeredWebJobsPager.
type WebAppsClientListTriggeredWebJobsResponse struct {
	// Collection of Kudu continuous web job information elements.
	TriggeredWebJobCollection
}

// WebAppsClientListTriggeredWebJobsSlotResponse contains the response from method WebAppsClient.NewListTriggeredWebJobsSlotPager.
type WebAppsClientListTriggeredWebJobsSlotResponse struct {
	// Collection of Kudu continuous web job information elements.
	TriggeredWebJobCollection
}

// WebAppsClientListUsagesResponse contains the response from method WebAppsClient.NewListUsagesPager.
type WebAppsClientListUsagesResponse struct {
	// Collection of CSM usage quotas.
	CsmUsageQuotaCollection
}

// WebAppsClientListUsagesSlotResponse contains the response from method WebAppsClient.NewListUsagesSlotPager.
type WebAppsClientListUsagesSlotResponse struct {
	// Collection of CSM usage quotas.
	CsmUsageQuotaCollection
}

// WebAppsClientListVnetConnectionsResponse contains the response from method WebAppsClient.ListVnetConnections.
type WebAppsClientListVnetConnectionsResponse struct {
	// Array of VnetInfoResource
	VnetInfoResourceArray []*VnetInfoResource
}

// WebAppsClientListVnetConnectionsSlotResponse contains the response from method WebAppsClient.ListVnetConnectionsSlot.
type WebAppsClientListVnetConnectionsSlotResponse struct {
	// Array of VnetInfoResource
	VnetInfoResourceArray []*VnetInfoResource
}

// WebAppsClientListWebJobsResponse contains the response from method WebAppsClient.NewListWebJobsPager.
type WebAppsClientListWebJobsResponse struct {
	// Collection of Kudu web job information elements.
	WebJobCollection
}

// WebAppsClientListWebJobsSlotResponse contains the response from method WebAppsClient.NewListWebJobsSlotPager.
type WebAppsClientListWebJobsSlotResponse struct {
	// Collection of Kudu web job information elements.
	WebJobCollection
}

// WebAppsClientListWorkflowsConnectionsResponse contains the response from method WebAppsClient.ListWorkflowsConnections.
type WebAppsClientListWorkflowsConnectionsResponse struct {
	// Workflow properties definition.
	WorkflowEnvelope
}

// WebAppsClientListWorkflowsConnectionsSlotResponse contains the response from method WebAppsClient.ListWorkflowsConnectionsSlot.
type WebAppsClientListWorkflowsConnectionsSlotResponse struct {
	// Workflow properties definition.
	WorkflowEnvelope
}

// WebAppsClientListWorkflowsResponse contains the response from method WebAppsClient.NewListWorkflowsPager.
type WebAppsClientListWorkflowsResponse struct {
	// Collection of Kudu workflow information elements.
	WorkflowEnvelopeCollection
}

// WebAppsClientMigrateMySQLResponse contains the response from method WebAppsClient.BeginMigrateMySQL.
type WebAppsClientMigrateMySQLResponse struct {
	// An operation on a resource.
	Operation
}

// WebAppsClientMigrateStorageResponse contains the response from method WebAppsClient.BeginMigrateStorage.
type WebAppsClientMigrateStorageResponse struct {
	// Response for a migration of app content request.
	StorageMigrationResponse
}

// WebAppsClientPutPrivateAccessVnetResponse contains the response from method WebAppsClient.PutPrivateAccessVnet.
type WebAppsClientPutPrivateAccessVnetResponse struct {
	// Description of the parameters of Private Access for a Web Site.
	PrivateAccess
}

// WebAppsClientPutPrivateAccessVnetSlotResponse contains the response from method WebAppsClient.PutPrivateAccessVnetSlot.
type WebAppsClientPutPrivateAccessVnetSlotResponse struct {
	// Description of the parameters of Private Access for a Web Site.
	PrivateAccess
}

// WebAppsClientRecoverSiteConfigurationSnapshotResponse contains the response from method WebAppsClient.RecoverSiteConfigurationSnapshot.
type WebAppsClientRecoverSiteConfigurationSnapshotResponse struct {
	// placeholder for future response values
}

// WebAppsClientRecoverSiteConfigurationSnapshotSlotResponse contains the response from method WebAppsClient.RecoverSiteConfigurationSnapshotSlot.
type WebAppsClientRecoverSiteConfigurationSnapshotSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientResetProductionSlotConfigResponse contains the response from method WebAppsClient.ResetProductionSlotConfig.
type WebAppsClientResetProductionSlotConfigResponse struct {
	// placeholder for future response values
}

// WebAppsClientResetSlotConfigurationSlotResponse contains the response from method WebAppsClient.ResetSlotConfigurationSlot.
type WebAppsClientResetSlotConfigurationSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestartResponse contains the response from method WebAppsClient.Restart.
type WebAppsClientRestartResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestartSlotResponse contains the response from method WebAppsClient.RestartSlot.
type WebAppsClientRestartSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestoreFromBackupBlobResponse contains the response from method WebAppsClient.BeginRestoreFromBackupBlob.
type WebAppsClientRestoreFromBackupBlobResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestoreFromBackupBlobSlotResponse contains the response from method WebAppsClient.BeginRestoreFromBackupBlobSlot.
type WebAppsClientRestoreFromBackupBlobSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestoreFromDeletedAppResponse contains the response from method WebAppsClient.BeginRestoreFromDeletedApp.
type WebAppsClientRestoreFromDeletedAppResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestoreFromDeletedAppSlotResponse contains the response from method WebAppsClient.BeginRestoreFromDeletedAppSlot.
type WebAppsClientRestoreFromDeletedAppSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestoreResponse contains the response from method WebAppsClient.BeginRestore.
type WebAppsClientRestoreResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestoreSlotResponse contains the response from method WebAppsClient.BeginRestoreSlot.
type WebAppsClientRestoreSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestoreSnapshotResponse contains the response from method WebAppsClient.BeginRestoreSnapshot.
type WebAppsClientRestoreSnapshotResponse struct {
	// placeholder for future response values
}

// WebAppsClientRestoreSnapshotSlotResponse contains the response from method WebAppsClient.BeginRestoreSnapshotSlot.
type WebAppsClientRestoreSnapshotSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientRunTriggeredWebJobResponse contains the response from method WebAppsClient.RunTriggeredWebJob.
type WebAppsClientRunTriggeredWebJobResponse struct {
	// placeholder for future response values
}

// WebAppsClientRunTriggeredWebJobSlotResponse contains the response from method WebAppsClient.RunTriggeredWebJobSlot.
type WebAppsClientRunTriggeredWebJobSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientStartContinuousWebJobResponse contains the response from method WebAppsClient.StartContinuousWebJob.
type WebAppsClientStartContinuousWebJobResponse struct {
	// placeholder for future response values
}

// WebAppsClientStartContinuousWebJobSlotResponse contains the response from method WebAppsClient.StartContinuousWebJobSlot.
type WebAppsClientStartContinuousWebJobSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientStartNetworkTraceResponse contains the response from method WebAppsClient.BeginStartNetworkTrace.
type WebAppsClientStartNetworkTraceResponse struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppsClientStartNetworkTraceResponse.
func (w *WebAppsClientStartNetworkTraceResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &w.NetworkTraceArray)
}

// WebAppsClientStartNetworkTraceSlotResponse contains the response from method WebAppsClient.BeginStartNetworkTraceSlot.
type WebAppsClientStartNetworkTraceSlotResponse struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppsClientStartNetworkTraceSlotResponse.
func (w *WebAppsClientStartNetworkTraceSlotResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &w.NetworkTraceArray)
}

// WebAppsClientStartResponse contains the response from method WebAppsClient.Start.
type WebAppsClientStartResponse struct {
	// placeholder for future response values
}

// WebAppsClientStartSlotResponse contains the response from method WebAppsClient.StartSlot.
type WebAppsClientStartSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientStartWebSiteNetworkTraceOperationResponse contains the response from method WebAppsClient.BeginStartWebSiteNetworkTraceOperation.
type WebAppsClientStartWebSiteNetworkTraceOperationResponse struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppsClientStartWebSiteNetworkTraceOperationResponse.
func (w *WebAppsClientStartWebSiteNetworkTraceOperationResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &w.NetworkTraceArray)
}

// WebAppsClientStartWebSiteNetworkTraceOperationSlotResponse contains the response from method WebAppsClient.BeginStartWebSiteNetworkTraceOperationSlot.
type WebAppsClientStartWebSiteNetworkTraceOperationSlotResponse struct {
	// Array of NetworkTrace
	NetworkTraceArray []*NetworkTrace
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WebAppsClientStartWebSiteNetworkTraceOperationSlotResponse.
func (w *WebAppsClientStartWebSiteNetworkTraceOperationSlotResponse) UnmarshalJSON(data []byte) error {
	return json.Unmarshal(data, &w.NetworkTraceArray)
}

// WebAppsClientStartWebSiteNetworkTraceResponse contains the response from method WebAppsClient.StartWebSiteNetworkTrace.
type WebAppsClientStartWebSiteNetworkTraceResponse struct {
	Value *string
}

// WebAppsClientStartWebSiteNetworkTraceSlotResponse contains the response from method WebAppsClient.StartWebSiteNetworkTraceSlot.
type WebAppsClientStartWebSiteNetworkTraceSlotResponse struct {
	Value *string
}

// WebAppsClientStopContinuousWebJobResponse contains the response from method WebAppsClient.StopContinuousWebJob.
type WebAppsClientStopContinuousWebJobResponse struct {
	// placeholder for future response values
}

// WebAppsClientStopContinuousWebJobSlotResponse contains the response from method WebAppsClient.StopContinuousWebJobSlot.
type WebAppsClientStopContinuousWebJobSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientStopNetworkTraceResponse contains the response from method WebAppsClient.StopNetworkTrace.
type WebAppsClientStopNetworkTraceResponse struct {
	// placeholder for future response values
}

// WebAppsClientStopNetworkTraceSlotResponse contains the response from method WebAppsClient.StopNetworkTraceSlot.
type WebAppsClientStopNetworkTraceSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientStopResponse contains the response from method WebAppsClient.Stop.
type WebAppsClientStopResponse struct {
	// placeholder for future response values
}

// WebAppsClientStopSlotResponse contains the response from method WebAppsClient.StopSlot.
type WebAppsClientStopSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientStopWebSiteNetworkTraceResponse contains the response from method WebAppsClient.StopWebSiteNetworkTrace.
type WebAppsClientStopWebSiteNetworkTraceResponse struct {
	// placeholder for future response values
}

// WebAppsClientStopWebSiteNetworkTraceSlotResponse contains the response from method WebAppsClient.StopWebSiteNetworkTraceSlot.
type WebAppsClientStopWebSiteNetworkTraceSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientSwapSlotResponse contains the response from method WebAppsClient.BeginSwapSlot.
type WebAppsClientSwapSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientSwapSlotWithProductionResponse contains the response from method WebAppsClient.BeginSwapSlotWithProduction.
type WebAppsClientSwapSlotWithProductionResponse struct {
	// placeholder for future response values
}

// WebAppsClientSyncFunctionTriggersResponse contains the response from method WebAppsClient.SyncFunctionTriggers.
type WebAppsClientSyncFunctionTriggersResponse struct {
	// placeholder for future response values
}

// WebAppsClientSyncFunctionTriggersSlotResponse contains the response from method WebAppsClient.SyncFunctionTriggersSlot.
type WebAppsClientSyncFunctionTriggersSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientSyncFunctionsResponse contains the response from method WebAppsClient.SyncFunctions.
type WebAppsClientSyncFunctionsResponse struct {
	// placeholder for future response values
}

// WebAppsClientSyncFunctionsSlotResponse contains the response from method WebAppsClient.SyncFunctionsSlot.
type WebAppsClientSyncFunctionsSlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientSyncRepositoryResponse contains the response from method WebAppsClient.SyncRepository.
type WebAppsClientSyncRepositoryResponse struct {
	// placeholder for future response values
}

// WebAppsClientSyncRepositorySlotResponse contains the response from method WebAppsClient.SyncRepositorySlot.
type WebAppsClientSyncRepositorySlotResponse struct {
	// placeholder for future response values
}

// WebAppsClientUpdateApplicationSettingsResponse contains the response from method WebAppsClient.UpdateApplicationSettings.
type WebAppsClientUpdateApplicationSettingsResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientUpdateApplicationSettingsSlotResponse contains the response from method WebAppsClient.UpdateApplicationSettingsSlot.
type WebAppsClientUpdateApplicationSettingsSlotResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientUpdateAuthSettingsResponse contains the response from method WebAppsClient.UpdateAuthSettings.
type WebAppsClientUpdateAuthSettingsResponse struct {
	// Configuration settings for the Azure App Service Authentication / Authorization feature.
	SiteAuthSettings
}

// WebAppsClientUpdateAuthSettingsSlotResponse contains the response from method WebAppsClient.UpdateAuthSettingsSlot.
type WebAppsClientUpdateAuthSettingsSlotResponse struct {
	// Configuration settings for the Azure App Service Authentication / Authorization feature.
	SiteAuthSettings
}

// WebAppsClientUpdateAuthSettingsV2Response contains the response from method WebAppsClient.UpdateAuthSettingsV2.
type WebAppsClientUpdateAuthSettingsV2Response struct {
	// Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
	SiteAuthSettingsV2
}

// WebAppsClientUpdateAuthSettingsV2SlotResponse contains the response from method WebAppsClient.UpdateAuthSettingsV2Slot.
type WebAppsClientUpdateAuthSettingsV2SlotResponse struct {
	// Configuration settings for the Azure App Service Authentication / Authorization V2 feature.
	SiteAuthSettingsV2
}

// WebAppsClientUpdateAzureStorageAccountsResponse contains the response from method WebAppsClient.UpdateAzureStorageAccounts.
type WebAppsClientUpdateAzureStorageAccountsResponse struct {
	// AzureStorageInfo dictionary resource.
	AzureStoragePropertyDictionaryResource
}

// WebAppsClientUpdateAzureStorageAccountsSlotResponse contains the response from method WebAppsClient.UpdateAzureStorageAccountsSlot.
type WebAppsClientUpdateAzureStorageAccountsSlotResponse struct {
	// AzureStorageInfo dictionary resource.
	AzureStoragePropertyDictionaryResource
}

// WebAppsClientUpdateBackupConfigurationResponse contains the response from method WebAppsClient.UpdateBackupConfiguration.
type WebAppsClientUpdateBackupConfigurationResponse struct {
	// Description of a backup which will be performed.
	BackupRequest
}

// WebAppsClientUpdateBackupConfigurationSlotResponse contains the response from method WebAppsClient.UpdateBackupConfigurationSlot.
type WebAppsClientUpdateBackupConfigurationSlotResponse struct {
	// Description of a backup which will be performed.
	BackupRequest
}

// WebAppsClientUpdateConfigurationResponse contains the response from method WebAppsClient.UpdateConfiguration.
type WebAppsClientUpdateConfigurationResponse struct {
	// Web app configuration ARM resource.
	SiteConfigResource
}

// WebAppsClientUpdateConfigurationSlotResponse contains the response from method WebAppsClient.UpdateConfigurationSlot.
type WebAppsClientUpdateConfigurationSlotResponse struct {
	// Web app configuration ARM resource.
	SiteConfigResource
}

// WebAppsClientUpdateConnectionStringsResponse contains the response from method WebAppsClient.UpdateConnectionStrings.
type WebAppsClientUpdateConnectionStringsResponse struct {
	// String dictionary resource.
	ConnectionStringDictionary
}

// WebAppsClientUpdateConnectionStringsSlotResponse contains the response from method WebAppsClient.UpdateConnectionStringsSlot.
type WebAppsClientUpdateConnectionStringsSlotResponse struct {
	// String dictionary resource.
	ConnectionStringDictionary
}

// WebAppsClientUpdateDiagnosticLogsConfigResponse contains the response from method WebAppsClient.UpdateDiagnosticLogsConfig.
type WebAppsClientUpdateDiagnosticLogsConfigResponse struct {
	// Configuration of App Service site logs.
	SiteLogsConfig
}

// WebAppsClientUpdateDiagnosticLogsConfigSlotResponse contains the response from method WebAppsClient.UpdateDiagnosticLogsConfigSlot.
type WebAppsClientUpdateDiagnosticLogsConfigSlotResponse struct {
	// Configuration of App Service site logs.
	SiteLogsConfig
}

// WebAppsClientUpdateDomainOwnershipIdentifierResponse contains the response from method WebAppsClient.UpdateDomainOwnershipIdentifier.
type WebAppsClientUpdateDomainOwnershipIdentifierResponse struct {
	// A domain specific resource identifier.
	Identifier
}

// WebAppsClientUpdateDomainOwnershipIdentifierSlotResponse contains the response from method WebAppsClient.UpdateDomainOwnershipIdentifierSlot.
type WebAppsClientUpdateDomainOwnershipIdentifierSlotResponse struct {
	// A domain specific resource identifier.
	Identifier
}

// WebAppsClientUpdateFtpAllowedResponse contains the response from method WebAppsClient.UpdateFtpAllowed.
type WebAppsClientUpdateFtpAllowedResponse struct {
	// Publishing Credentials Policies parameters.
	CsmPublishingCredentialsPoliciesEntity
}

// WebAppsClientUpdateFtpAllowedSlotResponse contains the response from method WebAppsClient.UpdateFtpAllowedSlot.
type WebAppsClientUpdateFtpAllowedSlotResponse struct {
	// Publishing Credentials Policies parameters.
	CsmPublishingCredentialsPoliciesEntity
}

// WebAppsClientUpdateHybridConnectionResponse contains the response from method WebAppsClient.UpdateHybridConnection.
type WebAppsClientUpdateHybridConnectionResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// WebAppsClientUpdateHybridConnectionSlotResponse contains the response from method WebAppsClient.UpdateHybridConnectionSlot.
type WebAppsClientUpdateHybridConnectionSlotResponse struct {
	// Hybrid Connection contract. This is used to configure a Hybrid Connection.
	HybridConnection
}

// WebAppsClientUpdateMetadataResponse contains the response from method WebAppsClient.UpdateMetadata.
type WebAppsClientUpdateMetadataResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientUpdateMetadataSlotResponse contains the response from method WebAppsClient.UpdateMetadataSlot.
type WebAppsClientUpdateMetadataSlotResponse struct {
	// String dictionary resource.
	StringDictionary
}

// WebAppsClientUpdatePremierAddOnResponse contains the response from method WebAppsClient.UpdatePremierAddOn.
type WebAppsClientUpdatePremierAddOnResponse struct {
	// Premier add-on.
	PremierAddOn
}

// WebAppsClientUpdatePremierAddOnSlotResponse contains the response from method WebAppsClient.UpdatePremierAddOnSlot.
type WebAppsClientUpdatePremierAddOnSlotResponse struct {
	// Premier add-on.
	PremierAddOn
}

// WebAppsClientUpdateRelayServiceConnectionResponse contains the response from method WebAppsClient.UpdateRelayServiceConnection.
type WebAppsClientUpdateRelayServiceConnectionResponse struct {
	// Hybrid Connection for an App Service app.
	RelayServiceConnectionEntity
}

// WebAppsClientUpdateRelayServiceConnectionSlotResponse contains the response from method WebAppsClient.UpdateRelayServiceConnectionSlot.
type WebAppsClientUpdateRelayServiceConnectionSlotResponse struct {
	// Hybrid Connection for an App Service app.
	RelayServiceConnectionEntity
}

// WebAppsClientUpdateResponse contains the response from method WebAppsClient.Update.
type WebAppsClientUpdateResponse struct {
	// A web app, a mobile app backend, or an API app.
	Site
}

// WebAppsClientUpdateScmAllowedResponse contains the response from method WebAppsClient.UpdateScmAllowed.
type WebAppsClientUpdateScmAllowedResponse struct {
	// Publishing Credentials Policies parameters.
	CsmPublishingCredentialsPoliciesEntity
}

// WebAppsClientUpdateScmAllowedSlotResponse contains the response from method WebAppsClient.UpdateScmAllowedSlot.
type WebAppsClientUpdateScmAllowedSlotResponse struct {
	// Publishing Credentials Policies parameters.
	CsmPublishingCredentialsPoliciesEntity
}

// WebAppsClientUpdateSitePushSettingsResponse contains the response from method WebAppsClient.UpdateSitePushSettings.
type WebAppsClientUpdateSitePushSettingsResponse struct {
	// Push settings for the App.
	PushSettings
}

// WebAppsClientUpdateSitePushSettingsSlotResponse contains the response from method WebAppsClient.UpdateSitePushSettingsSlot.
type WebAppsClientUpdateSitePushSettingsSlotResponse struct {
	// Push settings for the App.
	PushSettings
}

// WebAppsClientUpdateSlotConfigurationNamesResponse contains the response from method WebAppsClient.UpdateSlotConfigurationNames.
type WebAppsClientUpdateSlotConfigurationNamesResponse struct {
	// Slot Config names azure resource.
	SlotConfigNamesResource
}

// WebAppsClientUpdateSlotResponse contains the response from method WebAppsClient.UpdateSlot.
type WebAppsClientUpdateSlotResponse struct {
	// A web app, a mobile app backend, or an API app.
	Site
}

// WebAppsClientUpdateSourceControlResponse contains the response from method WebAppsClient.UpdateSourceControl.
type WebAppsClientUpdateSourceControlResponse struct {
	// Source control configuration for an app.
	SiteSourceControl
}

// WebAppsClientUpdateSourceControlSlotResponse contains the response from method WebAppsClient.UpdateSourceControlSlot.
type WebAppsClientUpdateSourceControlSlotResponse struct {
	// Source control configuration for an app.
	SiteSourceControl
}

// WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckResponse contains the response from method WebAppsClient.UpdateSwiftVirtualNetworkConnectionWithCheck.
type WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckResponse struct {
	// Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
	SwiftVirtualNetwork
}

// WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse contains the response from method WebAppsClient.UpdateSwiftVirtualNetworkConnectionWithCheckSlot.
type WebAppsClientUpdateSwiftVirtualNetworkConnectionWithCheckSlotResponse struct {
	// Swift Virtual Network Contract. This is used to enable the new Swift way of doing virtual network integration.
	SwiftVirtualNetwork
}

// WebAppsClientUpdateVnetConnectionGatewayResponse contains the response from method WebAppsClient.UpdateVnetConnectionGateway.
type WebAppsClientUpdateVnetConnectionGatewayResponse struct {
	// The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.
	VnetGateway
}

// WebAppsClientUpdateVnetConnectionGatewaySlotResponse contains the response from method WebAppsClient.UpdateVnetConnectionGatewaySlot.
type WebAppsClientUpdateVnetConnectionGatewaySlotResponse struct {
	// The Virtual Network gateway contract. This is used to give the Virtual Network gateway access to the VPN package.
	VnetGateway
}

// WebAppsClientUpdateVnetConnectionResponse contains the response from method WebAppsClient.UpdateVnetConnection.
type WebAppsClientUpdateVnetConnectionResponse struct {
	// Virtual Network information ARM resource.
	VnetInfoResource
}

// WebAppsClientUpdateVnetConnectionSlotResponse contains the response from method WebAppsClient.UpdateVnetConnectionSlot.
type WebAppsClientUpdateVnetConnectionSlotResponse struct {
	// Virtual Network information ARM resource.
	VnetInfoResource
}

// WebSiteManagementClientCheckNameAvailabilityResponse contains the response from method WebSiteManagementClient.CheckNameAvailability.
type WebSiteManagementClientCheckNameAvailabilityResponse struct {
	// Information regarding availability of a resource name.
	ResourceNameAvailability
}

// WebSiteManagementClientGetPublishingUserResponse contains the response from method WebSiteManagementClient.GetPublishingUser.
type WebSiteManagementClientGetPublishingUserResponse struct {
	// User credentials used for publishing activity.
	User
}

// WebSiteManagementClientGetSourceControlResponse contains the response from method WebSiteManagementClient.GetSourceControl.
type WebSiteManagementClientGetSourceControlResponse struct {
	// The source control OAuth token.
	SourceControl
}

// WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse contains the response from method WebSiteManagementClient.GetSubscriptionDeploymentLocations.
type WebSiteManagementClientGetSubscriptionDeploymentLocationsResponse struct {
	// List of available locations (regions or App Service Environments) for
	// deployment of App Service resources.
	DeploymentLocations
}

// WebSiteManagementClientListAseRegionsResponse contains the response from method WebSiteManagementClient.NewListAseRegionsPager.
type WebSiteManagementClientListAseRegionsResponse struct {
	// Collection of ASE regions.
	AseRegionCollection
}

// WebSiteManagementClientListBillingMetersResponse contains the response from method WebSiteManagementClient.NewListBillingMetersPager.
type WebSiteManagementClientListBillingMetersResponse struct {
	// Collection of Billing Meters
	BillingMeterCollection
}

// WebSiteManagementClientListCustomHostNameSitesResponse contains the response from method WebSiteManagementClient.NewListCustomHostNameSitesPager.
type WebSiteManagementClientListCustomHostNameSitesResponse struct {
	// Collection of custom hostname sites
	CustomHostnameSitesCollection
}

// WebSiteManagementClientListGeoRegionsResponse contains the response from method WebSiteManagementClient.NewListGeoRegionsPager.
type WebSiteManagementClientListGeoRegionsResponse struct {
	// Collection of geographical regions.
	GeoRegionCollection
}

// WebSiteManagementClientListPremierAddOnOffersResponse contains the response from method WebSiteManagementClient.NewListPremierAddOnOffersPager.
type WebSiteManagementClientListPremierAddOnOffersResponse struct {
	// Collection of premier add-on offers.
	PremierAddOnOfferCollection
}

// WebSiteManagementClientListSKUsResponse contains the response from method WebSiteManagementClient.ListSKUs.
type WebSiteManagementClientListSKUsResponse struct {
	// Collection of SKU information.
	SKUInfos
}

// WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse contains the response from method WebSiteManagementClient.NewListSiteIdentifiersAssignedToHostNamePager.
type WebSiteManagementClientListSiteIdentifiersAssignedToHostNameResponse struct {
	// Collection of identifiers.
	IdentifierCollection
}

// WebSiteManagementClientListSourceControlsResponse contains the response from method WebSiteManagementClient.NewListSourceControlsPager.
type WebSiteManagementClientListSourceControlsResponse struct {
	// Collection of source controls.
	SourceControlCollection
}

// WebSiteManagementClientMoveResponse contains the response from method WebSiteManagementClient.Move.
type WebSiteManagementClientMoveResponse struct {
	// placeholder for future response values
}

// WebSiteManagementClientUpdatePublishingUserResponse contains the response from method WebSiteManagementClient.UpdatePublishingUser.
type WebSiteManagementClientUpdatePublishingUserResponse struct {
	// User credentials used for publishing activity.
	User
}

// WebSiteManagementClientUpdateSourceControlResponse contains the response from method WebSiteManagementClient.UpdateSourceControl.
type WebSiteManagementClientUpdateSourceControlResponse struct {
	// The source control OAuth token.
	SourceControl
}

// WebSiteManagementClientValidateMoveResponse contains the response from method WebSiteManagementClient.ValidateMove.
type WebSiteManagementClientValidateMoveResponse struct {
	// placeholder for future response values
}

// WebSiteManagementClientValidateResponse contains the response from method WebSiteManagementClient.Validate.
type WebSiteManagementClientValidateResponse struct {
	// Describes the result of resource validation.
	ValidateResponse
}

// WebSiteManagementClientVerifyHostingEnvironmentVnetResponse contains the response from method WebSiteManagementClient.VerifyHostingEnvironmentVnet.
type WebSiteManagementClientVerifyHostingEnvironmentVnetResponse struct {
	// A class that describes the reason for a validation failure.
	VnetValidationFailureDetails
}

// WorkflowRunActionRepetitionsClientGetResponse contains the response from method WorkflowRunActionRepetitionsClient.Get.
type WorkflowRunActionRepetitionsClientGetResponse struct {
	// The workflow run action repetition definition.
	WorkflowRunActionRepetitionDefinition
}

// WorkflowRunActionRepetitionsClientListExpressionTracesResponse contains the response from method WorkflowRunActionRepetitionsClient.NewListExpressionTracesPager.
type WorkflowRunActionRepetitionsClientListExpressionTracesResponse struct {
	// The expression traces.
	ExpressionTraces
}

// WorkflowRunActionRepetitionsClientListResponse contains the response from method WorkflowRunActionRepetitionsClient.NewListPager.
type WorkflowRunActionRepetitionsClientListResponse struct {
	// A collection of workflow run action repetitions.
	WorkflowRunActionRepetitionDefinitionCollection
}

// WorkflowRunActionRepetitionsRequestHistoriesClientGetResponse contains the response from method WorkflowRunActionRepetitionsRequestHistoriesClient.Get.
type WorkflowRunActionRepetitionsRequestHistoriesClientGetResponse struct {
	// The request history.
	RequestHistory
}

// WorkflowRunActionRepetitionsRequestHistoriesClientListResponse contains the response from method WorkflowRunActionRepetitionsRequestHistoriesClient.NewListPager.
type WorkflowRunActionRepetitionsRequestHistoriesClientListResponse struct {
	// The list of workflow request histories.
	RequestHistoryListResult
}

// WorkflowRunActionScopeRepetitionsClientGetResponse contains the response from method WorkflowRunActionScopeRepetitionsClient.Get.
type WorkflowRunActionScopeRepetitionsClientGetResponse struct {
	// The workflow run action repetition definition.
	WorkflowRunActionRepetitionDefinition
}

// WorkflowRunActionScopeRepetitionsClientListResponse contains the response from method WorkflowRunActionScopeRepetitionsClient.NewListPager.
type WorkflowRunActionScopeRepetitionsClientListResponse struct {
	// A collection of workflow run action repetitions.
	WorkflowRunActionRepetitionDefinitionCollection
}

// WorkflowRunActionsClientGetResponse contains the response from method WorkflowRunActionsClient.Get.
type WorkflowRunActionsClientGetResponse struct {
	// The workflow run action.
	WorkflowRunAction
}

// WorkflowRunActionsClientListExpressionTracesResponse contains the response from method WorkflowRunActionsClient.NewListExpressionTracesPager.
type WorkflowRunActionsClientListExpressionTracesResponse struct {
	// The expression traces.
	ExpressionTraces
}

// WorkflowRunActionsClientListResponse contains the response from method WorkflowRunActionsClient.NewListPager.
type WorkflowRunActionsClientListResponse struct {
	// The list of workflow run actions.
	WorkflowRunActionListResult
}

// WorkflowRunsClientCancelResponse contains the response from method WorkflowRunsClient.Cancel.
type WorkflowRunsClientCancelResponse struct {
	// placeholder for future response values
}

// WorkflowRunsClientGetResponse contains the response from method WorkflowRunsClient.Get.
type WorkflowRunsClientGetResponse struct {
	// The workflow run.
	WorkflowRun
}

// WorkflowRunsClientListResponse contains the response from method WorkflowRunsClient.NewListPager.
type WorkflowRunsClientListResponse struct {
	// The list of workflow runs.
	WorkflowRunListResult
}

// WorkflowTriggerHistoriesClientGetResponse contains the response from method WorkflowTriggerHistoriesClient.Get.
type WorkflowTriggerHistoriesClientGetResponse struct {
	// The workflow trigger history.
	WorkflowTriggerHistory
}

// WorkflowTriggerHistoriesClientListResponse contains the response from method WorkflowTriggerHistoriesClient.NewListPager.
type WorkflowTriggerHistoriesClientListResponse struct {
	// The list of workflow trigger histories.
	WorkflowTriggerHistoryListResult
}

// WorkflowTriggerHistoriesClientResubmitResponse contains the response from method WorkflowTriggerHistoriesClient.BeginResubmit.
type WorkflowTriggerHistoriesClientResubmitResponse struct {
	// placeholder for future response values
}

// WorkflowTriggersClientGetResponse contains the response from method WorkflowTriggersClient.Get.
type WorkflowTriggersClientGetResponse struct {
	// The workflow trigger.
	WorkflowTrigger
}

// WorkflowTriggersClientGetSchemaJSONResponse contains the response from method WorkflowTriggersClient.GetSchemaJSON.
type WorkflowTriggersClientGetSchemaJSONResponse struct {
	// The JSON schema.
	JSONSchema
}

// WorkflowTriggersClientListCallbackURLResponse contains the response from method WorkflowTriggersClient.ListCallbackURL.
type WorkflowTriggersClientListCallbackURLResponse struct {
	// The workflow trigger callback URL.
	WorkflowTriggerCallbackURL
}

// WorkflowTriggersClientListResponse contains the response from method WorkflowTriggersClient.NewListPager.
type WorkflowTriggersClientListResponse struct {
	// The list of workflow triggers.
	WorkflowTriggerListResult
}

// WorkflowTriggersClientRunResponse contains the response from method WorkflowTriggersClient.BeginRun.
type WorkflowTriggersClientRunResponse struct {
	// placeholder for future response values
}

// WorkflowVersionsClientGetResponse contains the response from method WorkflowVersionsClient.Get.
type WorkflowVersionsClientGetResponse struct {
	// The workflow version.
	WorkflowVersion
}

// WorkflowVersionsClientListResponse contains the response from method WorkflowVersionsClient.NewListPager.
type WorkflowVersionsClientListResponse struct {
	// The list of workflow versions.
	WorkflowVersionListResult
}

// WorkflowsClientRegenerateAccessKeyResponse contains the response from method WorkflowsClient.RegenerateAccessKey.
type WorkflowsClientRegenerateAccessKeyResponse struct {
	// placeholder for future response values
}

// WorkflowsClientValidateResponse contains the response from method WorkflowsClient.Validate.
type WorkflowsClientValidateResponse struct {
	// placeholder for future response values
}
