/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 - 2012 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "save_conf_tab.h"
#include "populate_client_settings.h"


extern gchar *selected_connection;



void save_conf_tab(struct w *widgets)
{
    /* Save the configuration for this site. */
    FILE *fp;
    GtkTextBuffer *conf_textbuffer;
    GtkTextIter start, end;
    gchar *conf = NULL;
    gchar *utf8 = NULL;

    gchar *openvpn_client_conf = g_strdup_printf("%s/client/%s/gadmin-openvpn-client.conf",
                                                   OPENVPN_SYSCONF_DIR, selected_connection);

    conf_textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->conf_textview));
    gtk_text_buffer_get_bounds(conf_textbuffer, &start, &end);

    conf = gtk_text_iter_get_text(&start, &end);

    if((fp=fopen(openvpn_client_conf, "w+"))==NULL)
    {
        g_free(openvpn_client_conf);
        return;
    }
    fputs(conf, fp);
    fclose(fp);

    g_free(openvpn_client_conf);

    populate_client_settings(widgets);

    /* Dont update the conf tab */

    if( conf!=NULL )
        g_free(conf);

    if( utf8!=NULL )
        g_free(utf8);
}
